/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.servlet.GuiceFilter;
import com.google.inject.servlet.GuiceServletContextListener;
import com.google.inject.servlet.ServletModule;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.guice.spi.container.servlet.GuiceContainer;
import com.sun.jersey.test.framework.WebAppDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.ws.rs.core.MediaType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryClientService;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManager;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryManagerOnTimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.TestApplicationHistoryManagerOnTimelineStore;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.AHSWebServices;
import org.apache.hadoop.yarn.server.applicationhistoryservice.webapp.JAXBContextResolver;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.timeline.TimelineDataManager;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineACLsManager;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.GenericExceptionHandler;
import org.apache.hadoop.yarn.webapp.JerseyTestBase;
import org.apache.hadoop.yarn.webapp.WebServicesTestUtils;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestAHSWebServices
extends JerseyTestBase {
    private static ApplicationHistoryClientService historyClientService;
    private static final String[] USERS;
    private static final int MAX_APPS = 5;
    private Injector injector = Guice.createInjector((Module[])new Module[]{new ServletModule(){

        protected void configureServlets() {
            this.bind(JAXBContextResolver.class);
            this.bind(AHSWebServices.class);
            this.bind(GenericExceptionHandler.class);
            this.bind(ApplicationBaseProtocol.class).toInstance((Object)historyClientService);
            this.serve("/*", new String[0]).with(GuiceContainer.class);
            this.filter("/*", new String[0]).through(TestSimpleAuthFilter.class);
        }
    }});
    private int round;

    @BeforeClass
    public static void setupClass() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        TimelineStore store = TestApplicationHistoryManagerOnTimelineStore.createStore(5);
        TimelineACLsManager aclsManager = new TimelineACLsManager((Configuration)conf);
        aclsManager.setTimelineStore(store);
        TimelineDataManager dataManager = new TimelineDataManager(store, aclsManager);
        conf.setBoolean("yarn.acl.enable", true);
        conf.set("yarn.admin.acl", "foo");
        dataManager.init((Configuration)conf);
        ApplicationACLsManager appAclsManager = new ApplicationACLsManager((Configuration)conf);
        ApplicationHistoryManagerOnTimelineStore historyManager = new ApplicationHistoryManagerOnTimelineStore(dataManager, appAclsManager);
        historyManager.init((Configuration)conf);
        historyClientService = new ApplicationHistoryClientService((ApplicationHistoryManager)historyManager){

            protected void serviceStart() throws Exception {
            }
        };
        historyClientService.init((Configuration)conf);
        historyClientService.start();
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
        if (historyClientService != null) {
            historyClientService.stop();
        }
    }

    @Parameterized.Parameters
    public static Collection<Object[]> rounds() {
        return Arrays.asList({0}, {1});
    }

    public TestAHSWebServices(int round) {
        super(new WebAppDescriptor.Builder(new String[]{"org.apache.hadoop.yarn.server.applicationhistoryservice.webapp"}).contextListenerClass(GuiceServletConfig.class).filterClass(GuiceFilter.class).contextPath("jersey-guice-filter").servletPath("/").build());
        this.round = round;
    }

    @Test
    public void testInvalidApp() {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)6);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((String)"404 not found expected", (Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
    }

    @Test
    public void testInvalidAttempt() {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)6);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (this.round == 1) {
            Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
            return;
        }
        Assert.assertEquals((String)"404 not found expected", (Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
    }

    @Test
    public void testInvalidContainer() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)6L);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).path("containers").path(containerId.toString()).queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (this.round == 1) {
            Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
            return;
        }
        Assert.assertEquals((String)"404 not found expected", (Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
    }

    @Test
    public void testInvalidUri() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("applicationhistory").path("bogus").queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidUri2() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.NOT_FOUND, (Object)response.getClientResponseStatus());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testInvalidAccept() throws JSONException, Exception {
        WebResource r = this.resource();
        String responseStr = "";
        try {
            responseStr = (String)r.path("ws").path("v1").path("applicationhistory").queryParam("user.name", USERS[this.round]).accept(new String[]{"text/plain"}).get(String.class);
            Assert.fail((String)"should have thrown exception on invalid uri");
        }
        catch (UniformInterfaceException ue) {
            ClientResponse response = ue.getResponse();
            Assert.assertEquals((Object)ClientResponse.Status.INTERNAL_SERVER_ERROR, (Object)response.getClientResponseStatus());
            WebServicesTestUtils.checkStringMatch((String)"error string exists and shouldn't", (String)"", (String)responseStr);
        }
    }

    @Test
    public void testAbout() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("about").queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        TimelineAbout actualAbout = (TimelineAbout)response.getEntity(TimelineAbout.class);
        TimelineAbout expectedAbout = TimelineUtils.createTimelineAbout((String)"Generic History Service API");
        Assert.assertNotNull((String)"Timeline service about response is null", (Object)actualAbout);
        Assert.assertEquals((Object)expectedAbout.getAbout(), (Object)actualAbout.getAbout());
        Assert.assertEquals((Object)expectedAbout.getTimelineServiceVersion(), (Object)actualAbout.getTimelineServiceVersion());
        Assert.assertEquals((Object)expectedAbout.getTimelineServiceBuildVersion(), (Object)actualAbout.getTimelineServiceBuildVersion());
        Assert.assertEquals((Object)expectedAbout.getTimelineServiceVersionBuiltOn(), (Object)actualAbout.getTimelineServiceVersionBuiltOn());
        Assert.assertEquals((Object)expectedAbout.getHadoopVersion(), (Object)actualAbout.getHadoopVersion());
        Assert.assertEquals((Object)expectedAbout.getHadoopBuildVersion(), (Object)actualAbout.getHadoopBuildVersion());
        Assert.assertEquals((Object)expectedAbout.getHadoopVersionBuiltOn(), (Object)actualAbout.getHadoopVersionBuiltOn());
    }

    @Test
    public void testAppsQuery() throws Exception {
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").queryParam("state", YarnApplicationState.FINISHED.toString()).queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject apps = json.getJSONObject("apps");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)apps.length());
        JSONArray array = apps.getJSONArray("app");
        Assert.assertEquals((String)"incorrect number of elements", (long)5L, (long)array.length());
    }

    @Test
    public void testSingleApp() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject app = json.getJSONObject("app");
        Assert.assertEquals((Object)appId.toString(), (Object)app.getString("appId"));
        Assert.assertEquals((Object)"test app", (Object)app.get("name"));
        Assert.assertEquals((Object)(this.round == 0 ? "test diagnostics info" : ""), (Object)app.get("diagnosticsInfo"));
        Assert.assertEquals((Object)"test queue", (Object)app.get("queue"));
        Assert.assertEquals((Object)"user1", (Object)app.get("user"));
        Assert.assertEquals((Object)"test app type", (Object)app.get("type"));
        Assert.assertEquals((Object)FinalApplicationStatus.UNDEFINED.toString(), (Object)app.get("finalAppStatus"));
        Assert.assertEquals((Object)YarnApplicationState.FINISHED.toString(), (Object)app.get("appState"));
    }

    @Test
    public void testMultipleAttempts() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (this.round == 1) {
            Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
            return;
        }
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject appAttempts = json.getJSONObject("appAttempts");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)appAttempts.length());
        JSONArray array = appAttempts.getJSONArray("appAttempt");
        Assert.assertEquals((String)"incorrect number of elements", (long)5L, (long)array.length());
    }

    @Test
    public void testSingleAttempt() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (this.round == 1) {
            Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
            return;
        }
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject appAttempt = json.getJSONObject("appAttempt");
        Assert.assertEquals((Object)appAttemptId.toString(), (Object)appAttempt.getString("appAttemptId"));
        Assert.assertEquals((Object)"test host", (Object)appAttempt.getString("host"));
        Assert.assertEquals((Object)"test diagnostics info", (Object)appAttempt.getString("diagnosticsInfo"));
        Assert.assertEquals((Object)"test tracking url", (Object)appAttempt.getString("trackingUrl"));
        Assert.assertEquals((Object)YarnApplicationAttemptState.FINISHED.toString(), (Object)appAttempt.get("appAttemptState"));
    }

    @Test
    public void testMultipleContainers() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).path("containers").queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (this.round == 1) {
            Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
            return;
        }
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject containers = json.getJSONObject("containers");
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)containers.length());
        JSONArray array = containers.getJSONArray("container");
        Assert.assertEquals((String)"incorrect number of elements", (long)5L, (long)array.length());
    }

    @Test
    public void testSingleContainer() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)0L, (int)1);
        ApplicationAttemptId appAttemptId = ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1);
        ContainerId containerId = ContainerId.newContainerId((ApplicationAttemptId)appAttemptId, (long)1L);
        WebResource r = this.resource();
        ClientResponse response = (ClientResponse)r.path("ws").path("v1").path("applicationhistory").path("apps").path(appId.toString()).path("appattempts").path(appAttemptId.toString()).path("containers").path(containerId.toString()).queryParam("user.name", USERS[this.round]).accept(new String[]{"application/json"}).get(ClientResponse.class);
        if (this.round == 1) {
            Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)response.getClientResponseStatus());
            return;
        }
        Assert.assertEquals((Object)MediaType.APPLICATION_JSON_TYPE, (Object)response.getType());
        JSONObject json = (JSONObject)response.getEntity(JSONObject.class);
        Assert.assertEquals((String)"incorrect number of elements", (long)1L, (long)json.length());
        JSONObject container = json.getJSONObject("container");
        Assert.assertEquals((Object)containerId.toString(), (Object)container.getString("containerId"));
        Assert.assertEquals((Object)"test diagnostics info", (Object)container.getString("diagnosticsInfo"));
        Assert.assertEquals((Object)"-1", (Object)container.getString("allocatedMB"));
        Assert.assertEquals((Object)"-1", (Object)container.getString("allocatedVCores"));
        Assert.assertEquals((Object)NodeId.newInstance((String)"test host", (int)100).toString(), (Object)container.getString("assignedNodeId"));
        Assert.assertEquals((Object)"-1", (Object)container.getString("priority"));
        YarnConfiguration conf = new YarnConfiguration();
        Assert.assertEquals((Object)(WebAppUtils.getHttpSchemePrefix((Configuration)conf) + WebAppUtils.getAHSWebAppURLWithoutScheme((Configuration)conf) + "/applicationhistory/logs/test host:100/container_0_0001_01_000001/container_0_0001_01_000001/user1"), (Object)container.getString("logUrl"));
        Assert.assertEquals((Object)ContainerState.COMPLETE.toString(), (Object)container.getString("containerState"));
    }

    static {
        USERS = new String[]{"foo", "bar"};
    }

    public class GuiceServletConfig
    extends GuiceServletContextListener {
        protected Injector getInjector() {
            return TestAHSWebServices.this.injector;
        }
    }

    @Singleton
    public static class TestSimpleAuthFilter
    extends AuthenticationFilter {
        protected Properties getConfiguration(String configPrefix, FilterConfig filterConfig) throws ServletException {
            Properties properties = super.getConfiguration(configPrefix, filterConfig);
            properties.put("type", "simple");
            properties.put("simple.anonymous.allowed", "false");
            return properties;
        }
    }
}

