/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.recovery;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.service.ServiceStateException;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.timeline.recovery.LeveldbTimelineStateStore;
import org.apache.hadoop.yarn.server.timeline.recovery.TimelineStateStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestLeveldbTimelineStateStore {
    private FileContext fsContext;
    private File fsPath;
    private Configuration conf;
    private TimelineStateStore store;

    @Before
    public void setup() throws Exception {
        this.fsPath = new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsoluteFile();
        this.fsContext = FileContext.getLocalFSFileContext();
        this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
        this.conf = new YarnConfiguration();
        this.conf.setBoolean("yarn.timeline-service.recovery.enabled", true);
        this.conf.setClass("yarn.timeline-service.state-store-class", LeveldbTimelineStateStore.class, TimelineStateStore.class);
        this.conf.set("yarn.timeline-service.leveldb-state-store.path", this.fsPath.getAbsolutePath());
    }

    @After
    public void tearDown() throws Exception {
        if (this.store != null) {
            this.store.stop();
        }
        if (this.fsContext != null) {
            this.fsContext.delete(new Path(this.fsPath.getAbsolutePath()), true);
        }
    }

    private LeveldbTimelineStateStore initAndStartTimelineServiceStateStoreService() {
        this.store = new LeveldbTimelineStateStore();
        this.store.init(this.conf);
        this.store.start();
        return (LeveldbTimelineStateStore)this.store;
    }

    @Test
    public void testTokenStore() throws Exception {
        this.initAndStartTimelineServiceStateStoreService();
        TimelineStateStore.TimelineServiceState state = this.store.loadState();
        Assert.assertTrue((String)"token state not empty", (boolean)state.tokenState.isEmpty());
        Assert.assertTrue((String)"key state not empty", (boolean)state.tokenMasterKeyState.isEmpty());
        DelegationKey key1 = new DelegationKey(1, 2L, "keyData1".getBytes());
        TimelineDelegationTokenIdentifier token1 = new TimelineDelegationTokenIdentifier(new Text("tokenOwner1"), new Text("tokenRenewer1"), new Text("tokenUser1"));
        token1.setSequenceNumber(1);
        token1.getBytes();
        Long tokenDate1 = 1L;
        TimelineDelegationTokenIdentifier token2 = new TimelineDelegationTokenIdentifier(new Text("tokenOwner2"), new Text("tokenRenewer2"), new Text("tokenUser2"));
        token2.setSequenceNumber(12345678);
        token2.getBytes();
        Long tokenDate2 = 87654321L;
        this.store.storeTokenMasterKey(key1);
        try {
            this.store.storeTokenMasterKey(key1);
            Assert.fail((String)"redundant store of key undetected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.store.storeToken(token1, tokenDate1);
        this.store.storeToken(token2, tokenDate2);
        try {
            this.store.storeToken(token1, tokenDate1);
            Assert.fail((String)"redundant store of token undetected");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.store.close();
        this.initAndStartTimelineServiceStateStoreService();
        state = this.store.loadState();
        Assert.assertEquals((String)"incorrect loaded token count", (long)2L, (long)state.tokenState.size());
        Assert.assertTrue((String)"missing token 1", (boolean)state.tokenState.containsKey(token1));
        Assert.assertEquals((String)"incorrect token 1 date", (Object)tokenDate1, state.tokenState.get(token1));
        Assert.assertTrue((String)"missing token 2", (boolean)state.tokenState.containsKey(token2));
        Assert.assertEquals((String)"incorrect token 2 date", (Object)tokenDate2, state.tokenState.get(token2));
        Assert.assertEquals((String)"incorrect master key count", (long)1L, (long)state.tokenMasterKeyState.size());
        Assert.assertTrue((String)"missing master key 1", (boolean)state.tokenMasterKeyState.contains(key1));
        Assert.assertEquals((String)"incorrect latest sequence number", (long)12345678L, (long)state.getLatestSequenceNumber());
        DelegationKey key2 = new DelegationKey(3, 4L, "keyData2".getBytes());
        DelegationKey key3 = new DelegationKey(5, 6L, "keyData3".getBytes());
        TimelineDelegationTokenIdentifier token3 = new TimelineDelegationTokenIdentifier(new Text("tokenOwner3"), new Text("tokenRenewer3"), new Text("tokenUser3"));
        token3.setSequenceNumber(12345679);
        token3.getBytes();
        Long tokenDate3 = 87654321L;
        this.store.removeToken(token1);
        this.store.storeTokenMasterKey(key2);
        Long newTokenDate2 = 975318642L;
        this.store.updateToken(token2, newTokenDate2);
        this.store.removeTokenMasterKey(key1);
        this.store.storeTokenMasterKey(key3);
        this.store.storeToken(token3, tokenDate3);
        this.store.close();
        this.initAndStartTimelineServiceStateStoreService();
        state = this.store.loadState();
        Assert.assertEquals((String)"incorrect loaded token count", (long)2L, (long)state.tokenState.size());
        Assert.assertFalse((String)"token 1 not removed", (boolean)state.tokenState.containsKey(token1));
        Assert.assertTrue((String)"missing token 2", (boolean)state.tokenState.containsKey(token2));
        Assert.assertEquals((String)"incorrect token 2 date", (Object)newTokenDate2, state.tokenState.get(token2));
        Assert.assertTrue((String)"missing token 3", (boolean)state.tokenState.containsKey(token3));
        Assert.assertEquals((String)"incorrect token 3 date", (Object)tokenDate3, state.tokenState.get(token3));
        Assert.assertEquals((String)"incorrect master key count", (long)2L, (long)state.tokenMasterKeyState.size());
        Assert.assertFalse((String)"master key 1 not removed", (boolean)state.tokenMasterKeyState.contains(key1));
        Assert.assertTrue((String)"missing master key 2", (boolean)state.tokenMasterKeyState.contains(key2));
        Assert.assertTrue((String)"missing master key 3", (boolean)state.tokenMasterKeyState.contains(key3));
        Assert.assertEquals((String)"incorrect latest sequence number", (long)12345679L, (long)state.getLatestSequenceNumber());
        this.store.close();
    }

    @Test
    public void testCheckVersion() throws IOException {
        LeveldbTimelineStateStore store = this.initAndStartTimelineServiceStateStoreService();
        Version defaultVersion = store.getCurrentVersion();
        Assert.assertEquals((Object)defaultVersion, (Object)store.loadVersion());
        Version compatibleVersion = Version.newInstance((int)defaultVersion.getMajorVersion(), (int)(defaultVersion.getMinorVersion() + 2));
        store.storeVersion(compatibleVersion);
        Assert.assertEquals((Object)compatibleVersion, (Object)store.loadVersion());
        store.stop();
        store = this.initAndStartTimelineServiceStateStoreService();
        Assert.assertEquals((Object)defaultVersion, (Object)store.loadVersion());
        Version incompatibleVersion = Version.newInstance((int)(defaultVersion.getMajorVersion() + 1), (int)defaultVersion.getMinorVersion());
        store.storeVersion(incompatibleVersion);
        store.stop();
        try {
            this.initAndStartTimelineServiceStateStoreService();
            Assert.fail((String)"Incompatible version, should expect fail here.");
        }
        catch (ServiceStateException e) {
            Assert.assertTrue((String)"Exception message mismatch", (boolean)e.getMessage().contains("Incompatible version for timeline state store"));
        }
    }
}

