/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.timeline.security;

import java.io.File;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.KerberosTestUtils;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.security.ssl.KeyStoreTestUtil;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.timeline.TimelineDomain;
import org.apache.hadoop.yarn.api.records.timeline.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timeline.TimelinePutResponse;
import org.apache.hadoop.yarn.client.api.TimelineClient;
import org.apache.hadoop.yarn.security.client.TimelineDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryServer;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestTimelineAuthenticationFilter {
    private static final String FOO_USER = "foo";
    private static final String BAR_USER = "bar";
    private static final String HTTP_USER = "HTTP";
    private static final File testRootDir = new File(System.getProperty("test.build.dir", "target/test-dir"), TestTimelineAuthenticationFilter.class.getName() + "-root");
    private static File httpSpnegoKeytabFile = new File(KerberosTestUtils.getKeytabFile());
    private static String httpSpnegoPrincipal = KerberosTestUtils.getServerPrincipal();
    private static final String BASEDIR = System.getProperty("test.build.dir", "target/test-dir") + "/" + TestTimelineAuthenticationFilter.class.getSimpleName();
    private static MiniKdc testMiniKDC;
    private static String keystoresDir;
    private static String sslConfDir;
    private static ApplicationHistoryServer testTimelineServer;
    private static Configuration conf;
    private static boolean withSsl;

    @Parameterized.Parameters
    public static Collection<Object[]> withSsl() {
        return Arrays.asList({false}, {true});
    }

    public TestTimelineAuthenticationFilter(boolean withSsl) {
        TestTimelineAuthenticationFilter.withSsl = withSsl;
    }

    @BeforeClass
    public static void setup() {
        try {
            testMiniKDC = new MiniKdc(MiniKdc.createConf(), testRootDir);
            testMiniKDC.start();
            testMiniKDC.createPrincipal(httpSpnegoKeytabFile, new String[]{"HTTP/localhost"});
        }
        catch (Exception e) {
            Assert.assertTrue((String)"Couldn't setup MiniKDC", (boolean)false);
        }
        try {
            testTimelineServer = new ApplicationHistoryServer();
            conf = new Configuration(false);
            conf.setStrings("yarn.timeline-service.http-authentication.type", new String[]{"kerberos"});
            conf.set("yarn.timeline-service.http-authentication.kerberos.principal", httpSpnegoPrincipal);
            conf.set("yarn.timeline-service.http-authentication.kerberos.keytab", httpSpnegoKeytabFile.getAbsolutePath());
            conf.set("hadoop.security.authentication", "kerberos");
            conf.set("yarn.timeline-service.principal", httpSpnegoPrincipal);
            conf.set("yarn.timeline-service.keytab", httpSpnegoKeytabFile.getAbsolutePath());
            conf.setBoolean("yarn.timeline-service.enabled", true);
            conf.setClass("yarn.timeline-service.store-class", MemoryTimelineStore.class, TimelineStore.class);
            conf.set("yarn.timeline-service.address", "localhost:10200");
            conf.set("yarn.timeline-service.webapp.address", "localhost:8188");
            conf.set("yarn.timeline-service.webapp.https.address", "localhost:8190");
            conf.set("hadoop.proxyuser.HTTP.hosts", "*");
            conf.set("hadoop.proxyuser.HTTP.users", FOO_USER);
            conf.setInt("yarn.timeline-service.client.max-retries", 1);
            if (withSsl) {
                conf.set("yarn.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
                File base = new File(BASEDIR);
                FileUtil.fullyDelete((File)base);
                base.mkdirs();
                keystoresDir = new File(BASEDIR).getAbsolutePath();
                sslConfDir = KeyStoreTestUtil.getClasspathDir(TestTimelineAuthenticationFilter.class);
                KeyStoreTestUtil.setupSSLConfig((String)keystoresDir, (String)sslConfDir, (Configuration)conf, (boolean)false);
            }
            UserGroupInformation.setConfiguration((Configuration)conf);
            testTimelineServer.init(conf);
            testTimelineServer.start();
        }
        catch (Exception e) {
            Assert.assertTrue((String)"Couldn't setup TimelineServer", (boolean)false);
        }
    }

    private TimelineClient createTimelineClientForUGI() {
        TimelineClient client = TimelineClient.createTimelineClient();
        client.init(conf);
        client.start();
        return client;
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (testMiniKDC != null) {
            testMiniKDC.stop();
        }
        if (testTimelineServer != null) {
            testTimelineServer.stop();
        }
        if (withSsl) {
            KeyStoreTestUtil.cleanupSSLConfig((String)keystoresDir, (String)sslConfDir);
            File base = new File(BASEDIR);
            FileUtil.fullyDelete((File)base);
        }
    }

    @Test
    public void testPutTimelineEntities() throws Exception {
        KerberosTestUtils.doAs((String)"HTTP/localhost", (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TimelineClient client = TestTimelineAuthenticationFilter.this.createTimelineClientForUGI();
                TimelineEntity entityToStore = new TimelineEntity();
                entityToStore.setEntityType(TestTimelineAuthenticationFilter.class.getName());
                entityToStore.setEntityId("entity1");
                entityToStore.setStartTime(Long.valueOf(0L));
                TimelinePutResponse putResponse = client.putEntities(new TimelineEntity[]{entityToStore});
                Assert.assertEquals((long)0L, (long)putResponse.getErrors().size());
                TimelineEntity entityToRead = testTimelineServer.getTimelineStore().getEntity("entity1", TestTimelineAuthenticationFilter.class.getName(), null);
                Assert.assertNotNull((Object)entityToRead);
                return null;
            }
        });
    }

    @Test
    public void testPutDomains() throws Exception {
        KerberosTestUtils.doAs((String)"HTTP/localhost", (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TimelineClient client = TestTimelineAuthenticationFilter.this.createTimelineClientForUGI();
                TimelineDomain domainToStore = new TimelineDomain();
                domainToStore.setId(TestTimelineAuthenticationFilter.class.getName());
                domainToStore.setReaders("*");
                domainToStore.setWriters("*");
                client.putDomain(domainToStore);
                TimelineDomain domainToRead = testTimelineServer.getTimelineStore().getDomain(TestTimelineAuthenticationFilter.class.getName());
                Assert.assertNotNull((Object)domainToRead);
                return null;
            }
        });
    }

    @Test
    public void testDelegationTokenOperations() throws Exception {
        TimelineClient httpUserClient = (TimelineClient)KerberosTestUtils.doAs((String)"HTTP/localhost", (Callable)new Callable<TimelineClient>(){

            @Override
            public TimelineClient call() throws Exception {
                return TestTimelineAuthenticationFilter.this.createTimelineClientForUGI();
            }
        });
        UserGroupInformation httpUser = (UserGroupInformation)KerberosTestUtils.doAs((String)"HTTP/localhost", (Callable)new Callable<UserGroupInformation>(){

            @Override
            public UserGroupInformation call() throws Exception {
                return UserGroupInformation.getCurrentUser();
            }
        });
        Token token = httpUserClient.getDelegationToken(httpUser.getShortUserName());
        Assert.assertNotNull((Object)token);
        TimelineDelegationTokenIdentifier tDT = (TimelineDelegationTokenIdentifier)token.decodeIdentifier();
        Assert.assertNotNull((Object)tDT);
        Assert.assertEquals((Object)new Text(HTTP_USER), (Object)tDT.getOwner());
        Assert.assertFalse((boolean)token.getService().toString().isEmpty());
        long renewTime1 = httpUserClient.renewDelegationToken(token);
        Thread.sleep(100L);
        token.setService(new Text());
        Assert.assertTrue((boolean)token.getService().toString().isEmpty());
        long renewTime2 = httpUserClient.renewDelegationToken(token);
        Assert.assertTrue((renewTime1 < renewTime2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)token.getService().toString().isEmpty());
        httpUserClient.cancelDelegationToken(token);
        try {
            httpUserClient.renewDelegationToken(token);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Renewal request for unknown token"));
        }
        UserGroupInformation fooUgi = UserGroupInformation.createProxyUser((String)FOO_USER, (UserGroupInformation)httpUser);
        TimelineClient fooUserClient = (TimelineClient)fooUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TimelineClient>(){

            @Override
            public TimelineClient run() throws Exception {
                return TestTimelineAuthenticationFilter.this.createTimelineClientForUGI();
            }
        });
        token = fooUserClient.getDelegationToken(httpUser.getShortUserName());
        Assert.assertNotNull((Object)token);
        tDT = (TimelineDelegationTokenIdentifier)token.decodeIdentifier();
        Assert.assertNotNull((Object)tDT);
        Assert.assertEquals((Object)new Text(FOO_USER), (Object)tDT.getOwner());
        Assert.assertEquals((Object)new Text(HTTP_USER), (Object)tDT.getRealUser());
        Token tokenToRenew = token;
        renewTime1 = httpUserClient.renewDelegationToken(tokenToRenew);
        renewTime2 = httpUserClient.renewDelegationToken(tokenToRenew);
        Assert.assertTrue((renewTime1 < renewTime2 ? 1 : 0) != 0);
        Assert.assertFalse((boolean)tokenToRenew.getService().toString().isEmpty());
        fooUserClient.cancelDelegationToken(tokenToRenew);
        try {
            httpUserClient.renewDelegationToken(tokenToRenew);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Renewal request for unknown token"));
        }
        UserGroupInformation barUgi = UserGroupInformation.createProxyUser((String)BAR_USER, (UserGroupInformation)httpUser);
        TimelineClient barUserClient = (TimelineClient)barUgi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<TimelineClient>(){

            @Override
            public TimelineClient run() {
                return TestTimelineAuthenticationFilter.this.createTimelineClientForUGI();
            }
        });
        try {
            barUserClient.getDelegationToken(httpUser.getShortUserName());
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((e.getCause() instanceof AuthorizationException || e.getCause() instanceof AuthenticationException ? 1 : 0) != 0);
        }
    }
}

