/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice.webapp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import java.util.Collections;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationBaseProtocol;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timeline.TimelineAbout;
import org.apache.hadoop.yarn.logaggregation.filecontroller.LogAggregationFileControllerFactory;
import org.apache.hadoop.yarn.server.webapp.LogWebServiceUtils;
import org.apache.hadoop.yarn.server.webapp.WebServices;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppAttemptsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppInfo;
import org.apache.hadoop.yarn.server.webapp.dao.AppsInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainerInfo;
import org.apache.hadoop.yarn.server.webapp.dao.ContainersInfo;
import org.apache.hadoop.yarn.util.timeline.TimelineUtils;
import org.apache.hadoop.yarn.webapp.BadRequestException;
import org.apache.hadoop.yarn.webapp.NotFoundException;
import org.codehaus.jettison.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Path(value="/ws/v1/applicationhistory")
public class AHSWebServices
extends WebServices {
    private static final Logger LOG = LoggerFactory.getLogger(AHSWebServices.class);
    private static final String NM_DOWNLOAD_URI_STR = "/ws/v1/node/containers";
    private static final Joiner JOINER = Joiner.on((String)"");
    private static final Joiner DOT_JOINER = Joiner.on((String)". ");
    private final Configuration conf;
    private final LogAggregationFileControllerFactory factory;

    @Inject
    public AHSWebServices(ApplicationBaseProtocol appBaseProt, Configuration conf) {
        super(appBaseProt);
        this.conf = conf;
        this.factory = new LogAggregationFileControllerFactory(conf);
    }

    @GET
    @Path(value="/about")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public TimelineAbout about(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        this.initForReadableEndpoints(res);
        return TimelineUtils.createTimelineAbout((String)"Generic History Service API");
    }

    @GET
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppsInfo get(@Context HttpServletRequest req, @Context HttpServletResponse res) {
        return this.getApps(req, res, null, Collections.emptySet(), null, null, null, null, null, null, null, null, Collections.emptySet());
    }

    @GET
    @Path(value="/apps")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppsInfo getApps(@Context HttpServletRequest req, @Context HttpServletResponse res, @QueryParam(value="state") String stateQuery, @QueryParam(value="states") Set<String> statesQuery, @QueryParam(value="finalStatus") String finalStatusQuery, @QueryParam(value="user") String userQuery, @QueryParam(value="queue") String queueQuery, @QueryParam(value="limit") String count, @QueryParam(value="startedTimeBegin") String startedBegin, @QueryParam(value="startedTimeEnd") String startedEnd, @QueryParam(value="finishedTimeBegin") String finishBegin, @QueryParam(value="finishedTimeEnd") String finishEnd, @QueryParam(value="applicationTypes") Set<String> applicationTypes) {
        this.initForReadableEndpoints(res);
        AHSWebServices.validateStates(stateQuery, statesQuery);
        return super.getApps(req, res, stateQuery, statesQuery, finalStatusQuery, userQuery, queueQuery, count, startedBegin, startedEnd, finishBegin, finishEnd, applicationTypes);
    }

    @GET
    @Path(value="/apps/{appid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppInfo getApp(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId) {
        this.initForReadableEndpoints(res);
        return super.getApp(req, res, appId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppAttemptsInfo getAppAttempts(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId) {
        this.initForReadableEndpoints(res);
        return super.getAppAttempts(req, res, appId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public AppAttemptInfo getAppAttempt(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId) {
        this.initForReadableEndpoints(res);
        return super.getAppAttempt(req, res, appId, appAttemptId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}/containers")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ContainersInfo getContainers(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId) {
        this.initForReadableEndpoints(res);
        return super.getContainers(req, res, appId, appAttemptId);
    }

    @GET
    @Path(value="/apps/{appid}/appattempts/{appattemptid}/containers/{containerid}")
    @Produces(value={"application/json; charset=utf-8", "application/xml; charset=utf-8"})
    public ContainerInfo getContainer(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="appid") String appId, @PathParam(value="appattemptid") String appAttemptId, @PathParam(value="containerid") String containerId) {
        this.initForReadableEndpoints(res);
        return super.getContainer(req, res, appId, appAttemptId, containerId);
    }

    private static void validateStates(String stateQuery, Set<String> statesQuery) {
        if (stateQuery != null && !stateQuery.isEmpty()) {
            statesQuery.add(stateQuery);
        }
        Set appStates = AHSWebServices.parseQueries(statesQuery, (boolean)true);
        block3: for (String appState : appStates) {
            switch (YarnApplicationState.valueOf((String)StringUtils.toUpperCase((String)appState))) {
                case FINISHED: 
                case FAILED: 
                case KILLED: {
                    continue block3;
                }
            }
            throw new BadRequestException("Invalid application-state " + appState + " specified. It should be a final state");
        }
    }

    @GET
    @Path(value="/containers/{containerid}/logs")
    @Produces(value={"application/json", "application/xml"})
    public Response getContainerLogsInfo(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @QueryParam(value="nm.id") String nmId, @QueryParam(value="redirected_from_node") @DefaultValue(value="false") boolean redirected_from_node) {
        AppInfo appInfo;
        ContainerId containerId = null;
        this.initForReadableEndpoints(res);
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("invalid container id, " + containerIdStr);
        }
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        try {
            appInfo = super.getApp(req, res, appId.toString());
        }
        catch (Exception ex) {
            return LogWebServiceUtils.getContainerLogMeta((LogAggregationFileControllerFactory)this.factory, (ApplicationId)appId, null, null, (String)containerIdStr, (boolean)false);
        }
        if (LogWebServiceUtils.isFinishedState((YarnApplicationState)appInfo.getAppState())) {
            return LogWebServiceUtils.getContainerLogMeta((LogAggregationFileControllerFactory)this.factory, (ApplicationId)appId, null, null, (String)containerIdStr, (boolean)false);
        }
        if (LogWebServiceUtils.isRunningState((YarnApplicationState)appInfo.getAppState())) {
            String nodeHttpAddress;
            String appOwner;
            block14: {
                appOwner = appInfo.getUser();
                nodeHttpAddress = null;
                if (nmId != null && !nmId.isEmpty()) {
                    try {
                        nodeHttpAddress = this.getNMWebAddressFromRM(this.conf, nmId);
                    }
                    catch (Exception ex) {
                        if (!LOG.isDebugEnabled()) break block14;
                        LOG.debug(ex.getMessage());
                    }
                }
            }
            if (nodeHttpAddress == null || nodeHttpAddress.isEmpty()) {
                ContainerInfo containerInfo;
                try {
                    containerInfo = super.getContainer(req, res, appId.toString(), containerId.getApplicationAttemptId().toString(), containerId.toString());
                }
                catch (Exception ex) {
                    return LogWebServiceUtils.getContainerLogMeta((LogAggregationFileControllerFactory)this.factory, (ApplicationId)appId, (String)appOwner, null, (String)containerIdStr, (boolean)true);
                }
                nodeHttpAddress = containerInfo.getNodeHttpAddress();
                if (nodeHttpAddress == null || nodeHttpAddress.isEmpty() || redirected_from_node) {
                    return LogWebServiceUtils.getContainerLogMeta((LogAggregationFileControllerFactory)this.factory, (ApplicationId)appId, (String)appOwner, null, (String)containerIdStr, (boolean)true);
                }
            }
            String uri = "/" + containerId.toString() + "/logs";
            String resURI = JOINER.join((Object)LogWebServiceUtils.getAbsoluteNMWebAddress((Configuration)this.conf, (String)nodeHttpAddress), (Object)NM_DOWNLOAD_URI_STR, new Object[]{uri});
            String query = req.getQueryString();
            if (query != null && !query.isEmpty()) {
                resURI = resURI + "?" + query;
            }
            Response.ResponseBuilder response = Response.status((int)307);
            response.header("Location", (Object)resURI);
            return response.build();
        }
        throw new NotFoundException("The application is not at Running or Finished State.");
    }

    @GET
    @Path(value="/containers/{containerid}/logs/{filename}")
    @Produces(value={"text/plain"})
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Response getContainerLogFile(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @PathParam(value="filename") String filename, @QueryParam(value="format") String format, @QueryParam(value="size") String size, @QueryParam(value="nm.id") String nmId, @QueryParam(value="redirected_from_node") boolean redirected_from_node) {
        return this.getLogs(req, res, containerIdStr, filename, format, size, nmId, redirected_from_node);
    }

    @GET
    @Path(value="/containerlogs/{containerid}/{filename}")
    @Produces(value={"text/plain; charset=utf-8"})
    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public Response getLogs(@Context HttpServletRequest req, @Context HttpServletResponse res, @PathParam(value="containerid") String containerIdStr, @PathParam(value="filename") String filename, @QueryParam(value="format") String format, @QueryParam(value="size") String size, @QueryParam(value="nm.id") String nmId, @QueryParam(value="redirected_from_node") @DefaultValue(value="false") boolean redirected_from_node) {
        AppInfo appInfo;
        ContainerId containerId;
        this.initForReadableEndpoints(res);
        try {
            containerId = ContainerId.fromString((String)containerIdStr);
        }
        catch (IllegalArgumentException ex) {
            return LogWebServiceUtils.createBadResponse((Response.Status)Response.Status.NOT_FOUND, (String)("Invalid ContainerId: " + containerIdStr));
        }
        long length = LogWebServiceUtils.parseLongParam((String)size);
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        try {
            appInfo = super.getApp(req, res, appId.toString());
        }
        catch (Exception ex) {
            return LogWebServiceUtils.sendStreamOutputResponse((LogAggregationFileControllerFactory)this.factory, (ApplicationId)appId, null, null, (String)containerIdStr, (String)filename, (String)format, (long)length, (boolean)false);
        }
        String appOwner = appInfo.getUser();
        if (LogWebServiceUtils.isFinishedState((YarnApplicationState)appInfo.getAppState())) {
            return LogWebServiceUtils.sendStreamOutputResponse((LogAggregationFileControllerFactory)this.factory, (ApplicationId)appId, (String)appOwner, null, (String)containerIdStr, (String)filename, (String)format, (long)length, (boolean)false);
        }
        if (LogWebServiceUtils.isRunningState((YarnApplicationState)appInfo.getAppState())) {
            String nodeHttpAddress;
            block14: {
                nodeHttpAddress = null;
                if (nmId != null && !nmId.isEmpty()) {
                    try {
                        nodeHttpAddress = this.getNMWebAddressFromRM(this.conf, nmId);
                    }
                    catch (Exception ex) {
                        if (!LOG.isDebugEnabled()) break block14;
                        LOG.debug(ex.getMessage());
                    }
                }
            }
            if (nodeHttpAddress == null || nodeHttpAddress.isEmpty()) {
                ContainerInfo containerInfo;
                try {
                    containerInfo = super.getContainer(req, res, appId.toString(), containerId.getApplicationAttemptId().toString(), containerId.toString());
                }
                catch (Exception ex) {
                    return LogWebServiceUtils.sendStreamOutputResponse((LogAggregationFileControllerFactory)this.factory, (ApplicationId)appId, (String)appOwner, null, (String)containerIdStr, (String)filename, (String)format, (long)length, (boolean)true);
                }
                nodeHttpAddress = containerInfo.getNodeHttpAddress();
                if (nodeHttpAddress == null || nodeHttpAddress.isEmpty() || redirected_from_node) {
                    return LogWebServiceUtils.sendStreamOutputResponse((LogAggregationFileControllerFactory)this.factory, (ApplicationId)appId, (String)appOwner, null, (String)containerIdStr, (String)filename, (String)format, (long)length, (boolean)true);
                }
            }
            String uri = "/" + containerId.toString() + "/logs/" + filename;
            String resURI = JOINER.join((Object)LogWebServiceUtils.getAbsoluteNMWebAddress((Configuration)this.conf, (String)nodeHttpAddress), (Object)NM_DOWNLOAD_URI_STR, new Object[]{uri});
            String query = req.getQueryString();
            if (query != null && !query.isEmpty()) {
                resURI = resURI + "?" + query;
            }
            Response.ResponseBuilder response = Response.status((int)307);
            response.header("Location", (Object)resURI);
            return response.build();
        }
        return LogWebServiceUtils.createBadResponse((Response.Status)Response.Status.NOT_FOUND, (String)"The application is not at Running or Finished State.");
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public String getNMWebAddressFromRM(Configuration configuration, String nodeId) throws ClientHandlerException, UniformInterfaceException, JSONException {
        return LogWebServiceUtils.getNMWebAddressFromRM((Configuration)configuration, (String)nodeId);
    }
}

