/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.applicationhistoryservice;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.lib.StaticUserWebFilter;
import org.apache.hadoop.security.AuthenticationFilterInitializer;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryClientService;
import org.apache.hadoop.yarn.server.applicationhistoryservice.ApplicationHistoryServer;
import org.apache.hadoop.yarn.server.timeline.MemoryTimelineStore;
import org.apache.hadoop.yarn.server.timeline.TimelineStore;
import org.apache.hadoop.yarn.server.timeline.recovery.MemoryTimelineStateStore;
import org.apache.hadoop.yarn.server.timeline.recovery.TimelineStateStore;
import org.apache.hadoop.yarn.server.timeline.security.TimelineAuthenticationFilterInitializer;
import org.junit.Assert;
import org.junit.Test;

public class TestApplicationHistoryServer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testStartStopServer() throws Exception {
        ApplicationHistoryServer historyServer = new ApplicationHistoryServer();
        YarnConfiguration config = new YarnConfiguration();
        config.setClass("yarn.timeline-service.store-class", MemoryTimelineStore.class, TimelineStore.class);
        config.setClass("yarn.timeline-service.state-store-class", MemoryTimelineStateStore.class, TimelineStateStore.class);
        config.set("yarn.timeline-service.webapp.address", "localhost:0");
        try {
            try {
                historyServer.init((Configuration)config);
                config.setInt("yarn.timeline-service.handler-thread-count", 0);
                historyServer.start();
                Assert.fail();
            }
            catch (IllegalArgumentException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("yarn.timeline-service.handler-thread-count"));
            }
            config.setInt("yarn.timeline-service.handler-thread-count", 10);
            historyServer = new ApplicationHistoryServer();
            historyServer.init((Configuration)config);
            Assert.assertEquals((Object)Service.STATE.INITED, (Object)historyServer.getServiceState());
            ApplicationHistoryClientService historyService = historyServer.getClientService();
            Assert.assertNotNull((Object)historyServer.getClientService());
            Assert.assertEquals((Object)Service.STATE.INITED, (Object)historyService.getServiceState());
            historyServer.start();
            Assert.assertEquals((Object)Service.STATE.STARTED, (Object)historyServer.getServiceState());
            Assert.assertEquals((Object)Service.STATE.STARTED, (Object)historyService.getServiceState());
            historyServer.stop();
            Assert.assertEquals((Object)Service.STATE.STOPPED, (Object)historyServer.getServiceState());
        }
        finally {
            historyServer.stop();
        }
    }

    @Test(timeout=60000L)
    public void testLaunch() throws Exception {
        ExitUtil.disableSystemExit();
        ApplicationHistoryServer historyServer = null;
        try {
            historyServer = ApplicationHistoryServer.launchAppHistoryServer((String[])new String[0]);
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((long)0L, (long)e.status);
            ExitUtil.resetFirstExitException();
            Assert.fail();
        }
        finally {
            if (historyServer != null) {
                historyServer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void testLaunchWithArguments() throws Exception {
        ExitUtil.disableSystemExit();
        ApplicationHistoryServer historyServer = null;
        try {
            String[] args = new String[]{"-Dyarn.timeline-service.leveldb-timeline-store.ttl-interval-ms=4000", "-Dyarn.timeline-service.ttl-ms=200"};
            historyServer = ApplicationHistoryServer.launchAppHistoryServer((String[])args);
            Configuration conf = historyServer.getConfig();
            Assert.assertEquals((Object)"4000", (Object)conf.get("yarn.timeline-service.leveldb-timeline-store.ttl-interval-ms"));
            Assert.assertEquals((Object)"200", (Object)conf.get("yarn.timeline-service.ttl-ms"));
        }
        catch (ExitUtil.ExitException e) {
            Assert.assertEquals((long)0L, (long)e.status);
            ExitUtil.resetFirstExitException();
            Assert.fail();
        }
        finally {
            if (historyServer != null) {
                historyServer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=240000L)
    public void testFilterOverrides() throws Exception {
        HashMap<String, String> driver = new HashMap<String, String>();
        driver.put("", TimelineAuthenticationFilterInitializer.class.getName());
        driver.put(StaticUserWebFilter.class.getName(), StaticUserWebFilter.class.getName() + "," + TimelineAuthenticationFilterInitializer.class.getName());
        driver.put(AuthenticationFilterInitializer.class.getName(), TimelineAuthenticationFilterInitializer.class.getName());
        driver.put(TimelineAuthenticationFilterInitializer.class.getName(), TimelineAuthenticationFilterInitializer.class.getName());
        driver.put(AuthenticationFilterInitializer.class.getName() + "," + TimelineAuthenticationFilterInitializer.class.getName(), TimelineAuthenticationFilterInitializer.class.getName());
        driver.put(AuthenticationFilterInitializer.class.getName() + ", " + TimelineAuthenticationFilterInitializer.class.getName(), TimelineAuthenticationFilterInitializer.class.getName());
        for (Map.Entry entry : driver.entrySet()) {
            String filterInitializer = (String)entry.getKey();
            String expectedValue = (String)entry.getValue();
            ApplicationHistoryServer historyServer = new ApplicationHistoryServer();
            YarnConfiguration config = new YarnConfiguration();
            config.setClass("yarn.timeline-service.store-class", MemoryTimelineStore.class, TimelineStore.class);
            config.setClass("yarn.timeline-service.state-store-class", MemoryTimelineStateStore.class, TimelineStateStore.class);
            config.set("yarn.timeline-service.webapp.address", "localhost:0");
            try {
                config.set("hadoop.http.filter.initializers", filterInitializer);
                historyServer.init((Configuration)config);
                historyServer.start();
                Configuration tmp = historyServer.getConfig();
                Assert.assertEquals((Object)expectedValue, (Object)tmp.get("hadoop.http.filter.initializers"));
            }
            finally {
                historyServer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=240000L)
    public void testHostedUIs() throws Exception {
        ApplicationHistoryServer historyServer = new ApplicationHistoryServer();
        YarnConfiguration config = new YarnConfiguration();
        config.setClass("yarn.timeline-service.store-class", MemoryTimelineStore.class, TimelineStore.class);
        config.setClass("yarn.timeline-service.state-store-class", MemoryTimelineStateStore.class, TimelineStateStore.class);
        config.set("yarn.timeline-service.webapp.address", "localhost:0");
        String UI1 = "UI1";
        String connFileStr = "";
        File diskFile = new File("./pom.xml");
        String diskFileStr = this.readInputStream(new FileInputStream(diskFile));
        try {
            config.set("yarn.timeline-service.ui-names", "UI1");
            config.set("yarn.timeline-service.ui-web-path.UI1", "/UI1");
            config.set("yarn.timeline-service.ui-on-disk-path.UI1", "./");
            historyServer.init((Configuration)config);
            historyServer.start();
            URL url = new URL("http://localhost:" + historyServer.getPort() + "/" + "UI1" + "/pom.xml");
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            Assert.assertEquals((long)200L, (long)conn.getResponseCode());
            connFileStr = this.readInputStream(conn.getInputStream());
        }
        finally {
            historyServer.stop();
        }
        Assert.assertEquals((String)"Web file contents should be the same as on disk contents", (Object)diskFileStr, (Object)connFileStr);
    }

    private String readInputStream(InputStream input) throws Exception {
        int read;
        ByteArrayOutputStream data = new ByteArrayOutputStream();
        byte[] buffer = new byte[512];
        while ((read = input.read(buffer)) >= 0) {
            data.write(buffer, 0, read);
        }
        return new String(data.toByteArray(), "UTF-8");
    }
}

