/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.security;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.ObjectName;
import javax.management.StandardMBean;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.security.ssl.CertificateLocalization;
import org.apache.hadoop.security.ssl.CryptoMaterial;
import org.apache.hadoop.security.ssl.FileBasedKeyStoresFactory;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.server.security.CertificateLocalizationMBean;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.mortbay.util.ajax.JSON;

@InterfaceAudience.LimitedPrivate(value={"Hive"})
public class CertificateLocalizationService
extends AbstractService
implements CertificateLocalization,
CertificateLocalizationMBean {
    private final Logger LOG = LogManager.getLogger(CertificateLocalizationService.class);
    private final String SYSTEM_TMP = System.getProperty("java.io.tmpdir", "/tmp");
    private final String LOCALIZATION_DIR_NAME = "certLoc";
    private Path materializeDir;
    private String superKeystoreLocation;
    private String superKeystorePass;
    private String superKeyPassword;
    private String superTrustStoreLocation;
    private String superTruststorePass;
    private final Map<StorageKey, CryptoMaterial> materialLocation = new ConcurrentHashMap<StorageKey, CryptoMaterial>();
    private ObjectName mbeanObjectName;
    private final ServiceType service;
    public static final String JMX_MATERIALIZED_KEY = "materialized";
    public static final String JMX_FORCE_REMOVE_OP = "forceRemoveMaterial";
    private final ReentrantLock lock = new ReentrantLock(true);
    private final BlockingQueue<LocalizationEvent> localizationEventsQ;
    private Thread localizationEventsHandler;

    public CertificateLocalizationService(ServiceType service) {
        super(CertificateLocalizationService.class.getName());
        this.service = service;
        this.localizationEventsQ = new ArrayBlockingQueue<LocalizationEvent>(100);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.parseSuperuserMaterial(conf);
        String localizationDir = this.service.toString() + "_" + "certLoc";
        this.materializeDir = Paths.get(this.SYSTEM_TMP, localizationDir);
        File fileMaterializeDir = this.materializeDir.toFile();
        if (!fileMaterializeDir.exists()) {
            fileMaterializeDir.mkdir();
            EnumSet<PosixFilePermission> materializeDirPerm = this.service == ServiceType.NM ? EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE) : EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE);
            Files.setPosixFilePermissions(this.materializeDir, materializeDirPerm);
        }
        this.LOG.debug((Object)("Initialized at dir: " + this.materializeDir.toString()));
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.localizationEventsHandler = this.createLocalizationEventsHandler();
        this.localizationEventsHandler.setDaemon(true);
        this.localizationEventsHandler.setName("CertificateLocalizationEvents handler");
        this.localizationEventsHandler.start();
        StandardMBean mbean = new StandardMBean(this, CertificateLocalizationMBean.class);
        this.mbeanObjectName = MBeans.register((String)this.service.toString(), (String)"CertificateLocalizer", (Object)mbean);
        super.serviceStart();
    }

    private void parseSuperuserMaterial(Configuration conf) {
        Configuration sslConf = new Configuration(false);
        sslConf.addResource(conf.get("hadoop.ssl.server.conf", "ssl-server.xml"));
        this.superKeystoreLocation = sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.location"));
        this.superKeystorePass = sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.password"));
        this.superKeyPassword = sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.keystore.keypassword"));
        this.superTrustStoreLocation = sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.truststore.location"));
        this.superTruststorePass = sslConf.get(FileBasedKeyStoresFactory.resolvePropertyName((SSLFactory.Mode)SSLFactory.Mode.SERVER, (String)"ssl.{0}.truststore.password"));
    }

    public String getSuperKeystoreLocation() {
        return this.superKeystoreLocation;
    }

    public String getSuperKeystorePass() {
        return this.superKeystorePass;
    }

    public String getSuperKeyPassword() {
        return this.superKeyPassword;
    }

    public String getSuperTruststoreLocation() {
        return this.superTrustStoreLocation;
    }

    public String getSuperTruststorePass() {
        return this.superTruststorePass;
    }

    protected void serviceStop() throws Exception {
        if (this.mbeanObjectName != null) {
            MBeans.unregister((ObjectName)this.mbeanObjectName);
        }
        if (this.localizationEventsHandler != null) {
            this.localizationEventsHandler.interrupt();
        }
        if (null != this.materializeDir) {
            FileUtils.deleteQuietly((File)this.materializeDir.toFile());
        }
        this.LOG.debug((Object)"Stopped CertificateLocalization service");
        super.serviceStop();
    }

    @VisibleForTesting
    public Path getMaterializeDirectory() {
        return this.materializeDir;
    }

    public void materializeCertificates(String username, String userFolder, ByteBuffer keyStore, String keyStorePassword, ByteBuffer trustStore, String trustStorePassword) throws InterruptedException {
        this.materializeCertificates(username, null, userFolder, keyStore, keyStorePassword, trustStore, trustStorePassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void materializeCertificates(String username, String applicationId, String userFolder, ByteBuffer keyStore, String keyStorePassword, ByteBuffer trustStore, String trustStorePassword) throws InterruptedException {
        StorageKey key = new StorageKey(username, applicationId);
        try {
            this.lock.lock();
            CryptoMaterial material = this.materialLocation.get(key);
            if (material != null) {
                material.incrementRequestedApplications();
                this.LOG.debug((Object)("Incrementing requested application to " + material.getRequestedApplications() + " for key " + key));
            } else {
                Path appDirPath = applicationId != null ? Paths.get(this.materializeDir.toString(), userFolder, applicationId) : Paths.get(this.materializeDir.toString(), userFolder);
                Path keyStorePath = Paths.get(appDirPath.toFile().getAbsolutePath(), username + "__kstore.jks");
                Path trustStorePath = Paths.get(appDirPath.toFile().getAbsolutePath(), username + "__tstore.jks");
                Path passwdPath = Paths.get(appDirPath.toFile().getAbsolutePath(), username + "__cert.key");
                CryptoMaterial cryptoMaterial = new CryptoMaterial(appDirPath, keyStorePath, trustStorePath, passwdPath, keyStore, keyStorePassword, trustStore, trustStorePassword);
                this.materialLocation.put(key, cryptoMaterial);
                MaterializeEvent event = new MaterializeEvent(key, cryptoMaterial);
                this.dispatchEvent(event);
                this.LOG.debug((Object)("Dispatch materialize event for key " + key));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeToLocalFS(ByteBuffer keyStore, File keyStoreLocation, ByteBuffer trustStore, File trustStoreLocation, String password, File passwordFileLocation) throws IOException {
        FileChannel keyStoreChannel = new FileOutputStream(keyStoreLocation, false).getChannel();
        keyStoreChannel.write(keyStore);
        keyStoreChannel.close();
        FileChannel trustStoreChannel = new FileOutputStream(trustStoreLocation, false).getChannel();
        trustStoreChannel.write(trustStore);
        trustStoreChannel.close();
        FileUtils.writeStringToFile((File)passwordFileLocation, (String)password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @InterfaceAudience.Private
    @VisibleForTesting
    protected boolean materializeInternal(MaterializeEvent event) {
        CryptoMaterial cryptoMaterial = event.cryptoMaterial;
        synchronized (cryptoMaterial) {
            if (event.cryptoMaterial.hasBeenCanceled()) {
                this.LOG.debug((Object)("Tried to materialize " + event.key + " but it has already been canceled, ignoring..."));
                event.cryptoMaterial.changeState(CryptoMaterial.STATE.FINISHED);
                event.cryptoMaterial.notifyAll();
                return false;
            }
            event.cryptoMaterial.changeState(CryptoMaterial.STATE.ONGOING);
        }
        this.LOG.debug((Object)("Materializing internal for " + event.key));
        File appDirFile = event.cryptoMaterial.getCertFolder().toFile();
        if (!appDirFile.exists()) {
            appDirFile.mkdirs();
        }
        try {
            Object materialPermissions;
            this.writeToLocalFS(event.cryptoMaterial.getKeyStoreMem(), event.cryptoMaterial.getKeyStoreLocation().toFile(), event.cryptoMaterial.getTrustStoreMem(), event.cryptoMaterial.getTrustStoreLocation().toFile(), event.cryptoMaterial.getKeyStorePass(), event.cryptoMaterial.getPasswdLocation().toFile());
            if (this.service == ServiceType.NM) {
                materialPermissions = EnumSet.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE);
                Files.setPosixFilePermissions(event.cryptoMaterial.getCertFolder(), (Set<PosixFilePermission>)materialPermissions);
                Files.setPosixFilePermissions(event.cryptoMaterial.getKeyStoreLocation(), (Set<PosixFilePermission>)materialPermissions);
                Files.setPosixFilePermissions(event.cryptoMaterial.getTrustStoreLocation(), (Set<PosixFilePermission>)materialPermissions);
                Files.setPosixFilePermissions(event.cryptoMaterial.getPasswdLocation(), (Set<PosixFilePermission>)materialPermissions);
            }
            materialPermissions = event.cryptoMaterial;
            synchronized (materialPermissions) {
                event.cryptoMaterial.changeState(CryptoMaterial.STATE.FINISHED);
                event.cryptoMaterial.notifyAll();
            }
            this.LOG.debug((Object)("Finished materialization for " + event.key));
            return true;
        }
        catch (IOException ex) {
            this.LOG.error((Object)ex, (Throwable)ex);
            try {
                this.lock.lock();
                this.materialLocation.remove(event.key);
                FileUtils.deleteQuietly((File)event.cryptoMaterial.getCertFolder().toFile());
                CryptoMaterial cryptoMaterial2 = event.cryptoMaterial;
                synchronized (cryptoMaterial2) {
                    event.cryptoMaterial.changeState(CryptoMaterial.STATE.FINISHED);
                    event.cryptoMaterial.notifyAll();
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private void dispatchEvent(LocalizationEvent event) throws InterruptedException {
        this.localizationEventsQ.put(event);
    }

    public void removeMaterial(String username) throws InterruptedException {
        this.removeMaterial(username, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMaterial(String username, String applicationId) throws InterruptedException {
        StorageKey key = new StorageKey(username, applicationId);
        try {
            this.lock.lock();
            CryptoMaterial material = this.materialLocation.get(key);
            if (material != null) {
                material.decrementRequestedApplications();
                this.LOG.debug((Object)("Decrementing requested applications to " + material.getRequestedApplications() + " for key " + key));
                if (material.isSafeToRemove()) {
                    RemoveEvent event = new RemoveEvent(material.getCertFolder());
                    this.materialLocation.remove(key);
                    this.dispatchEvent(event);
                    this.LOG.debug((Object)("Dispatching remove event for key " + key));
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void removeInternal(RemoveEvent event) {
        this.LOG.debug((Object)("Purging directory " + event.certificatesDirectory));
        FileUtils.deleteQuietly((File)event.certificatesDirectory.toFile());
    }

    public CryptoMaterial getMaterialLocation(String username) throws FileNotFoundException, InterruptedException {
        return this.getMaterialLocation(username, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CryptoMaterial getMaterialLocation(String username, String applicationId) throws FileNotFoundException, InterruptedException {
        StorageKey key = new StorageKey(username, applicationId);
        CryptoMaterial material = this.materialLocation.get(key);
        this.LOG.debug((Object)("Trying to get material for key " + key));
        if (material == null) {
            throw new FileNotFoundException("Materialized crypto material could not be found for user " + key);
        }
        CryptoMaterial cryptoMaterial = material;
        synchronized (cryptoMaterial) {
            while (!material.getState().equals((Object)CryptoMaterial.STATE.FINISHED)) {
                this.LOG.debug((Object)("Waiting to get notified for key " + key));
                material.wait();
            }
            this.LOG.debug((Object)("Notified for key " + key));
            material = this.materialLocation.get(key);
            if (material == null) {
                throw new FileNotFoundException("Materializer could not materialize certificate for " + key);
            }
            return material;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCryptoMaterial(String username, String applicationId, ByteBuffer keyStore, String keyStorePassword, ByteBuffer trustStore, String trustStorePassword) throws IOException, InterruptedException {
        StorageKey key = new StorageKey(username, applicationId);
        CryptoMaterial material = this.materialLocation.get(key);
        if (material == null) {
            this.LOG.warn((Object)("Requested to update crypto material for " + key + " but material is missing"));
            return;
        }
        CryptoMaterial cryptoMaterial = material;
        synchronized (cryptoMaterial) {
            while (!material.getState().equals((Object)CryptoMaterial.STATE.FINISHED)) {
                material.wait();
            }
            material.changeState(CryptoMaterial.STATE.ONGOING);
        }
        try {
            this.lock.lock();
            material = this.materialLocation.get(key);
            if (material == null) {
                return;
            }
            this.writeToLocalFS(keyStore.asReadOnlyBuffer(), material.getKeyStoreLocation().toFile(), trustStore.asReadOnlyBuffer(), material.getTrustStoreLocation().toFile(), keyStorePassword, material.getPasswdLocation().toFile());
            material.updateKeyStoreMem(keyStore);
            material.updateKeyStorePass(keyStorePassword);
            material.updateTrustStoreMem(trustStore);
            material.updateTrustStorePass(trustStorePassword);
        }
        finally {
            if (material != null) {
                cryptoMaterial = material;
                synchronized (cryptoMaterial) {
                    material.changeState(CryptoMaterial.STATE.FINISHED);
                    material.notifyAll();
                }
            }
            this.lock.unlock();
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected LocalizationEvent dequeue() throws InterruptedException {
        return this.localizationEventsQ.take();
    }

    @Override
    public String getState() {
        ImmutableMap state;
        try {
            this.lock.lock();
            state = ImmutableMap.copyOf(this.materialLocation);
        }
        finally {
            this.lock.unlock();
        }
        ReturnState returnState = new ReturnState();
        ReturnState internalState = new ReturnState();
        for (Map.Entry entry : state.entrySet()) {
            internalState.put(((StorageKey)entry.getKey()).username, ((CryptoMaterial)entry.getValue()).getRequestedApplications());
        }
        returnState.put(JMX_MATERIALIZED_KEY, JSON.toString(internalState));
        return JSON.toString(returnState);
    }

    @Override
    public boolean forceRemoveMaterial(String username) throws InterruptedException, ExecutionException {
        return this.forceRemoveMaterial(username, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forceRemoveMaterial(String username, String applicationId) throws InterruptedException, ExecutionException {
        StorageKey key = new StorageKey(username, applicationId);
        CryptoMaterial material = this.materialLocation.remove(key);
        if (material != null) {
            boolean managedToCancel;
            CryptoMaterial cryptoMaterial = material;
            synchronized (cryptoMaterial) {
                managedToCancel = material.tryToCancel();
            }
            if (managedToCancel) {
                FileUtils.deleteQuietly((File)material.getCertFolder().toFile());
            } else {
                cryptoMaterial = material;
                synchronized (cryptoMaterial) {
                    while (!material.getState().equals((Object)CryptoMaterial.STATE.FINISHED)) {
                        material.wait();
                    }
                    FileUtils.deleteQuietly((File)material.getCertFolder().toFile());
                }
            }
            return true;
        }
        return false;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected Thread createLocalizationEventsHandler() {
        return new LocalizationEventsHandler();
    }

    private class LocalizationEventsHandler
    extends Thread {
        private LocalizationEventsHandler() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    LocalizationEvent event = (LocalizationEvent)CertificateLocalizationService.this.localizationEventsQ.take();
                    if (event instanceof MaterializeEvent) {
                        CertificateLocalizationService.this.materializeInternal((MaterializeEvent)event);
                        continue;
                    }
                    if (event instanceof RemoveEvent) {
                        CertificateLocalizationService.this.removeInternal((RemoveEvent)event);
                        continue;
                    }
                    CertificateLocalizationService.this.LOG.warn((Object)"Unknown event type");
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
            }
            CertificateLocalizationService.this.LOG.info((Object)"Stopping localization events handler thread");
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected class RemoveEvent
    implements LocalizationEvent {
        private final Path certificatesDirectory;

        private RemoveEvent(Path certificatesDirectory) {
            this.certificatesDirectory = certificatesDirectory;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected class MaterializeEvent
    implements LocalizationEvent {
        private final StorageKey key;
        private final CryptoMaterial cryptoMaterial;

        private MaterializeEvent(StorageKey key, CryptoMaterial cryptoMaterial) {
            this.key = key;
            this.cryptoMaterial = cryptoMaterial;
        }
    }

    private class StorageKey {
        private final String username;
        private final String applicationId;

        public StorageKey(String username, String applicationId) {
            this.username = username;
            this.applicationId = applicationId;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof StorageKey)) {
                return false;
            }
            if (this.applicationId != null) {
                return this.username.equals(((StorageKey)other).username) && this.applicationId.equals(((StorageKey)other).applicationId);
            }
            return this.username.equals(((StorageKey)other).username);
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.username.hashCode();
            if (this.applicationId != null) {
                result = 31 * result + this.applicationId.hashCode();
            }
            return result;
        }

        public String toString() {
            String appId = this.applicationId != null ? this.applicationId : "unknown";
            return "CryptoKey <" + this.username + ", " + appId + ">";
        }
    }

    private class ReturnState<S, T>
    extends HashMap<S, T> {
        private static final long serialVersionUID = 1L;

        private ReturnState() {
        }
    }

    public static enum ServiceType {
        RM("RM"),
        NM("NM"),
        HS2("HS2"),
        HM("HM"),
        LLAP("LLAP");

        private final String service;

        private ServiceType(String service) {
            this.service = service;
        }

        public String toString() {
            return this.service;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected static interface LocalizationEvent {
    }
}

