/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb;

import com.google.protobuf.ByteString;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.SignalContainerRequestPBImpl;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoBase;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonServiceProtos;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdatedCryptoForApp;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.UpdatedCryptoForAppPBImpl;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.api.records.impl.pb.MasterKeyPBImpl;

public class NodeHeartbeatResponsePBImpl
extends ProtoBase<YarnServerCommonServiceProtos.NodeHeartbeatResponseProto>
implements NodeHeartbeatResponse {
    YarnServerCommonServiceProtos.NodeHeartbeatResponseProto proto = YarnServerCommonServiceProtos.NodeHeartbeatResponseProto.getDefaultInstance();
    YarnServerCommonServiceProtos.NodeHeartbeatResponseProto.Builder builder = null;
    boolean viaProto = false;
    private List<ContainerId> containersToCleanup = null;
    private List<ContainerId> containersToBeRemovedFromNM = null;
    private List<ApplicationId> applicationsToCleanup = null;
    private Map<ApplicationId, ByteBuffer> systemCredentials = null;
    private Resource resource = null;
    private MasterKey containerTokenMasterKey = null;
    private MasterKey nmTokenMasterKey = null;
    private List<Container> containersToDecrease = null;
    private List<SignalContainerRequest> containersToSignal = null;
    private Map<ApplicationId, UpdatedCryptoForApp> updatedCryptoForApps = null;

    public NodeHeartbeatResponsePBImpl() {
        this.builder = YarnServerCommonServiceProtos.NodeHeartbeatResponseProto.newBuilder();
    }

    public NodeHeartbeatResponsePBImpl(YarnServerCommonServiceProtos.NodeHeartbeatResponseProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerCommonServiceProtos.NodeHeartbeatResponseProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.containersToCleanup != null) {
            this.addContainersToCleanupToProto();
        }
        if (this.applicationsToCleanup != null) {
            this.addApplicationsToCleanupToProto();
        }
        if (this.containersToBeRemovedFromNM != null) {
            this.addContainersToBeRemovedFromNMToProto();
        }
        if (this.containerTokenMasterKey != null) {
            this.builder.setContainerTokenMasterKey(this.convertToProtoFormat(this.containerTokenMasterKey));
        }
        if (this.nmTokenMasterKey != null) {
            this.builder.setNmTokenMasterKey(this.convertToProtoFormat(this.nmTokenMasterKey));
        }
        if (this.systemCredentials != null) {
            this.addSystemCredentialsToProto();
        }
        if (this.containersToDecrease != null) {
            this.addContainersToDecreaseToProto();
        }
        if (this.containersToSignal != null) {
            this.addContainersToSignalToProto();
        }
        if (this.updatedCryptoForApps != null) {
            this.addUpdatedCryptoForAppsToProto();
        }
        if (this.resource != null) {
            this.builder.setResource(this.convertToProtoFormat(this.resource));
        }
    }

    private void addSystemCredentialsToProto() {
        this.maybeInitBuilder();
        this.builder.clearSystemCredentialsForApps();
        for (Map.Entry<ApplicationId, ByteBuffer> entry : this.systemCredentials.entrySet()) {
            this.builder.addSystemCredentialsForApps(YarnServerCommonServiceProtos.SystemCredentialsForAppsProto.newBuilder().setAppId(this.convertToProtoFormat(entry.getKey())).setCredentialsForApp(ProtoUtils.convertToProtoFormat((ByteBuffer)entry.getValue().duplicate())));
        }
    }

    private void addUpdatedCryptoForAppsToProto() {
        this.maybeInitBuilder();
        this.builder.clearUpdatedCryptoForApps();
        if (this.updatedCryptoForApps == null) {
            return;
        }
        for (Map.Entry<ApplicationId, UpdatedCryptoForApp> entry : this.updatedCryptoForApps.entrySet()) {
            this.builder.addUpdatedCryptoForApps(YarnServerCommonServiceProtos.UpdatedCryptoForAppsProto.newBuilder().setAppId(this.convertToProtoFormat(entry.getKey())).setUpdatedCryptoForApp(YarnServerCommonServiceProtos.UpdatedCryptoForAppProto.newBuilder().setKeyStore(ProtoUtils.convertToProtoFormat((ByteBuffer)entry.getValue().getKeyStore().duplicate())).setKeyStorePassword(String.valueOf(entry.getValue().getKeyStorePassword())).setTrustStore(ProtoUtils.convertToProtoFormat((ByteBuffer)entry.getValue().getTrustStore().duplicate())).setTrustStorePassword(String.valueOf(entry.getValue().getTrustStorePassword())).setVersion(entry.getValue().getVersion())));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerCommonServiceProtos.NodeHeartbeatResponseProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public int getResponseId() {
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getResponseId();
    }

    @Override
    public void setResponseId(int responseId) {
        this.maybeInitBuilder();
        this.builder.setResponseId(responseId);
    }

    @Override
    public Resource getResource() {
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p;
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder nodeHeartbeatResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.resource != null) {
            return this.resource;
        }
        if (!p.hasResource()) {
            return null;
        }
        this.resource = this.convertFromProtoFormat(p.getResource());
        return this.resource;
    }

    @Override
    public void setResource(Resource resource) {
        this.maybeInitBuilder();
        if (resource == null) {
            this.builder.clearResource();
        }
        this.resource = resource;
    }

    @Override
    public MasterKey getContainerTokenMasterKey() {
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p;
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder nodeHeartbeatResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.containerTokenMasterKey != null) {
            return this.containerTokenMasterKey;
        }
        if (!p.hasContainerTokenMasterKey()) {
            return null;
        }
        this.containerTokenMasterKey = this.convertFromProtoFormat(p.getContainerTokenMasterKey());
        return this.containerTokenMasterKey;
    }

    @Override
    public void setContainerTokenMasterKey(MasterKey masterKey) {
        this.maybeInitBuilder();
        if (masterKey == null) {
            this.builder.clearContainerTokenMasterKey();
        }
        this.containerTokenMasterKey = masterKey;
    }

    @Override
    public MasterKey getNMTokenMasterKey() {
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p;
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder nodeHeartbeatResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.nmTokenMasterKey != null) {
            return this.nmTokenMasterKey;
        }
        if (!p.hasNmTokenMasterKey()) {
            return null;
        }
        this.nmTokenMasterKey = this.convertFromProtoFormat(p.getNmTokenMasterKey());
        return this.nmTokenMasterKey;
    }

    @Override
    public void setNMTokenMasterKey(MasterKey masterKey) {
        this.maybeInitBuilder();
        if (masterKey == null) {
            this.builder.clearNmTokenMasterKey();
        }
        this.nmTokenMasterKey = masterKey;
    }

    @Override
    public NodeAction getNodeAction() {
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p;
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder nodeHeartbeatResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeAction()) {
            return null;
        }
        return this.convertFromProtoFormat(p.getNodeAction());
    }

    @Override
    public void setNodeAction(NodeAction nodeAction) {
        this.maybeInitBuilder();
        if (nodeAction == null) {
            this.builder.clearNodeAction();
            return;
        }
        this.builder.setNodeAction(this.convertToProtoFormat(nodeAction));
    }

    @Override
    public String getDiagnosticsMessage() {
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p;
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder nodeHeartbeatResponseProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasDiagnosticsMessage()) {
            return null;
        }
        return p.getDiagnosticsMessage();
    }

    @Override
    public void setDiagnosticsMessage(String diagnosticsMessage) {
        this.maybeInitBuilder();
        if (diagnosticsMessage == null) {
            this.builder.clearDiagnosticsMessage();
            return;
        }
        this.builder.setDiagnosticsMessage(diagnosticsMessage);
    }

    @Override
    public List<ContainerId> getContainersToCleanup() {
        this.initContainersToCleanup();
        return this.containersToCleanup;
    }

    @Override
    public List<ContainerId> getContainersToBeRemovedFromNM() {
        this.initContainersToBeRemovedFromNM();
        return this.containersToBeRemovedFromNM;
    }

    private void initContainersToCleanup() {
        if (this.containersToCleanup != null) {
            return;
        }
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ContainerIdProto> list = p.getContainersToCleanupList();
        this.containersToCleanup = new ArrayList<ContainerId>();
        for (YarnProtos.ContainerIdProto c : list) {
            this.containersToCleanup.add((ContainerId)this.convertFromProtoFormat(c));
        }
    }

    private void initContainersToBeRemovedFromNM() {
        if (this.containersToBeRemovedFromNM != null) {
            return;
        }
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ContainerIdProto> list = p.getContainersToBeRemovedFromNmList();
        this.containersToBeRemovedFromNM = new ArrayList<ContainerId>();
        for (YarnProtos.ContainerIdProto c : list) {
            this.containersToBeRemovedFromNM.add((ContainerId)this.convertFromProtoFormat(c));
        }
    }

    @Override
    public void addAllContainersToCleanup(List<ContainerId> containersToCleanup) {
        if (containersToCleanup == null) {
            return;
        }
        this.initContainersToCleanup();
        this.containersToCleanup.addAll(containersToCleanup);
    }

    @Override
    public void addContainersToBeRemovedFromNM(List<ContainerId> containers) {
        if (containers == null) {
            return;
        }
        this.initContainersToBeRemovedFromNM();
        this.containersToBeRemovedFromNM.addAll(containers);
    }

    private void addContainersToCleanupToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainersToCleanup();
        if (this.containersToCleanup == null) {
            return;
        }
        Iterable<YarnProtos.ContainerIdProto> iterable = new Iterable<YarnProtos.ContainerIdProto>(){

            @Override
            public Iterator<YarnProtos.ContainerIdProto> iterator() {
                return new Iterator<YarnProtos.ContainerIdProto>(){
                    Iterator<ContainerId> iter;
                    {
                        this.iter = NodeHeartbeatResponsePBImpl.this.containersToCleanup.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ContainerIdProto next() {
                        return NodeHeartbeatResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllContainersToCleanup((Iterable<? extends YarnProtos.ContainerIdProto>)iterable);
    }

    private void addContainersToBeRemovedFromNMToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainersToBeRemovedFromNm();
        if (this.containersToBeRemovedFromNM == null) {
            return;
        }
        Iterable<YarnProtos.ContainerIdProto> iterable = new Iterable<YarnProtos.ContainerIdProto>(){

            @Override
            public Iterator<YarnProtos.ContainerIdProto> iterator() {
                return new Iterator<YarnProtos.ContainerIdProto>(){
                    Iterator<ContainerId> iter;
                    {
                        this.iter = NodeHeartbeatResponsePBImpl.this.containersToBeRemovedFromNM.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ContainerIdProto next() {
                        return NodeHeartbeatResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllContainersToBeRemovedFromNm((Iterable<? extends YarnProtos.ContainerIdProto>)iterable);
    }

    @Override
    public List<ApplicationId> getApplicationsToCleanup() {
        this.initApplicationsToCleanup();
        return this.applicationsToCleanup;
    }

    private void initApplicationsToCleanup() {
        if (this.applicationsToCleanup != null) {
            return;
        }
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ApplicationIdProto> list = p.getApplicationsToCleanupList();
        this.applicationsToCleanup = new ArrayList<ApplicationId>();
        for (YarnProtos.ApplicationIdProto c : list) {
            this.applicationsToCleanup.add((ApplicationId)this.convertFromProtoFormat(c));
        }
    }

    @Override
    public void addAllApplicationsToCleanup(List<ApplicationId> applicationsToCleanup) {
        if (applicationsToCleanup == null) {
            return;
        }
        this.initApplicationsToCleanup();
        this.applicationsToCleanup.addAll(applicationsToCleanup);
    }

    private void addApplicationsToCleanupToProto() {
        this.maybeInitBuilder();
        this.builder.clearApplicationsToCleanup();
        if (this.applicationsToCleanup == null) {
            return;
        }
        Iterable<YarnProtos.ApplicationIdProto> iterable = new Iterable<YarnProtos.ApplicationIdProto>(){

            @Override
            public Iterator<YarnProtos.ApplicationIdProto> iterator() {
                return new Iterator<YarnProtos.ApplicationIdProto>(){
                    Iterator<ApplicationId> iter;
                    {
                        this.iter = NodeHeartbeatResponsePBImpl.this.applicationsToCleanup.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ApplicationIdProto next() {
                        return NodeHeartbeatResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllApplicationsToCleanup((Iterable<? extends YarnProtos.ApplicationIdProto>)iterable);
    }

    private void initContainersToDecrease() {
        if (this.containersToDecrease != null) {
            return;
        }
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnProtos.ContainerProto> list = p.getContainersToDecreaseList();
        this.containersToDecrease = new ArrayList<Container>();
        for (YarnProtos.ContainerProto c : list) {
            this.containersToDecrease.add((Container)this.convertFromProtoFormat(c));
        }
    }

    @Override
    public List<Container> getContainersToDecrease() {
        this.initContainersToDecrease();
        return this.containersToDecrease;
    }

    @Override
    public void addAllContainersToDecrease(Collection<Container> containersToDecrease) {
        if (containersToDecrease == null) {
            return;
        }
        this.initContainersToDecrease();
        this.containersToDecrease.addAll(containersToDecrease);
    }

    private void addContainersToDecreaseToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainersToDecrease();
        if (this.containersToDecrease == null) {
            return;
        }
        Iterable<YarnProtos.ContainerProto> iterable = new Iterable<YarnProtos.ContainerProto>(){

            @Override
            public Iterator<YarnProtos.ContainerProto> iterator() {
                return new Iterator<YarnProtos.ContainerProto>(){
                    private Iterator<Container> iter;
                    {
                        this.iter = NodeHeartbeatResponsePBImpl.this.containersToDecrease.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnProtos.ContainerProto next() {
                        return NodeHeartbeatResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllContainersToDecrease((Iterable<? extends YarnProtos.ContainerProto>)iterable);
    }

    @Override
    public Map<ApplicationId, ByteBuffer> getSystemCredentialsForApps() {
        if (this.systemCredentials != null) {
            return this.systemCredentials;
        }
        this.initSystemCredentials();
        return this.systemCredentials;
    }

    private void initSystemCredentials() {
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServerCommonServiceProtos.SystemCredentialsForAppsProto> list = p.getSystemCredentialsForAppsList();
        this.systemCredentials = new HashMap<ApplicationId, ByteBuffer>();
        for (YarnServerCommonServiceProtos.SystemCredentialsForAppsProto c : list) {
            ApplicationIdPBImpl appId = this.convertFromProtoFormat(c.getAppId());
            ByteBuffer byteBuffer = ProtoUtils.convertFromProtoFormat((ByteString)c.getCredentialsForApp());
            this.systemCredentials.put((ApplicationId)appId, byteBuffer);
        }
    }

    @Override
    public Map<ApplicationId, UpdatedCryptoForApp> getUpdatedCryptoForApps() {
        if (this.updatedCryptoForApps != null) {
            return this.updatedCryptoForApps;
        }
        this.initUpdatedCryptoForApps();
        return this.updatedCryptoForApps;
    }

    @Override
    public void setUpdatedCryptoForApps(Map<ApplicationId, UpdatedCryptoForApp> updatedCryptoForApps) {
        if (updatedCryptoForApps == null) {
            return;
        }
        this.initUpdatedCryptoForApps();
        this.updatedCryptoForApps.clear();
        this.updatedCryptoForApps.putAll(updatedCryptoForApps);
    }

    private void initUpdatedCryptoForApps() {
        if (this.updatedCryptoForApps != null) {
            return;
        }
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServerCommonServiceProtos.UpdatedCryptoForAppsProto> list = p.getUpdatedCryptoForAppsList();
        this.updatedCryptoForApps = new HashMap<ApplicationId, UpdatedCryptoForApp>();
        for (YarnServerCommonServiceProtos.UpdatedCryptoForAppsProto ucp : list) {
            ApplicationIdPBImpl appId = this.convertFromProtoFormat(ucp.getAppId());
            UpdatedCryptoForAppPBImpl updatedCryptoForApp = this.convertFromProtoFormat(ucp.getUpdatedCryptoForApp());
            this.updatedCryptoForApps.put((ApplicationId)appId, updatedCryptoForApp);
        }
    }

    private UpdatedCryptoForAppPBImpl convertFromProtoFormat(YarnServerCommonServiceProtos.UpdatedCryptoForAppProto p) {
        return new UpdatedCryptoForAppPBImpl(p);
    }

    @Override
    public void setSystemCredentialsForApps(Map<ApplicationId, ByteBuffer> systemCredentials) {
        if (systemCredentials == null || systemCredentials.isEmpty()) {
            return;
        }
        this.maybeInitBuilder();
        this.systemCredentials = new HashMap<ApplicationId, ByteBuffer>();
        this.systemCredentials.putAll(systemCredentials);
    }

    @Override
    public long getNextHeartBeatInterval() {
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getNextHeartBeatInterval();
    }

    @Override
    public void setNextHeartBeatInterval(long nextHeartBeatInterval) {
        this.maybeInitBuilder();
        this.builder.setNextHeartBeatInterval(nextHeartBeatInterval);
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t) {
        return ((ResourcePBImpl)t).getProto();
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto p) {
        return new ApplicationIdPBImpl(p);
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t) {
        return ((ApplicationIdPBImpl)t).getProto();
    }

    private NodeAction convertFromProtoFormat(YarnServerCommonProtos.NodeActionProto p) {
        return NodeAction.valueOf(p.name());
    }

    private YarnServerCommonProtos.NodeActionProto convertToProtoFormat(NodeAction t) {
        return YarnServerCommonProtos.NodeActionProto.valueOf(t.name());
    }

    private MasterKeyPBImpl convertFromProtoFormat(YarnServerCommonProtos.MasterKeyProto p) {
        return new MasterKeyPBImpl(p);
    }

    private YarnServerCommonProtos.MasterKeyProto convertToProtoFormat(MasterKey t) {
        return ((MasterKeyPBImpl)t).getProto();
    }

    private ContainerPBImpl convertFromProtoFormat(YarnProtos.ContainerProto p) {
        return new ContainerPBImpl(p);
    }

    private YarnProtos.ContainerProto convertToProtoFormat(Container t) {
        return ((ContainerPBImpl)t).getProto();
    }

    @Override
    public boolean getAreNodeLabelsAcceptedByRM() {
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getAreNodeLabelsAcceptedByRM();
    }

    @Override
    public void setAreNodeLabelsAcceptedByRM(boolean areNodeLabelsAcceptedByRM) {
        this.maybeInitBuilder();
        this.builder.setAreNodeLabelsAcceptedByRM(areNodeLabelsAcceptedByRM);
    }

    @Override
    public List<SignalContainerRequest> getContainersToSignalList() {
        this.initContainersToSignal();
        return this.containersToSignal;
    }

    private void initContainersToSignal() {
        if (this.containersToSignal != null) {
            return;
        }
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServiceProtos.SignalContainerRequestProto> list = p.getContainersToSignalList();
        this.containersToSignal = new ArrayList<SignalContainerRequest>();
        for (YarnServiceProtos.SignalContainerRequestProto c : list) {
            this.containersToSignal.add((SignalContainerRequest)this.convertFromProtoFormat(c));
        }
    }

    @Override
    public void addAllContainersToSignal(List<SignalContainerRequest> containersToSignal) {
        if (containersToSignal == null) {
            return;
        }
        this.initContainersToSignal();
        this.containersToSignal.addAll(containersToSignal);
    }

    private void addContainersToSignalToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainersToSignal();
        if (this.containersToSignal == null) {
            return;
        }
        Iterable<YarnServiceProtos.SignalContainerRequestProto> iterable = new Iterable<YarnServiceProtos.SignalContainerRequestProto>(){

            @Override
            public Iterator<YarnServiceProtos.SignalContainerRequestProto> iterator() {
                return new Iterator<YarnServiceProtos.SignalContainerRequestProto>(){
                    Iterator<SignalContainerRequest> iter;
                    {
                        this.iter = NodeHeartbeatResponsePBImpl.this.containersToSignal.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnServiceProtos.SignalContainerRequestProto next() {
                        return NodeHeartbeatResponsePBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllContainersToSignal((Iterable<? extends YarnServiceProtos.SignalContainerRequestProto>)iterable);
    }

    private SignalContainerRequestPBImpl convertFromProtoFormat(YarnServiceProtos.SignalContainerRequestProto p) {
        return new SignalContainerRequestPBImpl(p);
    }

    private YarnServiceProtos.SignalContainerRequestProto convertToProtoFormat(SignalContainerRequest t) {
        return ((SignalContainerRequestPBImpl)t).getProto();
    }

    @Override
    public synchronized boolean getNextheartbeat() {
        YarnServerCommonServiceProtos.NodeHeartbeatResponseProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getNextheartbeat();
    }

    @Override
    public void setNextheartbeat(boolean nextHeartbeat) {
        this.maybeInitBuilder();
        this.builder.setNextheartbeat(nextHeartbeat);
    }
}

