/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeLabelPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.NMContainerStatusPBImpl;

public class RegisterNodeManagerRequestPBImpl
extends RegisterNodeManagerRequest {
    YarnServerCommonServiceProtos.RegisterNodeManagerRequestProto proto = YarnServerCommonServiceProtos.RegisterNodeManagerRequestProto.getDefaultInstance();
    YarnServerCommonServiceProtos.RegisterNodeManagerRequestProto.Builder builder = null;
    boolean viaProto = false;
    private Resource resource = null;
    private NodeId nodeId = null;
    private List<NMContainerStatus> containerStatuses = null;
    private Map<ApplicationId, Integer> runningApplications = null;
    private Set<NodeLabel> labels = null;

    public RegisterNodeManagerRequestPBImpl() {
        this.builder = YarnServerCommonServiceProtos.RegisterNodeManagerRequestProto.newBuilder();
    }

    public RegisterNodeManagerRequestPBImpl(YarnServerCommonServiceProtos.RegisterNodeManagerRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerCommonServiceProtos.RegisterNodeManagerRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToBuilder() {
        if (this.containerStatuses != null) {
            this.addNMContainerStatusesToProto();
        }
        if (this.runningApplications != null) {
            this.addRunningApplicationsToProto();
        }
        if (this.resource != null) {
            this.builder.setResource(this.convertToProtoFormat(this.resource));
        }
        if (this.nodeId != null) {
            this.builder.setNodeId(this.convertToProtoFormat(this.nodeId));
        }
        if (this.labels != null) {
            this.builder.clearNodeLabels();
            YarnServerCommonServiceProtos.NodeLabelsProto.Builder newBuilder = YarnServerCommonServiceProtos.NodeLabelsProto.newBuilder();
            for (NodeLabel label : this.labels) {
                newBuilder.addNodeLabels(this.convertToProtoFormat(label));
            }
            this.builder.setNodeLabels(newBuilder.build());
        }
    }

    private synchronized void addNMContainerStatusesToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainerStatuses();
        ArrayList<YarnServerCommonServiceProtos.NMContainerStatusProto> list = new ArrayList<YarnServerCommonServiceProtos.NMContainerStatusProto>();
        for (NMContainerStatus status : this.containerStatuses) {
            list.add(this.convertToProtoFormat(status));
        }
        this.builder.addAllContainerStatuses(list);
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerCommonServiceProtos.RegisterNodeManagerRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public Resource getResource() {
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p;
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder registerNodeManagerRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.resource != null) {
            return this.resource;
        }
        if (!p.hasResource()) {
            return null;
        }
        this.resource = this.convertFromProtoFormat(p.getResource());
        return this.resource;
    }

    @Override
    public void setResource(Resource resource) {
        this.maybeInitBuilder();
        if (resource == null) {
            this.builder.clearResource();
        }
        this.resource = resource;
    }

    @Override
    public NodeId getNodeId() {
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p;
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder registerNodeManagerRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.nodeId != null) {
            return this.nodeId;
        }
        if (!p.hasNodeId()) {
            return null;
        }
        this.nodeId = this.convertFromProtoFormat(p.getNodeId());
        return this.nodeId;
    }

    @Override
    public void setNodeId(NodeId nodeId) {
        this.maybeInitBuilder();
        if (nodeId == null) {
            this.builder.clearNodeId();
        }
        this.nodeId = nodeId;
    }

    @Override
    public int getHttpPort() {
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p;
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder registerNodeManagerRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasHttpPort()) {
            return 0;
        }
        return p.getHttpPort();
    }

    @Override
    public void setHttpPort(int httpPort) {
        this.maybeInitBuilder();
        this.builder.setHttpPort(httpPort);
    }

    @Override
    public Map<ApplicationId, Integer> getRunningApplications() {
        this.initRunningApplications();
        return this.runningApplications;
    }

    private void initRunningApplications() {
        if (this.runningApplications != null) {
            return;
        }
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServerCommonServiceProtos.RunningApplicationsProto> list = p.getRunningApplicationsList();
        this.runningApplications = new HashMap<ApplicationId, Integer>(list.size());
        for (YarnServerCommonServiceProtos.RunningApplicationsProto rup : list) {
            ApplicationIdPBImpl appId = this.convertFromProtoFormat(rup.getAppId());
            Integer cryptoVersion = rup.getCryptoMaterialVersion();
            this.runningApplications.put((ApplicationId)appId, cryptoVersion);
        }
    }

    @Override
    public void setRunningApplications(Map<ApplicationId, Integer> apps) {
        if (apps == null) {
            return;
        }
        this.initRunningApplications();
        this.runningApplications.putAll(apps);
    }

    private void addRunningApplicationsToProto() {
        this.maybeInitBuilder();
        this.builder.clearRunningApplications();
        if (this.runningApplications == null) {
            return;
        }
        for (Map.Entry<ApplicationId, Integer> entry : this.runningApplications.entrySet()) {
            this.builder.addRunningApplications(YarnServerCommonServiceProtos.RunningApplicationsProto.newBuilder().setAppId(this.convertToProtoFormat(entry.getKey())).setCryptoMaterialVersion(entry.getValue()));
        }
    }

    @Override
    public List<NMContainerStatus> getNMContainerStatuses() {
        this.initContainerRecoveryReports();
        return this.containerStatuses;
    }

    private void initContainerRecoveryReports() {
        if (this.containerStatuses != null) {
            return;
        }
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServerCommonServiceProtos.NMContainerStatusProto> list = p.getContainerStatusesList();
        this.containerStatuses = new ArrayList<NMContainerStatus>();
        for (YarnServerCommonServiceProtos.NMContainerStatusProto c : list) {
            this.containerStatuses.add(this.convertFromProtoFormat(c));
        }
    }

    @Override
    public void setContainerStatuses(List<NMContainerStatus> containerReports) {
        if (containerReports == null) {
            return;
        }
        this.initContainerRecoveryReports();
        this.containerStatuses.addAll(containerReports);
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((RegisterNodeManagerRequestPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    @Override
    public String getNMVersion() {
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p;
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder registerNodeManagerRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNmVersion()) {
            return "";
        }
        return p.getNmVersion();
    }

    @Override
    public void setNMVersion(String version) {
        this.maybeInitBuilder();
        this.builder.setNmVersion(version);
    }

    @Override
    public Set<NodeLabel> getNodeLabels() {
        this.initNodeLabels();
        return this.labels;
    }

    @Override
    public void setNodeLabels(Set<NodeLabel> nodeLabels) {
        this.maybeInitBuilder();
        this.builder.clearNodeLabels();
        this.labels = nodeLabels;
    }

    private void initNodeLabels() {
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p;
        if (this.labels != null) {
            return;
        }
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder registerNodeManagerRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeLabels()) {
            this.labels = null;
            return;
        }
        YarnServerCommonServiceProtos.NodeLabelsProto nodeLabels = p.getNodeLabels();
        this.labels = new HashSet<NodeLabel>();
        for (YarnProtos.NodeLabelProto nlp : nodeLabels.getNodeLabelsList()) {
            this.labels.add((NodeLabel)this.convertFromProtoFormat(nlp));
        }
    }

    private NodeLabelPBImpl convertFromProtoFormat(YarnProtos.NodeLabelProto p) {
        return new NodeLabelPBImpl(p);
    }

    private YarnProtos.NodeLabelProto convertToProtoFormat(NodeLabel t) {
        return ((NodeLabelPBImpl)t).getProto();
    }

    private ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto p) {
        return new ApplicationIdPBImpl(p);
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t) {
        return ((ApplicationIdPBImpl)t).getProto();
    }

    private NodeIdPBImpl convertFromProtoFormat(YarnProtos.NodeIdProto p) {
        return new NodeIdPBImpl(p);
    }

    private YarnProtos.NodeIdProto convertToProtoFormat(NodeId t) {
        return ((NodeIdPBImpl)t).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t) {
        return ((ResourcePBImpl)t).getProto();
    }

    private NMContainerStatusPBImpl convertFromProtoFormat(YarnServerCommonServiceProtos.NMContainerStatusProto c) {
        return new NMContainerStatusPBImpl(c);
    }

    private YarnServerCommonServiceProtos.NMContainerStatusProto convertToProtoFormat(NMContainerStatus c) {
        return ((NMContainerStatusPBImpl)c).getProto();
    }
}

