/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.exception.FederationStateStoreException;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class FederationStateStoreBaseTest {
    private static final MonotonicClock CLOCK = new MonotonicClock();
    private FederationStateStore stateStore = this.createStateStore();
    private Configuration conf;

    protected abstract FederationStateStore createStateStore();

    @Before
    public void before() throws IOException, YarnException {
        this.stateStore.init(this.conf);
    }

    @After
    public void after() throws Exception {
        this.stateStore.close();
    }

    @Test
    public void testRegisterSubCluster() throws Exception {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        SubClusterInfo subClusterInfo = this.createSubClusterInfo(subClusterId);
        long previousTimeStamp = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis();
        SubClusterRegisterResponse result = this.stateStore.registerSubCluster(SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo));
        long currentTimeStamp = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis();
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)subClusterInfo, (Object)this.querySubClusterInfo(subClusterId));
        Assert.assertTrue((this.querySubClusterInfo(subClusterId).getLastHeartBeat() <= currentTimeStamp ? 1 : 0) != 0);
        Assert.assertTrue((this.querySubClusterInfo(subClusterId).getLastHeartBeat() >= previousTimeStamp ? 1 : 0) != 0);
    }

    @Test
    public void testDeregisterSubCluster() throws Exception {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        this.registerSubCluster(this.createSubClusterInfo(subClusterId));
        SubClusterDeregisterRequest deregisterRequest = SubClusterDeregisterRequest.newInstance((SubClusterId)subClusterId, (SubClusterState)SubClusterState.SC_UNREGISTERED);
        this.stateStore.deregisterSubCluster(deregisterRequest);
        Assert.assertEquals((Object)SubClusterState.SC_UNREGISTERED, (Object)this.querySubClusterInfo(subClusterId).getState());
    }

    @Test
    public void testDeregisterSubClusterUnknownSubCluster() throws Exception {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        SubClusterDeregisterRequest deregisterRequest = SubClusterDeregisterRequest.newInstance((SubClusterId)subClusterId, (SubClusterState)SubClusterState.SC_UNREGISTERED);
        try {
            this.stateStore.deregisterSubCluster(deregisterRequest);
            Assert.fail();
        }
        catch (FederationStateStoreException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("SubCluster SC not found"));
        }
    }

    @Test
    public void testGetSubClusterInfo() throws Exception {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        SubClusterInfo subClusterInfo = this.createSubClusterInfo(subClusterId);
        this.registerSubCluster(subClusterInfo);
        GetSubClusterInfoRequest request = GetSubClusterInfoRequest.newInstance((SubClusterId)subClusterId);
        Assert.assertEquals((Object)subClusterInfo, (Object)this.stateStore.getSubCluster(request).getSubClusterInfo());
    }

    @Test
    public void testGetSubClusterInfoUnknownSubCluster() throws Exception {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        GetSubClusterInfoRequest request = GetSubClusterInfoRequest.newInstance((SubClusterId)subClusterId);
        GetSubClusterInfoResponse response = this.stateStore.getSubCluster(request);
        Assert.assertNull((Object)response);
    }

    @Test
    public void testGetAllSubClustersInfo() throws Exception {
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        SubClusterInfo subClusterInfo1 = this.createSubClusterInfo(subClusterId1);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC2");
        SubClusterInfo subClusterInfo2 = this.createSubClusterInfo(subClusterId2);
        this.stateStore.registerSubCluster(SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo1));
        this.stateStore.registerSubCluster(SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo2));
        this.stateStore.subClusterHeartbeat(SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterId1, (SubClusterState)SubClusterState.SC_RUNNING, (String)"capability"));
        this.stateStore.subClusterHeartbeat(SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterId2, (SubClusterState)SubClusterState.SC_UNHEALTHY, (String)"capability"));
        List subClustersActive = this.stateStore.getSubClusters(GetSubClustersInfoRequest.newInstance((boolean)true)).getSubClusters();
        List subClustersAll = this.stateStore.getSubClusters(GetSubClustersInfoRequest.newInstance((boolean)false)).getSubClusters();
        Assert.assertEquals((long)1L, (long)subClustersActive.size());
        SubClusterInfo sc1 = (SubClusterInfo)subClustersActive.get(0);
        Assert.assertEquals((Object)subClusterId1, (Object)sc1.getSubClusterId());
        Assert.assertEquals((long)2L, (long)subClustersAll.size());
        Assert.assertTrue((boolean)subClustersAll.contains(sc1));
        subClustersAll.remove(sc1);
        SubClusterInfo sc2 = (SubClusterInfo)subClustersAll.get(0);
        Assert.assertEquals((Object)subClusterId2, (Object)sc2.getSubClusterId());
    }

    @Test
    public void testSubClusterHeartbeat() throws Exception {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        this.registerSubCluster(this.createSubClusterInfo(subClusterId));
        long previousHeartBeat = this.querySubClusterInfo(subClusterId).getLastHeartBeat();
        SubClusterHeartbeatRequest heartbeatRequest = SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterId, (SubClusterState)SubClusterState.SC_RUNNING, (String)"capability");
        this.stateStore.subClusterHeartbeat(heartbeatRequest);
        long currentTimeStamp = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis();
        Assert.assertEquals((Object)SubClusterState.SC_RUNNING, (Object)this.querySubClusterInfo(subClusterId).getState());
        Assert.assertTrue((this.querySubClusterInfo(subClusterId).getLastHeartBeat() <= currentTimeStamp ? 1 : 0) != 0);
        Assert.assertTrue((this.querySubClusterInfo(subClusterId).getLastHeartBeat() >= previousHeartBeat ? 1 : 0) != 0);
    }

    @Test
    public void testSubClusterHeartbeatUnknownSubCluster() throws Exception {
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        SubClusterHeartbeatRequest heartbeatRequest = SubClusterHeartbeatRequest.newInstance((SubClusterId)subClusterId, (SubClusterState)SubClusterState.SC_RUNNING, (String)"capability");
        try {
            this.stateStore.subClusterHeartbeat(heartbeatRequest);
            Assert.fail();
        }
        catch (FederationStateStoreException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("SubCluster SC does not exist; cannot heartbeat"));
        }
    }

    @Test
    public void testAddApplicationHomeSubCluster() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        ApplicationHomeSubCluster ahsc = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId);
        AddApplicationHomeSubClusterRequest request = AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ahsc);
        AddApplicationHomeSubClusterResponse response = this.stateStore.addApplicationHomeSubCluster(request);
        Assert.assertEquals((Object)subClusterId, (Object)response.getHomeSubCluster());
        Assert.assertEquals((Object)subClusterId, (Object)this.queryApplicationHomeSC(appId));
    }

    @Test
    public void testAddApplicationHomeSubClusterAppAlreadyExists() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        this.addApplicationHomeSC(appId, subClusterId1);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC2");
        ApplicationHomeSubCluster ahsc2 = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId2);
        AddApplicationHomeSubClusterResponse response = this.stateStore.addApplicationHomeSubCluster(AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ahsc2));
        Assert.assertEquals((Object)subClusterId1, (Object)response.getHomeSubCluster());
        Assert.assertEquals((Object)subClusterId1, (Object)this.queryApplicationHomeSC(appId));
    }

    @Test
    public void testAddApplicationHomeSubClusterAppAlreadyExistsInTheSameSC() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        this.addApplicationHomeSC(appId, subClusterId1);
        ApplicationHomeSubCluster ahsc2 = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId1);
        AddApplicationHomeSubClusterResponse response = this.stateStore.addApplicationHomeSubCluster(AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ahsc2));
        Assert.assertEquals((Object)subClusterId1, (Object)response.getHomeSubCluster());
        Assert.assertEquals((Object)subClusterId1, (Object)this.queryApplicationHomeSC(appId));
    }

    @Test
    public void testDeleteApplicationHomeSubCluster() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        this.addApplicationHomeSC(appId, subClusterId);
        DeleteApplicationHomeSubClusterRequest delRequest = DeleteApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
        DeleteApplicationHomeSubClusterResponse response = this.stateStore.deleteApplicationHomeSubCluster(delRequest);
        Assert.assertNotNull((Object)response);
        try {
            this.queryApplicationHomeSC(appId);
            Assert.fail();
        }
        catch (FederationStateStoreException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Application " + appId + " does not exist"));
        }
    }

    @Test
    public void testDeleteApplicationHomeSubClusterUnknownApp() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        DeleteApplicationHomeSubClusterRequest delRequest = DeleteApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
        try {
            this.stateStore.deleteApplicationHomeSubCluster(delRequest);
            Assert.fail();
        }
        catch (FederationStateStoreException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Application " + appId.toString() + " does not exist"));
        }
    }

    @Test
    public void testGetApplicationHomeSubCluster() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId = SubClusterId.newInstance((String)"SC");
        this.addApplicationHomeSC(appId, subClusterId);
        GetApplicationHomeSubClusterRequest getRequest = GetApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
        GetApplicationHomeSubClusterResponse result = this.stateStore.getApplicationHomeSubCluster(getRequest);
        Assert.assertEquals((Object)appId, (Object)result.getApplicationHomeSubCluster().getApplicationId());
        Assert.assertEquals((Object)subClusterId, (Object)result.getApplicationHomeSubCluster().getHomeSubCluster());
    }

    @Test
    public void testGetApplicationHomeSubClusterUnknownApp() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        GetApplicationHomeSubClusterRequest request = GetApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
        try {
            this.stateStore.getApplicationHomeSubCluster(request);
            Assert.fail();
        }
        catch (FederationStateStoreException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Application " + appId.toString() + " does not exist"));
        }
    }

    @Test
    public void testGetApplicationsHomeSubCluster() throws Exception {
        ApplicationId appId1 = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        ApplicationHomeSubCluster ahsc1 = ApplicationHomeSubCluster.newInstance((ApplicationId)appId1, (SubClusterId)subClusterId1);
        ApplicationId appId2 = ApplicationId.newInstance((long)1L, (int)2);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC2");
        ApplicationHomeSubCluster ahsc2 = ApplicationHomeSubCluster.newInstance((ApplicationId)appId2, (SubClusterId)subClusterId2);
        this.addApplicationHomeSC(appId1, subClusterId1);
        this.addApplicationHomeSC(appId2, subClusterId2);
        GetApplicationsHomeSubClusterRequest getRequest = GetApplicationsHomeSubClusterRequest.newInstance();
        GetApplicationsHomeSubClusterResponse result = this.stateStore.getApplicationsHomeSubCluster(getRequest);
        Assert.assertEquals((long)2L, (long)result.getAppsHomeSubClusters().size());
        Assert.assertTrue((boolean)result.getAppsHomeSubClusters().contains(ahsc1));
        Assert.assertTrue((boolean)result.getAppsHomeSubClusters().contains(ahsc2));
    }

    @Test
    public void testUpdateApplicationHomeSubCluster() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        this.addApplicationHomeSC(appId, subClusterId1);
        SubClusterId subClusterId2 = SubClusterId.newInstance((String)"SC2");
        ApplicationHomeSubCluster ahscUpdate = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId2);
        UpdateApplicationHomeSubClusterRequest updateRequest = UpdateApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ahscUpdate);
        UpdateApplicationHomeSubClusterResponse response = this.stateStore.updateApplicationHomeSubCluster(updateRequest);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals((Object)subClusterId2, (Object)this.queryApplicationHomeSC(appId));
    }

    @Test
    public void testUpdateApplicationHomeSubClusterUnknownApp() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)1L, (int)1);
        SubClusterId subClusterId1 = SubClusterId.newInstance((String)"SC1");
        ApplicationHomeSubCluster ahsc = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId1);
        UpdateApplicationHomeSubClusterRequest updateRequest = UpdateApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ahsc);
        try {
            this.stateStore.updateApplicationHomeSubCluster(updateRequest);
            Assert.fail();
        }
        catch (FederationStateStoreException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Application " + appId.toString() + " does not exist"));
        }
    }

    @Test
    public void testSetPolicyConfiguration() throws Exception {
        SetSubClusterPolicyConfigurationRequest request = SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)this.createSCPolicyConf("Queue", "PolicyType"));
        SetSubClusterPolicyConfigurationResponse result = this.stateStore.setPolicyConfiguration(request);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.createSCPolicyConf("Queue", "PolicyType"), (Object)this.queryPolicy("Queue"));
    }

    @Test
    public void testSetPolicyConfigurationUpdateExisting() throws Exception {
        this.setPolicyConf("Queue", "PolicyType1");
        SetSubClusterPolicyConfigurationRequest request2 = SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)this.createSCPolicyConf("Queue", "PolicyType2"));
        SetSubClusterPolicyConfigurationResponse result = this.stateStore.setPolicyConfiguration(request2);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.createSCPolicyConf("Queue", "PolicyType2"), (Object)this.queryPolicy("Queue"));
    }

    @Test
    public void testGetPolicyConfiguration() throws Exception {
        this.setPolicyConf("Queue", "PolicyType");
        GetSubClusterPolicyConfigurationRequest getRequest = GetSubClusterPolicyConfigurationRequest.newInstance((String)"Queue");
        GetSubClusterPolicyConfigurationResponse result = this.stateStore.getPolicyConfiguration(getRequest);
        Assert.assertNotNull((Object)result);
        Assert.assertEquals((Object)this.createSCPolicyConf("Queue", "PolicyType"), (Object)result.getPolicyConfiguration());
    }

    @Test
    public void testGetPolicyConfigurationUnknownQueue() throws Exception {
        GetSubClusterPolicyConfigurationRequest request = GetSubClusterPolicyConfigurationRequest.newInstance((String)"Queue");
        GetSubClusterPolicyConfigurationResponse response = this.stateStore.getPolicyConfiguration(request);
        Assert.assertNull((Object)response);
    }

    @Test
    public void testGetPoliciesConfigurations() throws Exception {
        this.setPolicyConf("Queue1", "PolicyType1");
        this.setPolicyConf("Queue2", "PolicyType2");
        GetSubClusterPoliciesConfigurationsResponse response = this.stateStore.getPoliciesConfigurations(GetSubClusterPoliciesConfigurationsRequest.newInstance());
        Assert.assertNotNull((Object)response);
        Assert.assertNotNull((Object)response.getPoliciesConfigs());
        Assert.assertEquals((long)2L, (long)response.getPoliciesConfigs().size());
        Assert.assertTrue((boolean)response.getPoliciesConfigs().contains(this.createSCPolicyConf("Queue1", "PolicyType1")));
        Assert.assertTrue((boolean)response.getPoliciesConfigs().contains(this.createSCPolicyConf("Queue2", "PolicyType2")));
    }

    private SubClusterInfo createSubClusterInfo(SubClusterId subClusterId) {
        String amRMAddress = "1.2.3.4:1";
        String clientRMAddress = "1.2.3.4:2";
        String rmAdminAddress = "1.2.3.4:3";
        String webAppAddress = "1.2.3.4:4";
        return SubClusterInfo.newInstance((SubClusterId)subClusterId, (String)amRMAddress, (String)clientRMAddress, (String)rmAdminAddress, (String)webAppAddress, (SubClusterState)SubClusterState.SC_NEW, (long)CLOCK.getTime(), (String)"capability");
    }

    private SubClusterPolicyConfiguration createSCPolicyConf(String queueName, String policyType) {
        ByteBuffer bb = ByteBuffer.allocate(100);
        bb.put((byte)2);
        return SubClusterPolicyConfiguration.newInstance((String)queueName, (String)policyType, (ByteBuffer)bb);
    }

    private void addApplicationHomeSC(ApplicationId appId, SubClusterId subClusterId) throws YarnException {
        ApplicationHomeSubCluster ahsc = ApplicationHomeSubCluster.newInstance((ApplicationId)appId, (SubClusterId)subClusterId);
        AddApplicationHomeSubClusterRequest request = AddApplicationHomeSubClusterRequest.newInstance((ApplicationHomeSubCluster)ahsc);
        this.stateStore.addApplicationHomeSubCluster(request);
    }

    private void setPolicyConf(String queue, String policyType) throws YarnException {
        SetSubClusterPolicyConfigurationRequest request = SetSubClusterPolicyConfigurationRequest.newInstance((SubClusterPolicyConfiguration)this.createSCPolicyConf(queue, policyType));
        this.stateStore.setPolicyConfiguration(request);
    }

    private void registerSubCluster(SubClusterInfo subClusterInfo) throws YarnException {
        this.stateStore.registerSubCluster(SubClusterRegisterRequest.newInstance((SubClusterInfo)subClusterInfo));
    }

    private SubClusterInfo querySubClusterInfo(SubClusterId subClusterId) throws YarnException {
        GetSubClusterInfoRequest request = GetSubClusterInfoRequest.newInstance((SubClusterId)subClusterId);
        return this.stateStore.getSubCluster(request).getSubClusterInfo();
    }

    private SubClusterId queryApplicationHomeSC(ApplicationId appId) throws YarnException {
        GetApplicationHomeSubClusterRequest request = GetApplicationHomeSubClusterRequest.newInstance((ApplicationId)appId);
        GetApplicationHomeSubClusterResponse response = this.stateStore.getApplicationHomeSubCluster(request);
        return response.getApplicationHomeSubCluster().getHomeSubCluster();
    }

    private SubClusterPolicyConfiguration queryPolicy(String queue) throws YarnException {
        GetSubClusterPolicyConfigurationRequest request = GetSubClusterPolicyConfigurationRequest.newInstance((String)queue);
        GetSubClusterPolicyConfigurationResponse result = this.stateStore.getPolicyConfiguration(request);
        return result.getPolicyConfiguration();
    }

    protected void setConf(Configuration conf) {
        this.conf = conf;
    }

    protected Configuration getConf() {
        return this.conf;
    }
}

