/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeLabelPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerCommonServiceProtos;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdatedCryptoForApp;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.LogAggregationReportPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.NMContainerStatusPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.UpdatedCryptoForAppPBImpl;

public class RegisterNodeManagerRequestPBImpl
extends RegisterNodeManagerRequest {
    YarnServerCommonServiceProtos.RegisterNodeManagerRequestProto proto = YarnServerCommonServiceProtos.RegisterNodeManagerRequestProto.getDefaultInstance();
    YarnServerCommonServiceProtos.RegisterNodeManagerRequestProto.Builder builder = null;
    boolean viaProto = false;
    private Resource resource = null;
    private NodeId nodeId = null;
    private List<NMContainerStatus> containerStatuses = null;
    private Map<ApplicationId, UpdatedCryptoForApp> runningApplications = null;
    private Set<NodeLabel> labels = null;
    private List<LogAggregationReport> logAggregationReportsForApps = null;
    private Resource physicalResource = null;

    public RegisterNodeManagerRequestPBImpl() {
        this.builder = YarnServerCommonServiceProtos.RegisterNodeManagerRequestProto.newBuilder();
    }

    public RegisterNodeManagerRequestPBImpl(YarnServerCommonServiceProtos.RegisterNodeManagerRequestProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnServerCommonServiceProtos.RegisterNodeManagerRequestProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private synchronized void mergeLocalToBuilder() {
        if (this.containerStatuses != null) {
            this.addNMContainerStatusesToProto();
        }
        if (this.runningApplications != null) {
            this.addRunningApplicationsToProto();
        }
        if (this.resource != null) {
            this.builder.setResource(RegisterNodeManagerRequestPBImpl.convertToProtoFormat(this.resource));
        }
        if (this.nodeId != null) {
            this.builder.setNodeId(RegisterNodeManagerRequestPBImpl.convertToProtoFormat(this.nodeId));
        }
        if (this.labels != null) {
            this.builder.clearNodeLabels();
            YarnServerCommonServiceProtos.NodeLabelsProto.Builder newBuilder = YarnServerCommonServiceProtos.NodeLabelsProto.newBuilder();
            for (NodeLabel label : this.labels) {
                newBuilder.addNodeLabels(RegisterNodeManagerRequestPBImpl.convertToProtoFormat(label));
            }
            this.builder.setNodeLabels(newBuilder.build());
        }
        if (this.physicalResource != null) {
            this.builder.setPhysicalResource(RegisterNodeManagerRequestPBImpl.convertToProtoFormat(this.physicalResource));
        }
        if (this.logAggregationReportsForApps != null) {
            this.addLogAggregationStatusForAppsToProto();
        }
    }

    private void addLogAggregationStatusForAppsToProto() {
        this.maybeInitBuilder();
        this.builder.clearLogAggregationReportsForApps();
        if (this.logAggregationReportsForApps == null) {
            return;
        }
        Iterable<YarnServerCommonServiceProtos.LogAggregationReportProto> it = new Iterable<YarnServerCommonServiceProtos.LogAggregationReportProto>(){

            @Override
            public Iterator<YarnServerCommonServiceProtos.LogAggregationReportProto> iterator() {
                return new Iterator<YarnServerCommonServiceProtos.LogAggregationReportProto>(){
                    private Iterator<LogAggregationReport> iter;
                    {
                        this.iter = RegisterNodeManagerRequestPBImpl.this.logAggregationReportsForApps.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public YarnServerCommonServiceProtos.LogAggregationReportProto next() {
                        return RegisterNodeManagerRequestPBImpl.this.convertToProtoFormat(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
        this.builder.addAllLogAggregationReportsForApps((Iterable<? extends YarnServerCommonServiceProtos.LogAggregationReportProto>)it);
    }

    private YarnServerCommonServiceProtos.LogAggregationReportProto convertToProtoFormat(LogAggregationReport value) {
        return ((LogAggregationReportPBImpl)value).getProto();
    }

    private synchronized void addNMContainerStatusesToProto() {
        this.maybeInitBuilder();
        this.builder.clearContainerStatuses();
        ArrayList<YarnServerCommonServiceProtos.NMContainerStatusProto> list = new ArrayList<YarnServerCommonServiceProtos.NMContainerStatusProto>();
        for (NMContainerStatus status : this.containerStatuses) {
            list.add(RegisterNodeManagerRequestPBImpl.convertToProtoFormat(status));
        }
        this.builder.addAllContainerStatuses(list);
    }

    private synchronized void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private synchronized void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerCommonServiceProtos.RegisterNodeManagerRequestProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public synchronized Resource getResource() {
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p;
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder registerNodeManagerRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.resource != null) {
            return this.resource;
        }
        if (!p.hasResource()) {
            return null;
        }
        this.resource = RegisterNodeManagerRequestPBImpl.convertFromProtoFormat(p.getResource());
        return this.resource;
    }

    @Override
    public synchronized void setResource(Resource resource) {
        this.maybeInitBuilder();
        if (resource == null) {
            this.builder.clearResource();
        }
        this.resource = resource;
    }

    @Override
    public synchronized NodeId getNodeId() {
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p;
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder registerNodeManagerRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.nodeId != null) {
            return this.nodeId;
        }
        if (!p.hasNodeId()) {
            return null;
        }
        this.nodeId = RegisterNodeManagerRequestPBImpl.convertFromProtoFormat(p.getNodeId());
        return this.nodeId;
    }

    @Override
    public synchronized void setNodeId(NodeId nodeId) {
        this.maybeInitBuilder();
        if (nodeId == null) {
            this.builder.clearNodeId();
        }
        this.nodeId = nodeId;
    }

    @Override
    public synchronized int getHttpPort() {
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p;
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder registerNodeManagerRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasHttpPort()) {
            return 0;
        }
        return p.getHttpPort();
    }

    @Override
    public synchronized void setHttpPort(int httpPort) {
        this.maybeInitBuilder();
        this.builder.setHttpPort(httpPort);
    }

    @Override
    public Map<ApplicationId, UpdatedCryptoForApp> getRunningApplications() {
        this.initRunningApplications();
        return this.runningApplications;
    }

    private synchronized void initRunningApplications() {
        if (this.runningApplications != null) {
            return;
        }
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServerCommonServiceProtos.RunningApplicationsProto> list = p.getRunningApplicationsList();
        this.runningApplications = new HashMap<ApplicationId, UpdatedCryptoForApp>(list.size());
        for (YarnServerCommonServiceProtos.RunningApplicationsProto rup : list) {
            ApplicationIdPBImpl appId = RegisterNodeManagerRequestPBImpl.convertFromProtoFormat(rup.getAppId());
            UpdatedCryptoForAppPBImpl upc = RegisterNodeManagerRequestPBImpl.convertFromProtoFormat(rup.getSecurityMaterialVersion());
            this.runningApplications.put((ApplicationId)appId, upc);
        }
    }

    @Override
    public void setRunningApplications(Map<ApplicationId, UpdatedCryptoForApp> apps) {
        if (apps == null) {
            return;
        }
        this.initRunningApplications();
        this.runningApplications.putAll(apps);
    }

    private void addRunningApplicationsToProto() {
        this.maybeInitBuilder();
        this.builder.clearRunningApplications();
        if (this.runningApplications == null) {
            return;
        }
        for (Map.Entry<ApplicationId, UpdatedCryptoForApp> entry : this.runningApplications.entrySet()) {
            this.builder.addRunningApplications(YarnServerCommonServiceProtos.RunningApplicationsProto.newBuilder().setAppId(RegisterNodeManagerRequestPBImpl.convertToProtoFormat(entry.getKey())).setSecurityMaterialVersion(RegisterNodeManagerRequestPBImpl.convertToProtoFormat(entry.getValue())));
        }
    }

    @Override
    public synchronized List<NMContainerStatus> getNMContainerStatuses() {
        this.initContainerRecoveryReports();
        return this.containerStatuses;
    }

    private synchronized void initContainerRecoveryReports() {
        if (this.containerStatuses != null) {
            return;
        }
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServerCommonServiceProtos.NMContainerStatusProto> list = p.getContainerStatusesList();
        this.containerStatuses = new ArrayList<NMContainerStatus>();
        for (YarnServerCommonServiceProtos.NMContainerStatusProto c : list) {
            this.containerStatuses.add(RegisterNodeManagerRequestPBImpl.convertFromProtoFormat(c));
        }
    }

    @Override
    public synchronized void setContainerStatuses(List<NMContainerStatus> containerReports) {
        if (containerReports == null) {
            return;
        }
        this.initContainerRecoveryReports();
        this.containerStatuses.addAll(containerReports);
    }

    @Override
    public synchronized Resource getPhysicalResource() {
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p;
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder registerNodeManagerRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.physicalResource != null) {
            return this.physicalResource;
        }
        if (!p.hasPhysicalResource()) {
            return null;
        }
        this.physicalResource = RegisterNodeManagerRequestPBImpl.convertFromProtoFormat(p.getPhysicalResource());
        return this.physicalResource;
    }

    @Override
    public synchronized void setPhysicalResource(Resource pPhysicalResource) {
        this.maybeInitBuilder();
        if (pPhysicalResource == null) {
            this.builder.clearPhysicalResource();
        }
        this.physicalResource = pPhysicalResource;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((RegisterNodeManagerRequestPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    @Override
    public synchronized String getNMVersion() {
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p;
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder registerNodeManagerRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNmVersion()) {
            return "";
        }
        return p.getNmVersion();
    }

    @Override
    public synchronized void setNMVersion(String version) {
        this.maybeInitBuilder();
        this.builder.setNmVersion(version);
    }

    @Override
    public synchronized Set<NodeLabel> getNodeLabels() {
        this.initNodeLabels();
        return this.labels;
    }

    @Override
    public synchronized void setNodeLabels(Set<NodeLabel> nodeLabels) {
        this.maybeInitBuilder();
        this.builder.clearNodeLabels();
        this.labels = nodeLabels;
    }

    private synchronized void initNodeLabels() {
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p;
        if (this.labels != null) {
            return;
        }
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder registerNodeManagerRequestProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeLabels()) {
            this.labels = null;
            return;
        }
        YarnServerCommonServiceProtos.NodeLabelsProto nodeLabels = p.getNodeLabels();
        this.labels = new HashSet<NodeLabel>();
        for (YarnProtos.NodeLabelProto nlp : nodeLabels.getNodeLabelsList()) {
            this.labels.add((NodeLabel)RegisterNodeManagerRequestPBImpl.convertFromProtoFormat(nlp));
        }
    }

    private static NodeLabelPBImpl convertFromProtoFormat(YarnProtos.NodeLabelProto p) {
        return new NodeLabelPBImpl(p);
    }

    private static YarnProtos.NodeLabelProto convertToProtoFormat(NodeLabel t) {
        return ((NodeLabelPBImpl)t).getProto();
    }

    private static ApplicationIdPBImpl convertFromProtoFormat(YarnProtos.ApplicationIdProto p) {
        return new ApplicationIdPBImpl(p);
    }

    private static YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId t) {
        return ((ApplicationIdPBImpl)t).getProto();
    }

    private static UpdatedCryptoForAppPBImpl convertFromProtoFormat(YarnServerCommonServiceProtos.UpdatedCryptoForAppProto p) {
        return new UpdatedCryptoForAppPBImpl(p);
    }

    private static YarnServerCommonServiceProtos.UpdatedCryptoForAppProto convertToProtoFormat(UpdatedCryptoForApp t) {
        return ((UpdatedCryptoForAppPBImpl)t).getProto();
    }

    private static NodeIdPBImpl convertFromProtoFormat(YarnProtos.NodeIdProto p) {
        return new NodeIdPBImpl(p);
    }

    private static YarnProtos.NodeIdProto convertToProtoFormat(NodeId t) {
        return ((NodeIdPBImpl)t).getProto();
    }

    private static ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private static YarnProtos.ResourceProto convertToProtoFormat(Resource t) {
        return ProtoUtils.convertToProtoFormat((Resource)t);
    }

    private static NMContainerStatusPBImpl convertFromProtoFormat(YarnServerCommonServiceProtos.NMContainerStatusProto c) {
        return new NMContainerStatusPBImpl(c);
    }

    private static YarnServerCommonServiceProtos.NMContainerStatusProto convertToProtoFormat(NMContainerStatus c) {
        return ((NMContainerStatusPBImpl)c).getProto();
    }

    @Override
    public synchronized List<LogAggregationReport> getLogAggregationReportsForApps() {
        if (this.logAggregationReportsForApps != null) {
            return this.logAggregationReportsForApps;
        }
        this.initLogAggregationReportsForApps();
        return this.logAggregationReportsForApps;
    }

    private void initLogAggregationReportsForApps() {
        YarnServerCommonServiceProtos.RegisterNodeManagerRequestProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        List<YarnServerCommonServiceProtos.LogAggregationReportProto> list = p.getLogAggregationReportsForAppsList();
        this.logAggregationReportsForApps = new ArrayList<LogAggregationReport>();
        for (YarnServerCommonServiceProtos.LogAggregationReportProto c : list) {
            this.logAggregationReportsForApps.add(this.convertFromProtoFormat(c));
        }
    }

    private LogAggregationReport convertFromProtoFormat(YarnServerCommonServiceProtos.LogAggregationReportProto logAggregationReport) {
        return new LogAggregationReportPBImpl(logAggregationReport);
    }

    @Override
    public synchronized void setLogAggregationReportsForApps(List<LogAggregationReport> logAggregationStatusForApps) {
        if (logAggregationStatusForApps == null) {
            this.builder.clearLogAggregationReportsForApps();
        }
        this.logAggregationReportsForApps = logAggregationStatusForApps;
    }
}

