/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.lib;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.apache.hadoop.yarn.lib.ZKClient;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ZKDatabase;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnLog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestZKClient {
    public static int CONNECTION_TIMEOUT = 30000;
    static final File BASETEST = new File(System.getProperty("build.test.dir", "target/zookeeper-build"));
    protected String hostPort = "127.0.0.1:2000";
    protected int maxCnxns = 0;
    protected NIOServerCnxnFactory factory = null;
    protected ZooKeeperServer zks;
    protected File tmpDir = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String send4LetterWord(String host, int port, String cmd) throws IOException {
        Socket sock = new Socket(host, port);
        BufferedReader reader = null;
        try {
            String line;
            OutputStream outstream = sock.getOutputStream();
            outstream.write(cmd.getBytes());
            outstream.flush();
            sock.shutdownOutput();
            reader = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            String string = sb.toString();
            return string;
        }
        finally {
            sock.close();
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static boolean waitForServerDown(String hp, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                String host = hp.split(":")[0];
                int port = Integer.parseInt(hp.split(":")[1]);
                TestZKClient.send4LetterWord(host, port, "stat");
            }
            catch (IOException e) {
                return true;
            }
            if (System.currentTimeMillis() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    public static boolean waitForServerUp(String hp, long timeout) {
        long start = System.currentTimeMillis();
        while (true) {
            try {
                String host = hp.split(":")[0];
                int port = Integer.parseInt(hp.split(":")[1]);
                String result = TestZKClient.send4LetterWord(host, port, "stat");
                if (result.startsWith("Zookeeper version:")) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (System.currentTimeMillis() > start + timeout) break;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        }
        return false;
    }

    public static File createTmpDir(File parentDir) throws IOException {
        File tmpFile = File.createTempFile("test", ".junit", parentDir);
        File tmpDir = new File(tmpFile + ".dir");
        Assert.assertFalse((boolean)tmpDir.exists());
        Assert.assertTrue((boolean)tmpDir.mkdirs());
        return tmpDir;
    }

    @Before
    public void setUp() throws IOException, InterruptedException {
        System.setProperty("zookeeper.preAllocSize", "100");
        FileTxnLog.setPreallocSize((long)102400L);
        if (!BASETEST.exists()) {
            BASETEST.mkdirs();
        }
        File dataDir = TestZKClient.createTmpDir(BASETEST);
        this.zks = new ZooKeeperServer(dataDir, dataDir, 3000);
        int PORT = Integer.parseInt(this.hostPort.split(":")[1]);
        if (this.factory == null) {
            this.factory = new NIOServerCnxnFactory();
            this.factory.configure(new InetSocketAddress(PORT), this.maxCnxns);
        }
        this.factory.startup(this.zks);
        Assert.assertTrue((String)"waiting for server up", (boolean)TestZKClient.waitForServerUp("127.0.0.1:" + PORT, CONNECTION_TIMEOUT));
    }

    @After
    public void tearDown() throws IOException, InterruptedException {
        if (this.zks != null) {
            ZKDatabase zkDb = this.zks.getZKDatabase();
            this.factory.shutdown();
            try {
                zkDb.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            int PORT = Integer.parseInt(this.hostPort.split(":")[1]);
            Assert.assertTrue((String)"waiting for server down", (boolean)TestZKClient.waitForServerDown("127.0.0.1:" + PORT, CONNECTION_TIMEOUT));
        }
    }

    @Test
    public void testzkClient() throws Exception {
        this.test("/some/test");
    }

    private void test(String testClient) throws Exception {
        ZKClient client = new ZKClient(this.hostPort);
        client.registerService("/nodemanager", "hostPort");
        client.unregisterService("/nodemanager");
    }
}

