/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.amrmproxy;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.BaseFederationPoliciesTest;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.HomeAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHomeAMRMProxyPolicy
extends BaseFederationPoliciesTest {
    private static final int NUM_SUBCLUSTERS = 4;
    private static final String HOME_SC_NAME = "sc2";
    private static final SubClusterId HOME_SC_ID = SubClusterId.newInstance((String)"sc2");

    @Before
    public void setUp() throws Exception {
        this.setPolicy((ConfigurableFederationPolicy)new HomeAMRMProxyPolicy());
        this.setPolicyInfo((WeightedPolicyInfo)Mockito.mock(WeightedPolicyInfo.class));
        for (int i = 0; i < 4; ++i) {
            SubClusterIdInfo sc = new SubClusterIdInfo("sc" + i);
            SubClusterInfo sci = (SubClusterInfo)Mockito.mock(SubClusterInfo.class);
            Mockito.when((Object)sci.getState()).thenReturn((Object)SubClusterState.SC_RUNNING);
            Mockito.when((Object)sci.getSubClusterId()).thenReturn((Object)sc.toId());
            this.getActiveSubclusters().put(sc.toId(), sci);
        }
        FederationPoliciesTestUtil.initializePolicyContext(this.getPolicy(), (WeightedPolicyInfo)Mockito.mock(WeightedPolicyInfo.class), this.getActiveSubclusters(), HOME_SC_NAME);
    }

    @Test
    public void testSplitAllocateRequest() throws YarnException {
        String[] hosts = new String[]{"host0", "host1", "host2", "host3"};
        List<ResourceRequest> resourceRequests = FederationPoliciesTestUtil.createResourceRequests(hosts, 2048, 2, 1, 3, null, false);
        HomeAMRMProxyPolicy federationPolicy = (HomeAMRMProxyPolicy)this.getPolicy();
        Map response = federationPolicy.splitResourceRequests(resourceRequests);
        Assert.assertEquals((long)1L, (long)response.size());
        Assert.assertNotNull(response.get(HOME_SC_ID));
        Assert.assertEquals((long)9L, (long)((List)response.get(HOME_SC_ID)).size());
    }

    @Test
    public void testHomeSubclusterNotActive() throws YarnException {
        FederationPoliciesTestUtil.initializePolicyContext(this.getPolicy(), (WeightedPolicyInfo)Mockito.mock(WeightedPolicyInfo.class), this.getActiveSubclusters(), "badsc");
        try {
            String[] hosts = new String[]{"host0", "host1", "host2", "host3"};
            List<ResourceRequest> resourceRequests = FederationPoliciesTestUtil.createResourceRequests(hosts, 2048, 2, 1, 3, null, false);
            HomeAMRMProxyPolicy federationPolicy = (HomeAMRMProxyPolicy)this.getPolicy();
            federationPolicy.splitResourceRequests(resourceRequests);
            Assert.fail((String)"It should fail when the home subcluster is not active");
        }
        catch (FederationPolicyException e) {
            GenericTestUtils.assertExceptionContains((String)"is not active", (Throwable)e);
        }
    }
}

