/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.amrmproxy;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.federation.policies.BaseFederationPoliciesTest;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.FederationAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.RejectAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRejectAMRMProxyPolicy
extends BaseFederationPoliciesTest {
    @Before
    public void setUp() throws Exception {
        this.setPolicy((ConfigurableFederationPolicy)new RejectAMRMProxyPolicy());
        this.setPolicyInfo((WeightedPolicyInfo)Mockito.mock(WeightedPolicyInfo.class));
        for (int i = 1; i <= 2; ++i) {
            SubClusterIdInfo sc = new SubClusterIdInfo("sc" + i);
            SubClusterInfo sci = (SubClusterInfo)Mockito.mock(SubClusterInfo.class);
            Mockito.when((Object)sci.getState()).thenReturn((Object)SubClusterState.SC_RUNNING);
            Mockito.when((Object)sci.getSubClusterId()).thenReturn((Object)sc.toId());
            this.getActiveSubclusters().put(sc.toId(), sci);
        }
        FederationPoliciesTestUtil.initializePolicyContext(this.getPolicy(), (WeightedPolicyInfo)Mockito.mock(WeightedPolicyInfo.class), this.getActiveSubclusters());
    }

    @Test(expected=FederationPolicyException.class)
    public void testSplitAllocateRequest() throws Exception {
        String[] hosts = new String[]{"host1", "host2"};
        List<ResourceRequest> resourceRequests = FederationPoliciesTestUtil.createResourceRequests(hosts, 2048, 2, 1, 3, null, false);
        Map response = ((FederationAMRMProxyPolicy)this.getPolicy()).splitResourceRequests(resourceRequests);
    }
}

