/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.BaseFederationPoliciesTest;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.policies.router.RejectRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Test;

public abstract class BaseRouterPoliciesTest
extends BaseFederationPoliciesTest {
    @Test
    public void testNullQueueRouting() throws YarnException {
        FederationRouterPolicy localPolicy = (FederationRouterPolicy)this.getPolicy();
        ApplicationSubmissionContext applicationSubmissionContext = ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, (Resource)Resources.none(), null, (boolean)false, null, null);
        SubClusterId chosen = localPolicy.getHomeSubcluster(applicationSubmissionContext, null);
        Assert.assertNotNull((Object)chosen);
    }

    @Test(expected=FederationPolicyException.class)
    public void testNullAppContext() throws YarnException {
        ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(null, null);
    }

    @Test
    public void testBlacklistSubcluster() throws YarnException {
        FederationRouterPolicy localPolicy = (FederationRouterPolicy)this.getPolicy();
        ApplicationSubmissionContext applicationSubmissionContext = ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, (Resource)Resources.none(), null, (boolean)false, null, null);
        Map<SubClusterId, SubClusterInfo> activeSubClusters = this.getActiveSubclusters();
        if (activeSubClusters != null && activeSubClusters.size() > 1 && !(localPolicy instanceof RejectRouterPolicy)) {
            Random random = new Random();
            ArrayList<SubClusterId> blacklistSubclusters = new ArrayList<SubClusterId>(activeSubClusters.keySet());
            SubClusterId removed = (SubClusterId)blacklistSubclusters.remove(random.nextInt(blacklistSubclusters.size()));
            this.getPolicyInfo().getRouterPolicyWeights().put(new SubClusterIdInfo(removed), Float.valueOf(1.0f));
            FederationPoliciesTestUtil.initializePolicyContext(this.getPolicy(), this.getPolicyInfo(), this.getActiveSubclusters());
            SubClusterId chosen = localPolicy.getHomeSubcluster(applicationSubmissionContext, blacklistSubclusters);
            Assert.assertNotNull((Object)chosen);
            Assert.assertEquals((Object)removed, (Object)chosen);
        }
    }

    @Test
    public void testAllBlacklistSubcluster() throws YarnException {
        FederationRouterPolicy localPolicy = (FederationRouterPolicy)this.getPolicy();
        ApplicationSubmissionContext applicationSubmissionContext = ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, (Resource)Resources.none(), null, (boolean)false, null, null);
        Map<SubClusterId, SubClusterInfo> activeSubClusters = this.getActiveSubclusters();
        if (activeSubClusters != null && activeSubClusters.size() > 1 && !(localPolicy instanceof RejectRouterPolicy)) {
            ArrayList<SubClusterId> blacklistSubclusters = new ArrayList<SubClusterId>(activeSubClusters.keySet());
            try {
                localPolicy.getHomeSubcluster(applicationSubmissionContext, blacklistSubclusters);
                Assert.fail();
            }
            catch (YarnException e) {
                Assert.assertTrue((boolean)e.getMessage().equals("No active SubCluster available to submit the request."));
            }
        }
    }
}

