/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationAttemptIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.SerializedExceptionPBImpl;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdatedCryptoForApp;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.NodeHeartbeatRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.NodeHeartbeatResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RegisterNodeManagerRequestPBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RegisterNodeManagerResponsePBImpl;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.UnRegisterNodeManagerRequestPBImpl;
import org.apache.hadoop.yarn.server.api.records.AppCollectorData;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeAction;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.server.api.records.impl.pb.MasterKeyPBImpl;
import org.apache.hadoop.yarn.server.api.records.impl.pb.NodeStatusPBImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestYarnServerApiClasses {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);

    @Test
    public void testRegisterNodeManagerResponsePBImpl() {
        RegisterNodeManagerResponsePBImpl original = new RegisterNodeManagerResponsePBImpl();
        original.setContainerTokenMasterKey(this.getMasterKey());
        original.setNMTokenMasterKey(this.getMasterKey());
        original.setNodeAction(NodeAction.NORMAL);
        original.setDiagnosticsMessage("testDiagnosticMessage");
        RegisterNodeManagerResponsePBImpl copy = new RegisterNodeManagerResponsePBImpl(original.getProto());
        Assert.assertEquals((long)1L, (long)copy.getContainerTokenMasterKey().getKeyId());
        Assert.assertEquals((long)1L, (long)copy.getNMTokenMasterKey().getKeyId());
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)copy.getNodeAction());
        Assert.assertEquals((Object)"testDiagnosticMessage", (Object)copy.getDiagnosticsMessage());
        Assert.assertFalse((boolean)copy.getAreNodeLabelsAcceptedByRM());
    }

    @Test
    public void testRegisterNodeManagerResponsePBImplWithRMAcceptLbls() {
        RegisterNodeManagerResponsePBImpl original = new RegisterNodeManagerResponsePBImpl();
        original.setAreNodeLabelsAcceptedByRM(true);
        RegisterNodeManagerResponsePBImpl copy = new RegisterNodeManagerResponsePBImpl(original.getProto());
        Assert.assertTrue((boolean)copy.getAreNodeLabelsAcceptedByRM());
    }

    @Test
    public void testNodeHeartbeatRequestPBImpl() {
        NodeHeartbeatRequestPBImpl original = new NodeHeartbeatRequestPBImpl();
        original.setLastKnownContainerTokenMasterKey(this.getMasterKey());
        original.setLastKnownNMTokenMasterKey(this.getMasterKey());
        original.setNodeStatus(this.getNodeStatus());
        original.setNodeLabels(this.getValidNodeLabels());
        Map<ApplicationId, AppCollectorData> collectors = this.getCollectors(false);
        original.setRegisteringCollectors(collectors);
        NodeHeartbeatRequestPBImpl copy = new NodeHeartbeatRequestPBImpl(original.getProto());
        Assert.assertEquals((long)1L, (long)copy.getLastKnownContainerTokenMasterKey().getKeyId());
        Assert.assertEquals((long)1L, (long)copy.getLastKnownNMTokenMasterKey().getKeyId());
        Assert.assertEquals((Object)"localhost", (Object)copy.getNodeStatus().getNodeId().getHost());
        Assert.assertEquals(collectors, (Object)copy.getRegisteringCollectors());
        Assert.assertTrue((boolean)original.getNodeLabels().containsAll(copy.getNodeLabels()));
        original.setNodeLabels(new HashSet());
        copy = new NodeHeartbeatRequestPBImpl(original.getProto());
        Assert.assertNotNull((Object)copy.getNodeLabels());
        Assert.assertEquals((long)0L, (long)copy.getNodeLabels().size());
    }

    @Test
    public void testNodeHBRequestPBImplWithNullCollectorToken() {
        NodeHeartbeatRequestPBImpl original = new NodeHeartbeatRequestPBImpl();
        Map<ApplicationId, AppCollectorData> collectors = this.getCollectors(true);
        original.setRegisteringCollectors(collectors);
        NodeHeartbeatRequestPBImpl copy = new NodeHeartbeatRequestPBImpl(original.getProto());
        Assert.assertEquals(collectors, (Object)copy.getRegisteringCollectors());
    }

    @Test
    public void testNodeHeartbeatRequestPBImplWithNullLabels() {
        NodeHeartbeatRequestPBImpl original = new NodeHeartbeatRequestPBImpl();
        NodeHeartbeatRequestPBImpl copy = new NodeHeartbeatRequestPBImpl(original.getProto());
        Assert.assertNull((Object)copy.getNodeLabels());
    }

    @Test
    public void testNodeHeartbeatRequestPBImplWithUpdatedCryptoForApps() {
        NodeHeartbeatRequestPBImpl original = new NodeHeartbeatRequestPBImpl();
        HashSet<ApplicationId> updatedApps = new HashSet<ApplicationId>();
        long now = System.currentTimeMillis();
        ApplicationId appId1 = ApplicationId.newInstance((long)now, (int)1);
        ApplicationId appId2 = ApplicationId.newInstance((long)now, (int)2);
        updatedApps.add(appId1);
        updatedApps.add(appId2);
        original.setUpdatedApplicationsWithNewCryptoMaterial(updatedApps);
        NodeHeartbeatRequestPBImpl copy = new NodeHeartbeatRequestPBImpl(original.getProto());
        Set copyUpdatedApps = copy.getUpdatedApplicationsWithNewCryptoMaterial();
        Assert.assertNotNull((Object)copyUpdatedApps);
        Assert.assertEquals((long)2L, (long)copyUpdatedApps.size());
        Assert.assertTrue((boolean)copyUpdatedApps.contains(appId1));
        Assert.assertTrue((boolean)copyUpdatedApps.contains(appId2));
    }

    @Test
    public void testNodeHeartbeatResponsePBImpl() {
        NodeHeartbeatResponsePBImpl original = new NodeHeartbeatResponsePBImpl();
        original.setDiagnosticsMessage("testDiagnosticMessage");
        original.setContainerTokenMasterKey(this.getMasterKey());
        original.setNMTokenMasterKey(this.getMasterKey());
        original.setNextHeartBeatInterval(1000L);
        original.setNodeAction(NodeAction.NORMAL);
        original.setResponseId(100);
        Map<ApplicationId, AppCollectorData> collectors = this.getCollectors(false);
        original.setAppCollectors(collectors);
        NodeHeartbeatResponsePBImpl copy = new NodeHeartbeatResponsePBImpl(original.getProto());
        Assert.assertEquals((long)100L, (long)copy.getResponseId());
        Assert.assertEquals((Object)NodeAction.NORMAL, (Object)copy.getNodeAction());
        Assert.assertEquals((long)1000L, (long)copy.getNextHeartBeatInterval());
        Assert.assertEquals((long)1L, (long)copy.getContainerTokenMasterKey().getKeyId());
        Assert.assertEquals((long)1L, (long)copy.getNMTokenMasterKey().getKeyId());
        Assert.assertEquals((Object)"testDiagnosticMessage", (Object)copy.getDiagnosticsMessage());
        Assert.assertEquals(collectors, (Object)copy.getAppCollectors());
        Assert.assertEquals((Object)false, (Object)copy.getAreNodeLabelsAcceptedByRM());
    }

    @Test
    public void testNodeHeartbeatResponsePBImplWithRMAcceptLbls() {
        NodeHeartbeatResponsePBImpl original = new NodeHeartbeatResponsePBImpl();
        original.setAreNodeLabelsAcceptedByRM(true);
        NodeHeartbeatResponsePBImpl copy = new NodeHeartbeatResponsePBImpl(original.getProto());
        Assert.assertTrue((boolean)copy.getAreNodeLabelsAcceptedByRM());
    }

    @Test
    public void testNodeHBResponsePBImplWithNullCollectorToken() {
        NodeHeartbeatResponsePBImpl original = new NodeHeartbeatResponsePBImpl();
        Map<ApplicationId, AppCollectorData> collectors = this.getCollectors(true);
        original.setAppCollectors(collectors);
        NodeHeartbeatResponsePBImpl copy = new NodeHeartbeatResponsePBImpl(original.getProto());
        Assert.assertEquals(collectors, (Object)copy.getAppCollectors());
    }

    @Test
    public void testNodeHeartbeatResponsePBImplWithDecreasedContainers() {
        NodeHeartbeatResponsePBImpl original = new NodeHeartbeatResponsePBImpl();
        original.addAllContainersToUpdate(Arrays.asList(this.getDecreasedContainer(1, 2, 2048, 2), this.getDecreasedContainer(2, 3, 1024, 1)));
        NodeHeartbeatResponsePBImpl copy = new NodeHeartbeatResponsePBImpl(original.getProto());
        Assert.assertEquals((long)1L, (long)((Container)copy.getContainersToUpdate().get(0)).getId().getContainerId());
        Assert.assertEquals((long)1024L, (long)((Container)copy.getContainersToUpdate().get(1)).getResource().getMemorySize());
    }

    @Test
    public void testNodeHeartbeatResponseWithUpdateCryptoForApps() {
        NodeHeartbeatResponsePBImpl original = new NodeHeartbeatResponsePBImpl();
        HashMap<ApplicationId, UpdatedCryptoForApp> updatedCryptoForApps = new HashMap<ApplicationId, UpdatedCryptoForApp>();
        long now = System.currentTimeMillis();
        ApplicationId appId1 = ApplicationId.newInstance((long)now, (int)1);
        UpdatedCryptoForApp crypto1 = (UpdatedCryptoForApp)recordFactory.newRecordInstance(UpdatedCryptoForApp.class);
        ByteBuffer keyStore1 = ByteBuffer.wrap("keyStore1".getBytes());
        char[] keyStorePassword1 = "keyStorePassword1".toCharArray();
        ByteBuffer trustStore1 = ByteBuffer.wrap("trustStore1".getBytes());
        char[] trustStorePassword1 = "trustStorePassword1".toCharArray();
        crypto1.setKeyStore(keyStore1);
        crypto1.setKeyStorePassword(keyStorePassword1);
        crypto1.setTrustStore(trustStore1);
        crypto1.setTrustStorePassword(trustStorePassword1);
        crypto1.setVersion(1);
        updatedCryptoForApps.put(appId1, crypto1);
        ApplicationId appId2 = ApplicationId.newInstance((long)now, (int)2);
        UpdatedCryptoForApp crypto2 = (UpdatedCryptoForApp)recordFactory.newRecordInstance(UpdatedCryptoForApp.class);
        ByteBuffer keyStore2 = ByteBuffer.wrap("keyStore2".getBytes());
        char[] keyStorePassword2 = "keyStorePassword2".toCharArray();
        ByteBuffer trustStore2 = ByteBuffer.wrap("trustStore2".getBytes());
        char[] trustStorePassword2 = "trustStorePassword2".toCharArray();
        crypto2.setKeyStore(keyStore2);
        crypto2.setKeyStorePassword(keyStorePassword2);
        crypto2.setTrustStore(trustStore2);
        crypto2.setTrustStorePassword(trustStorePassword2);
        crypto2.setVersion(1);
        updatedCryptoForApps.put(appId2, crypto2);
        original.setUpdatedCryptoForApps(updatedCryptoForApps);
        NodeHeartbeatResponsePBImpl copy = new NodeHeartbeatResponsePBImpl(original.getProto());
        Map copyCrypto = copy.getUpdatedCryptoForApps();
        Assert.assertNotNull((Object)copyCrypto);
        Assert.assertEquals((long)2L, (long)copyCrypto.size());
        UpdatedCryptoForApp copyAppCrypto1 = (UpdatedCryptoForApp)copyCrypto.get(appId1);
        Assert.assertNotNull((Object)copyAppCrypto1);
        Assert.assertTrue((boolean)keyStore1.equals(copyAppCrypto1.getKeyStore()));
        Assert.assertArrayEquals((char[])keyStorePassword1, (char[])copyAppCrypto1.getKeyStorePassword());
        Assert.assertTrue((boolean)trustStore1.equals(copyAppCrypto1.getTrustStore()));
        Assert.assertArrayEquals((char[])trustStorePassword1, (char[])copyAppCrypto1.getTrustStorePassword());
        Assert.assertEquals((long)1L, (long)copyAppCrypto1.getVersion());
        UpdatedCryptoForApp copyAppCrypto2 = (UpdatedCryptoForApp)copyCrypto.get(appId2);
        Assert.assertNotNull((Object)copyAppCrypto2);
        Assert.assertTrue((boolean)keyStore2.equals(copyAppCrypto2.getKeyStore()));
        Assert.assertArrayEquals((char[])keyStorePassword2, (char[])copyAppCrypto2.getKeyStorePassword());
        Assert.assertTrue((boolean)trustStore2.equals(copyAppCrypto2.getTrustStore()));
        Assert.assertArrayEquals((char[])trustStorePassword2, (char[])copyAppCrypto2.getTrustStorePassword());
        Assert.assertEquals((long)1L, (long)copyAppCrypto2.getVersion());
        Assert.assertFalse((boolean)copyAppCrypto1.getKeyStore().equals(copyAppCrypto2.getKeyStore()));
        Assert.assertFalse((boolean)copyAppCrypto1.getTrustStore().equals(copyAppCrypto2.getTrustStore()));
    }

    @Test
    public void testRegisterNodeManagerRequestPBImpl() {
        RegisterNodeManagerRequestPBImpl original = new RegisterNodeManagerRequestPBImpl();
        original.setHttpPort(8080);
        original.setNodeId(this.getNodeId());
        Resource resource = (Resource)recordFactory.newRecordInstance(Resource.class);
        resource.setMemorySize(10000L);
        resource.setVirtualCores(2);
        original.setResource(resource);
        original.setPhysicalResource(resource);
        RegisterNodeManagerRequestPBImpl copy = new RegisterNodeManagerRequestPBImpl(original.getProto());
        Assert.assertEquals((long)8080L, (long)copy.getHttpPort());
        Assert.assertEquals((long)9090L, (long)copy.getNodeId().getPort());
        Assert.assertEquals((long)10000L, (long)copy.getResource().getMemorySize());
        Assert.assertEquals((long)2L, (long)copy.getResource().getVirtualCores());
        Assert.assertEquals((long)10000L, (long)copy.getPhysicalResource().getMemorySize());
        Assert.assertEquals((long)2L, (long)copy.getPhysicalResource().getVirtualCores());
    }

    @Test
    public void testMasterKeyPBImpl() {
        MasterKeyPBImpl original = new MasterKeyPBImpl();
        original.setBytes(ByteBuffer.allocate(0));
        original.setKeyId(1);
        MasterKeyPBImpl copy = new MasterKeyPBImpl(original.getProto());
        Assert.assertEquals((long)1L, (long)copy.getKeyId());
        Assert.assertTrue((boolean)original.equals((Object)copy));
        Assert.assertEquals((long)original.hashCode(), (long)copy.hashCode());
    }

    @Test
    public void testSerializedExceptionPBImpl() {
        SerializedExceptionPBImpl original = new SerializedExceptionPBImpl();
        original.init("testMessage");
        SerializedExceptionPBImpl copy = new SerializedExceptionPBImpl(original.getProto());
        Assert.assertEquals((Object)"testMessage", (Object)copy.getMessage());
        original = new SerializedExceptionPBImpl();
        original.init("testMessage", new Throwable(new Throwable("parent")));
        copy = new SerializedExceptionPBImpl(original.getProto());
        Assert.assertEquals((Object)"testMessage", (Object)copy.getMessage());
        Assert.assertEquals((Object)"parent", (Object)copy.getCause().getMessage());
        Assert.assertTrue((boolean)copy.getRemoteTrace().startsWith("java.lang.Throwable: java.lang.Throwable: parent"));
    }

    @Test
    public void testNodeStatusPBImpl() {
        NodeStatusPBImpl original = new NodeStatusPBImpl();
        original.setContainersStatuses(Arrays.asList(this.getContainerStatus(1, 2, 1), this.getContainerStatus(2, 3, 1)));
        original.setKeepAliveApplications(Arrays.asList(this.getApplicationId(3), this.getApplicationId(4)));
        original.setNodeHealthStatus(this.getNodeHealthStatus());
        original.setNodeId(this.getNodeId());
        original.setResponseId(1);
        original.setIncreasedContainers(Arrays.asList(this.getIncreasedContainer(1, 2, 2048, 2), this.getIncreasedContainer(2, 3, 4096, 3)));
        NodeStatusPBImpl copy = new NodeStatusPBImpl(original.getProto());
        Assert.assertEquals((long)3L, (long)((ContainerStatus)copy.getContainersStatuses().get(1)).getContainerId().getContainerId());
        Assert.assertEquals((long)3L, (long)((ApplicationId)copy.getKeepAliveApplications().get(0)).getId());
        Assert.assertEquals((long)1000L, (long)copy.getNodeHealthStatus().getLastHealthReportTime());
        Assert.assertEquals((long)9090L, (long)copy.getNodeId().getPort());
        Assert.assertEquals((long)1L, (long)copy.getResponseId());
        Assert.assertEquals((long)1L, (long)((Container)copy.getIncreasedContainers().get(0)).getId().getContainerId());
        Assert.assertEquals((long)4096L, (long)((Container)copy.getIncreasedContainers().get(1)).getResource().getMemorySize());
    }

    @Test
    public void testRegisterNodeManagerRequestWithNullLabels() {
        RegisterNodeManagerRequest request = RegisterNodeManagerRequest.newInstance((NodeId)NodeId.newInstance((String)"host", (int)1234), (int)1234, (Resource)Resource.newInstance((int)0, (int)0), (String)"version", null, null);
        RegisterNodeManagerRequestPBImpl request1 = new RegisterNodeManagerRequestPBImpl(((RegisterNodeManagerRequestPBImpl)request).getProto());
        Assert.assertNull((Object)request1.getNodeLabels());
    }

    @Test
    public void testRegisterNodeManagerRequestWithValidLabels() {
        HashSet<NodeLabel> nodeLabels = this.getValidNodeLabels();
        RegisterNodeManagerRequest request = RegisterNodeManagerRequest.newInstance((NodeId)NodeId.newInstance((String)"host", (int)1234), (int)1234, (Resource)Resource.newInstance((int)0, (int)0), (String)"version", null, null, nodeLabels);
        RegisterNodeManagerRequestPBImpl copy = new RegisterNodeManagerRequestPBImpl(((RegisterNodeManagerRequestPBImpl)request).getProto());
        Assert.assertEquals((Object)true, (Object)nodeLabels.containsAll(copy.getNodeLabels()));
        request.setNodeLabels(new HashSet());
        copy = new RegisterNodeManagerRequestPBImpl(((RegisterNodeManagerRequestPBImpl)request).getProto());
        Assert.assertNotNull((Object)copy.getNodeLabels());
        Assert.assertEquals((long)0L, (long)copy.getNodeLabels().size());
    }

    @Test
    public void testUnRegisterNodeManagerRequestPBImpl() throws Exception {
        UnRegisterNodeManagerRequestPBImpl request = new UnRegisterNodeManagerRequestPBImpl();
        NodeId nodeId = NodeId.newInstance((String)"host", (int)1234);
        request.setNodeId(nodeId);
        UnRegisterNodeManagerRequestPBImpl copy = new UnRegisterNodeManagerRequestPBImpl(request.getProto());
        Assert.assertEquals((Object)nodeId, (Object)copy.getNodeId());
    }

    private HashSet<NodeLabel> getValidNodeLabels() {
        HashSet<NodeLabel> nodeLabels = new HashSet<NodeLabel>();
        nodeLabels.add(NodeLabel.newInstance((String)"java"));
        nodeLabels.add(NodeLabel.newInstance((String)"windows"));
        nodeLabels.add(NodeLabel.newInstance((String)"gpu"));
        nodeLabels.add(NodeLabel.newInstance((String)"x86"));
        return nodeLabels;
    }

    private Map<ApplicationId, AppCollectorData> getCollectors(boolean hasNullCollectorToken) {
        ApplicationId appID = ApplicationId.newInstance((long)1L, (int)1);
        String collectorAddr = "localhost:0";
        AppCollectorData data = AppCollectorData.newInstance((ApplicationId)appID, (String)collectorAddr);
        if (!hasNullCollectorToken) {
            data.setCollectorToken(Token.newInstance((byte[])new byte[0], (String)"kind", (byte[])new byte[0], (String)"s"));
        }
        HashMap<ApplicationId, AppCollectorData> collectorMap = new HashMap<ApplicationId, AppCollectorData>();
        collectorMap.put(appID, data);
        return collectorMap;
    }

    private ContainerStatus getContainerStatus(int applicationId, int containerID, int appAttemptId) {
        ContainerStatus status = (ContainerStatus)recordFactory.newRecordInstance(ContainerStatus.class);
        status.setContainerId(this.getContainerId(containerID, appAttemptId));
        return status;
    }

    private ApplicationAttemptId getApplicationAttemptId(int appAttemptId) {
        ApplicationAttemptId result = ApplicationAttemptIdPBImpl.newInstance((ApplicationId)this.getApplicationId(appAttemptId), (int)appAttemptId);
        return result;
    }

    private ContainerId getContainerId(int containerID, int appAttemptId) {
        ContainerId containerId = ContainerIdPBImpl.newContainerId((ApplicationAttemptId)this.getApplicationAttemptId(appAttemptId), (long)containerID);
        return containerId;
    }

    private ApplicationId getApplicationId(int applicationId) {
        ApplicationIdPBImpl appId = new ApplicationIdPBImpl(){

            public ApplicationIdPBImpl setParameters(int id, long timestamp) {
                this.setClusterTimestamp(timestamp);
                this.setId(id);
                this.build();
                return this;
            }
        }.setParameters(applicationId, 1000L);
        return new ApplicationIdPBImpl(appId.getProto());
    }

    private Container getDecreasedContainer(int containerID, int appAttemptId, int memory, int vCores) {
        ContainerId containerId = this.getContainerId(containerID, appAttemptId);
        Resource capability = Resource.newInstance((int)memory, (int)vCores);
        return Container.newInstance((ContainerId)containerId, null, null, (Resource)capability, null, null);
    }

    private Container getIncreasedContainer(int containerID, int appAttemptId, int memory, int vCores) {
        ContainerId containerId = this.getContainerId(containerID, appAttemptId);
        Resource capability = Resource.newInstance((int)memory, (int)vCores);
        return Container.newInstance((ContainerId)containerId, null, null, (Resource)capability, null, null);
    }

    private NodeStatus getNodeStatus() {
        NodeStatus status = (NodeStatus)recordFactory.newRecordInstance(NodeStatus.class);
        status.setContainersStatuses(new ArrayList());
        status.setKeepAliveApplications(new ArrayList());
        status.setNodeHealthStatus(this.getNodeHealthStatus());
        status.setNodeId(this.getNodeId());
        status.setResponseId(1);
        return status;
    }

    private NodeId getNodeId() {
        return NodeId.newInstance((String)"localhost", (int)9090);
    }

    private NodeHealthStatus getNodeHealthStatus() {
        NodeHealthStatus healStatus = (NodeHealthStatus)recordFactory.newRecordInstance(NodeHealthStatus.class);
        healStatus.setHealthReport("healthReport");
        healStatus.setIsNodeHealthy(true);
        healStatus.setLastHealthReportTime(1000L);
        return healStatus;
    }

    private MasterKey getMasterKey() {
        MasterKey key = (MasterKey)recordFactory.newRecordInstance(MasterKey.class);
        key.setBytes(ByteBuffer.allocate(0));
        key.setKeyId(1);
        return key;
    }
}

