/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords;

import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.protocolrecords.RegisterNodeManagerRequest;
import org.apache.hadoop.yarn.server.api.protocolrecords.UpdatedCryptoForApp;
import org.apache.hadoop.yarn.server.api.protocolrecords.impl.pb.RegisterNodeManagerRequestPBImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestRegisterNodeManagerRequest {
    @Test
    public void testRegisterNodeManagerRequest() {
        ApplicationId appId1 = ApplicationId.newInstance((long)1234L, (int)1);
        ApplicationId appId2 = ApplicationId.newInstance((long)1234L, (int)2);
        HashMap<ApplicationId, UpdatedCryptoForApp> runningApplications = new HashMap<ApplicationId, UpdatedCryptoForApp>(2);
        UpdatedCryptoForApp upc1 = UpdatedCryptoForApp.newInstance((int)1, (long)1L);
        UpdatedCryptoForApp upc2 = UpdatedCryptoForApp.newInstance((int)2, (long)2L);
        runningApplications.put(appId1, upc1);
        runningApplications.put(appId2, upc2);
        RegisterNodeManagerRequest request = RegisterNodeManagerRequest.newInstance((NodeId)NodeId.newInstance((String)"host", (int)1234), (int)1234, (Resource)Resource.newInstance((int)0, (int)0), (String)"version", Arrays.asList(NMContainerStatus.newInstance((ContainerId)ContainerId.newContainerId((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)ApplicationId.newInstance((long)1234L, (int)1), (int)1), (long)1L), (int)0, (ContainerState)ContainerState.RUNNING, (Resource)Resource.newInstance((int)1024, (int)1), (String)"good", (int)-1, (Priority)Priority.newInstance((int)0), (long)1234L)), runningApplications);
        RegisterNodeManagerRequestPBImpl request1 = new RegisterNodeManagerRequestPBImpl(((RegisterNodeManagerRequestPBImpl)request).getProto());
        Assert.assertEquals((long)request1.getNMContainerStatuses().size(), (long)request.getNMContainerStatuses().size());
        Assert.assertEquals((Object)((NMContainerStatus)request1.getNMContainerStatuses().get(0)).getContainerId(), (Object)((NMContainerStatus)request.getNMContainerStatuses().get(0)).getContainerId());
        Assert.assertEquals((long)request1.getRunningApplications().size(), (long)request.getRunningApplications().size());
        Assert.assertEquals(request1.getRunningApplications().get(0), request.getRunningApplications().get(0));
        Assert.assertEquals(request1.getRunningApplications().get(1), request.getRunningApplications().get(1));
    }

    @Test
    public void testRegisterNodeManagerRequestWithNullArrays() {
        RegisterNodeManagerRequest request = RegisterNodeManagerRequest.newInstance((NodeId)NodeId.newInstance((String)"host", (int)1234), (int)1234, (Resource)Resource.newInstance((int)0, (int)0), (String)"version", null, null);
        RegisterNodeManagerRequestPBImpl request1 = new RegisterNodeManagerRequestPBImpl(((RegisterNodeManagerRequestPBImpl)request).getProto());
        Assert.assertEquals((long)0L, (long)request1.getNMContainerStatuses().size());
        Assert.assertEquals((long)0L, (long)request1.getRunningApplications().size());
    }
}

