/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.manager;

import java.util.HashMap;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.BroadcastAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.manager.BasePolicyManagerTest;
import org.apache.hadoop.yarn.server.federation.policies.manager.PriorityBroadcastPolicyManager;
import org.apache.hadoop.yarn.server.federation.policies.router.PriorityRouterPolicy;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPriorityBroadcastPolicyManager
extends BasePolicyManagerTest {
    private WeightedPolicyInfo policyInfo;

    @Before
    public void setup() {
        this.wfp = new PriorityBroadcastPolicyManager();
        this.wfp.setQueue("queue1");
        SubClusterId sc1 = SubClusterId.newInstance((String)"sc1");
        SubClusterId sc2 = SubClusterId.newInstance((String)"sc2");
        this.policyInfo = new WeightedPolicyInfo();
        HashMap<SubClusterIdInfo, Float> routerWeights = new HashMap<SubClusterIdInfo, Float>();
        routerWeights.put(new SubClusterIdInfo(sc1), Float.valueOf(0.2f));
        routerWeights.put(new SubClusterIdInfo(sc2), Float.valueOf(0.8f));
        this.policyInfo.setRouterPolicyWeights(routerWeights);
        ((PriorityBroadcastPolicyManager)this.wfp).setWeightedPolicyInfo(this.policyInfo);
        this.expectedPolicyManager = PriorityBroadcastPolicyManager.class;
        this.expectedAMRMProxyPolicy = BroadcastAMRMProxyPolicy.class;
        this.expectedRouterPolicy = PriorityRouterPolicy.class;
    }

    @Test
    public void testPolicyInfoSetCorrectly() throws Exception {
        TestPriorityBroadcastPolicyManager.serializeAndDeserializePolicyManager(this.wfp, this.expectedPolicyManager, this.expectedAMRMProxyPolicy, this.expectedRouterPolicy);
        Assert.assertEquals((Object)((PriorityBroadcastPolicyManager)this.wfp).getWeightedPolicyInfo(), (Object)this.policyInfo);
    }
}

