/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.router;

import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.ConfigurableFederationPolicy;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.router.BaseRouterPoliciesTest;
import org.apache.hadoop.yarn.server.federation.policies.router.FederationRouterPolicy;
import org.apache.hadoop.yarn.server.federation.policies.router.RejectRouterPolicy;
import org.apache.hadoop.yarn.server.federation.utils.FederationPoliciesTestUtil;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Before;
import org.junit.Test;

public class TestRejectRouterPolicy
extends BaseRouterPoliciesTest {
    @Before
    public void setUp() throws Exception {
        this.setPolicy((ConfigurableFederationPolicy)new RejectRouterPolicy());
        this.setMockActiveSubclusters(2);
        FederationPoliciesTestUtil.initializePolicyContext(this.getPolicy(), this.getPolicyInfo(), this.getActiveSubclusters());
    }

    @Test(expected=FederationPolicyException.class)
    public void testNoClusterIsChosen() throws YarnException {
        ((FederationRouterPolicy)this.getPolicy()).getHomeSubcluster(this.getApplicationSubmissionContext(), null);
    }

    @Override
    @Test(expected=FederationPolicyException.class)
    public void testNullQueueRouting() throws YarnException {
        FederationRouterPolicy localPolicy = (FederationRouterPolicy)this.getPolicy();
        ApplicationSubmissionContext applicationSubmissionContext = ApplicationSubmissionContext.newInstance(null, null, null, null, null, (boolean)false, (boolean)false, (int)0, (Resource)Resources.none(), null, (boolean)false, null, null);
        localPolicy.getHomeSubcluster(applicationSubmissionContext, null);
    }
}

