/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.impl;

import java.io.IOException;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.apache.curator.test.TestingServer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.impl.FederationStateStoreBaseTest;
import org.apache.hadoop.yarn.server.federation.store.impl.ZookeeperFederationStateStore;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestZookeeperFederationStateStore
extends FederationStateStoreBaseTest {
    private static final Logger LOG = LoggerFactory.getLogger(TestZookeeperFederationStateStore.class);
    private static TestingServer curatorTestingServer;
    private static CuratorFramework curatorFramework;

    @Override
    @Before
    public void before() throws IOException, YarnException {
        try {
            curatorTestingServer = new TestingServer();
            curatorTestingServer.start();
            String connectString = curatorTestingServer.getConnectString();
            curatorFramework = CuratorFrameworkFactory.builder().connectString(connectString).retryPolicy((RetryPolicy)new RetryNTimes(100, 100)).build();
            curatorFramework.start();
            YarnConfiguration conf = new YarnConfiguration();
            conf.set("hadoop.zk.address", connectString);
            this.setConf((Configuration)conf);
        }
        catch (Exception e) {
            LOG.error("Cannot initialize ZooKeeper store", (Throwable)e);
            throw new IOException(e);
        }
        super.before();
    }

    @Override
    @After
    public void after() throws Exception {
        super.after();
        curatorFramework.close();
        try {
            curatorTestingServer.stop();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected FederationStateStore createStateStore() {
        Configuration conf = new Configuration();
        super.setConf(conf);
        return new ZookeeperFederationStateStore();
    }
}

