/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager;

import java.nio.ByteBuffer;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.event.AbstractEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;

public class AuxServicesEvent
extends AbstractEvent<AuxServicesEventType> {
    private final String user;
    private final String userFolder;
    private final String serviceId;
    private final ByteBuffer serviceData;
    private final ApplicationId appId;
    private final Container container;

    public AuxServicesEvent(AuxServicesEventType eventType, ApplicationId appId) {
        this(eventType, null, appId, null, null, null);
    }

    public AuxServicesEvent(AuxServicesEventType eventType, Container container) {
        this(eventType, null, container.getContainerId().getApplicationAttemptId().getApplicationId(), null, null, container, null);
    }

    public AuxServicesEvent(AuxServicesEventType eventType, String user, ApplicationId appId, String serviceId, ByteBuffer serviceData, String userFolder) {
        this(eventType, user, appId, serviceId, serviceData, null, userFolder);
    }

    public AuxServicesEvent(AuxServicesEventType eventType, String user, ApplicationId appId, String serviceId, ByteBuffer serviceData, Container container, String userFolder) {
        super((Enum)eventType);
        this.user = user;
        this.appId = appId;
        this.serviceId = serviceId;
        this.serviceData = serviceData;
        this.container = container;
        this.userFolder = userFolder;
    }

    public String getServiceID() {
        return this.serviceId;
    }

    public ByteBuffer getServiceData() {
        return this.serviceData;
    }

    public String getUser() {
        return this.user;
    }

    public String getUserFolder() {
        return this.userFolder;
    }

    public ApplicationId getApplicationID() {
        return this.appId;
    }

    public Container getContainer() {
        return this.container;
    }
}

