/*
 * Decompiled with CFR 0.152.
 */
package io.hops.devices;

import io.hops.GPUManagementLibrary;
import io.hops.exceptions.GPUManagementLibraryException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GPUManagementLibraryLoader {
    static final Log LOG = LogFactory.getLog(GPUManagementLibraryLoader.class);

    public static GPUManagementLibrary load(String classStr) throws GPUManagementLibraryException {
        GPUManagementLibrary gpuManagementLibrary = null;
        try {
            gpuManagementLibrary = (GPUManagementLibrary)Class.forName(classStr).newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new GPUManagementLibraryException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new GPUManagementLibraryException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new GPUManagementLibraryException((Throwable)e);
        }
        catch (UnsatisfiedLinkError e) {
            LOG.warn((Object)"Could not load JNI library for GPU management");
        }
        return gpuManagementLibrary;
    }
}

