/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.nio.ByteBuffer;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEvent;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEventType;

public class CMgrUpdateCryptoMaterialEvent
extends ContainerManagerEvent {
    private final ContainerId containerId;
    private final ByteBuffer keyStore;
    private final char[] keyStorePassword;
    private final ByteBuffer trustStore;
    private final char[] trustStorePassword;
    private final int version;

    public CMgrUpdateCryptoMaterialEvent(ContainerId containerId, ByteBuffer keyStore, char[] keyStorePassword, ByteBuffer trustStore, char[] trustStorePassword, int version) {
        super(ContainerManagerEventType.UPDATE_CRYPTO_MATERIAL);
        this.containerId = containerId;
        this.keyStore = keyStore;
        this.keyStorePassword = keyStorePassword;
        this.trustStore = trustStore;
        this.trustStorePassword = trustStorePassword;
        this.version = version;
    }

    public ContainerId getContainerId() {
        return this.containerId;
    }

    public ByteBuffer getKeyStore() {
        return this.keyStore.asReadOnlyBuffer();
    }

    public char[] getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public ByteBuffer getTrustStore() {
        return this.trustStore.asReadOnlyBuffer();
    }

    public char[] getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public int getVersion() {
        return this.version;
    }
}

