/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.amrmproxy;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AMRMProxyApplicationContext;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AbstractRequestInterceptor;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.RequestInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultRequestInterceptor
extends AbstractRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRequestInterceptor.class);
    private ApplicationMasterProtocol rmClient;
    private UserGroupInformation user = null;

    @Override
    public void init(AMRMProxyApplicationContext appContext) {
        super.init(appContext);
        try {
            this.user = UserGroupInformation.createProxyUser((String)appContext.getApplicationAttemptId().toString(), (UserGroupInformation)UserGroupInformation.getCurrentUser());
            this.user.addToken(appContext.getAMRMToken());
            final Configuration conf = this.getConf();
            this.rmClient = (ApplicationMasterProtocol)this.user.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<ApplicationMasterProtocol>(){

                @Override
                public ApplicationMasterProtocol run() throws Exception {
                    return (ApplicationMasterProtocol)ClientRMProxy.createRMProxy((Configuration)conf, ApplicationMasterProtocol.class, (boolean)true);
                }
            });
        }
        catch (IOException e) {
            String message = "Error while creating of RM app master service proxy for attemptId:" + appContext.getApplicationAttemptId().toString();
            if (this.user != null) {
                message = message + ", user: " + this.user;
            }
            LOG.info(message);
            throw new YarnRuntimeException(message, (Throwable)e);
        }
        catch (Exception e) {
            throw new YarnRuntimeException((Throwable)e);
        }
    }

    public RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        LOG.info("Forwarding registration request to the real YARN RM");
        return this.rmClient.registerApplicationMaster(request);
    }

    public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
        AllocateResponse allocateResponse;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Forwarding allocate request to the real YARN RM");
        }
        if ((allocateResponse = this.rmClient.allocate(request)).getAMRMToken() != null) {
            this.updateAMRMToken(allocateResponse.getAMRMToken());
        }
        return allocateResponse;
    }

    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
        LOG.info("Forwarding finish application request to the real YARN Resource Manager");
        return this.rmClient.finishApplicationMaster(request);
    }

    @Override
    public void setNextInterceptor(RequestInterceptor next) {
        throw new YarnRuntimeException("setNextInterceptor is being called on DefaultRequestInterceptor,which should be the last one in the chain Check if the interceptor pipeline configuration is correct");
    }

    private void updateAMRMToken(org.apache.hadoop.yarn.api.records.Token token) throws IOException {
        Token amrmToken = new Token(token.getIdentifier().array(), token.getPassword().array(), new Text(token.getKind()), new Text(token.getService()));
        this.user.addToken(amrmToken);
        amrmToken.setService(ClientRMProxy.getAMRMTokenService((Configuration)this.getConf()));
    }

    @VisibleForTesting
    public void setRMClient(ApplicationMasterProtocol rmClient) {
        this.rmClient = rmClient;
    }
}

