/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.nodelabels;

import java.io.IOException;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.AbstractNodeLabelsProvider;

public class ConfigurationNodeLabelsProvider
extends AbstractNodeLabelsProvider {
    private static final Log LOG = LogFactory.getLog(ConfigurationNodeLabelsProvider.class);

    public ConfigurationNodeLabelsProvider() {
        super("Configuration Based NodeLabels Provider");
    }

    private void updateNodeLabelsFromConfig(Configuration conf) throws IOException {
        String configuredNodePartition = conf.get("yarn.nodemanager.node-labels.provider.configured-node-partition", null);
        this.setNodeLabels(ConfigurationNodeLabelsProvider.convertToNodeLabelSet(configuredNodePartition));
    }

    @Override
    public TimerTask createTimerTask() {
        return new ConfigurationMonitorTimerTask();
    }

    @Override
    protected void cleanUp() throws Exception {
    }

    private class ConfigurationMonitorTimerTask
    extends TimerTask {
        private ConfigurationMonitorTimerTask() {
        }

        @Override
        public void run() {
            try {
                ConfigurationNodeLabelsProvider.this.updateNodeLabelsFromConfig((Configuration)new YarnConfiguration());
            }
            catch (Exception e) {
                LOG.error((Object)"Failed to update node Labels from configuration.xml ", (Throwable)e);
            }
        }
    }
}

