/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.ssl.JWTSecurityMaterial;
import org.apache.hadoop.security.ssl.X509SecurityMaterial;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ContainerManagementProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerStatusesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceRequest;
import org.apache.hadoop.yarn.api.protocolrecords.IncreaseContainersResourceResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainerRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StartContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.StopContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.SignalContainerResponsePBImpl;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.SerializedException;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.LogAggregationContextPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.InvalidAuxServiceException;
import org.apache.hadoop.yarn.exceptions.InvalidContainerException;
import org.apache.hadoop.yarn.exceptions.NMNotYetReadyException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.security.NMTokenIdentifier;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.nodemanager.CMgrCompletedAppsEvent;
import org.apache.hadoop.yarn.server.nodemanager.CMgrCompletedContainersEvent;
import org.apache.hadoop.yarn.server.nodemanager.CMgrDecreaseContainersResourceEvent;
import org.apache.hadoop.yarn.server.nodemanager.CMgrSignalContainersEvent;
import org.apache.hadoop.yarn.server.nodemanager.CMgrUpdateJWTEvent;
import org.apache.hadoop.yarn.server.nodemanager.CMgrUpdateX509Event;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEvent;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEventType;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.NMAuditLogger;
import org.apache.hadoop.yarn.server.nodemanager.NodeManager;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AMRMProxyService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServices;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.AuxServicesEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerSecurityUpdaterTask;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationContainerInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationFinishEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationInitEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerKillEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncher;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.ContainersLauncherEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.launcher.SignalContainersLauncherEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.ResourceLocalizationService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.event.LocalizationEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.sharedcache.SharedCacheUploadEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.localizer.sharedcache.SharedCacheUploadService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.logaggregation.LogAggregationService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.LogHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.NonAggregatingLogHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ChangeMonitoringContainerResourceEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorEventType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor.ContainersMonitorImpl;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.security.authorize.NMPolicyProvider;
import org.apache.hadoop.yarn.server.security.CertificateLocalizationService;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.server.utils.YarnServerSecurityUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

public class ContainerManagerImpl
extends CompositeService
implements ServiceStateChangeListener,
ContainerManagementProtocol,
EventHandler<ContainerManagerEvent> {
    private static final int SHUTDOWN_CLEANUP_SLOP_MS = 1000;
    private static final Log LOG = LogFactory.getLog(ContainerManagerImpl.class);
    static final String INVALID_NMTOKEN_MSG = "Invalid NMToken";
    static final String INVALID_CONTAINERTOKEN_MSG = "Invalid ContainerToken";
    final Context context;
    private final ContainersMonitor containersMonitor;
    private Server server;
    private final ResourceLocalizationService rsrcLocalizationSrvc;
    private final ContainersLauncher containersLauncher;
    private final AuxServices auxiliaryServices;
    private final NodeManagerMetrics metrics;
    private final ContainerExecutor exec;
    private final NodeStatusUpdater nodeStatusUpdater;
    protected LocalDirsHandlerService dirsHandler;
    protected final AsyncDispatcher dispatcher;
    private final DeletionService deletionService;
    private AtomicBoolean blockNewContainerRequests = new AtomicBoolean(false);
    private boolean serviceStopped = false;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private AMRMProxyService amrmProxyService;
    protected boolean amrmProxyEnabled = false;
    private long waitForContainersOnShutdownMillis;
    private final ExecutorService cryptoMaterialUpdaterThreadPool;
    private final Map<ContainerId, Future> x509Updaters = new HashMap<ContainerId, Future>();
    private final Map<ContainerId, Future> jwtUpdaters = new HashMap<ContainerId, Future>();

    public ContainerManagerImpl(Context context, ContainerExecutor exec, DeletionService deletionContext, NodeStatusUpdater nodeStatusUpdater, NodeManagerMetrics metrics, LocalDirsHandlerService dirsHandler) {
        super(ContainerManagerImpl.class.getName());
        this.context = context;
        this.dirsHandler = dirsHandler;
        this.dispatcher = new AsyncDispatcher();
        this.deletionService = deletionContext;
        this.metrics = metrics;
        this.rsrcLocalizationSrvc = this.createResourceLocalizationService(exec, deletionContext, context);
        this.addService((Service)this.rsrcLocalizationSrvc);
        this.containersLauncher = this.createContainersLauncher(context, exec);
        this.addService((Service)this.containersLauncher);
        this.exec = exec;
        this.nodeStatusUpdater = nodeStatusUpdater;
        this.auxiliaryServices = new AuxServices();
        this.auxiliaryServices.registerServiceListener(this);
        this.addService((Service)this.auxiliaryServices);
        this.containersMonitor = new ContainersMonitorImpl(exec, this.dispatcher, this.context);
        this.addService(this.containersMonitor);
        this.dispatcher.register(ContainerEventType.class, (EventHandler)new ContainerEventDispatcher());
        this.dispatcher.register(ApplicationEventType.class, (EventHandler)new ApplicationEventDispatcher());
        this.dispatcher.register(LocalizationEventType.class, (EventHandler)this.rsrcLocalizationSrvc);
        this.dispatcher.register(AuxServicesEventType.class, (EventHandler)this.auxiliaryServices);
        this.dispatcher.register(ContainersMonitorEventType.class, (EventHandler)this.containersMonitor);
        this.dispatcher.register(ContainersLauncherEventType.class, (EventHandler)this.containersLauncher);
        this.addService((Service)this.dispatcher);
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        this.cryptoMaterialUpdaterThreadPool = Executors.newFixedThreadPool(3, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Container crypto material updater thread #%d").build());
    }

    public void serviceInit(Configuration conf) throws Exception {
        LogHandler logHandler = this.createLogHandler(conf, this.context, this.deletionService);
        this.addIfService(logHandler);
        this.dispatcher.register(LogHandlerEventType.class, (EventHandler)logHandler);
        SharedCacheUploadService sharedCacheUploader = this.createSharedCacheUploaderService();
        this.addService((Service)sharedCacheUploader);
        this.dispatcher.register(SharedCacheUploadEventType.class, (EventHandler)sharedCacheUploader);
        this.createAMRMProxyService(conf);
        this.waitForContainersOnShutdownMillis = conf.getLong("yarn.nodemanager.sleep-delay-before-sigkill.ms", 250L) + conf.getLong("yarn.nodemanager.process-kill-wait.ms", 2000L) + 1000L;
        super.serviceInit(conf);
        this.recover();
    }

    protected void createAMRMProxyService(Configuration conf) {
        this.amrmProxyEnabled = conf.getBoolean("yarn.nodemanager.amrmproxy.enable", false);
        if (this.amrmProxyEnabled) {
            LOG.info((Object)"AMRMProxyService is enabled. All the AM->RM requests will be intercepted by the proxy");
            this.setAMRMProxyService(new AMRMProxyService(this.context, this.dispatcher));
            this.addService((Service)this.getAMRMProxyService());
        } else {
            LOG.info((Object)"AMRMProxyService is disabled");
        }
    }

    private void recover() throws IOException, URISyntaxException {
        NMStateStoreService stateStore = this.context.getNMStateStore();
        if (stateStore.canRecover()) {
            this.rsrcLocalizationSrvc.recoverLocalizedResources(stateStore.loadLocalizationState());
            NMStateStoreService.RecoveredApplicationsState appsState = stateStore.loadApplicationsState();
            for (YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto proto : appsState.getApplications()) {
                this.recoverApplication(proto);
            }
            for (NMStateStoreService.RecoveredContainerState rcs : stateStore.loadContainersState()) {
                this.recoverContainer(rcs);
            }
        }
    }

    private void recoverApplication(YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto p) throws IOException {
        ApplicationIdPBImpl appId = new ApplicationIdPBImpl(p.getId());
        Credentials creds = new Credentials();
        creds.readTokenStorageStream(new DataInputStream(p.getCredentials().newInput()));
        int cryptoMaterialVersion = -1;
        long jwtExpiration = -1L;
        if (this.isHopsTLSEnabled()) {
            this.materializeX509((ApplicationId)appId, p.getUser(), p.getUserFolder(), ProtoUtils.convertFromProtoFormat((ByteString)p.getKeyStore()), p.getKeyStorePassword(), ProtoUtils.convertFromProtoFormat((ByteString)p.getTrustStore()), p.getTrustStorePassword());
            cryptoMaterialVersion = p.getCryptoVersion();
        }
        if (this.isJWTEnabled()) {
            this.materializeJWT((ApplicationId)appId, p.getUser(), p.getUserFolder(), p.getJwt());
            jwtExpiration = p.getJwtExpiration();
        }
        List<YarnProtos.ApplicationACLMapProto> aclProtoList = p.getAclsList();
        HashMap<ApplicationAccessType, String> acls = new HashMap<ApplicationAccessType, String>(aclProtoList.size());
        for (YarnProtos.ApplicationACLMapProto aclProto : aclProtoList) {
            acls.put(ProtoUtils.convertFromProtoFormat((YarnProtos.ApplicationAccessTypeProto)aclProto.getAccessType()), aclProto.getAcl());
        }
        LogAggregationContextPBImpl logAggregationContext = null;
        if (p.getLogAggregationContext() != null) {
            logAggregationContext = new LogAggregationContextPBImpl(p.getLogAggregationContext());
        }
        LOG.info((Object)("Recovering application " + appId));
        ApplicationImpl app = null;
        app = this.isHopsTLSEnabled() || this.isJWTEnabled() ? new ApplicationImpl((Dispatcher)this.dispatcher, p.getUser(), (ApplicationId)appId, creds, this.context, p.getUserFolder(), cryptoMaterialVersion, jwtExpiration) : new ApplicationImpl((Dispatcher)this.dispatcher, p.getUser(), (ApplicationId)appId, creds, this.context, p.getUserFolder());
        this.context.getApplications().put((ApplicationId)appId, app);
        app.handle(new ApplicationInitEvent((ApplicationId)appId, acls, (LogAggregationContext)logAggregationContext));
    }

    private void recoverContainer(NMStateStoreService.RecoveredContainerState rcs) throws IOException {
        StartContainerRequest req = rcs.getStartRequest();
        ContainerLaunchContext launchContext = req.getContainerLaunchContext();
        ContainerTokenIdentifier token = BuilderUtils.newContainerTokenIdentifier((Token)req.getContainerToken());
        ContainerId containerId = token.getContainerID();
        ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
        LOG.info((Object)("Recovering " + containerId + " in state " + (Object)((Object)rcs.getStatus()) + " with exit code " + rcs.getExitCode()));
        Application app = (Application)this.context.getApplications().get(appId);
        if (app != null) {
            Credentials credentials = YarnServerSecurityUtils.parseCredentials((ContainerLaunchContext)launchContext);
            ContainerImpl container = new ContainerImpl(this.getConfig(), (Dispatcher)this.dispatcher, req.getContainerLaunchContext(), credentials, this.metrics, token, this.context, rcs);
            this.context.getContainers().put(containerId, container);
            app.handle((Event)new ApplicationContainerInitEvent(container));
        } else {
            if (rcs.getStatus() != NMStateStoreService.RecoveredContainerStatus.COMPLETED) {
                LOG.warn((Object)(containerId + " has no corresponding application!"));
            }
            LOG.info((Object)("Adding " + containerId + " to recently stopped containers"));
            this.nodeStatusUpdater.addCompletedContainer(containerId);
        }
    }

    private void waitForRecoveredContainers() throws InterruptedException {
        int sleepMsec = 100;
        int waitIterations = 100;
        ArrayList<ContainerId> newContainers = new ArrayList<ContainerId>();
        while (--waitIterations >= 0) {
            newContainers.clear();
            for (Container container : this.context.getContainers().values()) {
                if (container.getContainerState() != ContainerState.NEW) continue;
                newContainers.add(container.getContainerId());
            }
            if (newContainers.isEmpty()) break;
            LOG.info((Object)("Waiting for containers: " + newContainers));
            Thread.sleep(100L);
        }
        if (waitIterations < 0) {
            LOG.warn((Object)"Timeout waiting for recovered containers");
        }
    }

    protected LogHandler createLogHandler(Configuration conf, Context context, DeletionService deletionService) {
        if (conf.getBoolean("yarn.log-aggregation-enable", false)) {
            return new LogAggregationService((Dispatcher)this.dispatcher, context, deletionService, this.dirsHandler);
        }
        return new NonAggregatingLogHandler((Dispatcher)this.dispatcher, deletionService, this.dirsHandler, context.getNMStateStore());
    }

    public ContainersMonitor getContainersMonitor() {
        return this.containersMonitor;
    }

    protected ResourceLocalizationService createResourceLocalizationService(ContainerExecutor exec, DeletionService deletionContext, Context context) {
        return new ResourceLocalizationService((Dispatcher)this.dispatcher, exec, deletionContext, this.dirsHandler, context);
    }

    protected SharedCacheUploadService createSharedCacheUploaderService() {
        return new SharedCacheUploadService();
    }

    protected ContainersLauncher createContainersLauncher(Context context, ContainerExecutor exec) {
        return new ContainersLauncher(context, (Dispatcher)this.dispatcher, exec, this.dirsHandler, this);
    }

    protected void serviceStart() throws Exception {
        InetSocketAddress connectAddress;
        boolean usingEphemeralPort;
        Configuration conf = this.getConfig();
        InetSocketAddress initialAddress = conf.getSocketAddr("yarn.nodemanager.bind-host", "yarn.nodemanager.address", "0.0.0.0:0", 0);
        boolean bl = usingEphemeralPort = initialAddress.getPort() == 0;
        if (this.context.getNMStateStore().canRecover() && usingEphemeralPort) {
            throw new IllegalArgumentException("Cannot support recovery with an ephemeral server port. Check the setting of yarn.nodemanager.address");
        }
        boolean delayedRpcServerStart = this.context.getNMStateStore().canRecover();
        Configuration serverConf = new Configuration(conf);
        serverConf.set("hadoop.security.authentication", SaslRpcServer.AuthMethod.TOKEN.toString());
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(ContainerManagementProtocol.class, (Object)this, initialAddress, serverConf, (SecretManager)this.context.getNMTokenSecretManager(), conf.getInt("yarn.nodemanager.container-manager.thread-count", 20));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            this.refreshServiceAcls(conf, new NMPolicyProvider());
        }
        LOG.info((Object)"Blocking new container-requests as container manager rpc server is still starting.");
        this.setBlockNewContainerRequests(true);
        String bindHost = conf.get("yarn.nodemanager.bind-host");
        String nmAddress = conf.getTrimmed("yarn.nodemanager.address");
        String hostOverride = null;
        if (bindHost != null && !bindHost.isEmpty() && nmAddress != null && !nmAddress.isEmpty()) {
            hostOverride = nmAddress.split(":")[0];
        }
        if (delayedRpcServerStart) {
            connectAddress = NetUtils.getConnectAddress((InetSocketAddress)initialAddress);
        } else {
            this.server.start();
            connectAddress = NetUtils.getConnectAddress((Server)this.server);
        }
        NodeId nodeId = this.buildNodeId(connectAddress, hostOverride);
        ((NodeManager.NMContext)this.context).setNodeId(nodeId);
        this.context.getNMTokenSecretManager().setNodeId(nodeId);
        this.context.getContainerTokenSecretManager().setNodeId(nodeId);
        super.serviceStart();
        if (delayedRpcServerStart) {
            this.waitForRecoveredContainers();
            this.server.start();
            connectAddress = NetUtils.getConnectAddress((Server)this.server);
            NodeId serverNode = this.buildNodeId(connectAddress, hostOverride);
            if (!serverNode.equals((Object)nodeId)) {
                throw new IOException("Node mismatch after server started, expected '" + nodeId + "' but found '" + serverNode + "'");
            }
        }
        LOG.info((Object)("ContainerManager started at " + connectAddress));
        LOG.info((Object)("ContainerManager bound to " + initialAddress));
    }

    private NodeId buildNodeId(InetSocketAddress connectAddress, String hostOverride) {
        if (hostOverride != null) {
            connectAddress = NetUtils.getConnectAddress((InetSocketAddress)new InetSocketAddress(hostOverride, connectAddress.getPort()));
        }
        return NodeId.newInstance((String)connectAddress.getAddress().getCanonicalHostName(), (int)connectAddress.getPort());
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAcl(configuration, policyProvider);
    }

    public void serviceStop() throws Exception {
        this.setBlockNewContainerRequests(true);
        this.writeLock.lock();
        try {
            this.serviceStopped = true;
            if (this.context != null) {
                this.cleanUpApplicationsOnNMShutDown();
            }
        }
        finally {
            this.writeLock.unlock();
        }
        if (this.auxiliaryServices.getServiceState() == Service.STATE.STARTED) {
            this.auxiliaryServices.unregisterServiceListener(this);
        }
        if (this.server != null) {
            this.server.stop();
        }
        if (this.cryptoMaterialUpdaterThreadPool != null) {
            this.cryptoMaterialUpdaterThreadPool.shutdownNow();
        }
        super.serviceStop();
    }

    public void cleanUpApplicationsOnNMShutDown() {
        ConcurrentMap<ApplicationId, Application> applications = this.context.getApplications();
        if (applications.isEmpty()) {
            return;
        }
        LOG.info((Object)("Applications still running : " + applications.keySet()));
        if (this.context.getNMStateStore().canRecover() && !this.context.getDecommissioned() && this.getConfig().getBoolean("yarn.nodemanager.recovery.supervised", false)) {
            return;
        }
        ArrayList<ApplicationId> appIds = new ArrayList<ApplicationId>(applications.keySet());
        this.handle(new CMgrCompletedAppsEvent(appIds, CMgrCompletedAppsEvent.Reason.ON_SHUTDOWN));
        LOG.info((Object)"Waiting for Applications to be Finished");
        long waitStartTime = System.currentTimeMillis();
        while (!applications.isEmpty() && System.currentTimeMillis() - waitStartTime < this.waitForContainersOnShutdownMillis) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)"Interrupted while sleeping on applications finish on shutdown", (Throwable)ex);
            }
        }
        if (applications.isEmpty()) {
            LOG.info((Object)"All applications in FINISHED state");
        } else {
            LOG.info((Object)("Done waiting for Applications to be Finished. Still alive: " + applications.keySet()));
        }
    }

    public void cleanupContainersOnNMResync() {
        ConcurrentMap<ContainerId, Container> containers = this.context.getContainers();
        if (containers.isEmpty()) {
            return;
        }
        LOG.info((Object)("Containers still running on " + (Object)((Object)CMgrCompletedContainersEvent.Reason.ON_NODEMANAGER_RESYNC) + " : " + containers.keySet()));
        ArrayList<ContainerId> containerIds = new ArrayList<ContainerId>(containers.keySet());
        LOG.info((Object)"Waiting for containers to be killed");
        this.handle(new CMgrCompletedContainersEvent(containerIds, CMgrCompletedContainersEvent.Reason.ON_NODEMANAGER_RESYNC));
        boolean allContainersCompleted = false;
        block2: while (!containers.isEmpty() && !allContainersCompleted) {
            allContainersCompleted = true;
            for (Map.Entry container : containers.entrySet()) {
                if (((ContainerImpl)container.getValue()).getCurrentState() == org.apache.hadoop.yarn.api.records.ContainerState.COMPLETE) continue;
                allContainersCompleted = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    LOG.warn((Object)"Interrupted while sleeping on container kill on resync", (Throwable)ex);
                }
                continue block2;
            }
        }
        if (allContainersCompleted) {
            LOG.info((Object)"All containers in DONE state");
        } else {
            LOG.info((Object)("Done waiting for containers to be killed. Still alive: " + containers.keySet()));
        }
    }

    protected UserGroupInformation getRemoteUgi() throws YarnException {
        UserGroupInformation remoteUgi;
        try {
            remoteUgi = UserGroupInformation.getCurrentUser();
        }
        catch (IOException e) {
            String msg = "Cannot obtain the user-name. Got exception: " + StringUtils.stringifyException((Throwable)e);
            LOG.warn((Object)msg);
            throw RPCUtil.getRemoteException((String)msg);
        }
        return remoteUgi;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected NMTokenIdentifier selectNMTokenIdentifier(UserGroupInformation remoteUgi) {
        Set tokenIdentifiers = remoteUgi.getTokenIdentifiers();
        NMTokenIdentifier resultId = null;
        for (TokenIdentifier id : tokenIdentifiers) {
            if (!(id instanceof NMTokenIdentifier)) continue;
            resultId = (NMTokenIdentifier)id;
            break;
        }
        return resultId;
    }

    protected void authorizeUser(UserGroupInformation remoteUgi, NMTokenIdentifier nmTokenIdentifier) throws YarnException {
        if (nmTokenIdentifier == null) {
            throw RPCUtil.getRemoteException((String)INVALID_NMTOKEN_MSG);
        }
        if (!remoteUgi.getUserName().equals(nmTokenIdentifier.getApplicationAttemptId().toString())) {
            throw RPCUtil.getRemoteException((String)("Expected applicationAttemptId: " + remoteUgi.getUserName() + "Found: " + nmTokenIdentifier.getApplicationAttemptId()));
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void authorizeStartAndResourceIncreaseRequest(NMTokenIdentifier nmTokenIdentifier, ContainerTokenIdentifier containerTokenIdentifier, boolean startRequest) throws YarnException {
        if (nmTokenIdentifier == null) {
            throw RPCUtil.getRemoteException((String)INVALID_NMTOKEN_MSG);
        }
        if (containerTokenIdentifier == null) {
            throw RPCUtil.getRemoteException((String)INVALID_CONTAINERTOKEN_MSG);
        }
        ContainerId containerId = containerTokenIdentifier.getContainerID();
        String containerIDStr = containerId.toString();
        boolean unauthorized = false;
        StringBuilder messageBuilder = new StringBuilder("Unauthorized request to " + (startRequest ? "start container." : "increase container resource."));
        if (!nmTokenIdentifier.getApplicationAttemptId().getApplicationId().equals((Object)containerId.getApplicationAttemptId().getApplicationId())) {
            unauthorized = true;
            messageBuilder.append("\nNMToken for application attempt : ").append(nmTokenIdentifier.getApplicationAttemptId()).append(" was used for " + (startRequest ? "starting " : "increasing resource of ") + "container with container token").append(" issued for application attempt : ").append(containerId.getApplicationAttemptId());
        } else if (startRequest && !this.context.getContainerTokenSecretManager().isValidStartContainerRequest(containerTokenIdentifier)) {
            unauthorized = true;
            messageBuilder.append("\n Attempt to relaunch the same ").append("container with id ").append(containerIDStr).append(".");
        } else if (containerTokenIdentifier.getExpiryTimeStamp() < System.currentTimeMillis()) {
            unauthorized = true;
            messageBuilder.append("\nThis token is expired. current time is ").append(System.currentTimeMillis()).append(" found ").append(containerTokenIdentifier.getExpiryTimeStamp());
            messageBuilder.append("\nNote: System times on machines may be out of sync.").append(" Check system time and time zones.");
        }
        if (unauthorized) {
            String msg = messageBuilder.toString();
            LOG.error((Object)msg);
            throw RPCUtil.getRemoteException((String)msg);
        }
        if (containerTokenIdentifier.getRMIdentifier() != this.nodeStatusUpdater.getRMIdentifier()) {
            StringBuilder sb = new StringBuilder("\nContainer ");
            sb.append(containerTokenIdentifier.getContainerID().toString()).append(" rejected as it is allocated by a previous RM");
            throw new InvalidContainerException(sb.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StartContainersResponse startContainers(StartContainersRequest requests) throws YarnException, IOException {
        if (this.blockNewContainerRequests.get()) {
            throw new NMNotYetReadyException("Rejecting new containers as NodeManager has not yet connected with ResourceManager");
        }
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        NMTokenIdentifier nmTokenIdentifier = this.selectNMTokenIdentifier(remoteUgi);
        this.authorizeUser(remoteUgi, nmTokenIdentifier);
        this.materializeSecurityMaterial(requests);
        ArrayList<ContainerId> succeededContainers = new ArrayList<ContainerId>();
        HashMap<ContainerId, SerializedException> failedContainers = new HashMap<ContainerId, SerializedException>();
        Context context = this.context;
        synchronized (context) {
            for (StartContainerRequest request : requests.getStartContainerRequests()) {
                ContainerId containerId = null;
                try {
                    if (request.getContainerToken() == null || request.getContainerToken().getIdentifier() == null) {
                        throw new IOException(INVALID_CONTAINERTOKEN_MSG);
                    }
                    ContainerTokenIdentifier containerTokenIdentifier = BuilderUtils.newContainerTokenIdentifier((Token)request.getContainerToken());
                    this.verifyAndGetContainerTokenIdentifier(request.getContainerToken(), containerTokenIdentifier);
                    containerId = containerTokenIdentifier.getContainerID();
                    if (this.amrmProxyEnabled && containerTokenIdentifier.getContainerType().equals((Object)ContainerType.APPLICATION_MASTER)) {
                        this.getAMRMProxyService().processApplicationStartRequest(request);
                    }
                    this.startContainerInternal(nmTokenIdentifier, containerTokenIdentifier, request);
                    succeededContainers.add(containerId);
                }
                catch (YarnException e) {
                    failedContainers.put(containerId, SerializedException.newInstance((Throwable)e));
                }
                catch (SecretManager.InvalidToken ie) {
                    failedContainers.put(containerId, SerializedException.newInstance((Throwable)ie));
                    throw ie;
                }
                catch (IOException e) {
                    throw RPCUtil.getRemoteException((Throwable)e);
                }
            }
            return StartContainersResponse.newInstance(this.getAuxServiceMetaData(), succeededContainers, failedContainers);
        }
    }

    private boolean isHopsTLSEnabled() {
        return ((NodeManager.NMContext)this.context).isHopsTLSEnabled();
    }

    private boolean isJWTEnabled() {
        return ((NodeManager.NMContext)this.context).isJWTEnabled();
    }

    private void materializeSecurityMaterial(StartContainersRequest requests) throws YarnException, IOException {
        if (this.isHopsTLSEnabled() || this.isJWTEnabled()) {
            String user = null;
            String userFolder = null;
            ApplicationId appId = null;
            if (!requests.getStartContainerRequests().isEmpty()) {
                StartContainerRequest request = (StartContainerRequest)requests.getStartContainerRequests().get(0);
                ContainerTokenIdentifier containerTokenIdentifier = BuilderUtils.newContainerTokenIdentifier((Token)request.getContainerToken());
                if (containerTokenIdentifier == null) {
                    throw RPCUtil.getRemoteException((Throwable)new IOException(INVALID_CONTAINERTOKEN_MSG));
                }
                user = containerTokenIdentifier.getApplicationSubmitter();
                userFolder = containerTokenIdentifier.getApplicationSubmitterFolder();
                appId = containerTokenIdentifier.getContainerID().getApplicationAttemptId().getApplicationId();
            }
            if (user == null || userFolder == null) {
                throw new IOException("User requested container or user folder is null");
            }
            if (this.isHopsTLSEnabled()) {
                this.materializeX509(appId, user, userFolder, requests.getKeyStore(), requests.getKeyStorePassword(), requests.getTrustStore(), requests.getTrustStorePassword());
            }
            if (this.isJWTEnabled()) {
                this.materializeJWT(appId, user, userFolder, requests.getJWT());
            }
        }
    }

    private void materializeX509(ApplicationId appId, String user, String userFolder, ByteBuffer keyStore, String keyStorePass, ByteBuffer trustStore, String trustStorePass) throws IOException {
        if (this.context.getApplications().containsKey(appId)) {
            LOG.debug((Object)"Application reference exists, certificates should have already been materialized");
            return;
        }
        if (keyStore == null || trustStore == null || keyStore.capacity() == 0 || trustStore.capacity() == 0) {
            throw new IOException("RPC TLS is enabled but keyStore or trustStore supplied is either null or empty");
        }
        if (keyStorePass != null && !keyStorePass.isEmpty() && trustStorePass != null && !trustStorePass.isEmpty()) {
            try {
                this.context.getCertificateLocalizationService().materializeCertificates(user, appId.toString(), userFolder, keyStore, keyStorePass, trustStore, trustStorePass);
            }
            catch (InterruptedException ex) {
                LOG.error((Object)ex, (Throwable)ex);
                throw new IOException(ex);
            }
        }
    }

    private void materializeJWT(ApplicationId appId, String user, String userFolder, String jwt) throws IOException {
        if (this.context.getApplications().containsKey(appId)) {
            LOG.debug((Object)"Application reference exists, JWT should have already been materialized");
            return;
        }
        if (jwt == null || jwt.isEmpty()) {
            throw new IOException("JWT is enabled but it either null or empty for application " + appId);
        }
        try {
            this.context.getCertificateLocalizationService().materializeJWT(user, appId.toString(), userFolder, jwt);
        }
        catch (InterruptedException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new IOException(ex);
        }
    }

    private YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto buildAppProto(ApplicationId appId, String user, String userFolder, Credentials credentials, Map<ApplicationAccessType, String> appAcls, LogAggregationContext logAggregationContext, ByteBuffer keyStore, String keyStorePass, ByteBuffer trustStore, String trustStorePass, int cryptoVersion, String jwt, long jwtExpiration) {
        YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto.Builder builder = YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto.newBuilder();
        builder.setId(((ApplicationIdPBImpl)appId).getProto());
        builder.setUser(user);
        builder.setUserFolder(userFolder);
        if (keyStore != null) {
            builder.setKeyStore(ProtoUtils.convertToProtoFormat((ByteBuffer)keyStore));
            builder.setKeyStorePassword(keyStorePass);
        }
        if (trustStore != null) {
            builder.setTrustStore(ProtoUtils.convertToProtoFormat((ByteBuffer)trustStore));
            builder.setTrustStorePassword(trustStorePass);
        }
        builder.setCryptoVersion(cryptoVersion);
        if (jwt != null) {
            builder.setJwt(jwt);
        }
        if (jwtExpiration != -1L) {
            builder.setJwtExpiration(jwtExpiration);
        }
        if (logAggregationContext != null) {
            builder.setLogAggregationContext(((LogAggregationContextPBImpl)logAggregationContext).getProto());
        }
        builder.clearCredentials();
        if (credentials != null) {
            DataOutputBuffer dob = new DataOutputBuffer();
            try {
                credentials.writeTokenStorageToStream((DataOutputStream)dob);
                builder.setCredentials(ByteString.copyFrom((byte[])dob.getData()));
            }
            catch (IOException e) {
                LOG.error((Object)"Cannot serialize credentials", (Throwable)e);
            }
        }
        builder.clearAcls();
        if (appAcls != null) {
            for (Map.Entry<ApplicationAccessType, String> acl : appAcls.entrySet()) {
                YarnProtos.ApplicationACLMapProto p = YarnProtos.ApplicationACLMapProto.newBuilder().setAccessType(ProtoUtils.convertToProtoFormat((ApplicationAccessType)acl.getKey())).setAcl(acl.getValue()).build();
                builder.addAcls(p);
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startContainerInternal(NMTokenIdentifier nmTokenIdentifier, ContainerTokenIdentifier containerTokenIdentifier, StartContainerRequest request) throws YarnException, IOException {
        block16: {
            this.authorizeStartAndResourceIncreaseRequest(nmTokenIdentifier, containerTokenIdentifier, true);
            this.updateNMTokenIdentifier(nmTokenIdentifier);
            ContainerId containerId = containerTokenIdentifier.getContainerID();
            String containerIdStr = containerId.toString();
            String user = containerTokenIdentifier.getApplicationSubmitter();
            String userFolder = containerTokenIdentifier.getApplicationSubmitterFolder();
            LOG.info((Object)("Start request for " + containerIdStr + " by user " + user));
            ContainerLaunchContext launchContext = request.getContainerLaunchContext();
            Map<String, ByteBuffer> serviceData = this.getAuxServiceMetaData();
            if (launchContext.getServiceData() != null && !launchContext.getServiceData().isEmpty()) {
                for (Map.Entry meta : launchContext.getServiceData().entrySet()) {
                    if (null != serviceData.get(meta.getKey())) continue;
                    throw new InvalidAuxServiceException("The auxService:" + (String)meta.getKey() + " does not exist");
                }
            }
            this.injectCryptoMaterialAsLocalResources(user, containerId, launchContext);
            int cryptoMaterialVersion = this.isHopsTLSEnabled() ? 0 : -1;
            long jwtExpiration = this.isJWTEnabled() ? 0L : -1L;
            for (Map.Entry rsrc : launchContext.getLocalResources().entrySet()) {
                if (rsrc.getValue() != null && ((LocalResource)rsrc.getValue()).getResource() != null) continue;
                throw new YarnException("Null resource URL for local resource " + (String)rsrc.getKey() + " : " + rsrc.getValue());
            }
            Credentials credentials = YarnServerSecurityUtils.parseCredentials((ContainerLaunchContext)launchContext);
            ContainerImpl container = new ContainerImpl(this.getConfig(), (Dispatcher)this.dispatcher, launchContext, credentials, this.metrics, containerTokenIdentifier, this.context);
            ApplicationId applicationID = containerId.getApplicationAttemptId().getApplicationId();
            if (this.context.getContainers().putIfAbsent(containerId, container) != null) {
                NMAuditLogger.logFailure(user, "Start Container Request", "ContainerManagerImpl", "Container already running on this node!", applicationID, containerId);
                throw RPCUtil.getRemoteException((String)("Container " + containerIdStr + " already is running on this node!!"));
            }
            this.readLock.lock();
            try {
                if (!this.serviceStopped) {
                    ApplicationImpl application = new ApplicationImpl((Dispatcher)this.dispatcher, user, applicationID, credentials, this.context, userFolder, cryptoMaterialVersion, jwtExpiration);
                    if (null == this.context.getApplications().putIfAbsent(applicationID, application)) {
                        LOG.info((Object)("Creating a new application reference for app " + applicationID));
                        LogAggregationContext logAggregationContext = containerTokenIdentifier.getLogAggregationContext();
                        Map appAcls = container.getLaunchContext().getApplicationACLs();
                        ByteBuffer keyStore = null;
                        ByteBuffer trustStore = null;
                        String keyStorePass = null;
                        String trustStorePass = null;
                        String jwt = null;
                        CertificateLocalizationService certLocService = this.context.getCertificateLocalizationService();
                        if (certLocService != null) {
                            if (this.isHopsTLSEnabled()) {
                                try {
                                    X509SecurityMaterial x509Material = certLocService.getX509MaterialLocation(user, applicationID.toString());
                                    keyStore = x509Material.getKeyStoreMem();
                                    trustStore = x509Material.getTrustStoreMem();
                                    keyStorePass = x509Material.getKeyStorePass();
                                    trustStorePass = x509Material.getTrustStorePass();
                                }
                                catch (InterruptedException ex) {
                                    throw new YarnException("Interrupted while waiting to get X.509 material for " + applicationID, (Throwable)ex);
                                }
                            }
                            if (this.isJWTEnabled()) {
                                try {
                                    JWTSecurityMaterial jwtMaterial = certLocService.getJWTMaterialLocation(user, applicationID.toString());
                                    jwt = jwtMaterial.getToken();
                                }
                                catch (InterruptedException ex) {
                                    throw new YarnException("Interrupted while waiting to get JWT material for " + applicationID, (Throwable)ex);
                                }
                            }
                        }
                        this.context.getNMStateStore().storeApplication(applicationID, this.buildAppProto(applicationID, user, userFolder, credentials, appAcls, logAggregationContext, keyStore, keyStorePass, trustStore, trustStorePass, cryptoMaterialVersion, jwt, jwtExpiration));
                        this.dispatcher.getEventHandler().handle((Event)new ApplicationInitEvent(applicationID, appAcls, logAggregationContext));
                    }
                    this.context.getNMStateStore().storeContainer(containerId, containerTokenIdentifier.getVersion(), request);
                    this.dispatcher.getEventHandler().handle((Event)new ApplicationContainerInitEvent(container));
                    this.context.getContainerTokenSecretManager().startContainerSuccessful(containerTokenIdentifier);
                    NMAuditLogger.logSuccess(user, "Start Container Request", "ContainerManageImpl", applicationID, containerId);
                    this.metrics.launchedContainer();
                    this.metrics.allocateContainer(containerTokenIdentifier.getResource());
                    break block16;
                }
                throw new YarnException("Container start failed as the NodeManager is in the process of shutting down");
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    private void addAsLocalResource(Map<File, String> resources, ContainerId containerId, ContainerLaunchContext containerLaunchContext) throws IOException {
        for (Map.Entry<File, String> resource : resources.entrySet()) {
            File localFile = resource.getKey();
            if (!localFile.exists() || !localFile.canRead()) {
                throw new IOException("Crypto material file " + localFile.getAbsolutePath() + " for container " + containerId.toString() + " does not exist or cannot be read");
            }
            URL fileURL = URL.newInstance((String)"file", null, (int)-1, (String)localFile.getAbsolutePath());
            LocalResource localResource = LocalResource.newInstance((URL)fileURL, (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PRIVATE, (long)localFile.length(), (long)localFile.lastModified());
            containerLaunchContext.getLocalResources().put(resource.getValue(), localResource);
        }
    }

    private void injectCryptoMaterialAsLocalResources(String applicationUser, ContainerId containerId, ContainerLaunchContext containerLaunchContext) throws YarnException, IOException {
        try {
            String applicationId = containerId.getApplicationAttemptId().getApplicationId().toString();
            HashMap<File, String> resources = null;
            if (this.isHopsTLSEnabled()) {
                resources = new HashMap<File, String>();
                X509SecurityMaterial cryptoMaterial = this.context.getCertificateLocalizationService().getX509MaterialLocation(applicationUser, applicationId);
                Path keyStoreLocation = cryptoMaterial.getKeyStoreLocation();
                Path trustStoreLocation = cryptoMaterial.getTrustStoreLocation();
                Path passwdLocation = cryptoMaterial.getPasswdLocation();
                if (keyStoreLocation == null || trustStoreLocation == null || passwdLocation == null) {
                    throw new YarnException("One of the crypto materials for container " + containerId.toString() + " has not been localized correctly and is null");
                }
                resources.put(keyStoreLocation.toFile(), "k_certificate");
                resources.put(trustStoreLocation.toFile(), "t_certificate");
                resources.put(passwdLocation.toFile(), "material_passwd");
            }
            if (this.isJWTEnabled()) {
                JWTSecurityMaterial material = this.context.getCertificateLocalizationService().getJWTMaterialLocation(applicationUser, applicationId);
                if (resources == null) {
                    resources = new HashMap(1);
                }
                resources.put(material.getTokenLocation().toFile(), "token.jwt");
            }
            if (resources != null) {
                this.addAsLocalResource(resources, containerId, containerLaunchContext);
            }
        }
        catch (InterruptedException ex) {
            throw new YarnException((Throwable)ex);
        }
    }

    protected ContainerTokenIdentifier verifyAndGetContainerTokenIdentifier(Token token, ContainerTokenIdentifier containerTokenIdentifier) throws YarnException, SecretManager.InvalidToken {
        byte[] password = this.context.getContainerTokenSecretManager().retrievePassword(containerTokenIdentifier);
        byte[] tokenPass = token.getPassword().array();
        if (password == null || tokenPass == null || !Arrays.equals(password, tokenPass)) {
            throw new SecretManager.InvalidToken("Invalid container token used for starting container on : " + this.context.getNodeId().toString());
        }
        return containerTokenIdentifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncreaseContainersResourceResponse increaseContainersResource(IncreaseContainersResourceRequest requests) throws YarnException, IOException {
        if (this.blockNewContainerRequests.get()) {
            throw new NMNotYetReadyException("Rejecting container resource increase as NodeManager has not yet connected with ResourceManager");
        }
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        NMTokenIdentifier nmTokenIdentifier = this.selectNMTokenIdentifier(remoteUgi);
        this.authorizeUser(remoteUgi, nmTokenIdentifier);
        ArrayList<ContainerId> successfullyIncreasedContainers = new ArrayList<ContainerId>();
        HashMap<ContainerId, SerializedException> failedContainers = new HashMap<ContainerId, SerializedException>();
        Context context = this.context;
        synchronized (context) {
            for (Token token : requests.getContainersToIncrease()) {
                ContainerId containerId = null;
                try {
                    if (token.getIdentifier() == null) {
                        throw new IOException(INVALID_CONTAINERTOKEN_MSG);
                    }
                    ContainerTokenIdentifier containerTokenIdentifier = BuilderUtils.newContainerTokenIdentifier((Token)token);
                    this.verifyAndGetContainerTokenIdentifier(token, containerTokenIdentifier);
                    this.authorizeStartAndResourceIncreaseRequest(nmTokenIdentifier, containerTokenIdentifier, false);
                    containerId = containerTokenIdentifier.getContainerID();
                    this.updateNMTokenIdentifier(nmTokenIdentifier);
                    Resource resource = containerTokenIdentifier.getResource();
                    this.changeContainerResourceInternal(containerId, containerTokenIdentifier.getVersion(), resource, true);
                    successfullyIncreasedContainers.add(containerId);
                }
                catch (SecretManager.InvalidToken | YarnException e) {
                    failedContainers.put(containerId, SerializedException.newInstance((Throwable)e));
                }
                catch (IOException e) {
                    throw RPCUtil.getRemoteException((Throwable)e);
                }
            }
        }
        return IncreaseContainersResourceResponse.newInstance(successfullyIncreasedContainers, failedContainers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeContainerResourceInternal(ContainerId containerId, int containerVersion, Resource targetResource, boolean increase) throws YarnException, IOException {
        block12: {
            Container container = (Container)this.context.getContainers().get(containerId);
            if (container == null) {
                if (this.nodeStatusUpdater.isContainerRecentlyStopped(containerId)) {
                    throw RPCUtil.getRemoteException((String)("Container " + containerId.toString() + " was recently stopped on node manager."));
                }
                throw RPCUtil.getRemoteException((String)("Container " + containerId.toString() + " is not handled by this NodeManager"));
            }
            ContainerState currentState = container.getContainerState();
            if (currentState != ContainerState.RUNNING) {
                throw RPCUtil.getRemoteException((String)("Container " + containerId.toString() + " is in " + currentState.name() + " state. Resource can only be changed when a container is in RUNNING state"));
            }
            Resource currentResource = container.getResource();
            if (currentResource.equals((Object)targetResource)) {
                LOG.warn((Object)("Unable to change resource for container " + containerId.toString() + ". The target resource " + targetResource.toString() + " is the same as the current resource"));
                return;
            }
            if (increase && !Resources.fitsIn((Resource)currentResource, (Resource)targetResource)) {
                throw RPCUtil.getRemoteException((String)("Unable to increase resource for container " + containerId.toString() + ". The target resource " + targetResource.toString() + " is smaller than the current resource " + currentResource.toString()));
            }
            if (!(increase || Resources.fitsIn((Resource)Resources.none(), (Resource)targetResource) && Resources.fitsIn((Resource)targetResource, (Resource)currentResource))) {
                throw RPCUtil.getRemoteException((String)("Unable to decrease resource for container " + containerId.toString() + ". The target resource " + targetResource.toString() + " is not smaller than the current resource " + currentResource.toString()));
            }
            if (increase) {
                org.apache.hadoop.yarn.api.records.Container increasedContainer = org.apache.hadoop.yarn.api.records.Container.newInstance((ContainerId)containerId, null, null, (Resource)targetResource, null, null);
                if (this.context.getIncreasedContainers().putIfAbsent(containerId, increasedContainer) != null) {
                    throw RPCUtil.getRemoteException((String)("Container " + containerId.toString() + " resource is being increased."));
                }
            }
            this.readLock.lock();
            try {
                if (!this.serviceStopped) {
                    this.context.getNMStateStore().storeContainerResourceChanged(containerId, containerVersion, targetResource);
                    this.getContainersMonitor().handle((Event)new ChangeMonitoringContainerResourceEvent(containerId, targetResource));
                    break block12;
                }
                throw new YarnException("Unable to change container resource as the NodeManager is in the process of shutting down");
            }
            finally {
                this.readLock.unlock();
            }
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void updateNMTokenIdentifier(NMTokenIdentifier nmTokenIdentifier) throws SecretManager.InvalidToken {
        this.context.getNMTokenSecretManager().appAttemptStartContainer(nmTokenIdentifier);
    }

    public StopContainersResponse stopContainers(StopContainersRequest requests) throws YarnException, IOException {
        ArrayList<ContainerId> succeededRequests = new ArrayList<ContainerId>();
        HashMap<ContainerId, SerializedException> failedRequests = new HashMap<ContainerId, SerializedException>();
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        NMTokenIdentifier identifier = this.selectNMTokenIdentifier(remoteUgi);
        if (identifier == null) {
            throw RPCUtil.getRemoteException((String)INVALID_NMTOKEN_MSG);
        }
        for (ContainerId id : requests.getContainerIds()) {
            try {
                this.stopContainerInternal(identifier, id);
                succeededRequests.add(id);
            }
            catch (YarnException e) {
                failedRequests.put(id, SerializedException.newInstance((Throwable)e));
            }
        }
        return StopContainersResponse.newInstance(succeededRequests, failedRequests);
    }

    private void stopContainerInternal(NMTokenIdentifier nmTokenIdentifier, ContainerId containerID) throws YarnException, IOException {
        String containerIDStr = containerID.toString();
        Container container = (Container)this.context.getContainers().get(containerID);
        LOG.info((Object)("Stopping container with container Id: " + containerIDStr));
        this.authorizeGetAndStopContainerRequest(containerID, container, true, nmTokenIdentifier);
        if (container == null) {
            if (!this.nodeStatusUpdater.isContainerRecentlyStopped(containerID)) {
                throw RPCUtil.getRemoteException((String)("Container " + containerIDStr + " is not handled by this NodeManager"));
            }
        } else {
            if (container.isRecovering()) {
                throw new NMNotYetReadyException("Container " + containerIDStr + " is recovering, try later");
            }
            this.context.getNMStateStore().storeContainerKilled(containerID);
            this.dispatcher.getEventHandler().handle((Event)new ContainerKillEvent(containerID, -105, "Container killed by the ApplicationMaster."));
            NMAuditLogger.logSuccess(container.getUser(), "Stop Container Request", "ContainerManageImpl", containerID.getApplicationAttemptId().getApplicationId(), containerID);
        }
    }

    public GetContainerStatusesResponse getContainerStatuses(GetContainerStatusesRequest request) throws YarnException, IOException {
        ArrayList<ContainerStatus> succeededRequests = new ArrayList<ContainerStatus>();
        HashMap<ContainerId, SerializedException> failedRequests = new HashMap<ContainerId, SerializedException>();
        UserGroupInformation remoteUgi = this.getRemoteUgi();
        NMTokenIdentifier identifier = this.selectNMTokenIdentifier(remoteUgi);
        if (identifier == null) {
            throw RPCUtil.getRemoteException((String)INVALID_NMTOKEN_MSG);
        }
        for (ContainerId id : request.getContainerIds()) {
            try {
                ContainerStatus status = this.getContainerStatusInternal(id, identifier);
                succeededRequests.add(status);
            }
            catch (YarnException e) {
                failedRequests.put(id, SerializedException.newInstance((Throwable)e));
            }
        }
        return GetContainerStatusesResponse.newInstance(succeededRequests, failedRequests);
    }

    private ContainerStatus getContainerStatusInternal(ContainerId containerID, NMTokenIdentifier nmTokenIdentifier) throws YarnException {
        String containerIDStr = containerID.toString();
        Container container = (Container)this.context.getContainers().get(containerID);
        LOG.info((Object)("Getting container-status for " + containerIDStr));
        this.authorizeGetAndStopContainerRequest(containerID, container, false, nmTokenIdentifier);
        if (container == null) {
            if (this.nodeStatusUpdater.isContainerRecentlyStopped(containerID)) {
                throw RPCUtil.getRemoteException((String)("Container " + containerIDStr + " was recently stopped on node manager."));
            }
            throw RPCUtil.getRemoteException((String)("Container " + containerIDStr + " is not handled by this NodeManager"));
        }
        ContainerStatus containerStatus = container.cloneAndGetContainerStatus();
        LOG.info((Object)("Returning " + containerStatus));
        return containerStatus;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void authorizeGetAndStopContainerRequest(ContainerId containerId, Container container, boolean stopRequest, NMTokenIdentifier identifier) throws YarnException {
        if (identifier == null) {
            throw RPCUtil.getRemoteException((String)INVALID_NMTOKEN_MSG);
        }
        ApplicationId nmTokenAppId = identifier.getApplicationAttemptId().getApplicationId();
        if (!nmTokenAppId.equals((Object)containerId.getApplicationAttemptId().getApplicationId()) || container != null && !nmTokenAppId.equals((Object)container.getContainerId().getApplicationAttemptId().getApplicationId())) {
            String msg;
            if (stopRequest) {
                msg = identifier.getApplicationAttemptId() + " attempted to stop non-application container : " + containerId;
                NMAuditLogger.logFailure("UnknownUser", "Stop Container Request", "ContainerManagerImpl", "Trying to stop unknown container!", nmTokenAppId, containerId);
            } else {
                msg = identifier.getApplicationAttemptId() + " attempted to get status for non-application container : " + containerId;
            }
            LOG.warn((Object)msg);
            throw RPCUtil.getRemoteException((String)msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future removeX509UpdaterTask(ContainerId cid) {
        Future task = null;
        Map<ContainerId, Future> map = this.x509Updaters;
        synchronized (map) {
            task = this.x509Updaters.remove(cid);
        }
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Future removeJWTUpdaterTask(ContainerId cid) {
        Future task = null;
        Map<ContainerId, Future> map = this.jwtUpdaters;
        synchronized (map) {
            task = this.jwtUpdaters.remove(cid);
        }
        return task;
    }

    private void scheduleSecurityUpdaterForContainer(ContainerManagerEvent event) {
        if (event instanceof CMgrUpdateX509Event) {
            this.scheduleX509Updater((CMgrUpdateX509Event)event);
        } else if (event instanceof CMgrUpdateJWTEvent) {
            this.scheduleJWTUpdater((CMgrUpdateJWTEvent)event);
        }
    }

    private void scheduleX509Updater(CMgrUpdateX509Event event) {
        ContainerImpl container;
        LOG.debug((Object)("Scheduling X.509 updater for container " + event.getContainerId()));
        Future previousTask = this.removeX509UpdaterTask(event.getContainerId());
        if (previousTask != null) {
            previousTask.cancel(true);
        }
        if ((container = (ContainerImpl)this.context.getContainers().get(event.getContainerId())) != null) {
            ContainerX509UpdaterTask updaterTask = new ContainerX509UpdaterTask(container, event.getKeyStore(), event.getKeyStorePassword(), event.getTrustStore(), event.getTrustStorePassword(), event.getVersion());
            this.scheduleX509UpdaterTaskInternal(updaterTask, container.getContainerId());
        }
    }

    private void scheduleJWTUpdater(CMgrUpdateJWTEvent event) {
        ContainerImpl container;
        LOG.debug((Object)("Scheduling JWT updater for container " + event.getContainerId()));
        Future previousTask = this.removeJWTUpdaterTask(event.getContainerId());
        if (previousTask != null) {
            previousTask.cancel(true);
        }
        if ((container = (ContainerImpl)this.context.getContainers().get(event.getContainerId())) != null) {
            ContainerJWTUpdaterTask updaterTask = new ContainerJWTUpdaterTask(container, event.getJwt(), event.getJwtExpiration());
            this.scheduleJWTUpdaterTaskInternal(updaterTask, container.getContainerId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleX509UpdaterTaskInternal(ContainerX509UpdaterTask updater, ContainerId cid) {
        Map<ContainerId, Future> map = this.x509Updaters;
        synchronized (map) {
            Future<?> task = this.cryptoMaterialUpdaterThreadPool.submit(updater);
            this.x509Updaters.put(cid, task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleJWTUpdaterTaskInternal(ContainerJWTUpdaterTask updater, ContainerId cid) {
        Map<ContainerId, Future> map = this.jwtUpdaters;
        synchronized (map) {
            Future<?> task = this.cryptoMaterialUpdaterThreadPool.submit(updater);
            this.jwtUpdaters.put(cid, task);
        }
    }

    public void handle(ContainerManagerEvent event) {
        switch ((ContainerManagerEventType)event.getType()) {
            case FINISH_APPS: {
                CMgrCompletedAppsEvent appsFinishedEvent = (CMgrCompletedAppsEvent)event;
                for (ApplicationId appID : appsFinishedEvent.getAppsToCleanup()) {
                    Application app = (Application)this.context.getApplications().get(appID);
                    if (app == null) {
                        LOG.warn((Object)("couldn't find application " + appID + " while processing FINISH_APPS event"));
                        continue;
                    }
                    boolean shouldDropEvent = false;
                    for (Container container : app.getContainers().values()) {
                        if (!container.isRecovering()) continue;
                        LOG.info((Object)("drop FINISH_APPS event to " + appID + " because container " + container.getContainerId() + " is recovering"));
                        shouldDropEvent = true;
                        break;
                    }
                    if (shouldDropEvent) continue;
                    String diagnostic = "";
                    if (appsFinishedEvent.getReason() == CMgrCompletedAppsEvent.Reason.ON_SHUTDOWN) {
                        diagnostic = "Application killed on shutdown";
                    } else if (appsFinishedEvent.getReason() == CMgrCompletedAppsEvent.Reason.BY_RESOURCEMANAGER) {
                        diagnostic = "Application killed by ResourceManager";
                    }
                    this.dispatcher.getEventHandler().handle((Event)new ApplicationFinishEvent(appID, diagnostic));
                }
                break;
            }
            case FINISH_CONTAINERS: {
                CMgrCompletedContainersEvent containersFinishedEvent = (CMgrCompletedContainersEvent)event;
                for (ContainerId containerId : containersFinishedEvent.getContainersToCleanup()) {
                    ApplicationId appId = containerId.getApplicationAttemptId().getApplicationId();
                    Application app = (Application)this.context.getApplications().get(appId);
                    if (app == null) {
                        LOG.warn((Object)("couldn't find app " + appId + " while processing FINISH_CONTAINERS event"));
                        continue;
                    }
                    Container container = app.getContainers().get(containerId);
                    if (container == null) {
                        LOG.warn((Object)("couldn't find container " + containerId + " while processing FINISH_CONTAINERS event"));
                        continue;
                    }
                    if (container.isRecovering()) {
                        LOG.info((Object)("drop FINISH_CONTAINERS event to " + containerId + " because container is recovering"));
                        continue;
                    }
                    this.dispatcher.getEventHandler().handle((Event)new ContainerKillEvent(containerId, -106, "Container Killed by ResourceManager"));
                }
                break;
            }
            case DECREASE_CONTAINERS_RESOURCE: {
                CMgrDecreaseContainersResourceEvent containersDecreasedEvent = (CMgrDecreaseContainersResourceEvent)event;
                for (org.apache.hadoop.yarn.api.records.Container container : containersDecreasedEvent.getContainersToDecrease()) {
                    try {
                        this.changeContainerResourceInternal(container.getId(), container.getVersion(), container.getResource(), false);
                    }
                    catch (YarnException e) {
                        LOG.error((Object)"Unable to decrease container resource", (Throwable)e);
                    }
                    catch (IOException e) {
                        LOG.error((Object)"Unable to update container resource in store", (Throwable)e);
                    }
                }
                break;
            }
            case SIGNAL_CONTAINERS: {
                CMgrSignalContainersEvent containersSignalEvent = (CMgrSignalContainersEvent)event;
                for (SignalContainerRequest request : containersSignalEvent.getContainersToSignal()) {
                    this.internalSignalToContainer(request, "ResourceManager");
                }
                break;
            }
            case UPDATE_CRYPTO_MATERIAL: {
                this.scheduleSecurityUpdaterForContainer(event);
                break;
            }
            default: {
                throw new YarnRuntimeException("Got an unknown ContainerManagerEvent type: " + event.getType());
            }
        }
    }

    public void setBlockNewContainerRequests(boolean blockNewContainerRequests) {
        this.blockNewContainerRequests.set(blockNewContainerRequests);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public boolean getBlockNewContainerRequestsStatus() {
        return this.blockNewContainerRequests.get();
    }

    public void stateChanged(Service service) {
    }

    public Context getContext() {
        return this.context;
    }

    @VisibleForTesting
    public Map<ContainerId, Future> getX509Updaters() {
        return this.x509Updaters;
    }

    @VisibleForTesting
    public Map<ContainerId, Future> getJWTUpdaters() {
        return this.jwtUpdaters;
    }

    public Map<String, ByteBuffer> getAuxServiceMetaData() {
        return this.auxiliaryServices.getMetaData();
    }

    @InterfaceAudience.Private
    public AMRMProxyService getAMRMProxyService() {
        return this.amrmProxyService;
    }

    @InterfaceAudience.Private
    protected void setAMRMProxyService(AMRMProxyService amrmProxyService) {
        this.amrmProxyService = amrmProxyService;
    }

    public SignalContainerResponse signalToContainer(SignalContainerRequest request) throws YarnException, IOException {
        this.internalSignalToContainer(request, "Application Master");
        return new SignalContainerResponsePBImpl();
    }

    private void internalSignalToContainer(SignalContainerRequest request, String sentBy) {
        ContainerId containerId = request.getContainerId();
        Container container = (Container)this.context.getContainers().get(containerId);
        if (container != null) {
            LOG.info((Object)(containerId + " signal request " + request.getCommand() + " by " + sentBy));
            this.dispatcher.getEventHandler().handle((Event)new SignalContainersLauncherEvent(container, request.getCommand()));
        } else {
            LOG.info((Object)("Container " + containerId + " no longer exists"));
        }
    }

    class ApplicationEventDispatcher
    implements EventHandler<ApplicationEvent> {
        ApplicationEventDispatcher() {
        }

        public void handle(ApplicationEvent event) {
            Application app = (Application)ContainerManagerImpl.this.context.getApplications().get(event.getApplicationID());
            if (app != null) {
                app.handle((Event)event);
            } else {
                LOG.warn((Object)("Event " + (Object)((Object)event) + " sent to absent application " + event.getApplicationID()));
            }
        }
    }

    class ContainerEventDispatcher
    implements EventHandler<ContainerEvent> {
        ContainerEventDispatcher() {
        }

        public void handle(ContainerEvent event) {
            ConcurrentMap<ContainerId, Container> containers = ContainerManagerImpl.this.context.getContainers();
            Container c = (Container)containers.get(event.getContainerID());
            if (c != null) {
                c.handle((Event)event);
            } else {
                LOG.warn((Object)("Event " + (Object)((Object)event) + " sent to absent container " + event.getContainerID()));
            }
        }
    }

    private class ContainerX509UpdaterTask
    extends ContainerSecurityUpdaterTask {
        private final ByteBuffer keyStore;
        private final char[] keyStorePassword;
        private final ByteBuffer trustStore;
        private final char[] trustStorePassword;
        private final int cryptoVersion;

        private ContainerX509UpdaterTask(ContainerImpl container, ByteBuffer keyStore, char[] keyStorePassword, ByteBuffer trustStore, char[] trustStorePassword, int cryptoVersion) {
            super(container);
            this.keyStore = keyStore;
            this.keyStorePassword = keyStorePassword;
            this.trustStore = trustStore;
            this.trustStorePassword = trustStorePassword;
            this.cryptoVersion = cryptoVersion;
        }

        @Override
        protected void removeSecurityUpdaterTask() {
            ContainerManagerImpl.this.removeX509UpdaterTask(this.container.getContainerId());
        }

        @Override
        protected void scheduleSecurityUpdaterTask() {
            ContainerManagerImpl.this.scheduleX509UpdaterTaskInternal(this, this.container.getContainerId());
        }

        @Override
        protected void execute() throws IOException {
            this.container.identifyCryptoMaterialLocation();
            File keyStorePath = this.container.getKeyStoreLocalizedPath();
            File trustStorePath = this.container.getTrustStoreLocalizedPath();
            File passwordFilePath = this.container.getPasswordFileLocalizedPath();
            if (keyStorePath == null || trustStorePath == null || passwordFilePath == null) {
                throw new IOException("Could not identify localized X.509 cryptographic material location for container " + this.container.getContainerId());
            }
            this.writeByteBufferToFile(keyStorePath, this.keyStore);
            this.writeByteBufferToFile(trustStorePath, this.trustStore);
            this.writeStringToFile(passwordFilePath, String.valueOf(this.keyStorePassword));
        }

        @Override
        protected void updateStateStore() throws IOException {
            ApplicationId applicationId = this.container.getContainerId().getApplicationAttemptId().getApplicationId();
            Application app = (Application)ContainerManagerImpl.this.context.getApplications().get(applicationId);
            app.setX509Version(this.cryptoVersion);
            try {
                YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto appProto;
                if (ContainerManagerImpl.this.isJWTEnabled()) {
                    JWTSecurityMaterial jwtSecurityMaterial = ContainerManagerImpl.this.context.getCertificateLocalizationService().getJWTMaterialLocation(this.container.getUser(), applicationId.toString());
                    appProto = ContainerManagerImpl.this.buildAppProto(applicationId, this.container.getUser(), this.container.getUserFolder(), this.container.getCredentials(), this.container.getLaunchContext().getApplicationACLs(), this.container.getContainerTokenIdentifier().getLogAggregationContext(), this.keyStore, String.valueOf(this.keyStorePassword), this.trustStore, String.valueOf(this.trustStorePassword), this.cryptoVersion, jwtSecurityMaterial.getToken(), app.getJWTExpiration());
                } else {
                    appProto = ContainerManagerImpl.this.buildAppProto(applicationId, this.container.getUser(), this.container.getUserFolder(), this.container.getCredentials(), this.container.getLaunchContext().getApplicationACLs(), this.container.getContainerTokenIdentifier().getLogAggregationContext(), this.keyStore, String.valueOf(this.keyStorePassword), this.trustStore, String.valueOf(this.trustStorePassword), this.cryptoVersion, null, -1L);
                }
                ContainerManagerImpl.this.context.getNMStateStore().storeApplication(applicationId, appProto);
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }
    }

    private class ContainerJWTUpdaterTask
    extends ContainerSecurityUpdaterTask {
        private final String jwt;
        private final long jwtExpiration;

        private ContainerJWTUpdaterTask(ContainerImpl container, String jwt, long jwtExpiration) {
            super(container);
            this.jwt = jwt;
            this.jwtExpiration = jwtExpiration;
        }

        @Override
        protected void removeSecurityUpdaterTask() {
            ContainerManagerImpl.this.removeJWTUpdaterTask(this.container.getContainerId());
        }

        @Override
        protected void scheduleSecurityUpdaterTask() {
            ContainerManagerImpl.this.scheduleJWTUpdaterTaskInternal(this, this.container.getContainerId());
        }

        @Override
        protected void execute() throws IOException {
            this.container.identifyCryptoMaterialLocation();
            File jwtFile = this.container.getJWTLocalizedPath();
            if (jwtFile == null) {
                throw new IOException("Could not identify localized JWT file for container " + this.container.getContainerId());
            }
            this.writeStringToFile(jwtFile, this.jwt);
        }

        @Override
        protected void updateStateStore() throws IOException {
            ApplicationId applicationId = this.container.getContainerId().getApplicationAttemptId().getApplicationId();
            Application app = (Application)ContainerManagerImpl.this.context.getApplications().get(applicationId);
            app.setJWTExpiration(this.jwtExpiration);
            try {
                YarnServerNodemanagerRecoveryProtos.ContainerManagerApplicationProto appProto;
                if (ContainerManagerImpl.this.isHopsTLSEnabled()) {
                    X509SecurityMaterial x509SecurityMaterial = ContainerManagerImpl.this.context.getCertificateLocalizationService().getX509MaterialLocation(this.container.getUser(), applicationId.toString());
                    appProto = ContainerManagerImpl.this.buildAppProto(applicationId, this.container.getUser(), this.container.getUserFolder(), this.container.getCredentials(), this.container.getLaunchContext().getApplicationACLs(), this.container.getContainerTokenIdentifier().getLogAggregationContext(), x509SecurityMaterial.getKeyStoreMem(), String.valueOf(x509SecurityMaterial.getKeyStorePass()), x509SecurityMaterial.getTrustStoreMem(), String.valueOf(x509SecurityMaterial.getTrustStorePass()), app.getX509Version(), this.jwt, this.jwtExpiration);
                } else {
                    appProto = ContainerManagerImpl.this.buildAppProto(applicationId, this.container.getUser(), this.container.getUserFolder(), this.container.getCredentials(), this.container.getLaunchContext().getApplicationACLs(), this.container.getContainerTokenIdentifier().getLogAggregationContext(), null, null, null, null, -1, this.jwt, this.jwtExpiration);
                }
                ContainerManagerImpl.this.context.getNMStateStore().storeApplication(applicationId, appProto);
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }
    }
}

