/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.BackOff;
import org.apache.hadoop.util.ExponentialBackOff;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;

abstract class ContainerSecurityUpdaterTask
implements Runnable {
    private static final Log LOG = LogFactory.getLog(ContainerSecurityUpdaterTask.class);
    protected final ContainerImpl container;
    private final BackOff backOff;
    private long backOffTime;

    ContainerSecurityUpdaterTask(ContainerImpl container) {
        this.container = container;
        this.backOff = this.createBackOffPolicy();
        this.backOffTime = 0L;
    }

    protected abstract void removeSecurityUpdaterTask();

    protected abstract void scheduleSecurityUpdaterTask();

    protected abstract void updateStateStore() throws IOException;

    protected abstract void execute() throws IOException;

    @Override
    public void run() {
        try {
            TimeUnit.MILLISECONDS.sleep(this.backOffTime);
            if (!this.isContainerStillRunning()) {
                this.removeSecurityUpdaterTask();
                return;
            }
            this.execute();
            this.updateStateStore();
            this.removeSecurityUpdaterTask();
            this.backOff.reset();
            this.backOffTime = 0L;
            LOG.debug((Object)("Updated security material for container: " + this.container.getContainerId()));
        }
        catch (IOException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            this.removeSecurityUpdaterTask();
            this.backOffTime = this.backOff.getBackOffInMillis();
            if (this.backOffTime != -1L) {
                LOG.warn((Object)("Re-scheduling updating security material for container " + this.container.getContainerId() + " after " + this.backOffTime + "ms"));
                this.scheduleSecurityUpdaterTask();
            } else {
                LOG.error((Object)("Reached maximum number of retries for container " + this.container.getContainerId() + ", giving up"), (Throwable)ex);
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    protected void writeByteBufferToFile(File target, ByteBuffer data) throws IOException {
        Set<PosixFilePermission> permissions = null;
        Path targetPath = target.toPath();
        if (!target.canWrite()) {
            permissions = this.addOwnerWritePermission(targetPath);
        }
        FileChannel fileChannel = new FileOutputStream(target, false).getChannel();
        fileChannel.write(data);
        fileChannel.close();
        if (permissions != null) {
            this.removeOwnerWritePermission(targetPath, permissions);
        }
    }

    protected void writeStringToFile(File target, String data) throws IOException {
        Set<PosixFilePermission> permissions = null;
        Path targetPath = target.toPath();
        if (!target.canWrite()) {
            permissions = this.addOwnerWritePermission(targetPath);
        }
        FileUtils.writeStringToFile((File)target, (String)data);
        if (permissions != null) {
            this.removeOwnerWritePermission(targetPath, permissions);
        }
    }

    protected Set<PosixFilePermission> addOwnerWritePermission(Path target) throws IOException {
        Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(target, new LinkOption[0]);
        if (permissions.add(PosixFilePermission.OWNER_WRITE)) {
            Files.setPosixFilePermissions(target, permissions);
        }
        return permissions;
    }

    protected void removeOwnerWritePermission(Path target, Set<PosixFilePermission> permissions) throws IOException {
        if (permissions.remove((Object)PosixFilePermission.OWNER_WRITE)) {
            Files.setPosixFilePermissions(target, permissions);
        }
    }

    protected boolean isContainerStillRunning() {
        boolean running = this.container.getContainerState().equals((Object)ContainerState.RUNNING);
        if (!running) {
            LOG.info((Object)("Crypto updater for container " + this.container.getContainerId() + " run but the container is not in RUNNING state, instead state is: " + (Object)((Object)this.container.getContainerState())));
        }
        return running;
    }

    private BackOff createBackOffPolicy() {
        return new ExponentialBackOff.Builder().setInitialIntervalMillis(200L).setMaximumIntervalMillis(5000L).setMultiplier(1.4).setMaximumRetries(6).build();
    }
}

