/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event;

import java.util.Map;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.loghandler.event.LogHandlerEventType;

public class LogHandlerAppStartedEvent
extends LogHandlerEvent {
    private final ApplicationId applicationId;
    private final String user;
    private final String userFolder;
    private final Credentials credentials;
    private final Map<ApplicationAccessType, String> appAcls;
    private final LogAggregationContext logAggregationContext;

    public LogHandlerAppStartedEvent(ApplicationId appId, String user, Credentials credentials, Map<ApplicationAccessType, String> appAcls, String userFolder) {
        this(appId, user, credentials, appAcls, null, userFolder);
    }

    public LogHandlerAppStartedEvent(ApplicationId appId, String user, Credentials credentials, Map<ApplicationAccessType, String> appAcls, LogAggregationContext logAggregationContext, String userFolder) {
        super(LogHandlerEventType.APPLICATION_STARTED);
        this.applicationId = appId;
        this.user = user;
        this.userFolder = userFolder;
        this.credentials = credentials;
        this.appAcls = appAcls;
        this.logAggregationContext = logAggregationContext;
    }

    public ApplicationId getApplicationId() {
        return this.applicationId;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public String getUser() {
        return this.user;
    }

    public String getUserFolder() {
        return this.userFolder;
    }

    public Map<ApplicationAccessType, String> getApplicationAcls() {
        return this.appAcls;
    }

    public LogAggregationContext getLogAggregationContext() {
        return this.logAggregationContext;
    }
}

