/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.BaseCGroupsCpuResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CpuResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;

public class CGroups2CpuResourceHandlerImpl
extends BaseCGroupsCpuResourceHandler
implements CpuResourceHandler {
    static final Integer DEFAULT_CPU_PERIOD = 100000;
    static final int DEFAULT_WEIGHT_OPPORTUNISTIC = 1;
    static final int DEFAULT_WEIGHT = 100;
    static final String UNLIMITED_QUOTA = "max";
    private static final Pattern CPU_MAX_PATTERN = Pattern.compile("^(.*)\\s+(.*)$");

    CGroups2CpuResourceHandlerImpl(CGroupsHandler cGroupsHandler) {
        super(cGroupsHandler);
    }

    @Override
    String getCpuUnlimitedQuota() {
        return UNLIMITED_QUOTA;
    }

    @Override
    boolean doCpuLimitsExist(String path) throws IOException {
        Path cpuMax = Paths.get(path, String.format("%s.%s", CPU.getName(), CGroupsHandler.CpuParameters.MAX.getName()));
        if (cpuMax.toFile().exists()) {
            String[] values = this.parseCpuMax(cpuMax);
            return !values[0].equals(UNLIMITED_QUOTA);
        }
        return false;
    }

    @Override
    void updateCpuBandwidthParams(String groupId, String cpuQuotaUs, String cpuPeriodUs) throws ResourceHandlerException {
        String effectivePeriod = cpuPeriodUs.isEmpty() ? String.valueOf(DEFAULT_CPU_PERIOD) : cpuPeriodUs;
        String param = String.format("%s %s", cpuQuotaUs, effectivePeriod);
        this.cGroupsHandler.updateCGroupParam(CPU, groupId, CGroupsHandler.CpuParameters.MAX.getName(), param);
    }

    @Override
    void updateCpuWeightParam(String cgroupId, int weight) throws ResourceHandlerException {
        this.cGroupsHandler.updateCGroupParam(CPU, cgroupId, CGroupsHandler.CpuParameters.WEIGHT.getName(), String.valueOf(weight));
    }

    @Override
    int getDefaultOpportunisticWeight() {
        return 1;
    }

    @Override
    int getDefaultWeight() {
        return 100;
    }

    private String[] parseCpuMax(Path path) throws IOException {
        String content = FileUtils.readFileToString((File)path.toFile(), (Charset)StandardCharsets.UTF_8).trim();
        Matcher matcher = CPU_MAX_PATTERN.matcher(content);
        if (matcher.find()) {
            return new String[]{matcher.group(1), matcher.group(2)};
        }
        throw new IOException("Failed to parse " + path);
    }
}

