/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.security.ContainerTokenIdentifier;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.privileged.PrivilegedOperation;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CpuResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.server.nodemanager.util.NodeManagerHardwareUtils;
import org.apache.hadoop.yarn.util.ResourceCalculatorPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCGroupsCpuResourceHandler
implements CpuResourceHandler {
    final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private static final Logger staticLogger = LoggerFactory.getLogger(BaseCGroupsCpuResourceHandler.class);
    @VisibleForTesting
    static final int MAX_QUOTA_US = 1000000;
    @VisibleForTesting
    static final int MIN_PERIOD_US = 1000;
    static final CGroupsHandler.CGroupController CPU = CGroupsHandler.CGroupController.CPU;
    private static final String TOP_CGROUP = "";
    final CGroupsHandler cGroupsHandler;
    private boolean strictResourceUsageMode = false;
    private float yarnProcessors;
    private float nodeVCores;

    public BaseCGroupsCpuResourceHandler(CGroupsHandler cGroupsHandler) {
        this.cGroupsHandler = cGroupsHandler;
    }

    @Override
    public List<PrivilegedOperation> bootstrap(Configuration conf) throws ResourceHandlerException {
        return this.bootstrap(ResourceCalculatorPlugin.getResourceCalculatorPlugin(null, (Configuration)conf), conf);
    }

    @Override
    public List<PrivilegedOperation> preStart(Container container) throws ResourceHandlerException {
        String cgroupId = container.getContainerId().toString();
        this.cGroupsHandler.createCGroup(CPU, cgroupId);
        this.updateContainer(container);
        ArrayList<PrivilegedOperation> ret = new ArrayList<PrivilegedOperation>();
        ret.add(new PrivilegedOperation(PrivilegedOperation.OperationType.ADD_PID_TO_CGROUP, "cgroups=" + this.cGroupsHandler.getPathForCGroupTasks(CPU, cgroupId)));
        return ret;
    }

    @Override
    public List<PrivilegedOperation> reacquireContainer(ContainerId containerId) throws ResourceHandlerException {
        return null;
    }

    @VisibleForTesting
    List<PrivilegedOperation> bootstrap(ResourceCalculatorPlugin plugin, Configuration conf) throws ResourceHandlerException {
        boolean existingCpuLimits;
        this.strictResourceUsageMode = conf.getBoolean("yarn.nodemanager.linux-container-executor.cgroups.strict-resource-usage", false);
        this.cGroupsHandler.initializeCGroupController(CPU);
        this.nodeVCores = NodeManagerHardwareUtils.getVCores(plugin, conf);
        this.yarnProcessors = NodeManagerHardwareUtils.getContainersCPUs(plugin, conf);
        int systemProcessors = NodeManagerHardwareUtils.getNodeCPUs(plugin, conf);
        try {
            existingCpuLimits = this.doCpuLimitsExist(this.cGroupsHandler.getPathForCGroup(CPU, TOP_CGROUP));
        }
        catch (IOException ie) {
            throw new ResourceHandlerException(ie);
        }
        if (systemProcessors != (int)this.yarnProcessors) {
            this.LOG.info("YARN containers restricted to " + this.yarnProcessors + " cores");
            int[] limits = BaseCGroupsCpuResourceHandler.getOverallLimits(this.yarnProcessors);
            this.updateCpuBandwidthParams(TOP_CGROUP, String.valueOf(limits[1]), String.valueOf(limits[0]));
        } else if (existingCpuLimits) {
            this.LOG.info("Removing CPU constraints for YARN containers.");
            this.updateCpuBandwidthParams(TOP_CGROUP, this.getCpuUnlimitedQuota(), TOP_CGROUP);
        }
        return null;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static int[] getOverallLimits(float yarnProcessors) {
        int[] ret = new int[2];
        if (yarnProcessors < 0.01f) {
            throw new IllegalArgumentException("Number of processors can't be <= 0.");
        }
        int quotaUS = 1000000;
        int periodUS = (int)(1000000.0f / yarnProcessors);
        if (yarnProcessors < 1.0f && (quotaUS = (int)((float)(periodUS = 1000000) * yarnProcessors)) < 1000) {
            staticLogger.warn("The quota calculated for the cgroup was too low. The minimum value is 1000, calculated value is " + quotaUS + ". Setting quota to minimum value.");
            quotaUS = 1000;
        }
        if (periodUS < 1000) {
            staticLogger.warn("The period calculated for the cgroup was too low. The minimum value is 1000, calculated value is " + periodUS + ". Using all available CPU.");
            periodUS = 1000000;
            quotaUS = -1;
        }
        ret[0] = periodUS;
        ret[1] = quotaUS;
        return ret;
    }

    @Override
    public List<PrivilegedOperation> updateContainer(Container container) throws ResourceHandlerException {
        Resource containerResource = container.getResource();
        String cgroupId = container.getContainerId().toString();
        File cgroup = new File(this.cGroupsHandler.getPathForCGroup(CPU, cgroupId));
        if (cgroup.exists()) {
            try {
                int containerVCores = containerResource.getVirtualCores();
                ContainerTokenIdentifier id = container.getContainerTokenIdentifier();
                if (id != null && id.getExecutionType() == ExecutionType.OPPORTUNISTIC) {
                    this.updateCpuWeightParam(cgroupId, this.getDefaultOpportunisticWeight());
                } else {
                    int cpuShares = this.getDefaultWeight() * containerVCores;
                    this.updateCpuWeightParam(cgroupId, cpuShares);
                }
                if (this.strictResourceUsageMode && this.nodeVCores != (float)containerVCores) {
                    float containerCPU = (float)containerVCores * this.yarnProcessors / this.nodeVCores;
                    int[] limits = BaseCGroupsCpuResourceHandler.getOverallLimits(containerCPU);
                    this.updateCpuBandwidthParams(cgroupId, String.valueOf(limits[1]), String.valueOf(limits[0]));
                }
            }
            catch (ResourceHandlerException re) {
                this.cGroupsHandler.deleteCGroup(CPU, cgroupId);
                this.LOG.warn("Could not update cgroup for container", (Throwable)((Object)re));
                throw re;
            }
        }
        return null;
    }

    @Override
    public List<PrivilegedOperation> postComplete(ContainerId containerId) throws ResourceHandlerException {
        this.cGroupsHandler.deleteCGroup(CPU, containerId.toString());
        return null;
    }

    @Override
    public List<PrivilegedOperation> teardown() throws ResourceHandlerException {
        return null;
    }

    abstract String getCpuUnlimitedQuota();

    abstract boolean doCpuLimitsExist(String var1) throws IOException;

    abstract void updateCpuBandwidthParams(String var1, String var2, String var3) throws ResourceHandlerException;

    abstract void updateCpuWeightParam(String var1, int var2) throws ResourceHandlerException;

    abstract int getDefaultOpportunisticWeight();

    abstract int getDefaultWeight();
}

