/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.BaseCGroupsMemoryResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.MemoryResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;

public class CGroups2MemoryResourceHandlerImpl
extends BaseCGroupsMemoryResourceHandler
implements MemoryResourceHandler {
    private static final String NO_OOM_KILL = "oom_kill 0";

    CGroups2MemoryResourceHandlerImpl(CGroupsHandler cGroupsHandler) {
        super(cGroupsHandler);
    }

    @Override
    void updateHardLimit(String cgroupId, String limit) throws ResourceHandlerException {
        this.cGroupsHandler.updateCGroupParam(MEMORY, cgroupId, CGroupsHandler.MemoryParameters.MEMORY_MAX.getName(), limit);
    }

    @Override
    void updateSoftLimit(String cgroupId, String limit) throws ResourceHandlerException {
        this.cGroupsHandler.updateCGroupParam(MEMORY, cgroupId, CGroupsHandler.MemoryParameters.MEMORY_HIGH.getName(), limit);
    }

    @Override
    void updateSwappiness(String cgroupId, String value) throws ResourceHandlerException {
    }

    @Override
    String getOOMStatus(String cgroupId) throws ResourceHandlerException {
        return this.cGroupsHandler.getCGroupParam(CGroupsHandler.CGroupController.MEMORY, cgroupId, CGroupsHandler.MemoryParameters.EVENTS_LOCAL.getName());
    }

    @Override
    boolean parseOOMStatus(String status) {
        return !status.contains(NO_OOM_KILL);
    }
}

