/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.BaseCGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;

public class CGroups2HandlerImpl
extends BaseCGroupsHandler
implements CGroupsHandler {
    private static final String CGROUP_PROCS_FILE = "cgroup.procs";

    CGroups2HandlerImpl(Configuration conf) {
        super(conf);
    }

    @Override
    String getProcessesFilename() {
        return CGROUP_PROCS_FILE;
    }

    @Override
    public String getPathForCGroup(CGroupsHandler.CGroupController controller, String cGroupId) {
        return Paths.get(this.cGroupMountPath, this.cGroupPrefix, cGroupId).toString();
    }

    @Override
    public void initializeCGroupController(CGroupsHandler.CGroupController controller) throws ResourceHandlerException {
        block6: {
            File rootHierarchy = new File(this.cGroupMountPath);
            if (!rootHierarchy.exists()) {
                throw new ResourceHandlerException("Cgroup2 root hierarchy " + rootHierarchy + " does not exist");
            }
            Path yarnHierarchy = Paths.get(this.cGroupMountPath, this.cGroupPrefix);
            if (!yarnHierarchy.toFile().exists()) {
                this.LOG.info("Yarn hierarchy does not exist. Creating " + yarnHierarchy);
                try {
                    if (!yarnHierarchy.toFile().mkdirs()) {
                        throw new ResourceHandlerException("Cannot create Yarn hierarchy " + yarnHierarchy);
                    }
                    break block6;
                }
                catch (SecurityException ex) {
                    throw new ResourceHandlerException("No permission to create " + yarnHierarchy, ex);
                }
            }
            if (!FileUtil.canWrite((File)yarnHierarchy.toFile())) {
                throw new ResourceHandlerException("Yarn hierarchy " + yarnHierarchy + " exists but it is not writable");
            }
        }
    }

    @Override
    public String getControllerPath(CGroupsHandler.CGroupController controller) {
        return Paths.get(this.cGroupMountPath, this.cGroupPrefix).toString();
    }
}

