/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.monitor;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.UniformReservoir;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableQuantiles;
import org.apache.hadoop.metrics2.lib.MutableStat;
import org.apache.hadoop.metrics2.util.Quantile;
import org.apache.hadoop.metrics2.util.QuantileEstimator;
import org.apache.hadoop.yarn.api.records.ContainerId;

@InterfaceAudience.Private
@Metrics(context="container")
public class ContainerMetrics
implements MetricsSource {
    public static final String PMEM_LIMIT_METRIC_NAME = "pMemLimitMBs";
    public static final String VMEM_LIMIT_METRIC_NAME = "vMemLimitMBs";
    public static final String VCORE_LIMIT_METRIC_NAME = "vCoreLimit";
    public static final String PMEM_USAGE_METRIC_NAME = "pMemUsageMBs";
    public static final String PMEM_USAGE_QUANTILES_NAME = "pMemUsageMBHistogram";
    public static final String LAUNCH_DURATION_METRIC_NAME = "launchDurationMs";
    public static final String LOCALIZATION_DURATION_METRIC_NAME = "localizationDurationMs";
    private static final String PHY_CPU_USAGE_METRIC_NAME = "pCpuUsagePercent";
    private static final String PHY_CPU_USAGE_QUANTILES_NAME = "pCpuUsagePercentHistogram";
    private static final String VCORE_USAGE_METRIC_NAME = "milliVcoreUsage";
    @Metric
    public MutableStat pMemMBsStat;
    @Metric
    public MutableQuantiles pMemMBQuantiles;
    @Metric
    public MutableStat cpuCoreUsagePercent;
    @Metric
    public MutableQuantiles cpuCoreUsagePercentQuantiles;
    @Metric
    public MutableStat milliVcoresUsed;
    @Metric
    public MutableGaugeInt pMemLimitMbs;
    @Metric
    public MutableGaugeInt vMemLimitMbs;
    @Metric
    public MutableGaugeInt cpuVcoreLimit;
    @Metric
    public MutableGaugeLong launchDurationMs;
    @Metric
    public MutableGaugeLong localizationDurationMs;
    @Metric
    public MutableGaugeLong startTime;
    @Metric
    public MutableGaugeLong finishTime;
    @Metric
    public MutableGaugeInt exitCode;
    static final MetricsInfo RECORD_INFO = Interns.info((String)"ContainerResource", (String)"Resource limit and usage by container");
    public static final MetricsInfo PROCESSID_INFO = Interns.info((String)"ContainerPid", (String)"Container Process Id");
    final MetricsInfo recordInfo;
    final MetricsRegistry registry;
    final ContainerId containerId;
    final MetricsSystem metricsSystem;
    private final long flushPeriodMs;
    private final long unregisterDelayMs;
    private boolean flushOnPeriod = false;
    private boolean finished = false;
    private Timer timer;
    private static final Map<ContainerId, ContainerMetrics> usageMetrics = new HashMap<ContainerId, ContainerMetrics>();
    private static final Timer unregisterContainerMetricsTimer = new Timer("Container metrics unregistration", true);

    ContainerMetrics(MetricsSystem ms, ContainerId containerId, long flushPeriodMs, long delayMs) {
        this.recordInfo = Interns.info((String)ContainerMetrics.sourceName(containerId), (String)RECORD_INFO.description());
        this.registry = new MetricsRegistry(this.recordInfo);
        this.metricsSystem = ms;
        this.containerId = containerId;
        this.flushPeriodMs = flushPeriodMs;
        this.unregisterDelayMs = delayMs < 0L ? 0L : delayMs;
        this.scheduleTimerTaskIfRequired();
        this.pMemMBsStat = this.registry.newStat(PMEM_USAGE_METRIC_NAME, "Physical memory stats", "Usage", "MBs", true);
        this.pMemMBQuantiles = this.registry.newQuantiles(PMEM_USAGE_QUANTILES_NAME, "Physical memory quantiles", "Usage", "MBs", 1);
        ContainerMetricsQuantiles memEstimator = new ContainerMetricsQuantiles(MutableQuantiles.quantiles);
        this.pMemMBQuantiles.setEstimator((QuantileEstimator)memEstimator);
        this.cpuCoreUsagePercent = this.registry.newStat(PHY_CPU_USAGE_METRIC_NAME, "Physical Cpu core percent usage stats", "Usage", "Percents", true);
        this.cpuCoreUsagePercentQuantiles = this.registry.newQuantiles(PHY_CPU_USAGE_QUANTILES_NAME, "Physical Cpu core percent usage quantiles", "Usage", "Percents", 1);
        ContainerMetricsQuantiles cpuEstimator = new ContainerMetricsQuantiles(MutableQuantiles.quantiles);
        this.cpuCoreUsagePercentQuantiles.setEstimator((QuantileEstimator)cpuEstimator);
        this.milliVcoresUsed = this.registry.newStat(VCORE_USAGE_METRIC_NAME, "1000 times Vcore usage", "Usage", "MilliVcores", true);
        this.pMemLimitMbs = this.registry.newGauge(PMEM_LIMIT_METRIC_NAME, "Physical memory limit in MBs", 0);
        this.vMemLimitMbs = this.registry.newGauge(VMEM_LIMIT_METRIC_NAME, "Virtual memory limit in MBs", 0);
        this.cpuVcoreLimit = this.registry.newGauge(VCORE_LIMIT_METRIC_NAME, "CPU limit in number of vcores", 0);
        this.launchDurationMs = this.registry.newGauge(LAUNCH_DURATION_METRIC_NAME, "Launch duration in MS", 0L);
        this.localizationDurationMs = this.registry.newGauge(LOCALIZATION_DURATION_METRIC_NAME, "Localization duration in MS", 0L);
    }

    ContainerMetrics tag(MetricsInfo info, ContainerId containerId) {
        this.registry.tag(info, containerId.toString());
        return this;
    }

    static String sourceName(ContainerId containerId) {
        return RECORD_INFO.name() + "_" + containerId.toString();
    }

    public static ContainerMetrics forContainer(ContainerId containerId, long flushPeriodMs, long delayMs) {
        return ContainerMetrics.forContainer(DefaultMetricsSystem.instance(), containerId, flushPeriodMs, delayMs);
    }

    public static synchronized ContainerMetrics getContainerMetrics(ContainerId containerId) {
        return usageMetrics.get(containerId);
    }

    static synchronized ContainerMetrics forContainer(MetricsSystem ms, ContainerId containerId, long flushPeriodMs, long delayMs) {
        ContainerMetrics metrics = usageMetrics.get(containerId);
        if (metrics == null) {
            metrics = new ContainerMetrics(ms, containerId, flushPeriodMs, delayMs).tag(RECORD_INFO, containerId);
            if (ms != null) {
                metrics = (ContainerMetrics)ms.register(ContainerMetrics.sourceName(containerId), "Metrics for container: " + containerId, (Object)metrics);
            }
            usageMetrics.put(containerId, metrics);
        }
        return metrics;
    }

    static synchronized void unregisterContainerMetrics(ContainerMetrics cm) {
        cm.metricsSystem.unregisterSource(cm.recordInfo.name());
        usageMetrics.remove(cm.containerId);
    }

    public synchronized void getMetrics(MetricsCollector collector, boolean all) {
        if (this.finished || this.flushOnPeriod) {
            this.registry.snapshot(collector.addRecord(this.registry.info()), all);
        }
        if (!this.finished && this.flushOnPeriod) {
            this.flushOnPeriod = false;
            this.scheduleTimerTaskIfRequired();
        }
    }

    public synchronized void finished() {
        if (!this.finished) {
            this.finished = true;
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.scheduleTimerTaskForUnregistration();
            this.pMemMBQuantiles.stop();
            this.cpuCoreUsagePercentQuantiles.stop();
        }
    }

    public void recordMemoryUsage(int memoryMBs) {
        if (memoryMBs >= 0) {
            this.pMemMBsStat.add((long)memoryMBs);
            this.pMemMBQuantiles.add((long)memoryMBs);
        }
    }

    public void recordCpuUsage(int totalPhysicalCpuPercent, int milliVcoresUsed) {
        if (totalPhysicalCpuPercent >= 0) {
            this.cpuCoreUsagePercent.add((long)totalPhysicalCpuPercent);
            this.cpuCoreUsagePercentQuantiles.add((long)totalPhysicalCpuPercent);
        }
        if (milliVcoresUsed >= 0) {
            this.milliVcoresUsed.add((long)milliVcoresUsed);
        }
    }

    public void recordProcessId(String processId) {
        this.registry.tag(PROCESSID_INFO, processId, true);
    }

    public void recordResourceLimit(int vmemLimit, int pmemLimit, int cpuVcores) {
        this.vMemLimitMbs.set(vmemLimit);
        this.pMemLimitMbs.set(pmemLimit);
        this.cpuVcoreLimit.set(cpuVcores);
    }

    public void recordStateChangeDurations(long launchDuration, long localizationDuration) {
        this.launchDurationMs.set(launchDuration);
        this.localizationDurationMs.set(localizationDuration);
    }

    public void recordStartTime(long startTime) {
        this.startTime.set(startTime);
    }

    public void recordFinishTimeAndExitCode(long finishTime, int exitCode) {
        this.finishTime.set(finishTime);
        this.exitCode.set(exitCode);
    }

    private synchronized void scheduleTimerTaskIfRequired() {
        if (this.flushPeriodMs > 0L) {
            if (this.timer == null) {
                this.timer = new Timer("Metrics flush checker", true);
            }
            TimerTask timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ContainerMetrics containerMetrics = ContainerMetrics.this;
                    synchronized (containerMetrics) {
                        if (!ContainerMetrics.this.finished) {
                            ContainerMetrics.this.flushOnPeriod = true;
                        }
                    }
                }
            };
            this.timer.schedule(timerTask, this.flushPeriodMs);
        }
    }

    private void scheduleTimerTaskForUnregistration() {
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                ContainerMetrics.unregisterContainerMetrics(ContainerMetrics.this);
            }
        };
        unregisterContainerMetricsTimer.schedule(timerTask, this.unregisterDelayMs);
    }

    public static class ContainerMetricsQuantiles
    implements QuantileEstimator {
        private final Histogram histogram = new Histogram((Reservoir)new UniformReservoir());
        private Quantile[] quantiles;

        ContainerMetricsQuantiles(Quantile[] q) {
            this.quantiles = q;
        }

        public synchronized void insert(long value) {
            this.histogram.update(value);
        }

        public synchronized long getCount() {
            return this.histogram.getCount();
        }

        public synchronized void clear() {
        }

        public synchronized Map<Quantile, Long> snapshot() {
            Snapshot snapshot = this.histogram.getSnapshot();
            TreeMap<Quantile, Long> values = new TreeMap<Quantile, Long>();
            for (Quantile quantile : this.quantiles) {
                values.put(quantile, (long)snapshot.getValue(quantile.quantile));
            }
            return values;
        }
    }
}

