/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.BaseCGroupsCpuResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CpuResourceHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;

@InterfaceStability.Unstable
@InterfaceAudience.Private
public class CGroupsCpuResourceHandlerImpl
extends BaseCGroupsCpuResourceHandler
implements CpuResourceHandler {
    @VisibleForTesting
    static final int CPU_DEFAULT_WEIGHT = 1024;
    static final int CPU_DEFAULT_WEIGHT_OPPORTUNISTIC = 2;
    static final String UNLIMITED_QUOTA = "-1";

    CGroupsCpuResourceHandlerImpl(CGroupsHandler cGroupsHandler) {
        super(cGroupsHandler);
    }

    @Override
    void updateCpuBandwidthParams(String groupId, String cpuQuotaUs, String cpuPeriodUs) throws ResourceHandlerException {
        if (!cpuPeriodUs.isEmpty()) {
            this.cGroupsHandler.updateCGroupParam(CPU, groupId, CGroupsHandler.CpuParameters.PERIOD_US.getName(), cpuPeriodUs);
        }
        this.cGroupsHandler.updateCGroupParam(CPU, groupId, CGroupsHandler.CpuParameters.QUOTA_US.getName(), cpuQuotaUs);
    }

    @Override
    String getCpuUnlimitedQuota() {
        return UNLIMITED_QUOTA;
    }

    @Override
    boolean doCpuLimitsExist(String path) throws IOException {
        String contents;
        int quotaUS;
        File quotaFile = new File(path, CPU.getName() + "." + CGroupsHandler.CpuParameters.QUOTA_US.getName());
        return quotaFile.exists() && (quotaUS = Integer.parseInt((contents = FileUtils.readFileToString((File)quotaFile, (String)"UTF-8")).trim())) != -1;
    }

    @InterfaceAudience.Private
    public static boolean cpuLimitsExist(String path) throws IOException {
        String contents;
        int quotaUS;
        File quotaFile = new File(path, CPU.getName() + "." + CGroupsHandler.CpuParameters.QUOTA_US.getName());
        return quotaFile.exists() && (quotaUS = Integer.parseInt((contents = FileUtils.readFileToString((File)quotaFile, (String)"UTF-8")).trim())) != -1;
    }

    @Override
    void updateCpuWeightParam(String cgroupId, int weight) throws ResourceHandlerException {
        this.cGroupsHandler.updateCGroupParam(CPU, cgroupId, CGroupsHandler.CpuParameters.SHARES.getName(), String.valueOf(weight));
    }

    @Override
    int getDefaultOpportunisticWeight() {
        return 2;
    }

    @Override
    int getDefaultWeight() {
        return 1024;
    }
}

