/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.NetworkTagMappingManager;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.ObjectMapper;

public class NetworkTagMappingJsonManager
implements NetworkTagMappingManager {
    private static final String FORMAT_NET_CLS_CLASS_ID = "0x[0-9]{8}";
    private NetworkTagMapping networkTagMapping = null;

    @Override
    public void initialize(Configuration conf) {
        String mappingJsonFile = conf.get("yarn.nodemanager.network-tagging.mapping-file.path", "");
        if (mappingJsonFile == null || mappingJsonFile.isEmpty()) {
            throw new YarnRuntimeException("To use NetworkTagMappingJsonManager, we have to set the configuration:yarn.nodemanager.network-tagging.mapping-file.path");
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            this.networkTagMapping = (NetworkTagMapping)mapper.readValue(new File(mappingJsonFile), NetworkTagMapping.class);
        }
        catch (Exception e) {
            throw new YarnRuntimeException((Throwable)e);
        }
        if (this.networkTagMapping == null) {
            throw new YarnRuntimeException("Fail to load the specific JSON file: " + mappingJsonFile);
        }
        this.networkTagMapping.validateUsers();
        this.networkTagMapping.validateGroups();
        this.networkTagMapping.validateDefaultClass();
    }

    @Override
    public String getNetworkTagHexID(Container container) {
        String userNetworkTagID = this.networkTagMapping.getUserNetworkTagID(container.getUser());
        if (userNetworkTagID != null) {
            return userNetworkTagID;
        }
        UserGroupInformation userUGI = UserGroupInformation.createRemoteUser((String)container.getUser());
        List<Group> groups = this.networkTagMapping.getGroups();
        for (Group group : groups) {
            if (!userUGI.getGroups().contains(group.getGroupName())) continue;
            return group.getNetworkTagID();
        }
        return this.networkTagMapping.getDefaultNetworkTagID();
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public NetworkTagMapping getNetworkTagMapping() {
        return this.networkTagMapping;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static class Group {
        @JsonProperty(value="name")
        private String groupName;
        @JsonProperty(value="network-tag-id")
        private String networkTagID;

        public String getGroupName() {
            return this.groupName;
        }

        public void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public String getNetworkTagID() {
            return this.networkTagID;
        }

        public void setNetworkTagID(String networkTagID) {
            this.networkTagID = networkTagID;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static class User {
        @JsonProperty(value="name")
        private String userName;
        @JsonProperty(value="network-tag-id")
        private String networkTagID;

        public User() {
        }

        public User(String userName, String networkTagID) {
            this.setUserName(userName);
            this.setNetworkTagID(networkTagID);
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getNetworkTagID() {
            return this.networkTagID;
        }

        public void setNetworkTagID(String networkTagID) {
            this.networkTagID = networkTagID;
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public static class NetworkTagMapping {
        @JsonProperty(value="users")
        private List<User> users = new LinkedList<User>();
        @JsonProperty(value="groups")
        private List<Group> groups = new LinkedList<Group>();
        @JsonProperty(value="default-network-tag-id")
        private String defaultNetworkTagID;
        @JsonIgnore
        private final Pattern pattern = Pattern.compile("0x[0-9]{8}");

        public List<User> getUsers() {
            return this.users;
        }

        public void setUsers(List<User> users) {
            this.users = users;
        }

        public void addUser(User user) {
            this.users.add(user);
        }

        public String getUserNetworkTagID(String userName) {
            for (User user : this.users) {
                if (!userName.equals(user.getUserName())) continue;
                return user.getNetworkTagID();
            }
            return null;
        }

        public List<Group> getGroups() {
            return this.groups;
        }

        public void setGroups(List<Group> groups) {
            this.groups = groups;
        }

        public void addGroup(Group group) {
            this.groups.add(group);
        }

        public String getDefaultNetworkTagID() {
            return this.defaultNetworkTagID;
        }

        public void setDefaultNetworkTagID(String defaultNetworkTagID) {
            this.defaultNetworkTagID = defaultNetworkTagID;
        }

        private boolean containsUser(String user, List<User> userList) {
            for (User existing : userList) {
                if (!user.equals(existing.getUserName())) continue;
                return true;
            }
            return false;
        }

        private boolean containsGroup(String group, List<Group> groupList) {
            for (Group existing : groupList) {
                if (!group.equals(existing.getGroupName())) continue;
                return true;
            }
            return false;
        }

        public void validateUsers() {
            LinkedList<User> validateUsers = new LinkedList<User>();
            for (User user : this.users) {
                Matcher m = this.pattern.matcher(user.getNetworkTagID());
                if (!m.matches()) {
                    throw new YarnRuntimeException("User-network-tag-id mapping configuraton error. The user:" + user.getUserName() + " 's configured network-tag-id:" + user.getNetworkTagID() + " does not match the '0xAAAABBBB' format.");
                }
                String[] userSplits = user.getUserName().split(",");
                if (userSplits.length > 1) {
                    String networkTagID = user.getNetworkTagID();
                    for (String split : userSplits) {
                        if (this.containsUser(split.trim(), validateUsers)) continue;
                        User addUsers = new User(split.trim(), networkTagID);
                        validateUsers.add(addUsers);
                    }
                    continue;
                }
                if (this.containsUser(user.getUserName(), validateUsers)) continue;
                validateUsers.add(user);
            }
            this.users = validateUsers;
        }

        public void validateGroups() {
            LinkedList<Group> validateGroups = new LinkedList<Group>();
            for (Group group : this.groups) {
                if (this.containsGroup(group.getGroupName(), validateGroups)) continue;
                Matcher m = this.pattern.matcher(group.getNetworkTagID());
                if (!m.matches()) {
                    throw new YarnRuntimeException("Group-network-tag-id mapping configuraton error. The group:" + group.getGroupName() + " 's configured network-tag-id:" + group.getNetworkTagID() + " does not match the '0xAAAABBBB' format.");
                }
                validateGroups.add(group);
            }
            this.groups = validateGroups;
        }

        public void validateDefaultClass() {
            if (this.getDefaultNetworkTagID() == null || this.getDefaultNetworkTagID().isEmpty()) {
                throw new YarnRuntimeException("Missing value for defaultNetworkTagID. We have to set non-empty value for defaultNetworkTagID");
            }
            Matcher m = this.pattern.matcher(this.getDefaultNetworkTagID());
            if (!m.matches()) {
                throw new YarnRuntimeException("Configuration error on default-network-tag-id. The configured default-network-tag-id:" + this.getDefaultNetworkTagID() + " does not match the '0xAAAABBBB' format.");
            }
        }
    }
}

