/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.CGroupsHandler;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.resources.ResourceHandlerException;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCGroupsHandler
implements CGroupsHandler {
    final Logger LOG = LoggerFactory.getLogger(this.getClass());
    final long deleteCGroupTimeout;
    final long deleteCGroupDelay;
    final String cGroupPrefix;
    final String cGroupMountPath;
    final Clock clock;
    static final String CGROUPS_FSTYPE = "cgroup";
    static final String CGROUPS2_FSTYPE = "cgroup2";

    BaseCGroupsHandler(Configuration conf) {
        this.deleteCGroupTimeout = conf.getLong("yarn.nodemanager.linux-container-executor.cgroups.delete-timeout-ms", 1000L) + conf.getLong("yarn.nodemanager.sleep-delay-before-sigkill.ms", 250L) + 1000L;
        this.deleteCGroupDelay = conf.getLong("yarn.nodemanager.linux-container-executor.cgroups.delete-delay-ms", 20L);
        this.cGroupPrefix = conf.get("yarn.nodemanager.linux-container-executor.cgroups.hierarchy", "/hadoop-yarn").replaceAll("^/", "").replaceAll("$/", "");
        this.cGroupMountPath = conf.get("yarn.nodemanager.linux-container-executor.cgroups.mount-path", null);
        this.clock = new MonotonicClock();
    }

    @Override
    public String createCGroup(CGroupsHandler.CGroupController controller, String cGroupId) throws ResourceHandlerException {
        File cGroupFile;
        String path = this.getPathForCGroup(controller, cGroupId);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("createCgroup: " + path);
        }
        if (!(cGroupFile = new File(path)).exists() && !cGroupFile.mkdir()) {
            throw new ResourceHandlerException("Failed to create cgroup at " + path);
        }
        return path;
    }

    @Override
    public void updateCGroupParam(CGroupsHandler.CGroupController controller, String cGroupId, String param, String value) throws ResourceHandlerException {
        block9: {
            PrintWriter pw;
            String cGroupParamPath;
            block10: {
                cGroupParamPath = this.getPathForCGroupParam(controller, cGroupId, param);
                pw = null;
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug(String.format("updateCGroupParam for path: %s with value %s", cGroupParamPath, value));
                }
                try {
                    File file = new File(cGroupParamPath);
                    OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8);
                    pw = new PrintWriter(w);
                    pw.write(value);
                    if (pw == null) break block9;
                    boolean hasError = pw.checkError();
                    pw.close();
                    if (!hasError) break block10;
                }
                catch (IOException e) {
                    try {
                        throw new ResourceHandlerException(String.format("Unable to write to %s with value: %s", cGroupParamPath, value), e);
                    }
                    catch (Throwable throwable) {
                        if (pw != null) {
                            boolean hasError = pw.checkError();
                            pw.close();
                            if (hasError) {
                                throw new ResourceHandlerException(String.format("PrintWriter unable to write to %s with value: %s", cGroupParamPath, value));
                            }
                            if (pw.checkError()) {
                                throw new ResourceHandlerException(String.format("Error while closing cgroup file %s", cGroupParamPath));
                            }
                        }
                        throw throwable;
                    }
                }
                throw new ResourceHandlerException(String.format("PrintWriter unable to write to %s with value: %s", cGroupParamPath, value));
            }
            if (pw.checkError()) {
                throw new ResourceHandlerException(String.format("Error while closing cgroup file %s", cGroupParamPath));
            }
        }
    }

    @Override
    public String getCGroupParam(CGroupsHandler.CGroupController controller, String cGroupId, String param) throws ResourceHandlerException {
        String cGroupParamPath = param.equals(this.getProcessesFilename()) ? this.getPathForCGroup(controller, cGroupId) + "/" + param : this.getPathForCGroupParam(controller, cGroupId, param);
        try {
            byte[] contents = Files.readAllBytes(Paths.get(cGroupParamPath, new String[0]));
            return new String(contents, StandardCharsets.UTF_8).trim();
        }
        catch (IOException e) {
            throw new ResourceHandlerException("Unable to read from " + cGroupParamPath);
        }
    }

    @Override
    public String getCGroupMountPath() {
        return this.cGroupMountPath;
    }

    @Override
    public String getRelativePathForCGroup(String cGroupId) {
        return this.cGroupPrefix + "/" + cGroupId;
    }

    @Override
    public String getPathForCGroupParam(CGroupsHandler.CGroupController controller, String cGroupId, String param) {
        return Paths.get(this.getPathForCGroup(controller, cGroupId), controller.getName() + "." + param).toString();
    }

    @Override
    public String getPathForCGroupTasks(CGroupsHandler.CGroupController controller, String cGroupId) {
        return Paths.get(this.getPathForCGroup(controller, cGroupId), this.getProcessesFilename()).toString();
    }

    @Override
    public void deleteCGroup(CGroupsHandler.CGroupController controller, String cGroupId) throws ResourceHandlerException {
        boolean deleted = false;
        String cGroupPath = this.getPathForCGroup(controller, cGroupId);
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("deleteCGroup: " + cGroupPath);
        }
        long start = this.clock.getTime();
        do {
            try {
                deleted = this.checkAndDeleteCgroup(new File(cGroupPath));
                if (deleted) continue;
                Thread.sleep(this.deleteCGroupDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!deleted && this.clock.getTime() - start < this.deleteCGroupTimeout);
        if (!deleted) {
            this.LOG.warn(String.format("Unable to delete  %s, tried to delete for %d ms", cGroupPath, this.deleteCGroupTimeout));
        }
    }

    boolean checkAndDeleteCgroup(File cgf) throws InterruptedException {
        boolean deleted = false;
        if (cgf.exists()) {
            String procsFile = Paths.get(cgf.toString(), this.getProcessesFilename()).toString();
            try (FileInputStream in = new FileInputStream(procsFile);){
                if (in.read() == -1) {
                    Thread.sleep(this.deleteCGroupDelay);
                    deleted = cgf.delete();
                    if (!deleted) {
                        this.LOG.warn("Failed attempt to delete cgroup: " + cgf);
                    }
                } else {
                    this.logLineFromTasksFile(cgf);
                }
            }
            catch (IOException e) {
                this.LOG.warn("Failed to read cgroup tasks file. ", (Throwable)e);
            }
        } else {
            this.LOG.info("Parent Cgroups directory {} does not exist. Skipping deletion", (Object)cgf.getPath());
            deleted = true;
        }
        return deleted;
    }

    void logLineFromTasksFile(File cgf) {
        if (this.LOG.isDebugEnabled()) {
            String procsFile = Paths.get(cgf.toString(), this.getProcessesFilename()).toString();
            try (BufferedReader inl = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(procsFile), StandardCharsets.UTF_8));){
                String str = inl.readLine();
                if (str != null) {
                    this.LOG.debug("First line in cgroup tasks file: " + cgf + " " + str);
                }
            }
            catch (IOException e) {
                this.LOG.warn("Failed to read cgroup tasks file. ", (Throwable)e);
            }
        }
    }

    abstract String getProcessesFilename();
}

