/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.quota;

import io.hops.exception.StorageException;
import io.hops.metadata.yarn.dal.quota.PriceMultiplicatorDataAccess;
import io.hops.metadata.yarn.dal.util.YARNOperationType;
import io.hops.metadata.yarn.entity.quota.PriceMultiplicator;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.util.RMStorageFactory;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.quota.ContainersLogsService;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;

public class PriceMultiplicatiorService
extends AbstractService {
    private static final Log LOG = LogFactory.getLog(PriceMultiplicatiorService.class);
    private Configuration conf;
    private final RMContext rmcontext;
    private volatile boolean stopped = false;
    private Thread priceCalculationThread;
    private Map<PriceMultiplicator.MultiplicatorType, Float> tippingPoints = new HashMap<PriceMultiplicator.MultiplicatorType, Float>();
    private Map<PriceMultiplicator.MultiplicatorType, Float> incrementFactors = new HashMap<PriceMultiplicator.MultiplicatorType, Float>();
    private long priceMultiplicationFactorCalculationInterval;
    private Map<PriceMultiplicator.MultiplicatorType, Float> currentMultiplicators = new HashMap<PriceMultiplicator.MultiplicatorType, Float>();
    private PriceMultiplicatorDataAccess priceMultiplicatorDA;

    public PriceMultiplicatiorService(RMContext rmctx) {
        super("Price multiplication factor service");
        this.rmcontext = rmctx;
    }

    public void serviceInit(Configuration conf) throws Exception {
        LOG.info((Object)"Initializing price estimation service");
        this.conf = conf;
        this.tippingPoints.put(PriceMultiplicator.MultiplicatorType.GENERAL, Float.valueOf(this.conf.getFloat("yarn.resourcemanager.quota.multiplicator.threshold.general", YarnConfiguration.DEFAULT_QUOTA_MULTIPLICATOR_THRESHOLD_GENERAL)));
        this.tippingPoints.put(PriceMultiplicator.MultiplicatorType.GPU, Float.valueOf(this.conf.getFloat("yarn.resourcemanager.quota.multiplicator.threshold.gpu", YarnConfiguration.DEFAULT_QUOTA_MULTIPLICATOR_THRESHOLD_GPU)));
        this.incrementFactors.put(PriceMultiplicator.MultiplicatorType.GENERAL, Float.valueOf(this.conf.getFloat("yarn.resourcemanager.quota.multiplicator.increment.general", YarnConfiguration.DEFAULT_QUOTA_INCREMENT_FACTOR_GENERAL)));
        this.incrementFactors.put(PriceMultiplicator.MultiplicatorType.GPU, Float.valueOf(this.conf.getFloat("yarn.resourcemanager.quota.multiplicator.increment.gpu", YarnConfiguration.DEFAULT_QUOTA_INCREMENT_FACTOR_GPU)));
        this.priceMultiplicationFactorCalculationInterval = this.conf.getLong("yarn.resourcemanager.quota.multiplicator.interval", YarnConfiguration.DEFAULT_QUOTA_PRICE_MULTIPLICATOR_INTERVAL);
        this.priceMultiplicatorDA = (PriceMultiplicatorDataAccess)RMStorageFactory.getDataAccess(PriceMultiplicatorDataAccess.class);
        for (PriceMultiplicator.MultiplicatorType type : PriceMultiplicator.MultiplicatorType.values()) {
            this.currentMultiplicators.put(type, new Float(1.0f));
        }
        this.recover();
    }

    private void recover() throws IOException {
        Map<PriceMultiplicator.MultiplicatorType, PriceMultiplicator> currentMultiplicators = this.getCurrentMultiplicator();
        for (PriceMultiplicator.MultiplicatorType type : PriceMultiplicator.MultiplicatorType.values()) {
            if (currentMultiplicators.get(type) == null) continue;
            this.currentMultiplicators.put(type, Float.valueOf(currentMultiplicators.get(type).getValue()));
        }
    }

    private Map<PriceMultiplicator.MultiplicatorType, PriceMultiplicator> getCurrentMultiplicator() throws IOException {
        LightWeightRequestHandler currentPriceHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.readCommitted();
                Map currentPrices = PriceMultiplicatiorService.this.priceMultiplicatorDA.getAll();
                connector.commit();
                return currentPrices;
            }
        };
        return (Map)currentPriceHandler.handle();
    }

    protected void serviceStart() throws Exception {
        assert (!this.stopped) : "starting when already stopped";
        LOG.info((Object)"Starting a new price estimation service.");
        this.priceCalculationThread = new Thread(new WorkingThread());
        this.priceCalculationThread.setName("Price estimation service");
        this.priceCalculationThread.setDaemon(true);
        this.priceCalculationThread.start();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        this.stopped = true;
        if (this.priceCalculationThread != null) {
            this.priceCalculationThread.interrupt();
        }
        super.serviceStop();
        LOG.info((Object)"Stopping the price estimation service.");
    }

    protected void computeNewGpuPrice() {
        QueueMetrics metrics = this.rmcontext.getScheduler().getRootQueueMetrics();
        float incrementBase = this.getPercenUsedGpus(metrics) - this.tippingPoints.get(PriceMultiplicator.MultiplicatorType.GPU).floatValue();
        incrementBase = Math.max(incrementBase, 0.0f);
        float multiplicator = 1.0f + incrementBase * this.incrementFactors.get(PriceMultiplicator.MultiplicatorType.GPU).floatValue();
        multiplicator = Math.max(multiplicator, this.currentMultiplicators.get(PriceMultiplicator.MultiplicatorType.GENERAL).floatValue());
        this.currentMultiplicators.put(PriceMultiplicator.MultiplicatorType.GPU, Float.valueOf(multiplicator));
        LOG.debug((Object)("New multiplicator: " + this.currentMultiplicators + " (mem: " + this.getPercenUsedMB(metrics) + ", vcores: " + this.getPercenUsedCores(metrics) + ", gpus: " + this.getPercenUsedGpus(metrics) + ")"));
    }

    private float getPercenUsedGpus(QueueMetrics metrics) {
        int totalGpus = metrics.getAllocatedGPUs() + metrics.getAvailableGPUs();
        int usedGpus = metrics.getAllocatedGPUs() + metrics.getPendingGPUs();
        return (float)usedGpus / (float)totalGpus;
    }

    private float getPercenUsedCores(QueueMetrics metrics) {
        int totalCores = metrics.getAllocatedVirtualCores() + metrics.getAvailableVirtualCores();
        int usedCores = metrics.getAllocatedVirtualCores() + metrics.getPendingVirtualCores();
        return (float)usedCores / (float)totalCores;
    }

    private float getPercenUsedMB(QueueMetrics metrics) {
        long totalMB = metrics.getAllocatedMB() + metrics.getAvailableMB();
        long usedMB = metrics.getAllocatedMB() + metrics.getPendingMB();
        return (float)usedMB / (float)totalMB;
    }

    protected void computeNewGeneralPrice() throws IOException {
        QueueMetrics metrics = this.rmcontext.getScheduler().getRootQueueMetrics();
        float incrementBase = Math.max(this.getPercenUsedCores(metrics), this.getPercenUsedMB(metrics)) - this.tippingPoints.get(PriceMultiplicator.MultiplicatorType.GENERAL).floatValue();
        incrementBase = Math.max(incrementBase, 0.0f);
        this.currentMultiplicators.put(PriceMultiplicator.MultiplicatorType.GENERAL, Float.valueOf(1.0f + incrementBase * this.incrementFactors.get(PriceMultiplicator.MultiplicatorType.GENERAL).floatValue()));
        LOG.debug((Object)("New multiplicator: " + this.currentMultiplicators + " (mem: " + this.getPercenUsedMB(metrics) + ", vcores: " + this.getPercenUsedCores(metrics) + ")"));
    }

    private void persistMultiplicators() throws IOException {
        LightWeightRequestHandler prepareHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws IOException {
                connector.beginTransaction();
                connector.writeLock();
                for (Map.Entry entry : PriceMultiplicatiorService.this.currentMultiplicators.entrySet()) {
                    PriceMultiplicatiorService.this.priceMultiplicatorDA.add((Object)new PriceMultiplicator((PriceMultiplicator.MultiplicatorType)entry.getKey(), ((Float)entry.getValue()).floatValue()));
                }
                connector.commit();
                LOG.debug((Object)("Commited new multiplicator: " + PriceMultiplicatiorService.this.currentMultiplicators + "for VARIABLE"));
                return null;
            }
        };
        prepareHandler.handle();
    }

    private class WorkingThread
    implements Runnable {
        private WorkingThread() {
        }

        @Override
        public void run() {
            LOG.info((Object)"Price estimation service started");
            while (!PriceMultiplicatiorService.this.stopped && !Thread.currentThread().isInterrupted()) {
                try {
                    PriceMultiplicatiorService.this.computeNewGeneralPrice();
                    PriceMultiplicatiorService.this.computeNewGpuPrice();
                    PriceMultiplicatiorService.this.persistMultiplicators();
                    ContainersLogsService cl = PriceMultiplicatiorService.this.rmcontext.getContainersLogsService();
                    if (cl != null) {
                        cl.setCurrentPrices(PriceMultiplicatiorService.this.currentMultiplicators);
                    }
                    Thread.sleep(PriceMultiplicatiorService.this.priceMultiplicationFactorCalculationInterval);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException ex) {
                    LOG.error((Object)ex, (Throwable)ex);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ex1) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            LOG.info((Object)"Quota scheduler thread is exiting gracefully");
        }
    }
}

