/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.LogAggregationContext;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.server.api.ContainerType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AggregateAppResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerChangeResourceEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerReservedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerUpdatesAcquiredEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceUsage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedContainerChangeRequest;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.SchedulingMode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.policy.SchedulableEntity;
import org.apache.hadoop.yarn.state.InvalidStateTransitionException;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SchedulerApplicationAttempt
implements SchedulableEntity {
    private static final Log LOG = LogFactory.getLog(SchedulerApplicationAttempt.class);
    private FastDateFormat fdf = FastDateFormat.getInstance((String)"EEE MMM dd HH:mm:ss Z yyyy");
    private static final long MEM_AGGREGATE_ALLOCATION_CACHE_MSECS = 3000L;
    protected long lastMemoryAggregateAllocationUpdateTime = 0L;
    private long lastMemorySeconds = 0L;
    private long lastVcoreSeconds = 0L;
    private long lastGpuSeconds = 0L;
    protected final AppSchedulingInfo appSchedulingInfo;
    protected ApplicationAttemptId attemptId;
    protected Map<ContainerId, RMContainer> liveContainers = new HashMap<ContainerId, RMContainer>();
    protected final Map<Priority, Map<NodeId, RMContainer>> reservedContainers = new HashMap<Priority, Map<NodeId, RMContainer>>();
    private final Multiset<Priority> reReservations = HashMultiset.create();
    private Resource resourceLimit = Resource.newInstance((int)0, (int)0);
    private boolean unmanagedAM = true;
    private boolean amRunning = false;
    private LogAggregationContext logAggregationContext;
    private volatile Priority appPriority = null;
    private boolean isAttemptRecovering;
    protected ResourceUsage attemptResourceUsage = new ResourceUsage();
    private AtomicLong firstAllocationRequestSentTime = new AtomicLong(0L);
    private AtomicLong firstContainerAllocatedTime = new AtomicLong(0L);
    protected List<RMContainer> newlyAllocatedContainers = new ArrayList<RMContainer>();
    protected Map<ContainerId, RMContainer> newlyDecreasedContainers = new HashMap<ContainerId, RMContainer>();
    protected Map<ContainerId, RMContainer> newlyIncreasedContainers = new HashMap<ContainerId, RMContainer>();
    protected Set<NMToken> updatedNMTokens = new HashSet<NMToken>();
    private Set<ContainerId> pendingRelease = null;
    Multiset<Priority> schedulingOpportunities = HashMultiset.create();
    Multiset<Priority> missedNonPartitionedRequestSchedulingOpportunity = HashMultiset.create();
    protected Map<Priority, Long> lastScheduledContainer = new HashMap<Priority, Long>();
    protected Queue queue;
    protected boolean isStopped = false;
    protected String appAMNodePartitionName = "";
    protected final RMContext rmContext;
    private RMAppAttempt appAttempt;

    public SchedulerApplicationAttempt(ApplicationAttemptId applicationAttemptId, String user, Queue queue, ActiveUsersManager activeUsersManager, RMContext rmContext) {
        Preconditions.checkNotNull((Object)rmContext, (Object)"RMContext should not be null");
        this.rmContext = rmContext;
        this.appSchedulingInfo = new AppSchedulingInfo(applicationAttemptId, user, queue, activeUsersManager, rmContext.getEpoch(), this.attemptResourceUsage, rmContext);
        this.queue = queue;
        this.pendingRelease = new HashSet<ContainerId>();
        this.attemptId = applicationAttemptId;
        if (rmContext.getRMApps() != null && rmContext.getRMApps().containsKey(applicationAttemptId.getApplicationId())) {
            RMApp rmApp = (RMApp)rmContext.getRMApps().get(applicationAttemptId.getApplicationId());
            ApplicationSubmissionContext appSubmissionContext = rmApp.getApplicationSubmissionContext();
            this.appAttempt = rmApp.getCurrentAppAttempt();
            if (appSubmissionContext != null) {
                this.unmanagedAM = appSubmissionContext.getUnmanagedAM();
                this.logAggregationContext = appSubmissionContext.getLogAggregationContext();
            }
        }
    }

    public synchronized Collection<RMContainer> getLiveContainers() {
        return new ArrayList<RMContainer>(this.liveContainers.values());
    }

    public AppSchedulingInfo getAppSchedulingInfo() {
        return this.appSchedulingInfo;
    }

    public boolean isPending() {
        return this.appSchedulingInfo.isPending();
    }

    public ApplicationAttemptId getApplicationAttemptId() {
        return this.appSchedulingInfo.getApplicationAttemptId();
    }

    public ApplicationId getApplicationId() {
        return this.appSchedulingInfo.getApplicationId();
    }

    public String getUser() {
        return this.appSchedulingInfo.getUser();
    }

    public Map<String, ResourceRequest> getResourceRequests(Priority priority) {
        return this.appSchedulingInfo.getResourceRequests(priority);
    }

    public Set<ContainerId> getPendingRelease() {
        return this.pendingRelease;
    }

    public long getNewContainerId() {
        return this.appSchedulingInfo.getNewContainerId();
    }

    public Collection<Priority> getPriorities() {
        return this.appSchedulingInfo.getPriorities();
    }

    public synchronized ResourceRequest getResourceRequest(Priority priority, String resourceName) {
        return this.appSchedulingInfo.getResourceRequest(priority, resourceName);
    }

    public synchronized int getTotalRequiredResources(Priority priority) {
        return this.getResourceRequest(priority, "*").getNumContainers();
    }

    public synchronized Resource getResource(Priority priority) {
        return this.appSchedulingInfo.getResource(priority);
    }

    public String getQueueName() {
        return this.appSchedulingInfo.getQueueName();
    }

    public Resource getAMResource() {
        return this.attemptResourceUsage.getAMUsed();
    }

    public Resource getAMResource(String label) {
        return this.attemptResourceUsage.getAMUsed(label);
    }

    public void setAMResource(Resource amResource) {
        this.attemptResourceUsage.setAMUsed(amResource);
    }

    public void setAMResource(String label, Resource amResource) {
        this.attemptResourceUsage.setAMUsed(label, amResource);
    }

    public boolean isAmRunning() {
        return this.amRunning;
    }

    public void setAmRunning(boolean bool) {
        this.amRunning = bool;
    }

    public boolean getUnmanagedAM() {
        return this.unmanagedAM;
    }

    public synchronized RMContainer getRMContainer(ContainerId id) {
        return this.liveContainers.get(id);
    }

    protected synchronized void resetReReservations(Priority priority) {
        this.reReservations.setCount((Object)priority, 0);
    }

    protected synchronized void addReReservation(Priority priority) {
        this.reReservations.add((Object)priority);
    }

    public synchronized int getReReservations(Priority priority) {
        return this.reReservations.count((Object)priority);
    }

    @InterfaceStability.Stable
    @InterfaceAudience.Private
    public synchronized Resource getCurrentReservation() {
        return this.attemptResourceUsage.getReserved();
    }

    public Queue getQueue() {
        return this.queue;
    }

    public synchronized boolean updateResourceRequests(List<ResourceRequest> requests) {
        if (!this.isStopped) {
            return this.appSchedulingInfo.updateResourceRequests(requests, false);
        }
        return false;
    }

    public synchronized void recoverResourceRequestsForContainer(List<ResourceRequest> requests) {
        if (!this.isStopped) {
            this.appSchedulingInfo.updateResourceRequests(requests, true);
        }
    }

    public synchronized void stop(RMAppAttemptState rmAppAttemptFinalState) {
        this.isStopped = true;
        this.appSchedulingInfo.stop();
    }

    public synchronized boolean isStopped() {
        return this.isStopped;
    }

    public synchronized List<RMContainer> getReservedContainers() {
        ArrayList<RMContainer> reservedContainers = new ArrayList<RMContainer>();
        for (Map.Entry<Priority, Map<NodeId, RMContainer>> e : this.reservedContainers.entrySet()) {
            reservedContainers.addAll(e.getValue().values());
        }
        return reservedContainers;
    }

    public synchronized boolean reserveIncreasedContainer(SchedulerNode node, Priority priority, RMContainer rmContainer, Resource reservedResource) {
        if (this.commonReserve(node, priority, rmContainer, reservedResource)) {
            this.attemptResourceUsage.incReserved(node.getPartition(), reservedResource);
            return true;
        }
        return false;
    }

    private synchronized boolean commonReserve(SchedulerNode node, Priority priority, RMContainer rmContainer, Resource reservedResource) {
        try {
            rmContainer.handle((Event)new RMContainerReservedEvent(rmContainer.getContainerId(), reservedResource, node.getNodeID(), priority));
        }
        catch (InvalidStateTransitionException e) {
            return false;
        }
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        if (reservedContainers == null) {
            reservedContainers = new HashMap<NodeId, RMContainer>();
            this.reservedContainers.put(priority, reservedContainers);
        }
        reservedContainers.put(node.getNodeID(), rmContainer);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Application attempt " + this.getApplicationAttemptId() + " reserved container " + rmContainer + " on node " + node + ". This attempt currently has " + reservedContainers.size() + " reserved containers at priority " + priority + "; currentReservation " + reservedResource));
        }
        return true;
    }

    public synchronized RMContainer reserve(SchedulerNode node, Priority priority, RMContainer rmContainer, Container container) {
        if (rmContainer == null) {
            rmContainer = new RMContainerImpl(container, this.getApplicationAttemptId(), node.getNodeID(), this.appSchedulingInfo.getUser(), this.rmContext);
            this.attemptResourceUsage.incReserved(node.getPartition(), container.getResource());
            ((RMContainerImpl)rmContainer).setQueueName(this.getQueueName());
            this.resetReReservations(priority);
        } else {
            this.addReReservation(priority);
        }
        this.commonReserve(node, priority, rmContainer, container.getResource());
        return rmContainer;
    }

    public synchronized boolean isReserved(SchedulerNode node, Priority priority) {
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        if (reservedContainers != null) {
            return reservedContainers.containsKey(node.getNodeID());
        }
        return false;
    }

    public synchronized void setHeadroom(Resource globalLimit) {
        this.resourceLimit = globalLimit;
    }

    public synchronized Resource getHeadroom() {
        if (this.resourceLimit.getMemorySize() < 0L) {
            this.resourceLimit.setMemorySize(0L);
        }
        return this.resourceLimit;
    }

    public synchronized int getNumReservedContainers(Priority priority) {
        Map<NodeId, RMContainer> reservedContainers = this.reservedContainers.get(priority);
        return reservedContainers == null ? 0 : reservedContainers.size();
    }

    public synchronized void containerLaunchedOnNode(ContainerId containerId, NodeId nodeId) {
        RMContainer rmContainer = this.getRMContainer(containerId);
        if (rmContainer == null) {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMNodeCleanContainerEvent(nodeId, containerId));
            return;
        }
        rmContainer.handle((Event)new RMContainerEvent(containerId, RMContainerEventType.LAUNCHED));
    }

    public synchronized void showRequests() {
        if (LOG.isDebugEnabled()) {
            for (Priority priority : this.getPriorities()) {
                Map<String, ResourceRequest> requests = this.getResourceRequests(priority);
                if (requests == null) continue;
                LOG.debug((Object)("showRequests: application=" + this.getApplicationId() + " headRoom=" + this.getHeadroom() + " currentConsumption=" + this.attemptResourceUsage.getUsed().getMemorySize()));
                for (ResourceRequest request : requests.values()) {
                    LOG.debug((Object)("showRequests: application=" + this.getApplicationId() + " request=" + request));
                }
            }
        }
    }

    public Resource getCurrentConsumption() {
        return this.attemptResourceUsage.getUsed();
    }

    private Container updateContainerAndNMToken(RMContainer rmContainer, boolean newContainer, boolean increasedContainer) {
        Container container = rmContainer.getContainer();
        ContainerType containerType = ContainerType.TASK;
        if (!newContainer) {
            container.setVersion(container.getVersion() + 1);
        }
        if (this.isWaitingForAMContainer()) {
            containerType = ContainerType.APPLICATION_MASTER;
        }
        try {
            container.setContainerToken(this.rmContext.getContainerTokenSecretManager().createContainerToken(container.getId(), container.getVersion(), container.getNodeId(), this.getUser(), container.getResource(), container.getPriority(), rmContainer.getCreationTime(), this.logAggregationContext, rmContainer.getNodeLabelExpression(), containerType, this.appSchedulingInfo.getUserFolder()));
            NMToken nmToken = this.rmContext.getNMTokenSecretManager().createAndGetNMToken(this.getUser(), this.getApplicationAttemptId(), container);
            if (nmToken != null) {
                this.updatedNMTokens.add(nmToken);
            }
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)("Error trying to assign container token and NM token to an updated container " + container.getId()), (Throwable)e);
            return null;
        }
        if (newContainer) {
            rmContainer.handle((Event)new RMContainerEvent(rmContainer.getContainerId(), RMContainerEventType.ACQUIRED));
        } else {
            rmContainer.handle((Event)new RMContainerUpdatesAcquiredEvent(rmContainer.getContainerId(), increasedContainer));
        }
        return container;
    }

    public synchronized List<Container> pullNewlyAllocatedContainers() {
        ArrayList<Container> returnContainerList = new ArrayList<Container>(this.newlyAllocatedContainers.size());
        Iterator<RMContainer> i = this.newlyAllocatedContainers.iterator();
        while (i.hasNext()) {
            RMContainer rmContainer = i.next();
            Container updatedContainer = this.updateContainerAndNMToken(rmContainer, true, false);
            if (updatedContainer == null) continue;
            returnContainerList.add(updatedContainer);
            i.remove();
        }
        return returnContainerList;
    }

    private synchronized List<Container> pullNewlyUpdatedContainers(Map<ContainerId, RMContainer> updatedContainerMap, boolean increase) {
        ArrayList<Container> returnContainerList = new ArrayList<Container>(updatedContainerMap.size());
        Iterator<Map.Entry<ContainerId, RMContainer>> i = updatedContainerMap.entrySet().iterator();
        while (i.hasNext()) {
            RMContainer rmContainer = i.next().getValue();
            Container updatedContainer = this.updateContainerAndNMToken(rmContainer, false, increase);
            if (updatedContainer == null) continue;
            returnContainerList.add(updatedContainer);
            i.remove();
        }
        return returnContainerList;
    }

    public synchronized List<Container> pullNewlyIncreasedContainers() {
        return this.pullNewlyUpdatedContainers(this.newlyIncreasedContainers, true);
    }

    public synchronized List<Container> pullNewlyDecreasedContainers() {
        return this.pullNewlyUpdatedContainers(this.newlyDecreasedContainers, false);
    }

    public synchronized List<NMToken> pullUpdatedNMTokens() {
        ArrayList<NMToken> returnList = new ArrayList<NMToken>(this.updatedNMTokens);
        this.updatedNMTokens.clear();
        return returnList;
    }

    public boolean isWaitingForAMContainer() {
        return !this.unmanagedAM && this.appAttempt.getMasterContainer() == null;
    }

    public synchronized void updateBlacklist(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        if (!this.isStopped) {
            if (this.isWaitingForAMContainer()) {
                this.appSchedulingInfo.updatePlacesBlacklistedBySystem(blacklistAdditions, blacklistRemovals);
            } else {
                this.appSchedulingInfo.updatePlacesBlacklistedByApp(blacklistAdditions, blacklistRemovals);
            }
        }
    }

    public boolean isPlaceBlacklisted(String resourceName) {
        boolean forAMContainer = this.isWaitingForAMContainer();
        return this.appSchedulingInfo.isPlaceBlacklisted(resourceName, forAMContainer);
    }

    public synchronized int addMissedNonPartitionedRequestSchedulingOpportunity(Priority priority) {
        this.missedNonPartitionedRequestSchedulingOpportunity.add((Object)priority);
        return this.missedNonPartitionedRequestSchedulingOpportunity.count((Object)priority);
    }

    public synchronized void resetMissedNonPartitionedRequestSchedulingOpportunity(Priority priority) {
        this.missedNonPartitionedRequestSchedulingOpportunity.setCount((Object)priority, 0);
    }

    public synchronized void addSchedulingOpportunity(Priority priority) {
        int count = this.schedulingOpportunities.count((Object)priority);
        if (count < Integer.MAX_VALUE) {
            this.schedulingOpportunities.setCount((Object)priority, count + 1);
        }
    }

    public synchronized void subtractSchedulingOpportunity(Priority priority) {
        int count = this.schedulingOpportunities.count((Object)priority) - 1;
        this.schedulingOpportunities.setCount((Object)priority, Math.max(count, 0));
    }

    public synchronized int getSchedulingOpportunities(Priority priority) {
        return this.schedulingOpportunities.count((Object)priority);
    }

    public synchronized void resetSchedulingOpportunities(Priority priority) {
        this.resetSchedulingOpportunities(priority, System.currentTimeMillis());
    }

    public synchronized void resetSchedulingOpportunities(Priority priority, long currentTimeMs) {
        this.lastScheduledContainer.put(priority, currentTimeMs);
        this.schedulingOpportunities.setCount((Object)priority, 0);
    }

    @VisibleForTesting
    void setSchedulingOpportunities(Priority priority, int count) {
        this.schedulingOpportunities.setCount((Object)priority, count);
    }

    synchronized AggregateAppResourceUsage getRunningAggregateAppResourceUsage() {
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.lastMemoryAggregateAllocationUpdateTime > 3000L) {
            long memorySeconds = 0L;
            long vcoreSeconds = 0L;
            long gpuSeconds = 0L;
            for (RMContainer rmContainer : this.liveContainers.values()) {
                long usedMillis = currentTimeMillis - rmContainer.getCreationTime();
                Resource resource = rmContainer.getContainer().getResource();
                memorySeconds += resource.getMemorySize() * usedMillis / 1000L;
                vcoreSeconds += (long)resource.getVirtualCores() * usedMillis / 1000L;
                gpuSeconds += (long)resource.getGPUs() * usedMillis / 1000L;
            }
            this.lastMemoryAggregateAllocationUpdateTime = currentTimeMillis;
            this.lastMemorySeconds = memorySeconds;
            this.lastVcoreSeconds = vcoreSeconds;
            this.lastGpuSeconds = gpuSeconds;
        }
        return new AggregateAppResourceUsage(this.lastMemorySeconds, this.lastVcoreSeconds, this.lastGpuSeconds);
    }

    public synchronized ApplicationResourceUsageReport getResourceUsageReport() {
        AggregateAppResourceUsage runningResourceUsage = this.getRunningAggregateAppResourceUsage();
        Resource usedResourceClone = Resources.clone((Resource)this.attemptResourceUsage.getAllUsed());
        Resource reservedResourceClone = Resources.clone((Resource)this.attemptResourceUsage.getReserved());
        Resource cluster = this.rmContext.getScheduler().getClusterResource();
        ResourceCalculator calc = this.rmContext.getScheduler().getResourceCalculator();
        float queueUsagePerc = 0.0f;
        float clusterUsagePerc = 0.0f;
        if (!calc.isInvalidDivisor(cluster)) {
            queueUsagePerc = calc.divide(cluster, usedResourceClone, Resources.multiply((Resource)cluster, (double)this.queue.getQueueInfo(false, false).getCapacity())) * 100.0f;
            clusterUsagePerc = calc.divide(cluster, usedResourceClone, cluster) * 100.0f;
        }
        return ApplicationResourceUsageReport.newInstance((int)this.liveContainers.size(), (int)this.reservedContainers.size(), (Resource)usedResourceClone, (Resource)reservedResourceClone, (Resource)Resources.add((Resource)usedResourceClone, (Resource)reservedResourceClone), (long)runningResourceUsage.getMemorySeconds(), (long)runningResourceUsage.getVcoreSeconds(), (long)runningResourceUsage.getGPUSeconds(), (float)queueUsagePerc, (float)clusterUsagePerc, (long)0L, (long)0L, (long)0L);
    }

    public synchronized Map<ContainerId, RMContainer> getLiveContainersMap() {
        return this.liveContainers;
    }

    public synchronized Resource getResourceLimit() {
        return this.resourceLimit;
    }

    public synchronized Map<Priority, Long> getLastScheduledContainer() {
        return this.lastScheduledContainer;
    }

    public synchronized void transferStateFromPreviousAttempt(SchedulerApplicationAttempt appAttempt) {
        this.liveContainers = appAttempt.getLiveContainersMap();
        this.attemptResourceUsage.copyAllUsed(appAttempt.attemptResourceUsage);
        this.resourceLimit = appAttempt.getResourceLimit();
        this.lastScheduledContainer = appAttempt.getLastScheduledContainer();
        this.appSchedulingInfo.transferStateFromPreviousAppSchedulingInfo(appAttempt.appSchedulingInfo);
    }

    public synchronized void move(Queue newQueue) {
        QueueMetrics oldMetrics = this.queue.getMetrics();
        QueueMetrics newMetrics = newQueue.getMetrics();
        String newQueueName = newQueue.getQueueName();
        String user = this.getUser();
        for (RMContainer rMContainer : this.liveContainers.values()) {
            Resource resource = rMContainer.getContainer().getResource();
            ((RMContainerImpl)rMContainer).setQueueName(newQueueName);
            oldMetrics.releaseResources(user, 1, resource);
            newMetrics.allocateResources(user, 1, resource, false);
        }
        for (Map map : this.reservedContainers.values()) {
            for (RMContainer reservedContainer : map.values()) {
                ((RMContainerImpl)reservedContainer).setQueueName(newQueueName);
                Resource resource = reservedContainer.getReservedResource();
                oldMetrics.unreserveResource(user, resource);
                newMetrics.reserveResource(user, resource);
            }
        }
        this.appSchedulingInfo.move(newQueue);
        this.queue = newQueue;
    }

    public synchronized void recoverContainer(SchedulerNode node, RMContainer rmContainer) {
        this.appSchedulingInfo.recoverContainer(rmContainer);
        if (rmContainer.getState().equals((Object)RMContainerState.COMPLETED)) {
            return;
        }
        LOG.info((Object)("SchedulerAttempt " + this.getApplicationAttemptId() + " is recovering container " + rmContainer.getContainerId()));
        this.liveContainers.put(rmContainer.getContainerId(), rmContainer);
        this.attemptResourceUsage.incUsed(node.getPartition(), rmContainer.getContainer().getResource());
    }

    public void incNumAllocatedContainers(NodeType containerType, NodeType requestType) {
        RMAppAttempt attempt = ((RMApp)this.rmContext.getRMApps().get(this.attemptId.getApplicationId())).getCurrentAppAttempt();
        if (attempt != null) {
            attempt.getRMAppAttemptMetrics().incNumAllocatedContainers(containerType, requestType);
        }
    }

    public void setApplicationHeadroomForMetrics(Resource headroom) {
        RMAppAttempt attempt = ((RMApp)this.rmContext.getRMApps().get(this.attemptId.getApplicationId())).getCurrentAppAttempt();
        if (attempt != null) {
            attempt.getRMAppAttemptMetrics().setApplicationAttemptHeadRoom(Resources.clone((Resource)headroom));
        }
    }

    public void recordContainerRequestTime(long value) {
        this.firstAllocationRequestSentTime.compareAndSet(0L, value);
    }

    public void recordContainerAllocationTime(long value) {
        long timediff;
        if (this.firstContainerAllocatedTime.compareAndSet(0L, value) && (timediff = this.firstContainerAllocatedTime.longValue() - this.firstAllocationRequestSentTime.longValue()) > 0L) {
            this.queue.getMetrics().addAppAttemptFirstContainerAllocationDelay(timediff);
        }
    }

    public Set<String> getBlacklistedNodes() {
        return this.appSchedulingInfo.getBlackListCopy();
    }

    @InterfaceAudience.Private
    public boolean hasPendingResourceRequest(ResourceCalculator rc, String nodePartition, Resource cluster, SchedulingMode schedulingMode) {
        return SchedulerUtils.hasPendingResourceRequest(rc, this.attemptResourceUsage, nodePartition, cluster, schedulingMode);
    }

    @VisibleForTesting
    public ResourceUsage getAppAttemptResourceUsage() {
        return this.attemptResourceUsage;
    }

    @Override
    public Priority getPriority() {
        return this.appPriority;
    }

    public void setPriority(Priority appPriority) {
        this.appPriority = appPriority;
    }

    @Override
    public String getId() {
        return this.getApplicationId().toString();
    }

    @Override
    public int compareInputOrderTo(SchedulableEntity other) {
        if (other instanceof SchedulerApplicationAttempt) {
            return this.getApplicationId().compareTo(((SchedulerApplicationAttempt)other).getApplicationId());
        }
        return 1;
    }

    @Override
    public ResourceUsage getSchedulingResourceUsage() {
        return this.attemptResourceUsage;
    }

    public synchronized boolean removeIncreaseRequest(NodeId nodeId, Priority priority, ContainerId containerId) {
        return this.appSchedulingInfo.removeIncreaseRequest(nodeId, priority, containerId);
    }

    public synchronized boolean updateIncreaseRequests(List<SchedContainerChangeRequest> increaseRequests) {
        return this.appSchedulingInfo.updateIncreaseRequests(increaseRequests);
    }

    private synchronized void changeContainerResource(SchedContainerChangeRequest changeRequest, boolean increase) {
        if (increase) {
            this.appSchedulingInfo.increaseContainer(changeRequest);
        } else {
            this.appSchedulingInfo.decreaseContainer(changeRequest);
        }
        RMContainer changedRMContainer = changeRequest.getRMContainer();
        changedRMContainer.handle((Event)new RMContainerChangeResourceEvent(changeRequest.getContainerId(), changeRequest.getTargetCapacity(), increase));
        if (increase) {
            this.newlyDecreasedContainers.remove(changeRequest.getContainerId());
            this.newlyIncreasedContainers.put(changeRequest.getContainerId(), changedRMContainer);
        } else {
            this.newlyIncreasedContainers.remove(changeRequest.getContainerId());
            this.newlyDecreasedContainers.put(changeRequest.getContainerId(), changedRMContainer);
        }
    }

    public synchronized void decreaseContainer(SchedContainerChangeRequest decreaseRequest) {
        this.changeContainerResource(decreaseRequest, false);
    }

    public synchronized void increaseContainer(SchedContainerChangeRequest increaseRequest) {
        this.changeContainerResource(increaseRequest, true);
    }

    public void setAppAMNodePartitionName(String partitionName) {
        this.appAMNodePartitionName = partitionName;
    }

    public String getAppAMNodePartitionName() {
        return this.appAMNodePartitionName;
    }

    public void updateAMContainerDiagnostics(AMState state, String diagnosticMessage) {
        if (!this.isWaitingForAMContainer()) {
            return;
        }
        StringBuilder diagnosticMessageBldr = new StringBuilder();
        diagnosticMessageBldr.append("[");
        diagnosticMessageBldr.append(this.fdf.format(System.currentTimeMillis()));
        diagnosticMessageBldr.append("] ");
        switch (state) {
            case INACTIVATED: {
                diagnosticMessageBldr.append(state.diagnosticMessage);
                if (diagnosticMessage != null) {
                    diagnosticMessageBldr.append(diagnosticMessage);
                }
                this.getPendingAppDiagnosticMessage(diagnosticMessageBldr);
                break;
            }
            case ACTIVATED: {
                diagnosticMessageBldr.append(state.diagnosticMessage);
                if (diagnosticMessage != null) {
                    diagnosticMessageBldr.append(diagnosticMessage);
                }
                this.getActivedAppDiagnosticMessage(diagnosticMessageBldr);
                break;
            }
            default: {
                diagnosticMessageBldr.append(state.diagnosticMessage);
            }
        }
        this.appAttempt.updateAMLaunchDiagnostics(diagnosticMessageBldr.toString());
    }

    protected void getPendingAppDiagnosticMessage(StringBuilder diagnosticMessage) {
    }

    protected void getActivedAppDiagnosticMessage(StringBuilder diagnosticMessage) {
    }

    @Override
    public boolean isRecovering() {
        return this.isAttemptRecovering;
    }

    protected void setAttemptRecovering(boolean isRecovering) {
        this.isAttemptRecovering = isRecovering;
    }

    public static enum AMState {
        UNMANAGED("User launched the Application Master, since it's unmanaged. "),
        INACTIVATED("Application is added to the scheduler and is not yet activated. "),
        ACTIVATED("Application is Activated, waiting for resources to be assigned for AM. "),
        ASSIGNED("Scheduler has assigned a container for AM, waiting for AM container to be launched"),
        LAUNCHED("AM container is launched, waiting for AM container to Register with RM");

        private String diagnosticMessage;

        private AMState(String diagnosticMessage) {
            this.diagnosticMessage = diagnosticMessage;
        }

        public String getDiagnosticMessage() {
            return this.diagnosticMessage;
        }
    }
}

