/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import io.hops.util.DBUtility;
import io.hops.util.DBUtilityTests;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.HostsFileReader;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.server.api.protocolrecords.NodeHeartbeatResponse;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManager;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.NodesListManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.quota.ContainersLogsService;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeCleanContainerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImplDist;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStartedEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeStatusEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.security.DelegationTokenRenewer;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Records;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestDistributedScheduler {
    private RMContext rmContext;
    private YarnScheduler scheduler;
    private SchedulerEventType eventType;
    private List<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
    private NodesListManagerEvent nodesListManagerEvent = null;

    @Before
    public void setUp() throws Exception {
        YarnConfiguration conf = new YarnConfiguration();
        RMStorageFactory.setConfiguration((Configuration)conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)conf);
        DBUtility.InitializeDB();
        InlineDispatcher rmDispatcher = new InlineDispatcher();
        this.rmContext = new RMContextImpl((Dispatcher)rmDispatcher, null, null, null, (DelegationTokenRenewer)Mockito.mock(DelegationTokenRenewer.class), null, null, null, null, null);
        NodesListManager nodesListManager = (NodesListManager)Mockito.mock(NodesListManager.class);
        HostsFileReader reader = (HostsFileReader)Mockito.mock(HostsFileReader.class);
        Mockito.when((Object)nodesListManager.getHostsReader()).thenReturn((Object)reader);
        ((RMContextImpl)this.rmContext).setNodesListManager(nodesListManager);
        ContainersLogsService containerLogsService = (ContainersLogsService)Mockito.mock(ContainersLogsService.class);
        ((RMContextImpl)this.rmContext).setContainersLogsService(containerLogsService);
        this.scheduler = (YarnScheduler)Mockito.mock(YarnScheduler.class);
        ((YarnScheduler)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                SchedulerEvent event = (SchedulerEvent)invocation.getArguments()[0];
                TestDistributedScheduler.this.eventType = (SchedulerEventType)event.getType();
                if (TestDistributedScheduler.this.eventType == SchedulerEventType.NODE_UPDATE) {
                    List lastestContainersInfoList = ((NodeUpdateSchedulerEvent)event).getRMNode().pullContainerUpdates();
                    for (UpdatedContainerInfo lastestContainersInfo : lastestContainersInfoList) {
                        TestDistributedScheduler.this.completedContainers.addAll(lastestContainersInfo.getCompletedContainers());
                    }
                }
                return null;
            }
        }).when((Object)this.scheduler)).handle((Event)Matchers.any(SchedulerEvent.class));
        rmDispatcher.register(SchedulerEventType.class, (EventHandler)new TestSchedulerEventDispatcher());
        rmDispatcher.register(NodesListManagerEventType.class, (EventHandler)new TestNodeListManagerEventDispatcher());
        NodeId nodeId = BuilderUtils.newNodeId((String)"localhost", (int)0);
        this.nodesListManagerEvent = null;
    }

    @Test(timeout=200000L)
    public void testUpdateHeartbeatResponseForCleanup() throws Exception {
        RMNodeImpl node = this.getRunningNode();
        NodeId nodeId = node.getNodeID();
        ContainerId completedContainerId = BuilderUtils.newContainerId((ApplicationAttemptId)BuilderUtils.newApplicationAttemptId((ApplicationId)BuilderUtils.newApplicationId((long)0L, (int)0), (int)0), (long)0L);
        node.handle((Event)new RMNodeCleanContainerEvent(nodeId, completedContainerId));
        Assert.assertEquals((long)1L, (long)node.getContainersToCleanUp().size());
        Assert.assertEquals((long)1L, (long)DBUtilityTests.getAllContainersToCleanUp().size());
        Assert.assertEquals((long)1L, (long)DBUtilityTests.getAllContainersToCleanUp().get(node.getNodeID().toString()).size());
        Assert.assertEquals((long)1L, (long)DBUtilityTests.getAllNextHeartbeat().size());
        ApplicationId finishedAppId = BuilderUtils.newApplicationId((long)0L, (int)1);
        node.handle((Event)new RMNodeCleanAppEvent(nodeId, finishedAppId));
        Assert.assertEquals((long)1L, (long)node.getAppsToCleanup().size());
        Thread.sleep(500L);
        Assert.assertEquals((long)1L, (long)DBUtilityTests.getAllAppsToCleanup().size());
        Assert.assertEquals((long)1L, (long)DBUtilityTests.getAllAppsToCleanup().get(node.getNodeID().toString()).size());
        RMNodeStatusEvent statusEvent = this.getMockRMNodeStatusEvent();
        node.handle((Event)statusEvent);
        Assert.assertEquals((long)1L, (long)node.getContainersToCleanUp().size());
        Assert.assertEquals((long)1L, (long)node.getAppsToCleanup().size());
        Assert.assertEquals((long)1L, (long)DBUtilityTests.getAllContainersToCleanUp().size());
        Assert.assertEquals((long)1L, (long)DBUtilityTests.getAllContainersToCleanUp().get(node.getNodeID().toString()).size());
        Assert.assertEquals((long)1L, (long)DBUtilityTests.getAllAppsToCleanup().size());
        Assert.assertEquals((long)1L, (long)DBUtilityTests.getAllAppsToCleanup().get(node.getNodeID().toString()).size());
        Assert.assertEquals((long)0L, (long)DBUtilityTests.getAllNextHeartbeat().size());
        NodeHeartbeatResponse hbrsp = (NodeHeartbeatResponse)Records.newRecord(NodeHeartbeatResponse.class);
        node.updateNodeHeartbeatResponseForCleanup(hbrsp);
        Assert.assertEquals((long)0L, (long)node.getContainersToCleanUp().size());
        Assert.assertEquals((long)0L, (long)node.getAppsToCleanup().size());
        Assert.assertEquals((long)1L, (long)hbrsp.getContainersToCleanup().size());
        Assert.assertEquals((Object)completedContainerId, hbrsp.getContainersToCleanup().get(0));
        Assert.assertEquals((long)1L, (long)hbrsp.getApplicationsToCleanup().size());
        Assert.assertEquals((Object)finishedAppId, hbrsp.getApplicationsToCleanup().get(0));
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)DBUtilityTests.getAllContainersToCleanUp().size());
        Assert.assertEquals((long)0L, (long)DBUtilityTests.getAllAppsToCleanup().size());
    }

    private RMNodeImpl getRunningNode() {
        return this.getRunningNode(null);
    }

    private RMNodeImpl getRunningNode(String nmVersion) {
        NodeId nodeId = BuilderUtils.newNodeId((String)"localhost", (int)0);
        Resource capability = Resource.newInstance((int)4096, (int)4);
        RMNodeImplDist node = new RMNodeImplDist(nodeId, this.rmContext, null, 0, 0, null, capability, nmVersion);
        node.handle((Event)new RMNodeStartedEvent(node.getNodeID(), null, null));
        Assert.assertEquals((Object)NodeState.RUNNING, (Object)node.getState());
        return node;
    }

    private RMNodeStatusEvent getMockRMNodeStatusEvent() {
        NodeHeartbeatResponse response = (NodeHeartbeatResponse)Mockito.mock(NodeHeartbeatResponse.class);
        NodeHealthStatus healthStatus = (NodeHealthStatus)Mockito.mock(NodeHealthStatus.class);
        Boolean yes = new Boolean(true);
        ((NodeHealthStatus)Mockito.doReturn((Object)yes).when((Object)healthStatus)).getIsNodeHealthy();
        RMNodeStatusEvent event = (RMNodeStatusEvent)Mockito.mock(RMNodeStatusEvent.class);
        ((RMNodeStatusEvent)Mockito.doReturn((Object)healthStatus).when((Object)event)).getNodeHealthStatus();
        ((RMNodeStatusEvent)Mockito.doReturn((Object)response).when((Object)event)).getLatestResponse();
        ((RMNodeStatusEvent)Mockito.doReturn((Object)RMNodeEventType.STATUS_UPDATE).when((Object)event)).getType();
        return event;
    }

    private class TestNodeListManagerEventDispatcher
    implements EventHandler<NodesListManagerEvent> {
        private TestNodeListManagerEventDispatcher() {
        }

        public void handle(NodesListManagerEvent event) {
            TestDistributedScheduler.this.nodesListManagerEvent = event;
        }
    }

    private final class TestSchedulerEventDispatcher
    implements EventHandler<SchedulerEvent> {
        private TestSchedulerEventDispatcher() {
        }

        public void handle(SchedulerEvent event) {
            TestDistributedScheduler.this.scheduler.handle((Event)event);
        }
    }
}

