/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.nodelabels;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.event.InlineDispatcher;
import org.apache.hadoop.yarn.nodelabels.NodeLabelTestBase;
import org.apache.hadoop.yarn.nodelabels.RMNodeLabel;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.NullRMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeLabelsUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestRMNodeLabelsManager
extends NodeLabelTestBase {
    private final Resource EMPTY_RESOURCE = Resource.newInstance((int)0, (int)0);
    private final Resource SMALL_RESOURCE = Resource.newInstance((int)100, (int)0);
    private final Resource LARGE_NODE = Resource.newInstance((int)1000, (int)0);
    NullRMNodeLabelsManager mgr = null;
    RMNodeLabelsManager lmgr = null;
    boolean checkQueueCall = false;

    @Before
    public void before() throws IOException {
        this.mgr = new NullRMNodeLabelsManager();
        Configuration conf = new Configuration();
        conf.setBoolean("yarn.node-labels.enabled", true);
        RMStorageFactory.setConfiguration((Configuration)conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)conf);
        DBUtility.InitializeDB();
        this.mgr.init(conf);
        this.mgr.start();
    }

    @After
    public void after() {
        this.mgr.stop();
    }

    @Test(timeout=5000L)
    public void testGetLabelResourceWhenNodeActiveDeactive() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1", "p2", "p3"}));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"}), (Object)this.toNodeId("n2"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"}), (Object)this.toNodeId("n3"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p3"})));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p1", null), (Object)this.EMPTY_RESOURCE);
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p2", null), (Object)this.EMPTY_RESOURCE);
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p3", null), (Object)this.EMPTY_RESOURCE);
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("", null), (Object)this.EMPTY_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)1), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)2), this.LARGE_NODE);
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p1", null), (Object)Resources.add((Resource)this.SMALL_RESOURCE, (Resource)this.LARGE_NODE));
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1", "p4"}));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p1", null), (Object)Resources.add((Resource)this.SMALL_RESOURCE, (Resource)this.LARGE_NODE));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p4", null), (Object)this.EMPTY_RESOURCE);
        this.mgr.updateNodeResource(NodeId.newInstance((String)"n1", (int)2), this.SMALL_RESOURCE);
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p1", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0));
        this.mgr.deactivateNode(NodeId.newInstance((String)"n1", (int)1));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p1", null), (Object)this.SMALL_RESOURCE);
        this.mgr.deactivateNode(NodeId.newInstance((String)"n1", (int)2));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p1", null), (Object)this.EMPTY_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)1), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)2), this.LARGE_NODE);
        this.mgr.removeFromClusterNodeLabels((Collection)ImmutableSet.of((Object)"p1"));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("", null), (Object)Resources.add((Resource)this.SMALL_RESOURCE, (Resource)this.LARGE_NODE));
    }

    @Test(timeout=5000L)
    public void testActivateNodeManagerWithZeroPort() throws Exception {
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)0), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)2), this.LARGE_NODE);
    }

    @Test(timeout=5000L)
    public void testGetLabelResource() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1", "p2", "p3"}));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"}), (Object)this.toNodeId("n2"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"}), (Object)this.toNodeId("n3"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p3"})));
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)1), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n2", (int)1), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n3", (int)1), this.SMALL_RESOURCE);
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"})));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p1", null), (Object)this.EMPTY_RESOURCE);
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p2", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p3", null), (Object)this.SMALL_RESOURCE);
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestRMNodeLabelsManager.toSet((Object[])new String[]{"p4", "p5", "p6"}));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n4"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"}), (Object)this.toNodeId("n5"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"}), (Object)this.toNodeId("n6"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p3"}), (Object)this.toNodeId("n7"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p4"}), (Object)this.toNodeId("n8"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p5"})));
        this.mgr.activateNode(NodeId.newInstance((String)"n4", (int)1), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n5", (int)1), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n6", (int)1), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n7", (int)1), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n8", (int)1), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n9", (int)1), this.SMALL_RESOURCE);
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p1", null), (Object)this.SMALL_RESOURCE);
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p2", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)3.0));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p3", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p4", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)1.0));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p5", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)1.0));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)1.0));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n4"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"}), (Object)this.toNodeId("n7"), (Object)RMNodeLabelsManager.EMPTY_STRING_SET, (Object)this.toNodeId("n5"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"}), (Object)this.toNodeId("n8"), (Object)RMNodeLabelsManager.EMPTY_STRING_SET, (Object)this.toNodeId("n9"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"})));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p1", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p2", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)3.0));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p3", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p4", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)0.0));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p5", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)0.0));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0));
    }

    @Test(timeout=5000L)
    public void testGetQueueResource() throws Exception {
        Resource clusterResource = Resource.newInstance((int)9999, (int)1);
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestRMNodeLabelsManager.toSet((Object[])new String[]{"red", "blue", "yellow"}));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("host1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"red"})));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("host2"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"blue"})));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("host3"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"yellow"})));
        this.mgr.activateNode(NodeId.newInstance((String)"host1", (int)1), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"host2", (int)1), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"host3", (int)1), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"host4", (int)1), this.SMALL_RESOURCE);
        Set q1Label = TestRMNodeLabelsManager.toSet((Object[])new String[]{"red", "blue"});
        Set q2Label = TestRMNodeLabelsManager.toSet((Object[])new String[]{"blue", "yellow"});
        Set q3Label = TestRMNodeLabelsManager.toSet((Object[])new String[]{"yellow"});
        Set q4Label = RMNodeLabelsManager.EMPTY_STRING_SET;
        Set q5Label = TestRMNodeLabelsManager.toSet((Object[])new String[]{"*"});
        HashMap<String, Set> queueToLabels = new HashMap<String, Set>();
        queueToLabels.put("Q1", q1Label);
        queueToLabels.put("Q2", q2Label);
        queueToLabels.put("Q3", q3Label);
        queueToLabels.put("Q4", q4Label);
        queueToLabels.put("Q5", q5Label);
        this.mgr.reinitializeQueueLabels(queueToLabels);
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)3.0), (Object)this.mgr.getQueueResource("Q1", q1Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)3.0), (Object)this.mgr.getQueueResource("Q2", q2Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0), (Object)this.mgr.getQueueResource("Q3", q3Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)1.0), (Object)this.mgr.getQueueResource("Q4", q4Label, clusterResource));
        Assert.assertEquals((Object)clusterResource, (Object)this.mgr.getQueueResource("Q5", q5Label, clusterResource));
        this.mgr.removeLabelsFromNode((Map)ImmutableMap.of((Object)this.toNodeId("host2"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"blue"})));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)3.0), (Object)this.mgr.getQueueResource("Q1", q1Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)3.0), (Object)this.mgr.getQueueResource("Q2", q2Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)3.0), (Object)this.mgr.getQueueResource("Q3", q3Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0), (Object)this.mgr.getQueueResource("Q4", q4Label, clusterResource));
        Assert.assertEquals((Object)clusterResource, (Object)this.mgr.getQueueResource("Q5", q5Label, clusterResource));
        this.mgr.deactivateNode(NodeId.newInstance((String)"host1", (int)1));
        this.mgr.deactivateNode(NodeId.newInstance((String)"host3", (int)1));
        this.mgr.activateNode(NodeId.newInstance((String)"host3", (int)1), this.SMALL_RESOURCE);
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0), (Object)this.mgr.getQueueResource("Q1", q1Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)3.0), (Object)this.mgr.getQueueResource("Q2", q2Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)3.0), (Object)this.mgr.getQueueResource("Q3", q3Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0), (Object)this.mgr.getQueueResource("Q4", q4Label, clusterResource));
        Assert.assertEquals((Object)clusterResource, (Object)this.mgr.getQueueResource("Q5", q5Label, clusterResource));
        q1Label = TestRMNodeLabelsManager.toSet((Object[])new String[]{"blue"});
        q2Label = TestRMNodeLabelsManager.toSet((Object[])new String[]{"blue", "red"});
        q3Label = TestRMNodeLabelsManager.toSet((Object[])new String[]{"red"});
        q4Label = RMNodeLabelsManager.EMPTY_STRING_SET;
        q5Label = TestRMNodeLabelsManager.toSet((Object[])new String[]{"*"});
        queueToLabels.clear();
        queueToLabels.put("Q1", q1Label);
        queueToLabels.put("Q2", q2Label);
        queueToLabels.put("Q3", q3Label);
        queueToLabels.put("Q4", q4Label);
        queueToLabels.put("Q5", q5Label);
        this.mgr.reinitializeQueueLabels(queueToLabels);
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0), (Object)this.mgr.getQueueResource("Q1", q1Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0), (Object)this.mgr.getQueueResource("Q2", q2Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0), (Object)this.mgr.getQueueResource("Q3", q3Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0), (Object)this.mgr.getQueueResource("Q4", q4Label, clusterResource));
        Assert.assertEquals((Object)clusterResource, (Object)this.mgr.getQueueResource("Q5", q5Label, clusterResource));
        this.mgr.activateNode(NodeId.newInstance((String)"host3", (int)2), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"host3", (int)3), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"host4", (int)2), this.SMALL_RESOURCE);
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)3.0), (Object)this.mgr.getQueueResource("Q1", q1Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)3.0), (Object)this.mgr.getQueueResource("Q2", q2Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)3.0), (Object)this.mgr.getQueueResource("Q3", q3Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)3.0), (Object)this.mgr.getQueueResource("Q4", q4Label, clusterResource));
        Assert.assertEquals((Object)clusterResource, (Object)this.mgr.getQueueResource("Q5", q5Label, clusterResource));
        this.mgr.deactivateNode(NodeId.newInstance((String)"host3", (int)3));
        this.mgr.deactivateNode(NodeId.newInstance((String)"host4", (int)2));
        this.mgr.deactivateNode(NodeId.newInstance((String)"host4", (int)1));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)1.0), (Object)this.mgr.getQueueResource("Q1", q1Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)1.0), (Object)this.mgr.getQueueResource("Q2", q2Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)1.0), (Object)this.mgr.getQueueResource("Q3", q3Label, clusterResource));
        Assert.assertEquals((Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)1.0), (Object)this.mgr.getQueueResource("Q4", q4Label, clusterResource));
        Assert.assertEquals((Object)clusterResource, (Object)this.mgr.getQueueResource("Q5", q5Label, clusterResource));
    }

    @Test(timeout=5000L)
    public void testGetLabelResourceWhenMultipleNMsExistingInSameHost() throws IOException {
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)1), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)2), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)3), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)4), this.SMALL_RESOURCE);
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)4.0));
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"}));
        this.mgr.addLabelsToNode((Map)ImmutableMap.of((Object)this.toNodeId("n1:1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"}), (Object)this.toNodeId("n1:2"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"})));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0));
        Assert.assertEquals((Object)this.mgr.getResourceByLabel("p1", null), (Object)Resources.multiply((Resource)this.SMALL_RESOURCE, (double)2.0));
    }

    @Test(timeout=5000L)
    public void testRemoveLabelsFromNode() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1", "p2", "p3"}));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"}), (Object)this.toNodeId("n2"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"}), (Object)this.toNodeId("n3"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p3"})));
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)1), this.SMALL_RESOURCE);
        try {
            this.mgr.removeLabelsFromNode((Map)ImmutableMap.of((Object)this.toNodeId("n1:1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"})));
            Assert.fail((String)"removeLabelsFromNode should trigger IOException");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1:1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"})));
        try {
            this.mgr.removeLabelsFromNode((Map)ImmutableMap.of((Object)this.toNodeId("n1:1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"})));
        }
        catch (IOException e) {
            Assert.fail((String)("IOException from removeLabelsFromNode " + e));
        }
    }

    @Test
    public void testReplaceLabelsFromNode() throws Exception {
        RMContext rmContext = (RMContext)Mockito.mock(RMContext.class);
        InlineDispatcher syncDispatcher = new InlineDispatcher();
        SchedulerEventHandler schedEventsHandler = new SchedulerEventHandler();
        syncDispatcher.register(SchedulerEventType.class, (EventHandler)schedEventsHandler);
        Mockito.when((Object)rmContext.getDispatcher()).thenReturn((Object)syncDispatcher);
        this.mgr.setRMContext(rmContext);
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1", "p2", "p3"}));
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)1), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n2", (int)1), this.SMALL_RESOURCE);
        this.mgr.activateNode(NodeId.newInstance((String)"n3", (int)1), this.SMALL_RESOURCE);
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1:1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"}), (Object)this.toNodeId("n2:1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"}), (Object)this.toNodeId("n3"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p3"})));
        Assert.assertTrue((String)"Event should be sent when there is change in labels", (boolean)schedEventsHandler.receivedEvent);
        Assert.assertEquals((String)"3 node label mapping modified", (long)3L, (long)schedEventsHandler.updatedNodeToLabels.size());
        ImmutableMap modifiedMap = ImmutableMap.of((Object)this.toNodeId("n1:1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"}), (Object)this.toNodeId("n2:1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"}), (Object)this.toNodeId("n3:1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p3"}));
        Assert.assertEquals((String)"Node label mapping is not matching", (Object)modifiedMap, schedEventsHandler.updatedNodeToLabels);
        schedEventsHandler.receivedEvent = false;
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1:1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"})));
        Assert.assertFalse((String)"No event should be sent when there is no change in labels", (boolean)schedEventsHandler.receivedEvent);
        schedEventsHandler.receivedEvent = false;
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n2:1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"}), (Object)this.toNodeId("n3"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p3"})));
        Assert.assertTrue((String)"Event should be sent when there is change in labels", (boolean)schedEventsHandler.receivedEvent);
        Assert.assertEquals((String)"Single node label mapping modified", (long)1L, (long)schedEventsHandler.updatedNodeToLabels.size());
        TestRMNodeLabelsManager.assertCollectionEquals((Collection)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"}), (Collection)schedEventsHandler.updatedNodeToLabels.get(this.toNodeId("n2:1")));
        schedEventsHandler.receivedEvent = false;
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n3"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"})));
        Assert.assertTrue((String)"Event should be sent when there is change in labels @ HOST", (boolean)schedEventsHandler.receivedEvent);
        Assert.assertEquals((String)"Single node label mapping modified", (long)1L, (long)schedEventsHandler.updatedNodeToLabels.size());
        TestRMNodeLabelsManager.assertCollectionEquals((Collection)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"}), (Collection)schedEventsHandler.updatedNodeToLabels.get(this.toNodeId("n3:1")));
        schedEventsHandler.receivedEvent = false;
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"})));
        Assert.assertTrue((String)"Event should be sent when labels are modified at host though labels were set @ NM level", (boolean)schedEventsHandler.receivedEvent);
        Assert.assertEquals((String)"Single node label mapping modified", (long)1L, (long)schedEventsHandler.updatedNodeToLabels.size());
        TestRMNodeLabelsManager.assertCollectionEquals((Collection)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"}), (Collection)schedEventsHandler.updatedNodeToLabels.get(this.toNodeId("n1:1")));
        schedEventsHandler.receivedEvent = false;
    }

    @Test(timeout=5000L)
    public void testGetLabelsOnNodesWhenNodeActiveDeactive() throws Exception {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1", "p2", "p3"}));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"})));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1:1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"})));
        this.mgr.activateNode(this.toNodeId("n1:1"), this.SMALL_RESOURCE);
        TestRMNodeLabelsManager.assertCollectionEquals((Collection)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"}), (Collection)((Collection)this.mgr.getNodeLabels().get(this.toNodeId("n1:1"))));
        this.mgr.deactivateNode(this.toNodeId("n1:1"));
        TestRMNodeLabelsManager.assertCollectionEquals((Collection)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"}), (Collection)((Collection)this.mgr.getNodeLabels().get(this.toNodeId("n1:1"))));
        TestRMNodeLabelsManager.assertCollectionEquals((Collection)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"}), (Collection)((Collection)this.mgr.getNodeLabels().get(this.toNodeId("n1"))));
        this.mgr.activateNode(this.toNodeId("n1:2"), this.SMALL_RESOURCE);
        TestRMNodeLabelsManager.assertCollectionEquals((Collection)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"}), (Collection)((Collection)this.mgr.getNodeLabels().get(this.toNodeId("n1:2"))));
        this.mgr.deactivateNode(this.toNodeId("n1:2"));
        Assert.assertNull(this.mgr.getNodeLabels().get(this.toNodeId("n1:2")));
        TestRMNodeLabelsManager.assertCollectionEquals((Collection)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p2"}), (Collection)((Collection)this.mgr.getNodeLabels().get(this.toNodeId("n1"))));
        this.mgr.activateNode(this.toNodeId("n1:2"), this.SMALL_RESOURCE);
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p3"})));
        TestRMNodeLabelsManager.assertCollectionEquals((Collection)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p3"}), (Collection)((Collection)this.mgr.getNodeLabels().get(this.toNodeId("n1:2"))));
        this.mgr.deactivateNode(this.toNodeId("n1:2"));
        Assert.assertNull(this.mgr.getNodeLabels().get(this.toNodeId("n1:2")));
        TestRMNodeLabelsManager.assertCollectionEquals((Collection)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p3"}), (Collection)((Collection)this.mgr.getNodeLabels().get(this.toNodeId("n1"))));
    }

    private void checkNodeLabelInfo(List<RMNodeLabel> infos, String labelName, int activeNMs, int memory) {
        for (RMNodeLabel info : infos) {
            if (!info.getLabelName().equals(labelName)) continue;
            Assert.assertEquals((long)activeNMs, (long)info.getNumActiveNMs());
            Assert.assertEquals((long)memory, (long)info.getResource().getMemorySize());
            return;
        }
        Assert.fail((String)("Failed to find info has label=" + labelName));
    }

    @Test(timeout=5000L)
    public void testPullRMNodeLabelsInfo() throws IOException {
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestRMNodeLabelsManager.toSet((Object[])new String[]{"x", "y", "z"}));
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)1), Resource.newInstance((int)10, (int)0));
        this.mgr.activateNode(NodeId.newInstance((String)"n2", (int)1), Resource.newInstance((int)10, (int)0));
        this.mgr.activateNode(NodeId.newInstance((String)"n3", (int)1), Resource.newInstance((int)10, (int)0));
        this.mgr.activateNode(NodeId.newInstance((String)"n4", (int)1), Resource.newInstance((int)10, (int)0));
        this.mgr.activateNode(NodeId.newInstance((String)"n5", (int)1), Resource.newInstance((int)10, (int)0));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"x"}), (Object)this.toNodeId("n2"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"x"}), (Object)this.toNodeId("n3"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"y"})));
        List infos = this.mgr.pullRMNodeLabelsInfo();
        Assert.assertEquals((long)4L, (long)infos.size());
        this.checkNodeLabelInfo(infos, "", 2, 20);
        this.checkNodeLabelInfo(infos, "x", 2, 20);
        this.checkNodeLabelInfo(infos, "y", 1, 10);
        this.checkNodeLabelInfo(infos, "z", 0, 0);
    }

    @Test(timeout=60000L)
    public void testcheckRemoveFromClusterNodeLabelsOfQueue() throws Exception {
        this.lmgr = new RMNodeLabelsManager();
        Configuration conf = new Configuration();
        File tempDir = File.createTempFile("nlb", ".tmp");
        tempDir.delete();
        tempDir.mkdirs();
        tempDir.deleteOnExit();
        conf.set("yarn.node-labels.fs-store.root-dir", tempDir.getAbsolutePath());
        conf.setBoolean("yarn.node-labels.enabled", true);
        conf.set("yarn.resourcemanager.scheduler.class", "org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler");
        Configuration withQueueLabels = this.getConfigurationWithQueueLabels(conf);
        MockRM rm = this.initRM(conf);
        this.lmgr.addToCluserNodeLabels((Collection)TestRMNodeLabelsManager.toSet((Object[])new NodeLabel[]{NodeLabel.newInstance((String)"x", (boolean)false)}));
        this.lmgr.removeFromClusterNodeLabels(Arrays.asList("x"));
        this.lmgr.addToCluserNodeLabelsWithDefaultExclusivity(TestRMNodeLabelsManager.toSet((Object[])new String[]{"x"}));
        rm.stop();
        class TestRMLabelManger
        extends RMNodeLabelsManager {
            TestRMLabelManger() {
            }

            protected void checkRemoveFromClusterNodeLabelsOfQueue(Collection<String> labelsToRemove) throws IOException {
                TestRMNodeLabelsManager.this.checkQueueCall = true;
            }
        }
        this.lmgr = new TestRMLabelManger();
        MockRM rm2 = this.initRM(withQueueLabels);
        Assert.assertFalse((String)"checkRemoveFromClusterNodeLabelsOfQueue should not be calledon recovery", (boolean)this.checkQueueCall);
        this.lmgr.removeFromClusterNodeLabels(Arrays.asList("x"));
        Assert.assertTrue((String)"checkRemoveFromClusterNodeLabelsOfQueue should be called since its not recovery", (boolean)this.checkQueueCall);
        rm2.stop();
    }

    private MockRM initRM(Configuration conf) {
        MockRM rm = new MockRM(conf){

            @Override
            public RMNodeLabelsManager createNodeLabelManager() {
                return TestRMNodeLabelsManager.this.lmgr;
            }
        };
        rm.getRMContext().setNodeLabelManager(this.lmgr);
        rm.start();
        Assert.assertEquals((Object)Service.STATE.STARTED, (Object)rm.getServiceState());
        return rm;
    }

    private Configuration getConfigurationWithQueueLabels(Configuration config) {
        CapacitySchedulerConfiguration conf = new CapacitySchedulerConfiguration(config);
        conf.setQueues("root", new String[]{"a"});
        conf.setCapacityByLabel("root", "x", 100.0f);
        String A = "root.a";
        conf.setCapacity("root.a", 100.0f);
        conf.setAccessibleNodeLabels("root.a", (Set)ImmutableSet.of((Object)"x"));
        conf.setCapacityByLabel("root.a", "x", 100.0f);
        return conf;
    }

    @Test(timeout=5000L)
    public void testLabelsToNodesOnNodeActiveDeactive() throws Exception {
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)1), Resource.newInstance((int)10, (int)0));
        Assert.assertTrue((boolean)this.mgr.getLabelsToNodes().isEmpty());
        TestRMNodeLabelsManager.assertLabelsToNodesEquals((Map)this.mgr.getLabelsToNodes(), (ImmutableMap)TestRMNodeLabelsManager.transposeNodeToLabels((Map)this.mgr.getNodeLabels()));
        this.mgr.addToCluserNodeLabelsWithDefaultExclusivity(TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"}));
        this.mgr.replaceLabelsOnNode((Map)ImmutableMap.of((Object)this.toNodeId("n1"), (Object)TestRMNodeLabelsManager.toSet((Object[])new String[]{"p1"})));
        Assert.assertEquals((long)2L, (long)((Set)this.mgr.getLabelsToNodes().get("p1")).size());
        TestRMNodeLabelsManager.assertLabelsToNodesEquals((Map)this.mgr.getLabelsToNodes(), (ImmutableMap)TestRMNodeLabelsManager.transposeNodeToLabels((Map)this.mgr.getNodeLabels()));
        this.mgr.activateNode(NodeId.newInstance((String)"n1", (int)2), Resource.newInstance((int)10, (int)0));
        Assert.assertEquals((long)3L, (long)((Set)this.mgr.getLabelsToNodes().get("p1")).size());
        TestRMNodeLabelsManager.assertLabelsToNodesEquals((Map)this.mgr.getLabelsToNodes(), (ImmutableMap)TestRMNodeLabelsManager.transposeNodeToLabels((Map)this.mgr.getNodeLabels()));
        this.mgr.deactivateNode(NodeId.newInstance((String)"n1", (int)1));
        Assert.assertEquals((long)2L, (long)((Set)this.mgr.getLabelsToNodes().get("p1")).size());
        TestRMNodeLabelsManager.assertLabelsToNodesEquals((Map)this.mgr.getLabelsToNodes(), (ImmutableMap)TestRMNodeLabelsManager.transposeNodeToLabels((Map)this.mgr.getNodeLabels()));
    }

    private static class SchedulerEventHandler
    implements EventHandler<SchedulerEvent> {
        Map<NodeId, Set<String>> updatedNodeToLabels = new HashMap<NodeId, Set<String>>();
        boolean receivedEvent;

        private SchedulerEventHandler() {
        }

        public void handle(SchedulerEvent event) {
            switch ((SchedulerEventType)event.getType()) {
                case NODE_LABELS_UPDATE: {
                    this.receivedEvent = true;
                    this.updatedNodeToLabels = ((NodeLabelsUpdateSchedulerEvent)event).getUpdatedNodeToLabels();
                    break;
                }
            }
        }
    }
}

