/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.DBRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStoreTestBase;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.junit.Before;
import org.junit.Test;

public class TestDBRMStateStore
extends RMStateStoreTestBase {
    private DBRMStateStore stateStore = null;
    private YarnConfiguration conf;

    @Before
    public void setup() throws IOException {
        this.conf = new YarnConfiguration();
        YarnAPIStorageFactory.setConfiguration((Configuration)this.conf);
        RMStorageFactory.setConfiguration((Configuration)this.conf);
        DBUtility.InitializeDB();
    }

    @Test(timeout=60000L)
    public void testApps() throws Exception {
        dbStateStoreTester tester = new dbStateStoreTester();
        this.testRMAppStateStore(tester);
    }

    @Test(timeout=60000L)
    public void testClientTokens() throws Exception {
        dbStateStoreTester tester = new dbStateStoreTester();
        this.testRMDTSecretManagerStateStore(tester);
    }

    @Test(timeout=60000L)
    public void testVersion() throws Exception {
        dbStateStoreTester tester = new dbStateStoreTester();
        this.testCheckVersion(tester);
    }

    @Test(timeout=60000L)
    public void testEpoch() throws Exception {
        dbStateStoreTester tester = new dbStateStoreTester();
        this.testEpoch(tester);
    }

    @Test(timeout=60000L)
    public void testAppDeletion() throws Exception {
        dbStateStoreTester tester = new dbStateStoreTester();
        this.testAppDeletion(tester);
    }

    @Test(timeout=60000L)
    public void testDeleteStore() throws Exception {
        dbStateStoreTester tester = new dbStateStoreTester();
        this.testDeleteStore(tester);
    }

    @Test(timeout=60000L)
    public void testAMTokens() throws Exception {
        dbStateStoreTester tester = new dbStateStoreTester();
        this.testAMRMTokenSecretManagerStateStore(tester);
    }

    class dbStateStoreTester
    implements RMStateStoreTestBase.RMStateStoreHelper {
        dbStateStoreTester() {
        }

        @Override
        public RMStateStore getRMStateStore() throws Exception {
            if (TestDBRMStateStore.this.stateStore != null) {
                TestDBRMStateStore.this.stateStore.close();
            }
            TestDBRMStateStore.this.stateStore = new DBRMStateStore();
            TestDBRMStateStore.this.stateStore.init((Configuration)TestDBRMStateStore.this.conf);
            TestDBRMStateStore.this.stateStore.start();
            return TestDBRMStateStore.this.stateStore;
        }

        @Override
        public boolean isFinalStateValid() throws Exception {
            return TestDBRMStateStore.this.stateStore.getNumEntriesInDatabase() == 5;
        }

        @Override
        public void writeVersion(Version version) throws Exception {
            byte[] versionDb = ((VersionPBImpl)version).getProto().toByteArray();
            TestDBRMStateStore.this.stateStore.storeVersiondb(versionDb);
        }

        @Override
        public Version getCurrentVersion() throws Exception {
            return TestDBRMStateStore.this.stateStore.getCurrentVersion();
        }

        @Override
        public boolean appExists(RMApp app) throws Exception {
            return TestDBRMStateStore.this.stateStore.loadRMAppState(app.getApplicationId()) != null;
        }
    }
}

