/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.ApplicationMasterService;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManagerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMContextImpl;
import org.apache.hadoop.yarn.server.resourcemanager.ahs.RMApplicationHistoryWriter;
import org.apache.hadoop.yarn.server.resourcemanager.metrics.SystemMetricsPublisher;
import org.apache.hadoop.yarn.server.resourcemanager.placement.PlacementManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.MockRMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.AMLivelinessMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.ContainerAllocationExpirer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.ClientToAMTokenSecretManagerInRM;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class TestAppManager {
    private Log LOG = LogFactory.getLog(TestAppManager.class);
    private static RMAppEventType appEventType = RMAppEventType.KILL;
    private RMContext rmContext;
    private SystemMetricsPublisher metricsPublisher;
    private TestRMAppManager appMonitor;
    private ApplicationSubmissionContext asContext;
    private ApplicationId appId;

    public synchronized RMAppEventType getAppEventType() {
        return appEventType;
    }

    public synchronized void setAppEventType(RMAppEventType newType) {
        appEventType = newType;
    }

    public static List<RMApp> newRMApps(int n, long time, RMAppState state) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < n; ++i) {
            list.add(new MockRMApp(i, time, state));
        }
        return list;
    }

    public RMContext mockRMContext(int n, long time) {
        List<RMApp> apps = TestAppManager.newRMApps(n, time, RMAppState.FINISHED);
        final ConcurrentMap map = Maps.newConcurrentMap();
        for (RMApp app : apps) {
            map.put(app.getApplicationId(), app);
        }
        AsyncDispatcher rmDispatcher = new AsyncDispatcher();
        ContainerAllocationExpirer containerAllocationExpirer = new ContainerAllocationExpirer((Dispatcher)rmDispatcher);
        AMLivelinessMonitor amLivelinessMonitor = new AMLivelinessMonitor((Dispatcher)rmDispatcher);
        AMLivelinessMonitor amFinishingMonitor = new AMLivelinessMonitor((Dispatcher)rmDispatcher);
        RMApplicationHistoryWriter writer = (RMApplicationHistoryWriter)Mockito.mock(RMApplicationHistoryWriter.class);
        RMContextImpl context = new RMContextImpl((Dispatcher)rmDispatcher, containerAllocationExpirer, amLivelinessMonitor, amFinishingMonitor, null, null, null, null, null){

            public ConcurrentMap<ApplicationId, RMApp> getRMApps() {
                return map;
            }
        };
        ((RMContextImpl)context).setStateStore((RMStateStore)Mockito.mock(RMStateStore.class));
        this.metricsPublisher = (SystemMetricsPublisher)Mockito.mock(SystemMetricsPublisher.class);
        context.setSystemMetricsPublisher(this.metricsPublisher);
        context.setRMApplicationHistoryWriter(writer);
        return context;
    }

    protected void addToCompletedApps(TestRMAppManager appMonitor, RMContext rmContext) {
        for (RMApp app : rmContext.getRMApps().values()) {
            if (app.getState() != RMAppState.FINISHED && app.getState() != RMAppState.KILLED && app.getState() != RMAppState.FAILED) continue;
            appMonitor.finishApplication(app.getApplicationId());
        }
    }

    @Before
    public void setUp() {
        long now = System.currentTimeMillis();
        this.rmContext = this.mockRMContext(1, now - 10L);
        ResourceScheduler scheduler = TestAppManager.mockResourceScheduler();
        ((RMContextImpl)this.rmContext).setScheduler(scheduler);
        Configuration conf = new Configuration();
        ApplicationMasterService masterService = new ApplicationMasterService(this.rmContext, (YarnScheduler)scheduler);
        this.appMonitor = new TestRMAppManager(this.rmContext, new ClientToAMTokenSecretManagerInRM(), (YarnScheduler)scheduler, masterService, new ApplicationACLsManager(conf), conf);
        this.appId = MockApps.newAppID((int)1);
        RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
        this.asContext = (ApplicationSubmissionContext)recordFactory.newRecordInstance(ApplicationSubmissionContext.class);
        this.asContext.setApplicationId(this.appId);
        this.asContext.setAMContainerSpec(TestAppManager.mockContainerLaunchContext(recordFactory));
        this.asContext.setResource(TestAppManager.mockResource());
        this.setupDispatcher(this.rmContext, conf);
    }

    @After
    public void tearDown() {
        this.setAppEventType(RMAppEventType.KILL);
        ((Service)this.rmContext.getDispatcher()).stop();
    }

    @Test
    public void testRMAppRetireNone() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 10L);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.max-completed-applications", 10);
        TestRMAppManager appMonitor = new TestRMAppManager(rmContext, (Configuration)conf);
        Assert.assertEquals((String)"Number of apps incorrect before checkAppTimeLimit", (long)10L, (long)rmContext.getRMApps().size());
        this.addToCompletedApps(appMonitor, rmContext);
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)10L, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)10L, (long)appMonitor.getCompletedAppsListSize());
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.never())).removeApplication((RMApp)Matchers.isA(RMApp.class));
    }

    @Test
    public void testRMAppRetireSome() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", 3);
        conf.setInt("yarn.resourcemanager.max-completed-applications", 3);
        TestRMAppManager appMonitor = new TestRMAppManager(rmContext, (Configuration)conf);
        Assert.assertEquals((String)"Number of apps incorrect before", (long)10L, (long)rmContext.getRMApps().size());
        this.addToCompletedApps(appMonitor, rmContext);
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)3L, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)3L, (long)appMonitor.getCompletedAppsListSize());
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.times((int)7))).removeApplication((RMApp)Matchers.isA(RMApp.class));
    }

    @Test
    public void testRMAppRetireSomeDifferentStates() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", 2);
        conf.setInt("yarn.resourcemanager.max-completed-applications", 2);
        TestRMAppManager appMonitor = new TestRMAppManager(rmContext, (Configuration)conf);
        rmContext.getRMApps().clear();
        Assert.assertEquals((String)"map isn't empty", (long)0L, (long)rmContext.getRMApps().size());
        MockRMApp app = new MockRMApp(0, now - 20000L, RMAppState.KILLED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(1, now - 200000L, RMAppState.FAILED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(2, now - 30000L, RMAppState.FINISHED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(3, now - 20000L, RMAppState.RUNNING);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(4, now - 20000L, RMAppState.NEW);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(5, now - 10001L, RMAppState.KILLED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(6, now - 30000L, RMAppState.ACCEPTED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(7, now - 20000L, RMAppState.SUBMITTED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(8, now - 10001L, RMAppState.FAILED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        app = new MockRMApp(9, now - 20000L, RMAppState.FAILED);
        rmContext.getRMApps().put(app.getApplicationId(), app);
        Assert.assertEquals((String)"Number of apps incorrect before", (long)10L, (long)rmContext.getRMApps().size());
        this.addToCompletedApps(appMonitor, rmContext);
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)6L, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)2L, (long)appMonitor.getCompletedAppsListSize());
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.times((int)4))).removeApplication((RMApp)Matchers.isA(RMApp.class));
    }

    @Test
    public void testRMAppRetireNullApp() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        TestRMAppManager appMonitor = new TestRMAppManager(rmContext, new Configuration());
        Assert.assertEquals((String)"Number of apps incorrect before", (long)10L, (long)rmContext.getRMApps().size());
        appMonitor.finishApplication(null);
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)0L, (long)appMonitor.getCompletedAppsListSize());
    }

    @Test
    public void testRMAppRetireZeroSetting() throws Exception {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", 0);
        conf.setInt("yarn.resourcemanager.max-completed-applications", 0);
        TestRMAppManager appMonitor = new TestRMAppManager(rmContext, (Configuration)conf);
        Assert.assertEquals((String)"Number of apps incorrect before", (long)10L, (long)rmContext.getRMApps().size());
        this.addToCompletedApps(appMonitor, rmContext);
        Assert.assertEquals((String)"Number of completed apps incorrect", (long)10L, (long)appMonitor.getCompletedAppsListSize());
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)0L, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)0L, (long)appMonitor.getCompletedAppsListSize());
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.times((int)10))).removeApplication((RMApp)Matchers.isA(RMApp.class));
    }

    @Test
    public void testStateStoreAppLimitLessThanMemoryAppLimit() {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        YarnConfiguration conf = new YarnConfiguration();
        int maxAppsInMemory = 8;
        int maxAppsInStateStore = 4;
        conf.setInt("yarn.resourcemanager.max-completed-applications", maxAppsInMemory);
        conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", maxAppsInStateStore);
        TestRMAppManager appMonitor = new TestRMAppManager(rmContext, (Configuration)conf);
        this.addToCompletedApps(appMonitor, rmContext);
        Assert.assertEquals((String)"Number of completed apps incorrect", (long)10L, (long)appMonitor.getCompletedAppsListSize());
        appMonitor.checkAppNumCompletedLimit();
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)maxAppsInMemory, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)maxAppsInMemory, (long)appMonitor.getCompletedAppsListSize());
        int numRemoveAppsFromStateStore = 10 - maxAppsInStateStore;
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.times((int)numRemoveAppsFromStateStore))).removeApplication((RMApp)Matchers.isA(RMApp.class));
        Assert.assertEquals((long)maxAppsInStateStore, (long)appMonitor.getCompletedAppsInStateStore());
    }

    @Test
    public void testStateStoreAppLimitLargerThanMemoryAppLimit() {
        long now = System.currentTimeMillis();
        RMContext rmContext = this.mockRMContext(10, now - 20000L);
        YarnConfiguration conf = new YarnConfiguration();
        int maxAppsInMemory = 8;
        conf.setInt("yarn.resourcemanager.max-completed-applications", maxAppsInMemory);
        conf.setInt("yarn.resourcemanager.state-store.max-completed-applications", 1000);
        TestRMAppManager appMonitor = new TestRMAppManager(rmContext, (Configuration)conf);
        this.addToCompletedApps(appMonitor, rmContext);
        Assert.assertEquals((String)"Number of completed apps incorrect", (long)10L, (long)appMonitor.getCompletedAppsListSize());
        appMonitor.checkAppNumCompletedLimit();
        int numRemoveApps = 10 - maxAppsInMemory;
        Assert.assertEquals((String)"Number of apps incorrect after # completed check", (long)maxAppsInMemory, (long)rmContext.getRMApps().size());
        Assert.assertEquals((String)"Number of completed apps incorrect after check", (long)maxAppsInMemory, (long)appMonitor.getCompletedAppsListSize());
        ((RMStateStore)Mockito.verify((Object)rmContext.getStateStore(), (VerificationMode)Mockito.times((int)numRemoveApps))).removeApplication((RMApp)Matchers.isA(RMApp.class));
        Assert.assertEquals((long)maxAppsInMemory, (long)appMonitor.getCompletedAppsInStateStore());
    }

    protected void setupDispatcher(RMContext rmContext, Configuration conf) {
        TestDispatcher testDispatcher = new TestDispatcher();
        TestAppManagerDispatcher testAppManagerDispatcher = new TestAppManagerDispatcher();
        rmContext.getDispatcher().register(RMAppEventType.class, (EventHandler)testDispatcher);
        rmContext.getDispatcher().register(RMAppManagerEventType.class, (EventHandler)testAppManagerDispatcher);
        ((Service)rmContext.getDispatcher()).init(conf);
        ((Service)rmContext.getDispatcher()).start();
        Assert.assertEquals((String)"app event type is wrong before", (Object)RMAppEventType.KILL, (Object)appEventType);
    }

    @Test
    public void testRMAppSubmit() throws Exception {
        this.appMonitor.submitApplication(this.asContext, "test");
        RMApp app = (RMApp)this.rmContext.getRMApps().get(this.appId);
        Assert.assertNotNull((String)"app is null", (Object)app);
        Assert.assertEquals((String)"app id doesn't match", (Object)this.appId, (Object)app.getApplicationId());
        Assert.assertEquals((String)"app state doesn't match", (Object)RMAppState.NEW, (Object)app.getState());
        ((SystemMetricsPublisher)Mockito.verify((Object)this.metricsPublisher)).appACLsUpdated((RMApp)Matchers.any(RMApp.class), (String)Matchers.any(String.class), Matchers.anyLong());
        int timeoutSecs = 0;
        while (this.getAppEventType() == RMAppEventType.KILL && timeoutSecs++ < 20) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"app event type sent is wrong", (Object)RMAppEventType.START, (Object)this.getAppEventType());
    }

    @Test
    public void testRMAppSubmitWithInvalidTokens() throws Exception {
        DataOutputBuffer dob = new DataOutputBuffer();
        ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        this.asContext.getAMContainerSpec().setTokens(securityTokens);
        try {
            this.appMonitor.submitApplication(this.asContext, "test");
            Assert.fail((String)"Application submission should fail because Tokens are invalid.");
        }
        catch (YarnException e) {
            Assert.assertTrue((String)"The thrown exception is not java.io.EOFException", (boolean)e.getMessage().contains("java.io.EOFException"));
        }
        int timeoutSecs = 0;
        while (this.getAppEventType() == RMAppEventType.KILL && timeoutSecs++ < 20) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"app event type sent is wrong", (Object)RMAppEventType.APP_REJECTED, (Object)this.getAppEventType());
        this.asContext.getAMContainerSpec().setTokens(null);
    }

    @Test
    public void testRMAppSubmitWithValidTokens() throws Exception {
        DataOutputBuffer dob = new DataOutputBuffer();
        Credentials credentials = new Credentials();
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        ByteBuffer securityTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        this.asContext.getAMContainerSpec().setTokens(securityTokens);
        this.appMonitor.submitApplication(this.asContext, "test");
        RMApp app = (RMApp)this.rmContext.getRMApps().get(this.appId);
        Assert.assertNotNull((String)"app is null", (Object)app);
        Assert.assertEquals((String)"app id doesn't match", (Object)this.appId, (Object)app.getApplicationId());
        Assert.assertEquals((String)"app state doesn't match", (Object)RMAppState.NEW, (Object)app.getState());
        ((SystemMetricsPublisher)Mockito.verify((Object)this.metricsPublisher)).appACLsUpdated((RMApp)Matchers.any(RMApp.class), (String)Matchers.any(String.class), Matchers.anyLong());
        int timeoutSecs = 0;
        while (this.getAppEventType() == RMAppEventType.KILL && timeoutSecs++ < 20) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"app event type sent is wrong", (Object)RMAppEventType.START, (Object)this.getAppEventType());
        this.asContext.getAMContainerSpec().setTokens(null);
    }

    @Test(timeout=30000L)
    public void testRMAppSubmitMaxAppAttempts() throws Exception {
        int[] globalMaxAppAttempts = new int[]{10, 1};
        int[][] individualMaxAppAttempts = new int[][]{{9, 10, 11, 0}, {1, 10, 0, -1}};
        int[][] expectedNums = new int[][]{{9, 10, 10, 10}, {1, 1, 1, 1}};
        for (int i = 0; i < globalMaxAppAttempts.length; ++i) {
            for (int j = 0; j < individualMaxAppAttempts.length; ++j) {
                ResourceScheduler scheduler = TestAppManager.mockResourceScheduler();
                Configuration conf = new Configuration();
                conf.setInt("yarn.resourcemanager.am.max-attempts", globalMaxAppAttempts[i]);
                ApplicationMasterService masterService = new ApplicationMasterService(this.rmContext, (YarnScheduler)scheduler);
                TestRMAppManager appMonitor = new TestRMAppManager(this.rmContext, new ClientToAMTokenSecretManagerInRM(), (YarnScheduler)scheduler, masterService, new ApplicationACLsManager(conf), conf);
                ApplicationId appID = MockApps.newAppID((int)(i * 4 + j + 1));
                this.asContext.setApplicationId(appID);
                if (individualMaxAppAttempts[i][j] != 0) {
                    this.asContext.setMaxAppAttempts(individualMaxAppAttempts[i][j]);
                }
                appMonitor.submitApplication(this.asContext, "test");
                RMApp app = (RMApp)this.rmContext.getRMApps().get(appID);
                Assert.assertEquals((String)"max application attempts doesn't match", (long)expectedNums[i][j], (long)app.getMaxAppAttempts());
                int timeoutSecs = 0;
                while (this.getAppEventType() == RMAppEventType.KILL && timeoutSecs++ < 20) {
                    Thread.sleep(1000L);
                }
                this.setAppEventType(RMAppEventType.KILL);
            }
        }
    }

    @Test(timeout=30000L)
    public void testRMAppSubmitDuplicateApplicationId() throws Exception {
        ApplicationId appId = MockApps.newAppID((int)0);
        this.asContext.setApplicationId(appId);
        RMApp appOrig = (RMApp)this.rmContext.getRMApps().get(appId);
        Assert.assertTrue((String)"app name matches but shouldn't", ("testApp1" != appOrig.getName() ? 1 : 0) != 0);
        try {
            this.appMonitor.submitApplication(this.asContext, "test");
            Assert.fail((String)"Exception is expected when applicationId is duplicate.");
        }
        catch (YarnException e) {
            Assert.assertTrue((String)"The thrown exception is not the expectd one.", (boolean)e.getMessage().contains("Cannot add a duplicate!"));
        }
        RMApp app = (RMApp)this.rmContext.getRMApps().get(appId);
        Assert.assertNotNull((String)"app is null", (Object)app);
        Assert.assertEquals((String)"app id doesn't match", (Object)appId, (Object)app.getApplicationId());
        Assert.assertEquals((String)"app state doesn't match", (Object)RMAppState.FINISHED, (Object)app.getState());
    }

    @Test(timeout=30000L)
    public void testRMAppSubmitInvalidResourceRequest() throws Exception {
        this.asContext.setResource(Resources.createResource((int)8193));
        try {
            this.appMonitor.submitApplication(this.asContext, "test");
            Assert.fail((String)"Application submission should fail because resource request is invalid.");
        }
        catch (YarnException e) {
            Assert.assertTrue((String)"The thrown exception is not InvalidResourceRequestException", (boolean)e.getMessage().contains("Invalid resource request"));
        }
    }

    @Test(timeout=30000L)
    public void testEscapeApplicationSummary() {
        RMApp app = (RMApp)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)app.getApplicationId()).thenReturn((Object)ApplicationId.newInstance((long)100L, (int)1));
        Mockito.when((Object)app.getName()).thenReturn((Object)"Multiline\n\n\r\rAppName");
        Mockito.when((Object)app.getUser()).thenReturn((Object)"Multiline\n\n\r\rUserName");
        Mockito.when((Object)app.getQueue()).thenReturn((Object)"Multiline\n\n\r\rQueueName");
        Mockito.when((Object)app.getState()).thenReturn((Object)RMAppState.RUNNING);
        Mockito.when((Object)app.getApplicationType()).thenReturn((Object)"MAPREDUCE");
        RMAppMetrics metrics = new RMAppMetrics(Resource.newInstance((int)1234, (int)56, (int)56), 10, 1, 16384L, 64L, 64L, 0L, 0L, 0L);
        Mockito.when((Object)app.getRMAppMetrics()).thenReturn((Object)metrics);
        new RMAppManager.ApplicationSummary();
        RMAppManager.ApplicationSummary.SummaryBuilder summary = RMAppManager.ApplicationSummary.createAppSummary((RMApp)app);
        String msg = summary.toString();
        this.LOG.info((Object)("summary: " + msg));
        Assert.assertFalse((boolean)msg.contains("\n"));
        Assert.assertFalse((boolean)msg.contains("\r"));
        String escaped = "\\n\\n\\r\\r";
        Assert.assertTrue((boolean)msg.contains("Multiline" + escaped + "AppName"));
        Assert.assertTrue((boolean)msg.contains("Multiline" + escaped + "UserName"));
        Assert.assertTrue((boolean)msg.contains("Multiline" + escaped + "QueueName"));
        Assert.assertTrue((boolean)msg.contains("memorySeconds=16384"));
        Assert.assertTrue((boolean)msg.contains("vcoreSeconds=64"));
        Assert.assertTrue((boolean)msg.contains("preemptedAMContainers=1"));
        Assert.assertTrue((boolean)msg.contains("preemptedNonAMContainers=10"));
        Assert.assertTrue((boolean)msg.contains("preemptedResources=<memory:1234\\, vCores:56\\, gpus:56>"));
        Assert.assertTrue((boolean)msg.contains("applicationType=MAPREDUCE"));
    }

    @Test
    public void testRMAppSubmitWithQueueChanged() throws Exception {
        PlacementManager placementMgr = (PlacementManager)Mockito.mock(PlacementManager.class);
        ((PlacementManager)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ApplicationSubmissionContext ctx = (ApplicationSubmissionContext)invocation.getArguments()[0];
                ctx.setQueue("newQueue");
                return null;
            }
        }).when((Object)placementMgr)).placeApplication((ApplicationSubmissionContext)Matchers.any(ApplicationSubmissionContext.class), (String)Matchers.any(String.class));
        this.rmContext.setQueuePlacementManager(placementMgr);
        this.asContext.setQueue("oldQueue");
        this.appMonitor.submitApplication(this.asContext, "test");
        RMApp app = (RMApp)this.rmContext.getRMApps().get(this.appId);
        Assert.assertNotNull((String)"app is null", (Object)app);
        Assert.assertEquals((Object)"newQueue", (Object)this.asContext.getQueue());
        int timeoutSecs = 0;
        while (this.getAppEventType() == RMAppEventType.KILL && timeoutSecs++ < 20) {
            Thread.sleep(1000L);
        }
        Assert.assertEquals((String)"app event type sent is wrong", (Object)RMAppEventType.START, (Object)this.getAppEventType());
    }

    private static ResourceScheduler mockResourceScheduler() {
        ResourceScheduler scheduler = (ResourceScheduler)Mockito.mock(ResourceScheduler.class);
        Mockito.when((Object)scheduler.getMinimumResourceCapability()).thenReturn((Object)Resources.createResource((int)1024));
        Mockito.when((Object)scheduler.getMaximumResourceCapability()).thenReturn((Object)Resources.createResource((int)8192));
        ResourceCalculator rs = (ResourceCalculator)Mockito.mock(ResourceCalculator.class);
        Mockito.when((Object)scheduler.getResourceCalculator()).thenReturn((Object)rs);
        return scheduler;
    }

    private static ContainerLaunchContext mockContainerLaunchContext(RecordFactory recordFactory) {
        ContainerLaunchContext amContainer = (ContainerLaunchContext)recordFactory.newRecordInstance(ContainerLaunchContext.class);
        amContainer.setApplicationACLs(new HashMap());
        return amContainer;
    }

    private static Resource mockResource() {
        return Resources.createResource((int)1024);
    }

    public class TestRMAppManager
    extends RMAppManager {
        public TestRMAppManager(RMContext context, Configuration conf) {
            super(context, null, null, new ApplicationACLsManager(conf), conf);
        }

        public TestRMAppManager(RMContext context, ClientToAMTokenSecretManagerInRM clientToAMSecretManager, YarnScheduler scheduler, ApplicationMasterService masterService, ApplicationACLsManager applicationACLsManager, Configuration conf) {
            super(context, scheduler, masterService, applicationACLsManager, conf);
        }

        public void checkAppNumCompletedLimit() {
            super.checkAppNumCompletedLimit();
        }

        public void finishApplication(ApplicationId appId) {
            super.finishApplication(appId);
        }

        public int getCompletedAppsListSize() {
            return super.getCompletedAppsListSize();
        }

        public int getCompletedAppsInStateStore() {
            return this.completedAppsInStateStore;
        }

        public void submitApplication(ApplicationSubmissionContext submissionContext, String user) throws YarnException, IOException {
            super.submitApplication(submissionContext, System.currentTimeMillis(), user);
        }
    }

    public class TestDispatcher
    implements EventHandler<RMAppEvent> {
        public void handle(RMAppEvent event) {
            TestAppManager.this.setAppEventType((RMAppEventType)event.getType());
            System.out.println("in handle routine " + TestAppManager.this.getAppEventType().toString());
        }
    }

    public class TestAppManagerDispatcher
    implements EventHandler<RMAppManagerEvent> {
        public void handle(RMAppManagerEvent event) {
        }
    }
}

