/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.quota;

import io.hops.exception.StorageException;
import io.hops.exception.StorageInitializtionException;
import io.hops.metadata.yarn.dal.quota.ContainersLogsDataAccess;
import io.hops.metadata.yarn.dal.util.YARNOperationType;
import io.hops.metadata.yarn.entity.quota.ContainerLog;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.quota.ContainersLogsService;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestContainersLogsService {
    private static final Log LOG = LogFactory.getLog(ContainersLogsService.class);
    private Configuration conf;
    Random random = new Random();
    private final int GB = 1024;

    @Before
    public void setup() throws IOException {
        try {
            this.conf = new YarnConfiguration();
            YarnAPIStorageFactory.setConfiguration((Configuration)this.conf);
            RMStorageFactory.setConfiguration((Configuration)this.conf);
            LOG.info((Object)"initialize db");
            DBUtility.InitializeDB();
        }
        catch (StorageInitializtionException ex) {
            LOG.error(null, (Throwable)ex);
        }
        catch (IOException ex) {
            LOG.error(null, (Throwable)ex);
        }
    }

    @Test(timeout=60000L)
    public void testCheckpoints() throws Exception {
        int checkpointTicks = 10;
        int monitorInterval = 1000;
        this.conf.setInt("yarn.resourcemanager.quota.containers.log.period", monitorInterval);
        this.conf.setBoolean("yarn.resourcemanager.quota.containers.log.checkpoints.enabled", true);
        this.conf.setInt("yarn.resourcemanager.quota.minTicksCharge", checkpointTicks);
        this.conf.setInt("yarn.resourcemanager.quota.containers.log.checkpoints.period", 1);
        MockRM rm = new MockRM(this.conf);
        rm.start();
        MockNM nm1 = rm.registerNode("h1:1234", 5120);
        MockNM nm2 = rm.registerNode("h2:5678", 10240);
        RMApp app = rm.submitApp(1024);
        nm1.nodeHeartbeat(true);
        RMAppAttempt attempt = app.getCurrentAppAttempt();
        MockAM am = rm.sendAMLaunched(attempt.getAppAttemptId());
        am.registerAppAttempt();
        int request = 4;
        am.allocate("h1", 1024, request, new ArrayList<ContainerId>());
        List conts = am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers();
        int contReceived = conts.size();
        while (contReceived < 4) {
            nm1.nodeHeartbeat(true);
            conts.addAll(am.allocate(new ArrayList<ResourceRequest>(), new ArrayList<ContainerId>()).getAllocatedContainers());
            contReceived = conts.size();
            Thread.sleep(100L);
        }
        Assert.assertEquals((long)4L, (long)conts.size());
        ArrayList<ContainerStatus> containersStatus = new ArrayList<ContainerStatus>();
        for (Container c : conts) {
            containersStatus.add(ContainerStatus.newInstance((ContainerId)c.getId(), (ContainerState)ContainerState.RUNNING, (String)"", (int)0));
        }
        HashMap<ApplicationId, List<ContainerStatus>> status = new HashMap<ApplicationId, List<ContainerStatus>>();
        status.put(am.getApplicationAttemptId().getApplicationId(), containersStatus);
        long initialCheckPointTick = rm.getRMContext().getContainersLogsService().getCurrentTick();
        nm1.nodeHeartbeat(status, true);
        int sleepTillCheckpoint = monitorInterval * (checkpointTicks + 1);
        Thread.sleep(sleepTillCheckpoint);
        Map<String, ContainerLog> cl = this.getContainersLogs();
        for (Container c : conts) {
            ContainerLog entry = cl.get(c.getId().toString());
            Assert.assertNotNull((Object)entry);
            Assert.assertEquals((long)((long)checkpointTicks + initialCheckPointTick), (long)entry.getStop());
            Assert.assertEquals((long)-201L, (long)entry.getExitstatus());
        }
    }

    private Map<String, ContainerLog> getContainersLogs() throws IOException {
        LightWeightRequestHandler allContainersHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws StorageException {
                ContainersLogsDataAccess containersLogsDA = (ContainersLogsDataAccess)RMStorageFactory.getDataAccess(ContainersLogsDataAccess.class);
                connector.beginTransaction();
                connector.readCommitted();
                Map allContainersLogs = containersLogsDA.getAll();
                connector.commit();
                return allContainersLogs;
            }
        };
        Map containersLogs = (Map)allContainersHandler.handle();
        return containersLogs;
    }
}

