/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.impl.MetricsSystemImpl;
import org.apache.hadoop.test.MetricsAsserts;
import org.apache.hadoop.test.MockitoMaker;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AppSchedulingInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.NodeType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fifo.FifoScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestQueueMetrics {
    static final int GB = 1024;
    private static final Configuration conf = new Configuration();
    private MetricsSystem ms;

    @Before
    public void setUp() {
        this.ms = new MetricsSystemImpl();
        QueueMetrics.clearQueueMetrics();
    }

    @Test
    public void testDefaultSingleQueueMetrics() {
        String queueName = "single";
        String user = "alice";
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)false, (Configuration)conf);
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        AppSchedulingInfo app = TestQueueMetrics.mockApp(user);
        metrics.submitApp(user);
        MetricsSource userSource = TestQueueMetrics.userSource(this.ms, queueName, user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 0, 0, 0, true);
        metrics.submitAppAttempt(user);
        TestQueueMetrics.checkApps(queueSource, 1, 1, 0, 0, 0, 0, true);
        metrics.setAvailableResourcesToQueue(Resources.createResource((long)102400L, (int)100, (int)100));
        metrics.incrPendingResources(user, 5, Resources.createResource((long)3072L, (int)3, (int)3));
        TestQueueMetrics.checkResources(queueSource, 0L, 0, 0, 0, 0L, 0L, 102400L, 100, 100, 15360L, 15, 15, 5, 0L, 0, 0, 0);
        metrics.runAppAttempt(app.getApplicationId(), user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 1, 0, 0, 0, true);
        metrics.allocateResources(user, 3, Resources.createResource((long)2048L, (int)2, (int)2), true);
        TestQueueMetrics.checkResources(queueSource, 6144L, 6, 6, 3, 3L, 0L, 102400L, 100, 100, 9216L, 9, 9, 2, 0L, 0, 0, 0);
        metrics.releaseResources(user, 1, Resources.createResource((long)2048L, (int)2, (int)2));
        TestQueueMetrics.checkResources(queueSource, 4096L, 4, 4, 2, 3L, 1L, 102400L, 100, 100, 9216L, 9, 9, 2, 0L, 0, 0, 0);
        metrics.incrPendingResources(user, 0, Resources.createResource((long)2048L, (int)2, (int)2));
        TestQueueMetrics.checkResources(queueSource, 4096L, 4, 4, 2, 3L, 1L, 102400L, 100, 100, 9216L, 9, 9, 2, 0L, 0, 0, 0);
        metrics.decrPendingResources(user, 0, Resources.createResource((long)2048L, (int)2, (int)2));
        TestQueueMetrics.checkResources(queueSource, 4096L, 4, 4, 2, 3L, 1L, 102400L, 100, 100, 9216L, 9, 9, 2, 0L, 0, 0, 0);
        metrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser());
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 0, 0, 0, true);
        metrics.finishApp(user, RMAppState.FINISHED);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 1, 0, 0, true);
        Assert.assertNull((Object)userSource);
    }

    @Test
    public void testQueueAppMetricsForMultipleFailures() {
        String queueName = "single";
        String user = "alice";
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)false, (Configuration)new Configuration());
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        AppSchedulingInfo app = TestQueueMetrics.mockApp(user);
        metrics.submitApp(user);
        MetricsSource userSource = TestQueueMetrics.userSource(this.ms, queueName, user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 0, 0, 0, true);
        metrics.submitAppAttempt(user);
        TestQueueMetrics.checkApps(queueSource, 1, 1, 0, 0, 0, 0, true);
        metrics.runAppAttempt(app.getApplicationId(), user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 1, 0, 0, 0, true);
        metrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser());
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 0, 0, 0, true);
        metrics.submitAppAttempt(user);
        TestQueueMetrics.checkApps(queueSource, 1, 1, 0, 0, 0, 0, true);
        metrics.runAppAttempt(app.getApplicationId(), user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 1, 0, 0, 0, true);
        metrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser());
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 0, 0, 0, true);
        metrics.submitAppAttempt(user);
        TestQueueMetrics.checkApps(queueSource, 1, 1, 0, 0, 0, 0, true);
        metrics.runAppAttempt(app.getApplicationId(), user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 1, 0, 0, 0, true);
        metrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser());
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 0, 0, 0, true);
        metrics.finishApp(user, RMAppState.FAILED);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 0, 1, 0, true);
        Assert.assertNull((Object)userSource);
    }

    @Test
    public void testSingleQueueWithUserMetrics() {
        String queueName = "single2";
        String user = "dodo";
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)true, (Configuration)conf);
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        AppSchedulingInfo app = TestQueueMetrics.mockApp(user);
        metrics.submitApp(user);
        MetricsSource userSource = TestQueueMetrics.userSource(this.ms, queueName, user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 0, 0, 0, 0, 0, true);
        metrics.submitAppAttempt(user);
        TestQueueMetrics.checkApps(queueSource, 1, 1, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 1, 0, 0, 0, 0, true);
        metrics.setAvailableResourcesToQueue(Resources.createResource((long)102400L, (int)100, (int)100));
        metrics.setAvailableResourcesToUser(user, Resources.createResource((long)10240L, (int)10, (int)10));
        metrics.incrPendingResources(user, 5, Resources.createResource((long)3072L, (int)3, (int)3));
        TestQueueMetrics.checkResources(queueSource, 0L, 0, 0, 0, 0L, 0L, 102400L, 100, 100, 15360L, 15, 15, 5, 0L, 0, 0, 0);
        TestQueueMetrics.checkResources(userSource, 0L, 0, 0, 0, 0L, 0L, 10240L, 10, 10, 15360L, 15, 15, 5, 0L, 0, 0, 0);
        metrics.runAppAttempt(app.getApplicationId(), user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 1, 0, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 0, 1, 0, 0, 0, true);
        metrics.allocateResources(user, 3, Resources.createResource((long)2048L, (int)2, (int)2), true);
        TestQueueMetrics.checkResources(queueSource, 6144L, 6, 6, 3, 3L, 0L, 102400L, 100, 100, 9216L, 9, 9, 2, 0L, 0, 0, 0);
        TestQueueMetrics.checkResources(userSource, 6144L, 6, 6, 3, 3L, 0L, 10240L, 10, 10, 9216L, 9, 9, 2, 0L, 0, 0, 0);
        metrics.releaseResources(user, 1, Resources.createResource((long)2048L, (int)2, (int)2));
        TestQueueMetrics.checkResources(queueSource, 4096L, 4, 4, 2, 3L, 1L, 102400L, 100, 100, 9216L, 9, 9, 2, 0L, 0, 0, 0);
        TestQueueMetrics.checkResources(userSource, 4096L, 4, 4, 2, 3L, 1L, 10240L, 10, 10, 9216L, 9, 9, 2, 0L, 0, 0, 0);
        metrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser());
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 0, 0, 0, 0, 0, true);
        metrics.finishApp(user, RMAppState.FINISHED);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 1, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 0, 0, 1, 0, 0, true);
    }

    @Test
    public void testNodeTypeMetrics() {
        String parentQueueName = "root";
        String leafQueueName = "root.leaf";
        String user = "alice";
        QueueMetrics parentMetrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)parentQueueName, null, (boolean)true, (Configuration)conf);
        Queue parentQueue = (Queue)MockitoMaker.make((Object)((Queue)MockitoMaker.stub(Queue.class).returning((Object)parentMetrics).from).getMetrics());
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)leafQueueName, (Queue)parentQueue, (boolean)true, (Configuration)conf);
        MetricsSource parentQueueSource = TestQueueMetrics.queueSource(this.ms, parentQueueName);
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, leafQueueName);
        metrics.submitApp(user);
        MetricsSource userSource = TestQueueMetrics.userSource(this.ms, leafQueueName, user);
        MetricsSource parentUserSource = TestQueueMetrics.userSource(this.ms, parentQueueName, user);
        metrics.incrNodeTypeAggregations(user, NodeType.NODE_LOCAL);
        TestQueueMetrics.checkAggregatedNodeTypes(queueSource, 1L, 0L, 0L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentQueueSource, 1L, 0L, 0L);
        TestQueueMetrics.checkAggregatedNodeTypes(userSource, 1L, 0L, 0L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentUserSource, 1L, 0L, 0L);
        metrics.incrNodeTypeAggregations(user, NodeType.RACK_LOCAL);
        TestQueueMetrics.checkAggregatedNodeTypes(queueSource, 1L, 1L, 0L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentQueueSource, 1L, 1L, 0L);
        TestQueueMetrics.checkAggregatedNodeTypes(userSource, 1L, 1L, 0L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentUserSource, 1L, 1L, 0L);
        metrics.incrNodeTypeAggregations(user, NodeType.OFF_SWITCH);
        TestQueueMetrics.checkAggregatedNodeTypes(queueSource, 1L, 1L, 1L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentQueueSource, 1L, 1L, 1L);
        TestQueueMetrics.checkAggregatedNodeTypes(userSource, 1L, 1L, 1L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentUserSource, 1L, 1L, 1L);
        metrics.incrNodeTypeAggregations(user, NodeType.OFF_SWITCH);
        TestQueueMetrics.checkAggregatedNodeTypes(queueSource, 1L, 1L, 2L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentQueueSource, 1L, 1L, 2L);
        TestQueueMetrics.checkAggregatedNodeTypes(userSource, 1L, 1L, 2L);
        TestQueueMetrics.checkAggregatedNodeTypes(parentUserSource, 1L, 1L, 2L);
    }

    @Test
    public void testTwoLevelWithUserMetrics() {
        String parentQueueName = "root";
        String leafQueueName = "root.leaf";
        String user = "alice";
        QueueMetrics parentMetrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)parentQueueName, null, (boolean)true, (Configuration)conf);
        Queue parentQueue = (Queue)MockitoMaker.make((Object)((Queue)MockitoMaker.stub(Queue.class).returning((Object)parentMetrics).from).getMetrics());
        QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)this.ms, (String)leafQueueName, (Queue)parentQueue, (boolean)true, (Configuration)conf);
        MetricsSource parentQueueSource = TestQueueMetrics.queueSource(this.ms, parentQueueName);
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, leafQueueName);
        AppSchedulingInfo app = TestQueueMetrics.mockApp(user);
        metrics.submitApp(user);
        MetricsSource userSource = TestQueueMetrics.userSource(this.ms, leafQueueName, user);
        MetricsSource parentUserSource = TestQueueMetrics.userSource(this.ms, parentQueueName, user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(parentQueueSource, 1, 0, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 0, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(parentUserSource, 1, 0, 0, 0, 0, 0, true);
        metrics.submitAppAttempt(user);
        TestQueueMetrics.checkApps(queueSource, 1, 1, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(parentQueueSource, 1, 1, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 1, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(parentUserSource, 1, 1, 0, 0, 0, 0, true);
        parentMetrics.setAvailableResourcesToQueue(Resources.createResource((long)102400L, (int)100, (int)100));
        metrics.setAvailableResourcesToQueue(Resources.createResource((long)102400L, (int)100, (int)100));
        parentMetrics.setAvailableResourcesToUser(user, Resources.createResource((long)10240L, (int)10, (int)10));
        metrics.setAvailableResourcesToUser(user, Resources.createResource((long)10240L, (int)10, (int)10));
        metrics.incrPendingResources(user, 5, Resources.createResource((long)3072L, (int)3, (int)3));
        TestQueueMetrics.checkResources(queueSource, 0L, 0, 0, 0, 0L, 0L, 102400L, 100, 100, 15360L, 15, 15, 5, 0L, 0, 0, 0);
        TestQueueMetrics.checkResources(parentQueueSource, 0L, 0, 0, 0, 0L, 0L, 102400L, 100, 100, 15360L, 15, 15, 5, 0L, 0, 0, 0);
        TestQueueMetrics.checkResources(userSource, 0L, 0, 0, 0, 0L, 0L, 10240L, 10, 10, 15360L, 15, 15, 5, 0L, 0, 0, 0);
        TestQueueMetrics.checkResources(parentUserSource, 0L, 0, 0, 0, 0L, 0L, 10240L, 10, 10, 15360L, 15, 15, 5, 0L, 0, 0, 0);
        metrics.runAppAttempt(app.getApplicationId(), user);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 1, 0, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 0, 1, 0, 0, 0, true);
        metrics.allocateResources(user, 3, Resources.createResource((long)2048L, (int)2, (int)2), true);
        metrics.reserveResource(user, Resources.createResource((long)3072L, (int)3, (int)3));
        TestQueueMetrics.checkResources(queueSource, 6144L, 6, 6, 3, 3L, 0L, 102400L, 100, 100, 9216L, 9, 9, 2, 3072L, 3, 3, 1);
        TestQueueMetrics.checkResources(parentQueueSource, 6144L, 6, 6, 3, 3L, 0L, 102400L, 100, 100, 9216L, 9, 9, 2, 3072L, 3, 3, 1);
        TestQueueMetrics.checkResources(userSource, 6144L, 6, 6, 3, 3L, 0L, 10240L, 10, 10, 9216L, 9, 9, 2, 3072L, 3, 3, 1);
        TestQueueMetrics.checkResources(parentUserSource, 6144L, 6, 6, 3, 3L, 0L, 10240L, 10, 10, 9216L, 9, 9, 2, 3072L, 3, 3, 1);
        metrics.releaseResources(user, 1, Resources.createResource((long)2048L, (int)2, (int)2));
        metrics.unreserveResource(user, Resources.createResource((long)3072L, (int)3, (int)3));
        TestQueueMetrics.checkResources(queueSource, 4096L, 4, 4, 2, 3L, 1L, 102400L, 100, 100, 9216L, 9, 9, 2, 0L, 0, 0, 0);
        TestQueueMetrics.checkResources(parentQueueSource, 4096L, 4, 4, 2, 3L, 1L, 102400L, 100, 100, 9216L, 9, 9, 2, 0L, 0, 0, 0);
        TestQueueMetrics.checkResources(userSource, 4096L, 4, 4, 2, 3L, 1L, 10240L, 10, 10, 9216L, 9, 9, 2, 0L, 0, 0, 0);
        TestQueueMetrics.checkResources(parentUserSource, 4096L, 4, 4, 2, 3L, 1L, 10240L, 10, 10, 9216L, 9, 9, 2, 0L, 0, 0, 0);
        metrics.finishAppAttempt(app.getApplicationId(), app.isPending(), app.getUser());
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(parentQueueSource, 1, 0, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 0, 0, 0, 0, 0, true);
        TestQueueMetrics.checkApps(parentUserSource, 1, 0, 0, 0, 0, 0, true);
        metrics.finishApp(user, RMAppState.FINISHED);
        TestQueueMetrics.checkApps(queueSource, 1, 0, 0, 1, 0, 0, true);
        TestQueueMetrics.checkApps(parentQueueSource, 1, 0, 0, 1, 0, 0, true);
        TestQueueMetrics.checkApps(userSource, 1, 0, 0, 1, 0, 0, true);
        TestQueueMetrics.checkApps(parentUserSource, 1, 0, 0, 1, 0, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetricsCache() {
        MetricsSystemImpl ms = new MetricsSystemImpl("cache");
        ms.start();
        try {
            String p1 = "root1";
            String leafQueueName = "root1.leaf";
            QueueMetrics p1Metrics = QueueMetrics.forQueue((MetricsSystem)ms, (String)p1, null, (boolean)true, (Configuration)conf);
            Queue parentQueue1 = (Queue)MockitoMaker.make((Object)((Queue)MockitoMaker.stub(Queue.class).returning((Object)p1Metrics).from).getMetrics());
            QueueMetrics metrics = QueueMetrics.forQueue((MetricsSystem)ms, (String)leafQueueName, (Queue)parentQueue1, (boolean)true, (Configuration)conf);
            Assert.assertNotNull((String)"QueueMetrics for A shoudn't be null", (Object)metrics);
            QueueMetrics alterMetrics = QueueMetrics.forQueue((MetricsSystem)ms, (String)leafQueueName, (Queue)parentQueue1, (boolean)true, (Configuration)conf);
            Assert.assertNotNull((String)"QueueMetrics for alterMetrics shoudn't be null", (Object)alterMetrics);
        }
        finally {
            ms.shutdown();
        }
    }

    @Test
    public void testMetricsInitializedOnRMInit() throws IOException {
        YarnConfiguration conf = new YarnConfiguration();
        RMStorageFactory.setConfiguration((Configuration)conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)conf);
        DBUtility.InitializeDB();
        conf.setClass("yarn.resourcemanager.scheduler.class", FifoScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM((Configuration)conf);
        QueueMetrics metrics = rm.getResourceScheduler().getRootQueueMetrics();
        TestQueueMetrics.checkApps((MetricsSource)metrics, 0, 0, 0, 0, 0, 0, true);
        MetricsAsserts.assertGauge((String)"ReservedContainers", (int)0, (MetricsSource)metrics);
    }

    @Test
    public void testCollectAllMetrics() {
        String queueName = "single";
        QueueMetrics.forQueue((MetricsSystem)this.ms, (String)queueName, null, (boolean)false, (Configuration)conf);
        MetricsSource queueSource = TestQueueMetrics.queueSource(this.ms, queueName);
        TestQueueMetrics.checkApps(queueSource, 0, 0, 0, 0, 0, 0, true);
        try {
            TestQueueMetrics.checkApps(queueSource, 0, 0, 0, 0, 0, 0, false);
            Assert.fail();
        }
        catch (AssertionError e) {
            Assert.assertTrue((boolean)((Throwable)((Object)e)).getMessage().contains("Expected exactly one metric for name "));
        }
        TestQueueMetrics.checkApps(queueSource, 0, 0, 0, 0, 0, 0, true);
    }

    public static void checkApps(MetricsSource source, int submitted, int pending, int running, int completed, int failed, int killed, boolean all) {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)source, (boolean)all);
        MetricsAsserts.assertCounter((String)"AppsSubmitted", (int)submitted, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AppsPending", (int)pending, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AppsRunning", (int)running, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"AppsCompleted", (int)completed, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"AppsFailed", (int)failed, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"AppsKilled", (int)killed, (MetricsRecordBuilder)rb);
    }

    public static void checkResources(MetricsSource source, long allocatedMB, int allocatedCores, int allocatedGPUs, int allocCtnrs, long aggreAllocCtnrs, long aggreReleasedCtnrs, long availableMB, int availableCores, int availableGPUs, long pendingMB, int pendingCores, int pendingGPUs, int pendingCtnrs, long reservedMB, int reservedCores, int reservedGPUs, int reservedCtnrs) {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)source);
        MetricsAsserts.assertGauge((String)"AllocatedMB", (long)allocatedMB, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AllocatedVCores", (int)allocatedCores, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AllocatedGPUs", (int)allocatedGPUs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AllocatedContainers", (int)allocCtnrs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"AggregateContainersAllocated", (long)aggreAllocCtnrs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"AggregateContainersReleased", (long)aggreReleasedCtnrs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AvailableMB", (long)availableMB, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AvailableVCores", (int)availableCores, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"AvailableGPUs", (int)availableGPUs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingMB", (long)pendingMB, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingVCores", (int)pendingCores, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingGPUs", (int)pendingGPUs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"PendingContainers", (int)pendingCtnrs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ReservedMB", (long)reservedMB, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ReservedVCores", (int)reservedCores, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ReservedGPUs", (int)reservedGPUs, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertGauge((String)"ReservedContainers", (int)reservedCtnrs, (MetricsRecordBuilder)rb);
    }

    public static void checkAggregatedNodeTypes(MetricsSource source, long nodeLocal, long rackLocal, long offSwitch) {
        MetricsRecordBuilder rb = MetricsAsserts.getMetrics((MetricsSource)source);
        MetricsAsserts.assertCounter((String)"AggregateNodeLocalContainersAllocated", (long)nodeLocal, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"AggregateRackLocalContainersAllocated", (long)rackLocal, (MetricsRecordBuilder)rb);
        MetricsAsserts.assertCounter((String)"AggregateOffSwitchContainersAllocated", (long)offSwitch, (MetricsRecordBuilder)rb);
    }

    private static AppSchedulingInfo mockApp(String user) {
        AppSchedulingInfo app = (AppSchedulingInfo)Mockito.mock(AppSchedulingInfo.class);
        Mockito.when((Object)app.getUser()).thenReturn((Object)user);
        ApplicationId appId = BuilderUtils.newApplicationId((long)1L, (int)1);
        ApplicationAttemptId id = BuilderUtils.newApplicationAttemptId((ApplicationId)appId, (int)1);
        Mockito.when((Object)app.getApplicationAttemptId()).thenReturn((Object)id);
        return app;
    }

    public static MetricsSource queueSource(MetricsSystem ms, String queue) {
        MetricsSource s = ms.getSource(QueueMetrics.sourceName((String)queue).toString());
        return s;
    }

    public static MetricsSource userSource(MetricsSystem ms, String queue, String user) {
        MetricsSource s = ms.getSource(QueueMetrics.sourceName((String)queue).append(",user=").append(user).toString());
        return s;
    }
}

