/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import io.hops.util.DBUtility;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.DrainDispatcher;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.MockAM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNM;
import org.apache.hadoop.yarn.server.resourcemanager.MockNodes;
import org.apache.hadoop.yarn.server.resourcemanager.MockRM;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.FileSystemRMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptImpl;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.LeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica.FiCaSchedulerApp;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class TestApplicationPriority {
    private final int GB = 1024;
    private YarnConfiguration conf;

    @Before
    public void setUp() throws Exception {
        this.conf = new YarnConfiguration();
        this.conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        RMStorageFactory.setConfiguration((Configuration)this.conf);
        YarnAPIStorageFactory.setConfiguration((Configuration)this.conf);
        DBUtility.InitializeDB();
    }

    @Test
    public void testApplicationOrderingWithPriority() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        MockRM rm = new MockRM(conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue q = (LeafQueue)cs.getQueue("default");
        Assert.assertNotNull((Object)q);
        String host = "127.0.0.1";
        RMNode node = MockNodes.newNodeInfo(0, MockNodes.newResource(16384), 1, host);
        cs.handle((SchedulerEvent)new NodeAddedSchedulerEvent(node));
        ApplicationId appId1 = BuilderUtils.newApplicationId((long)100L, (int)1);
        ApplicationAttemptId appAttemptId1 = BuilderUtils.newApplicationAttemptId((ApplicationId)appId1, (int)1);
        RMAppAttemptMetrics attemptMetric1 = new RMAppAttemptMetrics(appAttemptId1, rm.getRMContext());
        RMAppImpl app1 = (RMAppImpl)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)app1.getApplicationId()).thenReturn((Object)appId1);
        RMAppAttemptImpl attempt1 = (RMAppAttemptImpl)Mockito.mock(RMAppAttemptImpl.class);
        Mockito.when((Object)attempt1.getAppAttemptId()).thenReturn((Object)appAttemptId1);
        Mockito.when((Object)attempt1.getRMAppAttemptMetrics()).thenReturn((Object)attemptMetric1);
        Mockito.when((Object)app1.getCurrentAppAttempt()).thenReturn((Object)attempt1);
        rm.getRMContext().getRMApps().put(appId1, app1);
        AppAddedSchedulerEvent addAppEvent1 = new AppAddedSchedulerEvent(appId1, "default", "user", null, Priority.newInstance((int)5));
        cs.handle((SchedulerEvent)addAppEvent1);
        AppAttemptAddedSchedulerEvent addAttemptEvent1 = new AppAttemptAddedSchedulerEvent(appAttemptId1, false);
        cs.handle((SchedulerEvent)addAttemptEvent1);
        ApplicationId appId2 = BuilderUtils.newApplicationId((long)100L, (int)2);
        ApplicationAttemptId appAttemptId2 = BuilderUtils.newApplicationAttemptId((ApplicationId)appId2, (int)1);
        RMAppAttemptMetrics attemptMetric2 = new RMAppAttemptMetrics(appAttemptId2, rm.getRMContext());
        RMAppImpl app2 = (RMAppImpl)Mockito.mock(RMAppImpl.class);
        Mockito.when((Object)app2.getApplicationId()).thenReturn((Object)appId2);
        RMAppAttemptImpl attempt2 = (RMAppAttemptImpl)Mockito.mock(RMAppAttemptImpl.class);
        Mockito.when((Object)attempt2.getAppAttemptId()).thenReturn((Object)appAttemptId2);
        Mockito.when((Object)attempt2.getRMAppAttemptMetrics()).thenReturn((Object)attemptMetric2);
        Mockito.when((Object)app2.getCurrentAppAttempt()).thenReturn((Object)attempt2);
        rm.getRMContext().getRMApps().put(appId2, app2);
        AppAddedSchedulerEvent addAppEvent2 = new AppAddedSchedulerEvent(appId2, "default", "user", null, Priority.newInstance((int)8));
        cs.handle((SchedulerEvent)addAppEvent2);
        AppAttemptAddedSchedulerEvent addAttemptEvent2 = new AppAttemptAddedSchedulerEvent(appAttemptId2, false);
        cs.handle((SchedulerEvent)addAttemptEvent2);
        Assert.assertEquals((long)q.getApplications().size(), (long)2L);
        Assert.assertEquals((Object)((FiCaSchedulerApp)q.getApplications().iterator().next()).getApplicationAttemptId(), (Object)appAttemptId2);
        rm.stop();
    }

    @Test
    public void testApplicationPriorityAllocation() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setInt("yarn.cluster.max-application-priority", 10);
        MockRM rm = new MockRM(conf);
        rm.start();
        Priority appPriority1 = Priority.newInstance((int)5);
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 16384);
        RMApp app1 = rm.submitApp(1024, appPriority1);
        MockAM am1 = MockRM.launchAM(app1, rm, nm1);
        am1.registerAppAttempt();
        List<Container> allocated1 = am1.allocateAndWaitForContainers("127.0.0.1", 7, 2048, nm1);
        Assert.assertEquals((long)7L, (long)allocated1.size());
        Assert.assertEquals((long)2048L, (long)allocated1.get(0).getResource().getMemorySize());
        SchedulerNodeReport report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)15360L, (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)1024L, (long)report_nm1.getAvailableResource().getMemorySize());
        Priority appPriority2 = Priority.newInstance((int)8);
        RMApp app2 = rm.submitApp(1024, appPriority2);
        MockAM am2 = MockRM.launchAM(app2, rm, nm1);
        am2.registerAppAttempt();
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)16384L, (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)report_nm1.getAvailableResource().getMemorySize());
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        FiCaSchedulerApp schedulerAppAttempt = (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(app1.getApplicationId())).getCurrentAppAttempt();
        int counter = 0;
        for (Container c : allocated1) {
            if (++counter > 2) break;
            cs.markContainerForKillable(schedulerAppAttempt.getRMContainer(c.getId()));
        }
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)12288L, (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)4096L, (long)report_nm1.getAvailableResource().getMemorySize());
        am1.allocate("127.0.0.1", 2048, 10, new ArrayList<ContainerId>());
        List<Container> allocated2 = am2.allocateAndWaitForContainers("127.0.0.1", 2, 2048, nm1);
        Assert.assertEquals((long)2L, (long)allocated2.size());
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)16384L, (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)report_nm1.getAvailableResource().getMemorySize());
        rm.stop();
    }

    @Test
    public void testPriorityWithPendingApplications() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setInt("yarn.cluster.max-application-priority", 10);
        MockRM rm = new MockRM(conf);
        rm.start();
        Priority appPriority1 = Priority.newInstance((int)5);
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 8192);
        RMApp app1 = rm.submitApp(1024, appPriority1);
        MockAM am1 = MockRM.launchAM(app1, rm, nm1);
        am1.registerAppAttempt();
        List<Container> allocated1 = am1.allocateAndWaitForContainers("127.0.0.1", 7, 1024, nm1);
        Assert.assertEquals((long)7L, (long)allocated1.size());
        Assert.assertEquals((long)1024L, (long)allocated1.get(0).getResource().getMemorySize());
        SchedulerNodeReport report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)8192L, (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)report_nm1.getAvailableResource().getMemorySize());
        Priority appPriority2 = Priority.newInstance((int)7);
        RMApp app2 = rm.submitApp(1024, appPriority2);
        Priority appPriority3 = Priority.newInstance((int)8);
        RMApp app3 = rm.submitApp(1024, appPriority3);
        Priority appPriority4 = Priority.newInstance((int)6);
        RMApp app4 = rm.submitApp(1024, appPriority4);
        rm.killApp(app1.getApplicationId());
        rm.waitForState(am1.getApplicationAttemptId(), RMAppAttemptState.KILLED);
        MockAM am3 = MockRM.launchAM(app3, rm, nm1);
        am3.registerAppAttempt();
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)1024L, (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)7168L, (long)report_nm1.getAvailableResource().getMemorySize());
        rm.stop();
    }

    @Test
    public void testMaxPriorityValidation() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setInt("yarn.cluster.max-application-priority", 10);
        Priority maxPriority = Priority.newInstance((int)10);
        MockRM rm = new MockRM(conf);
        rm.start();
        Priority appPriority1 = Priority.newInstance((int)15);
        rm.registerNode("127.0.0.1:1234", 8192);
        RMApp app1 = rm.submitApp(1024, appPriority1);
        Assert.assertEquals((Object)app1.getApplicationSubmissionContext().getPriority(), (Object)maxPriority);
        rm.stop();
    }

    @Test
    public void testUpdatePriorityAtRuntime() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setInt("yarn.cluster.max-application-priority", 10);
        MockRM rm = new MockRM(conf);
        rm.start();
        Priority appPriority1 = Priority.newInstance((int)5);
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 16384);
        RMApp app1 = rm.submitApp(1024, appPriority1);
        MockAM am1 = MockRM.launchAM(app1, rm, nm1);
        am1.registerAppAttempt();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        Priority appPriority2 = Priority.newInstance((int)8);
        cs.updateApplicationPriority(appPriority2, app1.getApplicationId());
        FiCaSchedulerApp schedulerAppAttempt = (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(app1.getApplicationId())).getCurrentAppAttempt();
        Assert.assertEquals((Object)appPriority2, (Object)schedulerAppAttempt.getPriority());
    }

    @Test
    public void testUpdateInvalidPriorityAtRuntime() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setInt("yarn.cluster.max-application-priority", 10);
        MockRM rm = new MockRM(conf);
        rm.start();
        Priority appPriority1 = Priority.newInstance((int)5);
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 16384);
        RMApp app1 = rm.submitApp(1024, appPriority1);
        MockAM am1 = MockRM.launchAM(app1, rm, nm1);
        am1.registerAppAttempt();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        Priority appPriority2 = Priority.newInstance((int)15);
        cs.updateApplicationPriority(appPriority2, app1.getApplicationId());
        FiCaSchedulerApp schedulerAppAttempt = (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(app1.getApplicationId())).getCurrentAppAttempt();
        Priority appPriority3 = Priority.newInstance((int)10);
        Assert.assertEquals((Object)appPriority3, (Object)schedulerAppAttempt.getPriority());
        rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=180000L)
    public void testRMRestartWithChangeInPriority() throws Exception {
        this.conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.conf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", false);
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path tmpDir = new Path(new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsolutePath());
        fs.delete(tmpDir, true);
        fs.mkdirs(tmpDir);
        try {
            this.conf.set("yarn.resourcemanager.fs.state-store.uri", tmpDir.toString());
            this.conf.set("yarn.resourcemanager.store.class", FileSystemRMStateStore.class.getName());
            this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            this.conf.setInt("yarn.cluster.max-application-priority", 10);
            MockRM rm1 = new MockRM((Configuration)this.conf);
            rm1.start();
            MockNM nm1 = new MockNM("127.0.0.1:1234", 15120, rm1.getResourceTrackerService());
            nm1.registerNode();
            Priority appPriority1 = Priority.newInstance((int)5);
            RMApp app1 = rm1.submitApp(1024, appPriority1);
            MockAM am1 = MockRM.launchAM(app1, rm1, nm1);
            am1.registerAppAttempt();
            CapacityScheduler cs = (CapacityScheduler)rm1.getResourceScheduler();
            Priority appPriority2 = Priority.newInstance((int)8);
            cs.updateApplicationPriority(appPriority2, app1.getApplicationId());
            Thread.sleep(1000L);
            MockRM rm2 = new MockRM((Configuration)this.conf);
            rm2.start();
            nm1.setResourceTrackerService(rm2.getResourceTrackerService());
            Assert.assertEquals((long)1L, (long)rm2.getRMContext().getRMApps().size());
            RMApp loadedApp = (RMApp)rm2.getRMContext().getRMApps().get(app1.getApplicationId());
            Assert.assertEquals((Object)appPriority2, (Object)loadedApp.getCurrentAppAttempt().getSubmissionContext().getPriority());
            rm2.stop();
            rm1.stop();
        }
        finally {
            fs.delete(tmpDir, true);
        }
    }

    @Test
    public void testApplicationPriorityAllocationWithChangeInPriority() throws Exception {
        Configuration conf = new Configuration();
        conf.setClass("yarn.resourcemanager.scheduler.class", CapacityScheduler.class, ResourceScheduler.class);
        conf.setInt("yarn.cluster.max-application-priority", 10);
        MockRM rm = new MockRM(conf);
        rm.start();
        Priority appPriority1 = Priority.newInstance((int)5);
        MockNM nm1 = rm.registerNode("127.0.0.1:1234", 16384);
        RMApp app1 = rm.submitApp(1024, appPriority1);
        MockAM am1 = MockRM.launchAM(app1, rm, nm1);
        am1.registerAppAttempt();
        int NUM_CONTAINERS = 7;
        List<Container> allocated1 = am1.allocateAndWaitForContainers("127.0.0.1", NUM_CONTAINERS, 2048, nm1);
        Assert.assertEquals((long)7L, (long)allocated1.size());
        Assert.assertEquals((long)2048L, (long)allocated1.get(0).getResource().getMemorySize());
        SchedulerNodeReport report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)15360L, (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)1024L, (long)report_nm1.getAvailableResource().getMemorySize());
        Priority appPriority2 = Priority.newInstance((int)8);
        RMApp app2 = rm.submitApp(1024, appPriority2);
        MockAM am2 = MockRM.launchAM(app2, rm, nm1);
        am2.registerAppAttempt();
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)16384L, (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)report_nm1.getAvailableResource().getMemorySize());
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        FiCaSchedulerApp schedulerAppAttemptApp1 = (FiCaSchedulerApp)((SchedulerApplication)cs.getSchedulerApplications().get(app1.getApplicationId())).getCurrentAppAttempt();
        int counter = 0;
        Iterator<Container> iterator = allocated1.iterator();
        while (iterator.hasNext()) {
            Container c = iterator.next();
            if (++counter > 2) break;
            cs.markContainerForKillable(schedulerAppAttemptApp1.getRMContainer(c.getId()));
            iterator.remove();
        }
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)12288L, (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)4096L, (long)report_nm1.getAvailableResource().getMemorySize());
        am1.allocate("127.0.0.1", 2048, 10, new ArrayList<ContainerId>());
        List<Container> allocated2 = am2.allocateAndWaitForContainers("127.0.0.1", 2, 2048, nm1);
        Assert.assertEquals((long)2L, (long)allocated2.size());
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)16384L, (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)0L, (long)report_nm1.getAvailableResource().getMemorySize());
        counter = 0;
        Iterator<Container> iterator2 = allocated1.iterator();
        while (iterator2.hasNext()) {
            Container c = iterator2.next();
            if (++counter > 1) break;
            cs.markContainerForKillable(schedulerAppAttemptApp1.getRMContainer(c.getId()));
            iterator2.remove();
        }
        report_nm1 = rm.getResourceScheduler().getNodeReport(nm1.getNodeId());
        Assert.assertEquals((long)14336L, (long)report_nm1.getUsedResource().getMemorySize());
        Assert.assertEquals((long)2048L, (long)report_nm1.getAvailableResource().getMemorySize());
        Priority appPriority3 = Priority.newInstance((int)3);
        cs.updateApplicationPriority(appPriority3, app2.getApplicationId());
        am2.allocate("127.0.0.1", 2048, 3, new ArrayList<ContainerId>());
        List<Container> allocated3 = am1.allocateAndWaitForContainers("127.0.0.1", 1, 2048, nm1);
        Assert.assertEquals((long)1L, (long)allocated3.size());
        Assert.assertEquals((long)6L, (long)schedulerAppAttemptApp1.getLiveContainers().size());
        rm.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOrderOfActivatingThePriorityApplicationOnRMRestart() throws Exception {
        this.conf.setBoolean("yarn.resourcemanager.recovery.enabled", true);
        this.conf.setBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path tmpDir = new Path(new File("target", this.getClass().getSimpleName() + "-tmpDir").getAbsolutePath());
        fs.delete(tmpDir, true);
        fs.mkdirs(tmpDir);
        try {
            this.conf.set("yarn.resourcemanager.fs.state-store.uri", tmpDir.toString());
            this.conf.set("yarn.resourcemanager.store.class", FileSystemRMStateStore.class.getName());
            this.conf.setInt("yarn.resourcemanager.am.max-attempts", 2);
            this.conf.setInt("yarn.cluster.max-application-priority", 10);
            MockRM rm1 = new MockRM((Configuration)this.conf){

                @Override
                protected Dispatcher createDispatcher() {
                    return new DrainDispatcher();
                }
            };
            rm1.start();
            MockNM nm1 = new MockNM("127.0.0.1:1234", 16384, rm1.getResourceTrackerService());
            nm1.registerNode();
            ((DrainDispatcher)rm1.getRMContext().getDispatcher()).await();
            ResourceScheduler scheduler = rm1.getRMContext().getScheduler();
            LeafQueue defaultQueue = (LeafQueue)((CapacityScheduler)scheduler).getQueue("default");
            int memory = (int)(defaultQueue.getAMResourceLimit().getMemorySize() / 2L);
            Priority appPriority1 = Priority.newInstance((int)5);
            RMApp app1 = rm1.submitApp(memory, appPriority1);
            MockAM am1 = MockRM.launchAM(app1, rm1, nm1);
            am1.registerAppAttempt();
            Priority appPriority2 = Priority.newInstance((int)6);
            RMApp app2 = rm1.submitApp(memory, appPriority2);
            MockAM am2 = MockRM.launchAM(app2, rm1, nm1);
            am2.registerAppAttempt();
            ((DrainDispatcher)rm1.getRMContext().getDispatcher()).await();
            Assert.assertEquals((long)2L, (long)defaultQueue.getNumActiveApplications());
            Assert.assertEquals((long)0L, (long)defaultQueue.getNumPendingApplications());
            Priority appPriority3 = Priority.newInstance((int)7);
            RMApp app3 = rm1.submitApp(memory, appPriority3);
            ((DrainDispatcher)rm1.getRMContext().getDispatcher()).await();
            Assert.assertEquals((long)2L, (long)defaultQueue.getNumActiveApplications());
            Assert.assertEquals((long)1L, (long)defaultQueue.getNumPendingApplications());
            Iterator iterator = defaultQueue.getOrderingPolicy().getSchedulableEntities().iterator();
            FiCaSchedulerApp fcApp2 = (FiCaSchedulerApp)iterator.next();
            Assert.assertEquals((Object)app2.getCurrentAppAttempt().getAppAttemptId(), (Object)fcApp2.getApplicationAttemptId());
            FiCaSchedulerApp fcApp1 = (FiCaSchedulerApp)iterator.next();
            Assert.assertEquals((Object)app1.getCurrentAppAttempt().getAppAttemptId(), (Object)fcApp1.getApplicationAttemptId());
            iterator = defaultQueue.getPendingApplications().iterator();
            FiCaSchedulerApp fcApp3 = (FiCaSchedulerApp)iterator.next();
            Assert.assertEquals((Object)app3.getCurrentAppAttempt().getAppAttemptId(), (Object)fcApp3.getApplicationAttemptId());
            MockRM rm2 = new MockRM((Configuration)this.conf){

                @Override
                protected Dispatcher createDispatcher() {
                    return new DrainDispatcher();
                }
            };
            rm2.start();
            nm1.setResourceTrackerService(rm2.getResourceTrackerService());
            Assert.assertEquals((long)3L, (long)rm2.getRMContext().getRMApps().size());
            ((DrainDispatcher)rm2.getRMContext().getDispatcher()).await();
            scheduler = rm2.getRMContext().getScheduler();
            defaultQueue = (LeafQueue)((CapacityScheduler)scheduler).getQueue("default");
            int count = 50;
            while (count-- > 0 && defaultQueue.getNumPendingApplications() != 3) {
                Thread.sleep(50L);
            }
            Assert.assertEquals((long)0L, (long)defaultQueue.getNumActiveApplications());
            Assert.assertEquals((long)3L, (long)defaultQueue.getNumPendingApplications());
            nm1.registerNode();
            ((DrainDispatcher)rm2.getRMContext().getDispatcher()).await();
            count = 50;
            while (count-- > 0 && defaultQueue.getNumActiveApplications() != 2) {
                Thread.sleep(50L);
            }
            Assert.assertEquals((long)2L, (long)defaultQueue.getNumActiveApplications());
            Assert.assertEquals((long)1L, (long)defaultQueue.getNumPendingApplications());
            iterator = defaultQueue.getOrderingPolicy().getSchedulableEntities().iterator();
            fcApp2 = (FiCaSchedulerApp)iterator.next();
            Assert.assertEquals((Object)app2.getCurrentAppAttempt().getAppAttemptId(), (Object)fcApp2.getApplicationAttemptId());
            fcApp1 = (FiCaSchedulerApp)iterator.next();
            Assert.assertEquals((Object)app1.getCurrentAppAttempt().getAppAttemptId(), (Object)fcApp1.getApplicationAttemptId());
            iterator = defaultQueue.getPendingApplications().iterator();
            fcApp3 = (FiCaSchedulerApp)iterator.next();
            Assert.assertEquals((Object)app3.getCurrentAppAttempt().getAppAttemptId(), (Object)fcApp3.getApplicationAttemptId());
            rm2.stop();
            rm1.stop();
        }
        finally {
            fs.delete(tmpDir, true);
        }
    }

    @Test(timeout=120000L)
    public void testUpdatePriorityOnPendingAppAndKillAttempt() throws Exception {
        int maxPriority = 10;
        int appPriority = 5;
        YarnConfiguration conf = new YarnConfiguration();
        conf.setInt("yarn.cluster.max-application-priority", maxPriority);
        MockRM rm = new MockRM((Configuration)conf);
        rm.init((Configuration)conf);
        rm.start();
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        LeafQueue defaultQueue = (LeafQueue)cs.getQueue("default");
        RMApp app1 = rm.submitApp(1024, Priority.newInstance((int)appPriority));
        Collection appsPending = defaultQueue.getPendingApplications();
        Collection activeApps = defaultQueue.getOrderingPolicy().getSchedulableEntities();
        Assert.assertEquals((String)"Pending apps should be 1", (long)1L, (long)appsPending.size());
        Assert.assertEquals((String)"Active apps should be 0", (long)0L, (long)activeApps.size());
        this.killAppAndVerifyOrderingPolicy(rm, (CSQueue)defaultQueue, 0, 0, app1);
        MockNM nm1 = new MockNM("127.0.0.1:1234", 8096, rm.getResourceTrackerService());
        nm1.registerNode();
        RMApp app2 = rm.submitApp(1024, Priority.newInstance((int)appPriority));
        Assert.assertEquals((String)"Pending apps should be 0", (long)0L, (long)appsPending.size());
        Assert.assertEquals((String)"Active apps should be 1", (long)1L, (long)activeApps.size());
        RMApp app3 = rm.submitApp(1024, Priority.newInstance((int)appPriority));
        RMApp app4 = rm.submitApp(1024, Priority.newInstance((int)appPriority));
        Assert.assertEquals((String)"Pending apps should be 2", (long)2L, (long)appsPending.size());
        Assert.assertEquals((String)"Active apps should be 1", (long)1L, (long)activeApps.size());
        this.killAppAndVerifyOrderingPolicy(rm, (CSQueue)defaultQueue, 1, 1, app3);
        this.killAppAndVerifyOrderingPolicy(rm, (CSQueue)defaultQueue, 0, 1, app2);
        this.killAppAndVerifyOrderingPolicy(rm, (CSQueue)defaultQueue, 0, 0, app4);
        rm.stop();
    }

    private void killAppAndVerifyOrderingPolicy(MockRM rm, CSQueue defaultQueue, int appsPendingExpected, int activeAppsExpected, RMApp app) throws YarnException {
        CapacityScheduler cs = (CapacityScheduler)rm.getResourceScheduler();
        cs.updateApplicationPriority(Priority.newInstance((int)2), app.getApplicationId());
        AppAttemptRemovedSchedulerEvent removeAttempt = new AppAttemptRemovedSchedulerEvent(app.getCurrentAppAttempt().getAppAttemptId(), RMAppAttemptState.KILLED, false);
        cs.handle((SchedulerEvent)removeAttempt);
        rm.drainEvents();
        Collection appsPending = ((LeafQueue)defaultQueue).getPendingApplications();
        Collection activeApps = ((LeafQueue)defaultQueue).getApplications();
        Assert.assertEquals((String)("Pending apps should be " + appsPendingExpected), (long)appsPendingExpected, (long)appsPending.size());
        Assert.assertEquals((String)("Active apps should be " + activeAppsExpected), (long)activeAppsExpected, (long)activeApps.size());
    }
}

