/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import com.google.protobuf.InvalidProtocolBufferException;
import io.hops.exception.StorageException;
import io.hops.metadata.common.entity.ByteArrayVariable;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.hdfs.dal.VariableDataAccess;
import io.hops.metadata.yarn.dal.ContainerIdToCleanDataAccess;
import io.hops.metadata.yarn.dal.ContainerStatusDataAccess;
import io.hops.metadata.yarn.dal.ContainerToDecreaseDataAccess;
import io.hops.metadata.yarn.dal.ContainerToSignalDataAccess;
import io.hops.metadata.yarn.dal.NextHeartbeatDataAccess;
import io.hops.metadata.yarn.dal.PendingEventDataAccess;
import io.hops.metadata.yarn.dal.RMLoadDataAccess;
import io.hops.metadata.yarn.dal.RMNodeApplicationsDataAccess;
import io.hops.metadata.yarn.dal.UpdatedContainerInfoDataAccess;
import io.hops.metadata.yarn.dal.util.YARNOperationType;
import io.hops.metadata.yarn.entity.Container;
import io.hops.metadata.yarn.entity.ContainerId;
import io.hops.metadata.yarn.entity.ContainerToSignal;
import io.hops.metadata.yarn.entity.Load;
import io.hops.metadata.yarn.entity.NextHeartbeat;
import io.hops.metadata.yarn.entity.PendingEvent;
import io.hops.metadata.yarn.entity.RMNodeApplication;
import io.hops.metadata.yarn.entity.RMNodeComps;
import io.hops.transaction.handler.AsyncLightWeightRequestHandler;
import io.hops.transaction.handler.LightWeightRequestHandler;
import io.hops.transaction.handler.RequestHandler;
import io.hops.util.RMStorageFactory;
import io.hops.util.YarnAPIStorageFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.yarn.api.protocolrecords.SignalContainerRequest;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceTrackerService;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNodeImplDist;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.util.ConverterUtils;

public class DBUtility {
    private static final Log LOG = LogFactory.getLog(DBUtility.class);

    public static void removeContainersToClean(final Set<org.apache.hadoop.yarn.api.records.ContainerId> containers, final NodeId nodeId) throws IOException {
        long start = System.currentTimeMillis();
        AsyncLightWeightRequestHandler removeContainerToClean = new AsyncLightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ContainerIdToCleanDataAccess ctcDA = (ContainerIdToCleanDataAccess)RMStorageFactory.getDataAccess(ContainerIdToCleanDataAccess.class);
                ArrayList<ContainerId> containersToClean = new ArrayList<ContainerId>();
                for (org.apache.hadoop.yarn.api.records.ContainerId cid : containers) {
                    containersToClean.add(new ContainerId(nodeId.toString(), cid.toString()));
                }
                ctcDA.removeAll(containersToClean);
                connector.commit();
                return null;
            }
        };
        removeContainerToClean.handle();
        long duration = System.currentTimeMillis() - start;
        if (duration > 10L) {
            LOG.error((Object)("too long " + duration));
        }
    }

    public static void removeContainersToSignal(final Set<SignalContainerRequest> containerRequests, final NodeId nodeId) throws IOException {
        long start = System.currentTimeMillis();
        AsyncLightWeightRequestHandler removeContainerToSignal = new AsyncLightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ContainerToSignalDataAccess ctsDA = (ContainerToSignalDataAccess)RMStorageFactory.getDataAccess(ContainerToSignalDataAccess.class);
                ArrayList<ContainerToSignal> containersToSignal = new ArrayList<ContainerToSignal>();
                for (SignalContainerRequest cr : containerRequests) {
                    containersToSignal.add(new ContainerToSignal(nodeId.toString(), cr.getContainerId().toString(), cr.getCommand().toString()));
                }
                ctsDA.removeAll(containersToSignal);
                connector.commit();
                return null;
            }
        };
        removeContainerToSignal.handle();
        long duration = System.currentTimeMillis() - start;
        if (duration > 10L) {
            LOG.error((Object)("too long " + duration));
        }
    }

    public static void addContainerToSignal(final SignalContainerRequest containerRequest, final NodeId nodeId) throws IOException {
        long start = System.currentTimeMillis();
        AsyncLightWeightRequestHandler addContainerToSignal = new AsyncLightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ContainerToSignalDataAccess ctsDA = (ContainerToSignalDataAccess)RMStorageFactory.getDataAccess(ContainerToSignalDataAccess.class);
                ContainerToSignal containerToSignal = new ContainerToSignal(nodeId.toString(), containerRequest.getContainerId().toString(), containerRequest.getCommand().toString());
                ctsDA.add((Object)containerToSignal);
                connector.commit();
                return null;
            }
        };
        addContainerToSignal.handle();
        long duration = System.currentTimeMillis() - start;
        if (duration > 10L) {
            LOG.error((Object)("too long " + duration));
        }
    }

    public static void removeContainersToDecrease(final Collection<org.apache.hadoop.yarn.api.records.Container> containers) throws IOException {
        long start = System.currentTimeMillis();
        AsyncLightWeightRequestHandler removeContainerToDecrease = new AsyncLightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ContainerToDecreaseDataAccess ctsDA = (ContainerToDecreaseDataAccess)RMStorageFactory.getDataAccess(ContainerToDecreaseDataAccess.class);
                ArrayList<Container> containersToDecrease = new ArrayList<Container>();
                for (org.apache.hadoop.yarn.api.records.Container container : containers) {
                    containersToDecrease.add(new Container(container.getId().toString(), container.getNodeId().toString(), container.getNodeHttpAddress(), container.getPriority().getPriority(), container.getResource().getMemorySize(), container.getResource().getVirtualCores(), container.getResource().getGPUs(), container.getVersion()));
                }
                ctsDA.removeAll(containersToDecrease);
                connector.commit();
                return null;
            }
        };
        removeContainerToDecrease.handle();
        long duration = System.currentTimeMillis() - start;
        if (duration > 10L) {
            LOG.error((Object)("too long " + duration));
        }
    }

    public static void addContainersToDecrease(final List<org.apache.hadoop.yarn.api.records.Container> containers) throws IOException {
        long start = System.currentTimeMillis();
        AsyncLightWeightRequestHandler addContainerToDecrease = new AsyncLightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ContainerToDecreaseDataAccess ctsDA = (ContainerToDecreaseDataAccess)RMStorageFactory.getDataAccess(ContainerToDecreaseDataAccess.class);
                ArrayList<Container> containersToDecrease = new ArrayList<Container>();
                for (org.apache.hadoop.yarn.api.records.Container container : containers) {
                    containersToDecrease.add(new Container(container.getId().toString(), container.getNodeId().toString(), container.getNodeHttpAddress(), container.getPriority().getPriority(), container.getResource().getMemorySize(), container.getResource().getVirtualCores(), container.getResource().getGPUs(), container.getVersion()));
                }
                ctsDA.addAll(containersToDecrease);
                connector.commit();
                return null;
            }
        };
        addContainerToDecrease.handle();
        long duration = System.currentTimeMillis() - start;
        if (duration > 10L) {
            LOG.error((Object)("too long " + duration));
        }
    }

    public static void removeRMNodeApplications(final List<ApplicationId> applications, final NodeId nodeId, final RMNodeApplication.RMNodeApplicationStatus status) throws IOException {
        long start = System.currentTimeMillis();
        AsyncLightWeightRequestHandler removeRMNodeApplication = new AsyncLightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                RMNodeApplicationsDataAccess faDA = (RMNodeApplicationsDataAccess)RMStorageFactory.getDataAccess(RMNodeApplicationsDataAccess.class);
                ArrayList<RMNodeApplication> rmNodeApps = new ArrayList<RMNodeApplication>();
                for (ApplicationId appId : applications) {
                    rmNodeApps.add(new RMNodeApplication(nodeId.toString(), appId.toString(), status));
                }
                faDA.removeAll(rmNodeApps);
                connector.commit();
                return null;
            }
        };
        removeRMNodeApplication.handle();
        long duration = System.currentTimeMillis() - start;
        if (duration > 10L) {
            LOG.error((Object)("too long " + duration));
        }
    }

    public static void removeRMNodeApplication(final ApplicationId appId, final NodeId nodeId, final RMNodeApplication.RMNodeApplicationStatus status) throws IOException {
        long start = System.currentTimeMillis();
        AsyncLightWeightRequestHandler removeRMNodeApplication = new AsyncLightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                RMNodeApplicationsDataAccess faDA = (RMNodeApplicationsDataAccess)RMStorageFactory.getDataAccess(RMNodeApplicationsDataAccess.class);
                RMNodeApplication rmNodeApp = new RMNodeApplication(nodeId.toString(), appId.toString(), status);
                faDA.remove((Object)rmNodeApp);
                connector.commit();
                return null;
            }
        };
        removeRMNodeApplication.handle();
        long duration = System.currentTimeMillis() - start;
        if (duration > 10L) {
            LOG.error((Object)("too long " + duration));
        }
    }

    public static void addRMNodeApplication(final ApplicationId appId, final NodeId nodeId, final RMNodeApplication.RMNodeApplicationStatus status) throws IOException {
        long start = System.currentTimeMillis();
        AsyncLightWeightRequestHandler addRMNodeApplication = new AsyncLightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                RMNodeApplicationsDataAccess faDA = (RMNodeApplicationsDataAccess)RMStorageFactory.getDataAccess(RMNodeApplicationsDataAccess.class);
                faDA.add((Object)new RMNodeApplication(nodeId.toString(), appId.toString(), status));
                connector.commit();
                return null;
            }
        };
        addRMNodeApplication.handle();
        long duration = System.currentTimeMillis() - start;
        if (duration > 10L) {
            LOG.error((Object)("too long " + duration));
        }
    }

    public static void addContainerToClean(final org.apache.hadoop.yarn.api.records.ContainerId containerId, final NodeId nodeId) throws IOException {
        long start = System.currentTimeMillis();
        AsyncLightWeightRequestHandler addContainerToClean = new AsyncLightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                ContainerIdToCleanDataAccess ctcDA = (ContainerIdToCleanDataAccess)RMStorageFactory.getDataAccess(ContainerIdToCleanDataAccess.class);
                ctcDA.add((Object)new ContainerId(nodeId.toString(), containerId.toString()));
                connector.commit();
                return null;
            }
        };
        addContainerToClean.handle();
        long duration = System.currentTimeMillis() - start;
        if (duration > 10L) {
            LOG.error((Object)("too long " + duration));
        }
    }

    public static RMNode processHopRMNodeCompsForScheduler(RMNodeComps hopRMNodeComps, RMContext rmContext) throws InvalidProtocolBufferException {
        RMNode rmNode = null;
        if (hopRMNodeComps != null) {
            NodeId nodeId = ConverterUtils.toNodeId((String)hopRMNodeComps.getRMNodeId());
            rmNode = (RMNode)rmContext.getRMNodes().get(nodeId);
            if (rmNode == null) {
                boolean nextHeartbeat = true;
                Resource resource = null;
                if (hopRMNodeComps.getHopResource() != null) {
                    resource = Resource.newInstance((int)hopRMNodeComps.getHopResource().getMemory(), (int)hopRMNodeComps.getHopResource().getVirtualCores());
                } else {
                    LOG.error((Object)"ResourceOption should not be null");
                    resource = Resource.newInstance((int)0, (int)0);
                }
                rmNode = new RMNodeImplDist(nodeId, rmContext, hopRMNodeComps.getHopRMNode().getHostName(), hopRMNodeComps.getHopRMNode().getCommandPort(), hopRMNodeComps.getHopRMNode().getHttpPort(), ResourceTrackerService.resolve(hopRMNodeComps.getHopRMNode().getHostName()), resource, hopRMNodeComps.getHopRMNode().getNodemanagerVersion());
                NetUtils.createSocketAddrForHost((String)nodeId.getHost(), (int)nodeId.getPort());
            }
            if (hopRMNodeComps.getHopRMNode() != null) {
                ((RMNodeImplDist)rmNode).setState(hopRMNodeComps.getHopRMNode().getCurrentState());
            }
            if (hopRMNodeComps.getHopUpdatedContainerInfo() != null) {
                List hopUpdatedContainerInfoList = hopRMNodeComps.getHopUpdatedContainerInfo();
                if (hopUpdatedContainerInfoList != null && !hopUpdatedContainerInfoList.isEmpty()) {
                    ConcurrentLinkedQueue<UpdatedContainerInfo> updatedContainerInfoQueue = new ConcurrentLinkedQueue<UpdatedContainerInfo>();
                    HashMap<Integer, UpdatedContainerInfo> ucis = new HashMap<Integer, UpdatedContainerInfo>();
                    LOG.debug((Object)(hopRMNodeComps.getRMNodeId() + " getting ucis " + hopUpdatedContainerInfoList.size() + " pending event " + hopRMNodeComps.getPendingEvent().getId().getEventId()));
                    for (io.hops.metadata.yarn.entity.UpdatedContainerInfo hopUCI : hopUpdatedContainerInfoList) {
                        io.hops.metadata.yarn.entity.ContainerStatus hopContainerStatus;
                        org.apache.hadoop.yarn.api.records.ContainerId cid;
                        ContainerStatus conStatus;
                        if (!ucis.containsKey(hopUCI.getUpdatedContainerInfoId())) {
                            ucis.put(hopUCI.getUpdatedContainerInfoId(), new UpdatedContainerInfo(new ArrayList<ContainerStatus>(), new ArrayList<ContainerStatus>(), hopUCI.getUpdatedContainerInfoId()));
                        }
                        if ((conStatus = ContainerStatus.newInstance((org.apache.hadoop.yarn.api.records.ContainerId)(cid = ConverterUtils.toContainerId((String)hopUCI.getContainerId())), (ContainerState)ContainerState.valueOf((String)(hopContainerStatus = (io.hops.metadata.yarn.entity.ContainerStatus)hopRMNodeComps.getHopContainersStatusMap().get(hopUCI.getContainerId())).getState()), (String)hopContainerStatus.getDiagnostics(), (int)hopContainerStatus.getExitstatus())) == null) continue;
                        LOG.debug((Object)("add uci for container " + conStatus.getContainerId() + " status " + conStatus.getState()));
                        if (conStatus.getState().equals((Object)ContainerState.RUNNING)) {
                            ((UpdatedContainerInfo)ucis.get(hopUCI.getUpdatedContainerInfoId())).getNewlyLaunchedContainers().add(conStatus);
                            continue;
                        }
                        if (!conStatus.getState().equals((Object)ContainerState.COMPLETE)) continue;
                        ((UpdatedContainerInfo)ucis.get(hopUCI.getUpdatedContainerInfoId())).getCompletedContainers().add(conStatus);
                    }
                    for (UpdatedContainerInfo uci : ucis.values()) {
                        updatedContainerInfoQueue.add(uci);
                    }
                    ((RMNodeImplDist)rmNode).setUpdatedContainerInfo(updatedContainerInfoQueue);
                } else {
                    LOG.debug((Object)(hopRMNodeComps.getRMNodeId() + " hopUpdatedContainerInfoList = null || hopUpdatedContainerInfoList.isEmpty() " + hopRMNodeComps.getPendingEvent().getId().getEventId()));
                }
            } else {
                LOG.debug((Object)(hopRMNodeComps.getRMNodeId() + " hopRMNodeFull.getHopUpdatedContainerInfo()=null " + hopRMNodeComps.getPendingEvent().getId().getEventId()));
            }
        }
        return rmNode;
    }

    public static void addNextHB(final boolean nextHB, final String nodeId) throws IOException {
        long start = System.currentTimeMillis();
        AsyncLightWeightRequestHandler addNextHB = new AsyncLightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                NextHeartbeatDataAccess nhbDA = (NextHeartbeatDataAccess)RMStorageFactory.getDataAccess(NextHeartbeatDataAccess.class);
                nhbDA.update(new NextHeartbeat(nodeId, nextHB));
                connector.commit();
                return null;
            }
        };
        addNextHB.handle();
        long duration = System.currentTimeMillis() - start;
        if (duration > 10L) {
            LOG.error((Object)("too long " + duration));
        }
    }

    public static void removeUCI(List<UpdatedContainerInfo> ContainerInfoList, String nodeId) throws IOException {
        long start = System.currentTimeMillis();
        final ArrayList<io.hops.metadata.yarn.entity.UpdatedContainerInfo> uciToRemove = new ArrayList<io.hops.metadata.yarn.entity.UpdatedContainerInfo>();
        final ArrayList<io.hops.metadata.yarn.entity.ContainerStatus> containerStatusToRemove = new ArrayList<io.hops.metadata.yarn.entity.ContainerStatus>();
        for (UpdatedContainerInfo uci : ContainerInfoList) {
            io.hops.metadata.yarn.entity.ContainerStatus hopConStatus;
            io.hops.metadata.yarn.entity.UpdatedContainerInfo hopUCI;
            if (uci.getNewlyLaunchedContainers() != null && !uci.getNewlyLaunchedContainers().isEmpty()) {
                for (ContainerStatus containerStatus : uci.getNewlyLaunchedContainers()) {
                    hopUCI = new io.hops.metadata.yarn.entity.UpdatedContainerInfo(nodeId, containerStatus.getContainerId().toString(), uci.getUciId());
                    uciToRemove.add(hopUCI);
                    hopConStatus = new io.hops.metadata.yarn.entity.ContainerStatus(containerStatus.getContainerId().toString(), nodeId, uci.getUciId());
                    containerStatusToRemove.add(hopConStatus);
                }
            }
            if (uci.getCompletedContainers() == null || uci.getCompletedContainers().isEmpty()) continue;
            for (ContainerStatus containerStatus : uci.getCompletedContainers()) {
                hopUCI = new io.hops.metadata.yarn.entity.UpdatedContainerInfo(nodeId, containerStatus.getContainerId().toString(), uci.getUciId());
                uciToRemove.add(hopUCI);
                hopConStatus = new io.hops.metadata.yarn.entity.ContainerStatus(containerStatus.getContainerId().toString(), nodeId, uci.getUciId());
                containerStatusToRemove.add(hopConStatus);
            }
        }
        AsyncLightWeightRequestHandler removeUCIHandler = new AsyncLightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws StorageException {
                connector.beginTransaction();
                connector.writeLock();
                UpdatedContainerInfoDataAccess uciDA = (UpdatedContainerInfoDataAccess)RMStorageFactory.getDataAccess(UpdatedContainerInfoDataAccess.class);
                uciDA.removeAll((Collection)uciToRemove);
                ContainerStatusDataAccess csDA = (ContainerStatusDataAccess)RMStorageFactory.getDataAccess(ContainerStatusDataAccess.class);
                csDA.removeAll((Collection)containerStatusToRemove);
                connector.commit();
                return null;
            }
        };
        removeUCIHandler.handle();
        long duration = System.currentTimeMillis() - start;
        if (duration > 10L) {
            LOG.error((Object)("too long " + duration));
        }
    }

    public static Map<String, Load> getAllLoads() throws IOException {
        LightWeightRequestHandler getLoadHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws IOException {
                connector.beginTransaction();
                connector.readCommitted();
                RMLoadDataAccess DA = (RMLoadDataAccess)YarnAPIStorageFactory.getDataAccess(RMLoadDataAccess.class);
                Map res = DA.getAll();
                connector.commit();
                return res;
            }
        };
        return (Map)getLoadHandler.handle();
    }

    public static void updateLoad(final Load load) throws IOException {
        AsyncLightWeightRequestHandler updateLoadHandler = new AsyncLightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws IOException {
                connector.beginTransaction();
                connector.readCommitted();
                RMLoadDataAccess DA = (RMLoadDataAccess)YarnAPIStorageFactory.getDataAccess(RMLoadDataAccess.class);
                DA.update((Object)load);
                connector.commit();
                return null;
            }
        };
        updateLoadHandler.handle();
    }

    public static void removePendingEvent(String rmNodeId, PendingEvent.Type type, PendingEvent.Status status, int id, int contains) throws IOException {
        long start = System.currentTimeMillis();
        final PendingEvent pendingEvent = new PendingEvent(rmNodeId, type, status, id, contains);
        AsyncLightWeightRequestHandler removePendingEvents = new AsyncLightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws IOException {
                connector.beginTransaction();
                connector.writeLock();
                PendingEventDataAccess pendingEventDAO = (PendingEventDataAccess)YarnAPIStorageFactory.getDataAccess(PendingEventDataAccess.class);
                pendingEventDAO.removePendingEvent((Object)pendingEvent);
                connector.commit();
                return null;
            }
        };
        removePendingEvents.handle();
        long duration = System.currentTimeMillis() - start;
        if (duration > 10L) {
            LOG.error((Object)("too long " + duration));
        }
    }

    public static boolean InitializeDB() throws IOException {
        LightWeightRequestHandler setRMDTMasterKeyHandler = new LightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws IOException {
                boolean success = connector.formatStorage();
                LOG.debug((Object)("HOP :: Format storage has been completed: " + success));
                return success;
            }
        };
        return (Boolean)setRMDTMasterKeyHandler.handle();
    }

    public static byte[] verifySalt(final byte[] salt) throws IOException {
        AsyncLightWeightRequestHandler verifySalt = new AsyncLightWeightRequestHandler((RequestHandler.OperationType)YARNOperationType.TEST){

            public Object performTask() throws IOException {
                connector.beginTransaction();
                connector.writeLock();
                VariableDataAccess variableDAO = (VariableDataAccess)YarnAPIStorageFactory.getDataAccess(VariableDataAccess.class);
                Variable var = null;
                try {
                    var = (Variable)variableDAO.getVariable((Object)Variable.Finder.Seed);
                }
                catch (StorageException ex) {
                    LOG.warn((Object)ex);
                }
                if (var == null) {
                    var = new ByteArrayVariable(Variable.Finder.Seed, salt);
                    variableDAO.setVariable(var);
                }
                connector.commit();
                return var.getBytes();
            }
        };
        byte[] s = (byte[])verifySalt.handle();
        return s;
    }
}

