/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import io.hops.DalDriver;
import io.hops.DalEventStreaming;
import io.hops.DalStorageFactory;
import io.hops.StorageConnector;
import io.hops.exception.StorageInitializtionException;
import io.hops.metadata.common.EntityDataAccess;
import io.hops.metadata.common.entity.ArrayVariable;
import io.hops.metadata.common.entity.ByteArrayVariable;
import io.hops.metadata.common.entity.IntVariable;
import io.hops.metadata.common.entity.LongVariable;
import io.hops.metadata.common.entity.StringVariable;
import io.hops.metadata.common.entity.Variable;
import io.hops.metadata.election.dal.LeDescriptorDataAccess;
import io.hops.metadata.election.dal.YarnLeDescriptorDataAccess;
import io.hops.metadata.election.entity.LeDescriptor;
import io.hops.metadata.hdfs.dal.GroupDataAccess;
import io.hops.metadata.hdfs.dal.UserDataAccess;
import io.hops.metadata.hdfs.dal.UserGroupDataAccess;
import io.hops.metadata.hdfs.dal.VariableDataAccess;
import io.hops.security.UsersGroups;
import io.hops.transaction.EntityManager;
import io.hops.transaction.context.ContextInitializer;
import io.hops.transaction.context.EntityContext;
import io.hops.transaction.context.LeSnapshot;
import io.hops.transaction.context.VariableContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public class RMStorageFactory {
    private static final Log LOG = LogFactory.getLog(RMStorageFactory.class);
    private static boolean isInitialized = false;
    private static DalStorageFactory dStorageFactory;
    private static Map<Class, EntityDataAccess> dataAccessAdaptors;
    private static DalEventStreaming dEventStreaming;
    private static boolean streaingRunning;

    public static StorageConnector getConnector() {
        return dStorageFactory.getConnector();
    }

    public static synchronized void kickEventStreamingAPI(boolean isLeader, Configuration conf) throws StorageInitializtionException {
        dEventStreaming = DalDriver.loadHopsEventStreamingLib((String)"io.hops.metadata.ndb.JniNdbEventStreaming");
        String connectionString = dStorageFactory.getConnector().getClusterConnectString() + ":" + conf.getInt("hops.yarn.resourcemanager.event-streaming.db.port", YarnConfiguration.DEFAULT_HOPS_EVENT_STREAMING_DB_PORT);
        dEventStreaming.init(connectionString, dStorageFactory.getConnector().getDatabaseName());
        dEventStreaming.startHopsEvetAPISession(isLeader);
        streaingRunning = true;
    }

    public static synchronized void stopEventStreamingAPI() {
        if (streaingRunning && dEventStreaming != null) {
            streaingRunning = false;
            dEventStreaming.closeHopsEventAPISession();
        }
    }

    public static void setConfiguration(Configuration conf) throws StorageInitializtionException, IOException {
        if (isInitialized) {
            return;
        }
        RMStorageFactory.addToClassPath(conf.get("dfs.storage.driver.jarFile", ""));
        dStorageFactory = DalDriver.load((String)conf.get("dfs.storage.driver.class", "io.hops.metadata.ndb.NdbStorageFactory"));
        dStorageFactory.setConfiguration(RMStorageFactory.getMetadataClusterConfiguration(conf));
        RMStorageFactory.initDataAccessWrappers();
        EntityManager.addContextInitializer((ContextInitializer)RMStorageFactory.getContextInitializer());
        if (conf.getBoolean("hops.groups.updater.round", true)) {
            UsersGroups.init((UserDataAccess)((UserDataAccess)RMStorageFactory.getDataAccess(UserDataAccess.class)), (UserGroupDataAccess)((UserGroupDataAccess)RMStorageFactory.getDataAccess(UserGroupDataAccess.class)), (GroupDataAccess)((GroupDataAccess)RMStorageFactory.getDataAccess(GroupDataAccess.class)), (int)conf.getInt("hops.groups.updater.round", 120), (int)conf.getInt("hops.users.lru.threshold", 10000));
        }
        isInitialized = true;
    }

    public static Properties getMetadataClusterConfiguration(Configuration conf) throws IOException {
        String configFile = conf.get("dfs.storage.driver.configfile", "ndb-config.properties");
        Properties clusterConf = new Properties();
        InputStream inStream = StorageConnector.class.getClassLoader().getResourceAsStream(configFile);
        clusterConf.load(inStream);
        return clusterConf;
    }

    private static void addToClassPath(String s) throws StorageInitializtionException {
        try {
            File f = new File(s);
            URL u = f.toURI().toURL();
            URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> urlClass = URLClassLoader.class;
            Method method = urlClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlClassLoader, u);
        }
        catch (MalformedURLException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
        catch (SecurityException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
    }

    private static void initDataAccessWrappers() {
        dataAccessAdaptors.clear();
    }

    private static ContextInitializer getContextInitializer() {
        return new ContextInitializer(){

            public Map<Class, EntityContext> createEntityContexts() {
                HashMap<Class, EntityContext> entityContexts = new HashMap<Class, EntityContext>();
                VariableContext variableContext = new VariableContext((VariableDataAccess)RMStorageFactory.getDataAccess(VariableDataAccess.class));
                entityContexts.put(IntVariable.class, (EntityContext)variableContext);
                entityContexts.put(LongVariable.class, (EntityContext)variableContext);
                entityContexts.put(ByteArrayVariable.class, (EntityContext)variableContext);
                entityContexts.put(StringVariable.class, (EntityContext)variableContext);
                entityContexts.put(ArrayVariable.class, (EntityContext)variableContext);
                entityContexts.put(Variable.class, (EntityContext)variableContext);
                entityContexts.put(LeDescriptor.YarnLeDescriptor.class, (EntityContext)new LeSnapshot.YarnLESnapshot((LeDescriptorDataAccess)RMStorageFactory.getDataAccess(YarnLeDescriptorDataAccess.class)));
                return entityContexts;
            }

            public StorageConnector getConnector() {
                return dStorageFactory.getConnector();
            }
        };
    }

    public static EntityDataAccess getDataAccess(Class type) {
        if (dataAccessAdaptors.containsKey(type)) {
            return dataAccessAdaptors.get(type);
        }
        return dStorageFactory.getDataAccess(type);
    }

    static {
        dataAccessAdaptors = new HashMap<Class, EntityDataAccess>();
        streaingRunning = false;
    }
}

