/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery.records;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.ipc.CallerContext;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class ApplicationStateData {
    public Map<ApplicationAttemptId, ApplicationAttemptStateData> attempts = new HashMap<ApplicationAttemptId, ApplicationAttemptStateData>();

    public static ApplicationStateData newInstance(long submitTime, long startTime, String user, ApplicationSubmissionContext submissionContext, RMAppState state, String diagnostics, long finishTime, CallerContext callerContext) {
        ApplicationStateData appState = (ApplicationStateData)Records.newRecord(ApplicationStateData.class);
        appState.setSubmitTime(submitTime);
        appState.setStartTime(startTime);
        appState.setUser(user);
        appState.setApplicationSubmissionContext(submissionContext);
        appState.setState(state);
        appState.setDiagnostics(diagnostics);
        appState.setFinishTime(finishTime);
        appState.setCallerContext(callerContext);
        return appState;
    }

    public static ApplicationStateData newInstance(long submitTime, long startTime, ApplicationSubmissionContext context, String user, CallerContext callerContext, byte[] keyStore, char[] keyStorePassword, byte[] trustStore, char[] trustStorePassword, Integer cryptoMaterialVersion, long certificateExpiration, boolean isDuringMaterialRotation, long materialRotationStartTime) {
        ApplicationStateData appState = ApplicationStateData.newInstance(submitTime, startTime, context, user, callerContext);
        appState.setKeyStore(keyStore);
        appState.setKeyStorePassword(keyStorePassword);
        appState.setTrustStore(trustStore);
        appState.setTrustStorePassword(trustStorePassword);
        appState.setCryptoMaterialVersion(cryptoMaterialVersion);
        appState.setCertificateExpiration(certificateExpiration);
        appState.setIsDuringMaterialRotation(isDuringMaterialRotation);
        appState.setMaterialRotationStartTime(materialRotationStartTime);
        return appState;
    }

    public static ApplicationStateData newInstance(long submitTime, long startTime, ApplicationSubmissionContext context, String user, CallerContext callerContext) {
        return ApplicationStateData.newInstance(submitTime, startTime, user, context, null, "", 0L, callerContext);
    }

    public static ApplicationStateData newInstance(long submitTime, long startTime, ApplicationSubmissionContext context, String user) {
        return ApplicationStateData.newInstance(submitTime, startTime, context, user, null);
    }

    public int getAttemptCount() {
        return this.attempts.size();
    }

    public ApplicationAttemptStateData getAttempt(ApplicationAttemptId attemptId) {
        return this.attempts.get(attemptId);
    }

    public abstract YarnServerResourceManagerRecoveryProtos.ApplicationStateDataProto getProto();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract long getSubmitTime();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setSubmitTime(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Stable
    public abstract long getStartTime();

    @InterfaceAudience.Private
    @InterfaceStability.Unstable
    public abstract void setStartTime(long var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setUser(String var1);

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract String getUser();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract ApplicationSubmissionContext getApplicationSubmissionContext();

    @InterfaceAudience.Public
    @InterfaceStability.Unstable
    public abstract void setApplicationSubmissionContext(ApplicationSubmissionContext var1);

    public abstract RMAppState getState();

    public abstract void setState(RMAppState var1);

    public abstract String getDiagnostics();

    public abstract void setDiagnostics(String var1);

    public abstract long getFinishTime();

    public abstract void setFinishTime(long var1);

    public abstract CallerContext getCallerContext();

    public abstract void setCallerContext(CallerContext var1);

    public abstract byte[] getKeyStore();

    public abstract void setKeyStore(byte[] var1);

    public abstract char[] getKeyStorePassword();

    public abstract void setKeyStorePassword(char[] var1);

    public abstract byte[] getTrustStore();

    public abstract void setTrustStore(byte[] var1);

    public abstract char[] getTrustStorePassword();

    public abstract void setTrustStorePassword(char[] var1);

    public abstract Integer getCryptoMaterialVersion();

    public abstract void setCryptoMaterialVersion(Integer var1);

    public abstract long getCertificateExpiration();

    public abstract void setCertificateExpiration(long var1);

    public abstract boolean isDuringMaterialRotation();

    public abstract void setIsDuringMaterialRotation(boolean var1);

    public abstract long getMaterialRotationStartTime();

    public abstract void setMaterialRotationStartTime(long var1);
}

