/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMAppCertificateActions;
import org.apache.http.HttpEntity;
import org.apache.http.client.CookieStore;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.bouncycastle.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemWriter;

public class HopsworksRMAppCertificateActions
implements RMAppCertificateActions,
Configurable {
    public static final String HOPSWORKS_USER_KEY = "hops.hopsworks.user";
    public static final String HOPSWORKS_PASSWORD_KEY = "hops.hopsworks.password";
    private static final Log LOG = LogFactory.getLog(HopsworksRMAppCertificateActions.class);
    private static final Set<Integer> ACCEPTABLE_HTTP_RESPONSES = new HashSet<Integer>(2);
    private Configuration conf;
    private Configuration sslConf;
    private URL hopsworksHost;
    private URL loginEndpoint;
    private URL signEndpoint;
    private URL revokeEndpoint;
    private CertificateFactory certificateFactory;

    public HopsworksRMAppCertificateActions() throws MalformedURLException, GeneralSecurityException {
        ACCEPTABLE_HTTP_RESPONSES.add(200);
        ACCEPTABLE_HTTP_RESPONSES.add(204);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    public void init() throws MalformedURLException, GeneralSecurityException {
        this.hopsworksHost = new URL(this.conf.get(YarnConfiguration.HOPS_HOPSWORKS_HOST_KEY, "http://127.0.0.1"));
        this.loginEndpoint = new URL(this.hopsworksHost, this.conf.get(YarnConfiguration.HOPS_HOPSWORKS_LOGIN_ENDPOINT_KEY, YarnConfiguration.DEFAULT_HOPS_HOPSWORKS_LOGIN_ENDPOINT));
        this.signEndpoint = new URL(this.hopsworksHost, this.conf.get(YarnConfiguration.HOPS_HOPSWORKS_SIGN_ENDPOINT_KEY, YarnConfiguration.DEFAULT_HOPS_HOPSWORKS_SIGN_ENDPOINT));
        this.revokeEndpoint = new URL(this.hopsworksHost, this.conf.get(YarnConfiguration.HOPS_HOPSWORKS_REVOKE_ENDPOINT_KEY, YarnConfiguration.DEFAULT_HOPS_HOPSWORKS_REVOKE_ENDPOINT));
        this.certificateFactory = CertificateFactory.getInstance("X.509", "BC");
        this.sslConf = new Configuration(false);
        this.sslConf.addResource(this.conf.get("hadoop.ssl.server.conf", "ssl-server.xml"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public X509Certificate sign(PKCS10CertificationRequest csr) throws URISyntaxException, IOException, GeneralSecurityException {
        try (CloseableHttpClient httpClient = null;){
            httpClient = this.createHttpClient();
            this.login(httpClient);
            String csrStr = this.stringifyCSR(csr);
            JsonObject json = new JsonObject();
            json.addProperty("csr", csrStr);
            CloseableHttpResponse signResponse = this.post(httpClient, json, this.signEndpoint.toURI(), "Hopsworks CA could not sign CSR");
            String signResponseEntity = EntityUtils.toString((HttpEntity)signResponse.getEntity());
            JsonObject jsonResponse = new JsonParser().parse(signResponseEntity).getAsJsonObject();
            String signedCert = jsonResponse.get("pubAgentCert").getAsString();
            X509Certificate x509Certificate = this.parseCertificate(signedCert);
            return x509Certificate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int revoke(String certificateIdentifier) throws URISyntaxException, IOException, GeneralSecurityException {
        try (CloseableHttpClient httpClient = null;){
            httpClient = this.createHttpClient();
            this.login(httpClient);
            JsonObject json = new JsonObject();
            json.addProperty("identifier", certificateIdentifier);
            CloseableHttpResponse response = this.post(httpClient, json, this.revokeEndpoint.toURI(), "Hopsworks CA could not revoke certificate " + certificateIdentifier);
            int n = response.getStatusLine().getStatusCode();
            return n;
        }
    }

    protected CloseableHttpClient createHttpClient() throws GeneralSecurityException, IOException {
        BasicCookieStore cookieStore = new BasicCookieStore();
        return HttpClients.custom().setDefaultCookieStore((CookieStore)cookieStore).build();
    }

    private void login(CloseableHttpClient httpClient) throws URISyntaxException, IOException {
        HttpUriRequest login = RequestBuilder.post().setUri(this.loginEndpoint.toURI()).addParameter("email", this.sslConf.get(HOPSWORKS_USER_KEY)).addParameter("password", this.sslConf.get(HOPSWORKS_PASSWORD_KEY)).build();
        CloseableHttpResponse loginResponse = httpClient.execute(login);
        this.checkHTTPResponseCode(loginResponse.getStatusLine().getStatusCode(), "Could not login to Hopsworks");
    }

    private CloseableHttpResponse post(CloseableHttpClient httpClient, JsonObject jsonEntity, URI target, String errorMessage) throws IOException {
        HttpPost request = new HttpPost(target);
        request.setEntity((HttpEntity)new StringEntity(jsonEntity.toString()));
        request.addHeader("Content-Type", "application/json");
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
        this.checkHTTPResponseCode(response.getStatusLine().getStatusCode(), errorMessage);
        return response;
    }

    private X509Certificate parseCertificate(String certificateStr) throws IOException, GeneralSecurityException {
        try (ByteArrayInputStream bis = new ByteArrayInputStream(certificateStr.getBytes());){
            X509Certificate x509Certificate = (X509Certificate)this.certificateFactory.generateCertificate(bis);
            return x509Certificate;
        }
    }

    private void checkHTTPResponseCode(int responseCode, String msg) throws IOException {
        if (!ACCEPTABLE_HTTP_RESPONSES.contains(responseCode)) {
            throw new IOException("HTTP error, response code " + responseCode + " Message: " + msg);
        }
    }

    private String stringifyCSR(PKCS10CertificationRequest csr) throws IOException {
        try (StringWriter sw = new StringWriter();){
            PemWriter pw = new PemWriter((Writer)sw);
            JcaMiscPEMGenerator pog = new JcaMiscPEMGenerator((Object)csr);
            pw.writeObject((PemObjectGenerator)pog.generate());
            pw.flush();
            sw.flush();
            pw.close();
            String string = sw.toString();
            return string;
        }
    }
}

