/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ClusterMetricsInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.SchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.UserMetricsInfo;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;

public class MetricsOverviewTable
extends HtmlBlock {
    private static final long BYTES_IN_MB = 0x100000L;
    private final ResourceManager rm;

    @Inject
    MetricsOverviewTable(ResourceManager rm, View.ViewContext ctx) {
        super(ctx);
        this.rm = rm;
    }

    protected void render(HtmlBlock.Block html) {
        UserMetricsInfo userMetrics;
        html.style(new Object[]{".metrics {margin-bottom:5px}"});
        ClusterMetricsInfo clusterMetrics = new ClusterMetricsInfo(this.rm);
        Hamlet.DIV div = html.div().$class("metrics");
        ((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.h3("Cluster Metrics").table("#metricsoverview").thead().$class("ui-widget-header").tr().th().$class("ui-state-default")._(new Object[]{"Apps Submitted"})._()).th().$class("ui-state-default")._(new Object[]{"Apps Pending"})._()).th().$class("ui-state-default")._(new Object[]{"Apps Running"})._()).th().$class("ui-state-default")._(new Object[]{"Apps Completed"})._()).th().$class("ui-state-default")._(new Object[]{"Containers Running"})._()).th().$class("ui-state-default")._(new Object[]{"Memory Used"})._()).th().$class("ui-state-default")._(new Object[]{"Memory Total"})._()).th().$class("ui-state-default")._(new Object[]{"Memory Reserved"})._()).th().$class("ui-state-default")._(new Object[]{"VCores Used"})._()).th().$class("ui-state-default")._(new Object[]{"VCores Total"})._()).th().$class("ui-state-default")._(new Object[]{"VCores Reserved"})._()).th().$class("ui-state-default")._(new Object[]{"GPUs Used"})._()).th().$class("ui-state-default")._(new Object[]{"GPUs Total"})._()).th().$class("ui-state-default")._(new Object[]{"GPUs Reserved"})._())._())._()).tbody().$class("ui-widget-content").tr().td(String.valueOf(clusterMetrics.getAppsSubmitted())).td(String.valueOf(clusterMetrics.getAppsPending())).td(String.valueOf(clusterMetrics.getAppsRunning())).td(String.valueOf(clusterMetrics.getAppsCompleted() + clusterMetrics.getAppsFailed() + clusterMetrics.getAppsKilled())).td(String.valueOf(clusterMetrics.getContainersAllocated())).td(StringUtils.byteDesc((long)(clusterMetrics.getAllocatedMB() * 0x100000L))).td(StringUtils.byteDesc((long)(clusterMetrics.getTotalMB() * 0x100000L))).td(StringUtils.byteDesc((long)(clusterMetrics.getReservedMB() * 0x100000L))).td(String.valueOf(clusterMetrics.getAllocatedVirtualCores())).td(String.valueOf(clusterMetrics.getTotalVirtualCores())).td(String.valueOf(clusterMetrics.getReservedVirtualCores())).td(String.valueOf(clusterMetrics.getAllocatedGPUs())).td(String.valueOf(clusterMetrics.getTotalGPUs())).td(String.valueOf(clusterMetrics.getReservedGPUs()))._())._())._();
        ((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.h3("Cluster Nodes Metrics").table("#nodemetricsoverview").thead().$class("ui-widget-header").tr().th().$class("ui-state-default")._(new Object[]{"Active Nodes"})._()).th().$class("ui-state-default")._(new Object[]{"Decommissioning Nodes"})._()).th().$class("ui-state-default")._(new Object[]{"Decommissioned Nodes"})._()).th().$class("ui-state-default")._(new Object[]{"Lost Nodes"})._()).th().$class("ui-state-default")._(new Object[]{"Unhealthy Nodes"})._()).th().$class("ui-state-default")._(new Object[]{"Rebooted Nodes"})._()).th().$class("ui-state-default")._(new Object[]{"Shutdown Nodes"})._())._())._()).tbody().$class("ui-widget-content").tr().td().a(this.url(new String[]{"nodes"}), String.valueOf(clusterMetrics.getActiveNodes()))._()).td().a(this.url(new String[]{"nodes/decommissioning"}), String.valueOf(clusterMetrics.getDecommissioningNodes()))._()).td().a(this.url(new String[]{"nodes/decommissioned"}), String.valueOf(clusterMetrics.getDecommissionedNodes()))._()).td().a(this.url(new String[]{"nodes/lost"}), String.valueOf(clusterMetrics.getLostNodes()))._()).td().a(this.url(new String[]{"nodes/unhealthy"}), String.valueOf(clusterMetrics.getUnhealthyNodes()))._()).td().a(this.url(new String[]{"nodes/rebooted"}), String.valueOf(clusterMetrics.getRebootedNodes()))._()).td().a(this.url(new String[]{"nodes/shutdown"}), String.valueOf(clusterMetrics.getShutdownNodes()))._())._())._())._();
        String user = this.request().getRemoteUser();
        if (user != null && (userMetrics = new UserMetricsInfo(this.rm, user)).metricsAvailable()) {
            ((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.h3("User Metrics for " + user).table("#usermetricsoverview").thead().$class("ui-widget-header").tr().th().$class("ui-state-default")._(new Object[]{"Apps Submitted"})._()).th().$class("ui-state-default")._(new Object[]{"Apps Pending"})._()).th().$class("ui-state-default")._(new Object[]{"Apps Running"})._()).th().$class("ui-state-default")._(new Object[]{"Apps Completed"})._()).th().$class("ui-state-default")._(new Object[]{"Containers Running"})._()).th().$class("ui-state-default")._(new Object[]{"Containers Pending"})._()).th().$class("ui-state-default")._(new Object[]{"Containers Reserved"})._()).th().$class("ui-state-default")._(new Object[]{"Memory Used"})._()).th().$class("ui-state-default")._(new Object[]{"Memory Pending"})._()).th().$class("ui-state-default")._(new Object[]{"Memory Reserved"})._()).th().$class("ui-state-default")._(new Object[]{"VCores Used"})._()).th().$class("ui-state-default")._(new Object[]{"VCores Pending"})._()).th().$class("ui-state-default")._(new Object[]{"VCores Reserved"})._()).th().$class("ui-state-default")._(new Object[]{"GPUs Used"})._()).th().$class("ui-state-default")._(new Object[]{"GPUs Pending"})._()).th().$class("ui-state-default")._(new Object[]{"GPUs Reserved"})._())._())._()).tbody().$class("ui-widget-content").tr().td(String.valueOf(userMetrics.getAppsSubmitted())).td(String.valueOf(userMetrics.getAppsPending())).td(String.valueOf(userMetrics.getAppsRunning())).td(String.valueOf(userMetrics.getAppsCompleted() + userMetrics.getAppsFailed() + userMetrics.getAppsKilled())).td(String.valueOf(userMetrics.getRunningContainers())).td(String.valueOf(userMetrics.getPendingContainers())).td(String.valueOf(userMetrics.getReservedContainers())).td(StringUtils.byteDesc((long)(userMetrics.getAllocatedMB() * 0x100000L))).td(StringUtils.byteDesc((long)(userMetrics.getPendingMB() * 0x100000L))).td(StringUtils.byteDesc((long)(userMetrics.getReservedMB() * 0x100000L))).td(String.valueOf(userMetrics.getAllocatedVirtualCores())).td(String.valueOf(userMetrics.getPendingVirtualCores())).td(String.valueOf(userMetrics.getReservedVirtualCores())).td(String.valueOf(userMetrics.getAllocatedGPUs())).td(String.valueOf(userMetrics.getPendingGPUs())).td(String.valueOf(userMetrics.getReservedGPUs()))._())._())._();
        }
        SchedulerInfo schedulerInfo = new SchedulerInfo(this.rm);
        ((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)((Hamlet.TR)div.h3("Scheduler Metrics").table("#schedulermetricsoverview").thead().$class("ui-widget-header").tr().th().$class("ui-state-default")._(new Object[]{"Scheduler Type"})._()).th().$class("ui-state-default")._(new Object[]{"Scheduling Resource Type"})._()).th().$class("ui-state-default")._(new Object[]{"Minimum Allocation"})._()).th().$class("ui-state-default")._(new Object[]{"Maximum Allocation"})._()).th().$class("ui-state-default")._(new Object[]{"Maximum Cluster Application Priority"})._())._())._()).tbody().$class("ui-widget-content").tr().td(String.valueOf(schedulerInfo.getSchedulerType())).td(String.valueOf(schedulerInfo.getSchedulerResourceTypes())).td(schedulerInfo.getMinAllocation().toString()).td(schedulerInfo.getMaxAllocation().toString()).td(String.valueOf(schedulerInfo.getMaxClusterLevelAppPriority()))._())._())._();
        div._();
    }
}

