/*
 * Decompiled with CFR 0.152.
 */
package io.hops.util;

import io.hops.DalDriver;
import io.hops.DalStorageFactory;
import io.hops.StorageConnector;
import io.hops.exception.StorageException;
import io.hops.exception.StorageInitializtionException;
import io.hops.leaderElection.VarsRegister;
import io.hops.metadata.common.EntityDataAccess;
import io.hops.metadata.hdfs.dal.GroupDataAccess;
import io.hops.metadata.hdfs.dal.UserDataAccess;
import io.hops.metadata.hdfs.dal.UserGroupDataAccess;
import io.hops.security.UsersGroups;
import io.hops.transaction.EntityManager;
import io.hops.transaction.context.ContextInitializer;
import io.hops.transaction.context.EntityContext;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;

public class YarnAPIStorageFactory {
    private static boolean isInitialized = false;
    private static DalStorageFactory dStorageFactory;
    private static Map<Class, EntityDataAccess> dataAccessAdaptors;
    public static final String DFS_STORAGE_DRIVER_JAR_FILE = "dfs.storage.driver.jarFile";
    public static final String DFS_STORAGE_DRIVER_JAR_FILE_DEFAULT = "";
    public static final String DFS_STORAGE_DRIVER_CLASS = "dfs.storage.driver.class";
    public static final String DFS_STORAGE_DRIVER_CLASS_DEFAULT = "io.hops.metadata.ndb.NdbStorageFactory";
    public static final String DFS_STORAGE_DRIVER_CONFIG_FILE = "dfs.storage.driver.configfile";
    public static final String DFS_STORAGE_DRIVER_CONFIG_FILE_DEFAULT = "ndb-config.properties";
    public static final String EVENT_STREAMING_FOR_DISTRIBUTED_SERVICE = "io.hops.metadata.ndb.JniNdbEventStreaming";

    public static StorageConnector getConnector() {
        return dStorageFactory.getConnector();
    }

    public static void setConfiguration(Configuration conf) throws StorageInitializtionException, IOException {
        if (isInitialized) {
            return;
        }
        YarnAPIStorageFactory.addToClassPath(conf.get(DFS_STORAGE_DRIVER_JAR_FILE, DFS_STORAGE_DRIVER_JAR_FILE_DEFAULT));
        dStorageFactory = DalDriver.load((String)conf.get(DFS_STORAGE_DRIVER_CLASS, DFS_STORAGE_DRIVER_CLASS_DEFAULT));
        dStorageFactory.setConfiguration(YarnAPIStorageFactory.getMetadataClusterConfiguration(conf));
        YarnAPIStorageFactory.initDataAccessWrappers();
        EntityManager.addContextInitializer((ContextInitializer)YarnAPIStorageFactory.getContextInitializer());
        if (conf.getBoolean("hops.groups.updater.round", true)) {
            UsersGroups.init((UserDataAccess)((UserDataAccess)YarnAPIStorageFactory.getDataAccess(UserDataAccess.class)), (UserGroupDataAccess)((UserGroupDataAccess)YarnAPIStorageFactory.getDataAccess(UserGroupDataAccess.class)), (GroupDataAccess)((GroupDataAccess)YarnAPIStorageFactory.getDataAccess(GroupDataAccess.class)), (int)conf.getInt("hops.groups.updater.round", 120), (int)conf.getInt("hops.users.lru.threshold", 10000));
        }
        VarsRegister.registerYarnDefaultValues();
        isInitialized = true;
    }

    public static Properties getMetadataClusterConfiguration(Configuration conf) throws IOException {
        String configFile = conf.get(DFS_STORAGE_DRIVER_CONFIG_FILE, DFS_STORAGE_DRIVER_CONFIG_FILE_DEFAULT);
        Properties clusterConf = new Properties();
        InputStream inStream = StorageConnector.class.getClassLoader().getResourceAsStream(configFile);
        clusterConf.load(inStream);
        return clusterConf;
    }

    private static void addToClassPath(String s) throws StorageInitializtionException {
        try {
            File f = new File(s);
            URL u = f.toURI().toURL();
            URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
            Class<URLClassLoader> urlClass = URLClassLoader.class;
            Method method = urlClass.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)urlClassLoader, u);
        }
        catch (MalformedURLException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
        catch (IllegalArgumentException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
        catch (SecurityException ex) {
            throw new StorageInitializtionException((Throwable)ex);
        }
    }

    private static void initDataAccessWrappers() {
        dataAccessAdaptors.clear();
    }

    private static ContextInitializer getContextInitializer() {
        return new ContextInitializer(){

            public Map<Class, EntityContext> createEntityContexts() {
                HashMap<Class, EntityContext> entityContexts = new HashMap<Class, EntityContext>();
                return entityContexts;
            }

            public StorageConnector getConnector() {
                return dStorageFactory.getConnector();
            }
        };
    }

    public static EntityDataAccess getDataAccess(Class type) {
        if (dataAccessAdaptors.containsKey(type)) {
            return dataAccessAdaptors.get(type);
        }
        return dStorageFactory.getDataAccess(type);
    }

    public static boolean formatYarnStorageNonTransactional() throws StorageException {
        return dStorageFactory.getConnector().formatYarnStorageNonTransactional();
    }

    public static boolean formatYarnStorage() throws StorageException {
        return dStorageFactory.getConnector().formatYarnStorage();
    }

    static {
        dataAccessAdaptors = new HashMap<Class, EntityDataAccess>();
    }
}

